/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Random;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.View;

public abstract class PlaneCurve
extends Exhibit {
    protected Point2D[] points;
    protected Point2D[] randomSquare;
    protected Point2D[] movingSquare;

    protected abstract void makePoints();

    public int getPointCount() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length;
    }

    public Point2D getPoint(int n) {
        return this.points[n];
    }

    protected void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
        if (bl || this.points == null) {
            this.makePoints();
        }
    }

    protected void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        view.drawCurve(this.points);
    }

    public Point2D[] fillRandomSquare(int n) {
        Random random = new Random(42L);
        Point2D[] point2DArray = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = new Point2D.Double(2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0);
        }
        return point2DArray;
    }

    public Point2D[] initializeMovingSquare(int n) {
        this.movingSquare = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            this.movingSquare[i] = new Point2D.Double();
        }
        return this.movingSquare;
    }

    protected Point2D[] moveSquare(int n, double d, double d2, double d3, double d4, double d5) {
        for (int i = 0; i < n; ++i) {
            double d6 = d5 * this.randomSquare[i].getX();
            double d7 = d5 * this.randomSquare[i].getY();
            this.movingSquare[i].setLocation(d + d6 * d3 - d7 * d4, d2 + d6 * d4 + d7 * d3);
        }
        return this.movingSquare;
    }
}

