/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder3D;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.ode.ODE_3D;

public abstract class ODE2ndOrder3D
extends ODE_3D {
    public ODE2ndOrder3D() {
        super(false, true, "x", "y", "z", "x'", "y'", "z'");
        this.initialDataDefault = new double[]{1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0};
        this.timeSpanDefault = 30.0;
    }

    protected void nextEulerPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        dArray[0] = d2 + d * d5;
        dArray[1] = d3 + d * d6;
        dArray[2] = d4 + d * d7;
        dArray[3] = d5 + d * this.xdotdot(d2, d3, d4, d5, d6, d7);
        dArray[4] = d6 + d * this.ydotdot(d2, d3, d4, d5, d6, d7);
        dArray[5] = d7 + d * this.zdotdot(d2, d3, d4, d5, d6, d7);
    }

    protected void nextRungeKuttaPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        double d8 = d * d5;
        double d9 = d * d6;
        double d10 = d * d7;
        double d11 = d * this.xdotdot(d2, d3, d4, d5, d6, d7);
        double d12 = d * this.ydotdot(d2, d3, d4, d5, d6, d7);
        double d13 = d * this.zdotdot(d2, d3, d4, d5, d6, d7);
        double d14 = d * (d5 + d11 / 2.0);
        double d15 = d * (d6 + d12 / 2.0);
        double d16 = d * (d7 + d13 / 2.0);
        double d17 = d * this.xdotdot(d2 + d8 / 2.0, d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d6 + d12 / 2.0, d7 + d13 / 2.0);
        double d18 = d * this.ydotdot(d2 + d8 / 2.0, d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d6 + d12 / 2.0, d7 + d13 / 2.0);
        double d19 = d * this.zdotdot(d2 + d8 / 2.0, d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d6 + d12 / 2.0, d7 + d13 / 2.0);
        double d20 = d * (d5 + d17 / 2.0);
        double d21 = d * (d6 + d18 / 2.0);
        double d22 = d * (d7 + d19 / 2.0);
        double d23 = d * this.xdotdot(d2 + d14 / 2.0, d3 + d15 / 2.0, d4 + d16 / 2.0, d5 + d17 / 2.0, d6 + d18 / 2.0, d7 + d19 / 2.0);
        double d24 = d * this.ydotdot(d2 + d14 / 2.0, d3 + d15 / 2.0, d4 + d16 / 2.0, d5 + d17 / 2.0, d6 + d18 / 2.0, d7 + d19 / 2.0);
        double d25 = d * this.zdotdot(d2 + d14 / 2.0, d3 + d15 / 2.0, d4 + d16 / 2.0, d5 + d17 / 2.0, d6 + d18 / 2.0, d7 + d19 / 2.0);
        double d26 = d * (d5 + d23);
        double d27 = d * (d6 + d24);
        double d28 = d * (d7 + d25);
        double d29 = d * this.xdotdot(d2 + d20, d3 + d21, d4 + d22, d5 + d23, d6 + d24, d7 + d25);
        double d30 = d * this.ydotdot(d2 + d20, d3 + d21, d4 + d22, d5 + d23, d6 + d24, d7 + d25);
        double d31 = d * this.zdotdot(d2 + d20, d3 + d21, d4 + d22, d5 + d23, d6 + d24, d7 + d25);
        double d32 = d8 / 6.0 + d14 / 3.0 + d20 / 3.0 + d26 / 6.0;
        double d33 = d9 / 6.0 + d15 / 3.0 + d21 / 3.0 + d27 / 6.0;
        double d34 = d10 / 6.0 + d16 / 3.0 + d22 / 3.0 + d28 / 6.0;
        double d35 = d11 / 6.0 + d17 / 3.0 + d23 / 3.0 + d29 / 6.0;
        double d36 = d12 / 6.0 + d18 / 3.0 + d24 / 3.0 + d30 / 6.0;
        double d37 = d13 / 6.0 + d19 / 3.0 + d25 / 3.0 + d31 / 6.0;
        dArray[0] = d2 + d32;
        dArray[1] = d3 + d33;
        dArray[2] = d4 + d34;
        dArray[3] = d5 + d35;
        dArray[4] = d6 + d36;
        dArray[5] = d7 + d37;
    }

    protected abstract double xdotdot(double var1, double var3, double var5, double var7, double var9, double var11);

    protected abstract double ydotdot(double var1, double var3, double var5, double var7, double var9, double var11);

    protected abstract double zdotdot(double var1, double var3, double var5, double var7, double var9, double var11);

    protected MouseTask makeDefaultMouseTask(ODE_3D.ODEView oDEView) {
        return new ThrowIt();
    }

    private class ThrowIt
    extends BasicMouseTask3D {
        int startX;
        int startY;
        int currentX;
        int currentY;
        boolean throwing;

        private ThrowIt() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isAltDown()) {
                this.throwing = true;
                this.startX = this.currentX = mouseEvent.getX();
                this.startY = this.currentY = mouseEvent.getY();
                return true;
            }
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.throwing) {
                this.currentX = mouseEvent.getX();
                this.currentY = mouseEvent.getY();
                view.forceRedraw();
            } else {
                super.doMouseDrag(mouseEvent, display, view, n, n2);
            }
        }

        public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.throwing) {
                this.throwing = false;
                ODE_3D.ODEView oDEView = (ODE_3D.ODEView)view;
                Vector3D vector3D = ODE2ndOrder3D.this.screenPointTo3DPoint(oDEView, this.startX, this.startY);
                Vector3D vector3D2 = ODE2ndOrder3D.this.screenPointTo3DPoint(oDEView, this.currentX, this.currentY);
                double[] dArray = new double[]{vector3D.x, vector3D.y, vector3D.z, vector3D2.x - vector3D.x, vector3D2.y - vector3D.y, vector3D2.z - vector3D.z};
                ((ODE_3D.ODEView)view).startOrbitAtPoint(dArray);
            } else {
                super.doMouseUp(mouseEvent, display, view, n, n2);
            }
        }

        public void drawWhileDragging(Graphics2D graphics2D, Display display, View view, int n, int n2) {
            if (this.throwing) {
                if (((View3D)view).getViewStyle() == 1) {
                    graphics2D.setColor(Color.YELLOW);
                } else {
                    graphics2D.setColor(view.getForeground());
                }
                graphics2D.drawLine(this.startX, this.startY, this.currentX, this.currentY);
            } else {
                super.drawWhileDragging(graphics2D, display, view, n, n2);
            }
        }

        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText");
        }
    }
}

