/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder3D;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.ode.secondorder3D.ChargedParticles;

public class MagneticDipole
extends ChargedParticles {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.0);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 0.0, 0.0, 1.4142);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 1.4142, 1.4142, 0.0);

    public MagneticDipole() {
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.initialDataDefault = new double[]{-0.7, -0.7, 0.0, 0.0, 0.0, -0.2, 0.02, 100.0};
        this.setDefaultWindow(-1.0, 1.0, -1.0, 1.0);
        this.setDefaultViewpoint(new Vector3D(11.6, -8.1, 10.0));
    }

    protected void magneticField(double d, double d2, double d3, Vector3D vector3D) {
        double d4 = this.aa.getValue();
        double d5 = this.bb.getValue();
        double d6 = this.cc.getValue();
        double d7 = d * d + d2 * d2 + d3 * d3;
        double d8 = d7 * Math.sqrt(d7);
        double d9 = d4 * d + d5 * d2 + d6 * d3;
        vector3D.x = (3.0 * d9 * d / d7 - d4) / d8;
        vector3D.y = (3.0 * d9 * d2 / d7 - d5) / d8;
        vector3D.z = (3.0 * d9 * d3 / d7 - d6) / d8;
    }
}

