/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder3D;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.ode.ODE_3D;

public abstract class ChargedParticles
extends ODE_3D {
    public ChargedParticles() {
        super(false, true, "x", "y", "z", "x'", "y'", "z'");
        this.showAxes = true;
    }

    protected void nextEulerPoint(double[] dArray, double d) {
        Vector3D vector3D = new Vector3D();
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        this.dotdot(d2, d3, d4, d5, d6, d7, vector3D);
        dArray[0] = d2 + d * d5;
        dArray[1] = d3 + d * d6;
        dArray[2] = d4 + d * d7;
        dArray[3] = d5 + d * vector3D.x;
        dArray[4] = d6 + d * vector3D.y;
        dArray[5] = d7 + d * vector3D.z;
    }

    protected void nextRungeKuttaPoint(double[] dArray, double d) {
        Vector3D vector3D = new Vector3D();
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        double d8 = d * d5;
        double d9 = d * d6;
        double d10 = d * d7;
        this.dotdot(d2, d3, d4, d5, d6, d7, vector3D);
        double d11 = d * vector3D.x;
        double d12 = d * vector3D.y;
        double d13 = d * vector3D.z;
        double d14 = d * (d5 + d11 / 2.0);
        double d15 = d * (d6 + d12 / 2.0);
        double d16 = d * (d7 + d13 / 2.0);
        this.dotdot(d2 + d8 / 2.0, d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d6 + d12 / 2.0, d7 + d13 / 2.0, vector3D);
        double d17 = d * vector3D.x;
        double d18 = d * vector3D.y;
        double d19 = d * vector3D.z;
        double d20 = d * (d5 + d17 / 2.0);
        double d21 = d * (d6 + d18 / 2.0);
        double d22 = d * (d7 + d19 / 2.0);
        this.dotdot(d2 + d14 / 2.0, d3 + d15 / 2.0, d4 + d16 / 2.0, d5 + d17 / 2.0, d6 + d18 / 2.0, d7 + d19 / 2.0, vector3D);
        double d23 = d * vector3D.x;
        double d24 = d * vector3D.y;
        double d25 = d * vector3D.z;
        double d26 = d * (d5 + d23);
        double d27 = d * (d6 + d24);
        double d28 = d * (d7 + d25);
        this.dotdot(d2 + d20, d3 + d21, d4 + d22, d5 + d23, d6 + d24, d7 + d25, vector3D);
        double d29 = d * vector3D.x;
        double d30 = d * vector3D.y;
        double d31 = d * vector3D.z;
        double d32 = d8 / 6.0 + d14 / 3.0 + d20 / 3.0 + d26 / 6.0;
        double d33 = d9 / 6.0 + d15 / 3.0 + d21 / 3.0 + d27 / 6.0;
        double d34 = d10 / 6.0 + d16 / 3.0 + d22 / 3.0 + d28 / 6.0;
        double d35 = d11 / 6.0 + d17 / 3.0 + d23 / 3.0 + d29 / 6.0;
        double d36 = d12 / 6.0 + d18 / 3.0 + d24 / 3.0 + d30 / 6.0;
        double d37 = d13 / 6.0 + d19 / 3.0 + d25 / 3.0 + d31 / 6.0;
        dArray[0] = d2 + d32;
        dArray[1] = d3 + d33;
        dArray[2] = d4 + d34;
        dArray[3] = d5 + d35;
        dArray[4] = d6 + d36;
        dArray[5] = d7 + d37;
    }

    private void dotdot(double d, double d2, double d3, double d4, double d5, double d6, Vector3D vector3D) {
        this.magneticField(d, d2, d3, vector3D);
        Vector3D vector3D2 = new Vector3D();
        this.magneticField(d, d2, d3, vector3D2);
        double d7 = vector3D2.x;
        double d8 = vector3D2.y;
        double d9 = vector3D2.z;
        vector3D.x = d8 * d6 - d9 * d5;
        vector3D.y = d9 * d4 - d7 * d6;
        vector3D.z = d7 * d5 - d8 * d4;
    }

    protected abstract void magneticField(double var1, double var3, double var5, Vector3D var7);

    protected MouseTask makeDefaultMouseTask(ODE_3D.ODEView oDEView) {
        return new ThrowIt();
    }

    private class ThrowIt
    extends BasicMouseTask3D {
        int startX;
        int startY;
        int currentX;
        int currentY;
        boolean throwing;

        private ThrowIt() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isAltDown()) {
                this.throwing = true;
                this.startX = this.currentX = mouseEvent.getX();
                this.startY = this.currentY = mouseEvent.getY();
                return true;
            }
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.throwing) {
                this.currentX = mouseEvent.getX();
                this.currentY = mouseEvent.getY();
                view.forceRedraw();
            } else {
                super.doMouseDrag(mouseEvent, display, view, n, n2);
            }
        }

        public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.throwing) {
                this.throwing = false;
                ODE_3D.ODEView oDEView = (ODE_3D.ODEView)view;
                Vector3D vector3D = ChargedParticles.this.screenPointTo3DPoint(oDEView, this.startX, this.startY);
                Vector3D vector3D2 = ChargedParticles.this.screenPointTo3DPoint(oDEView, this.currentX, this.currentY);
                double[] dArray = new double[]{vector3D.x, vector3D.y, vector3D.z, vector3D2.x - vector3D.x, vector3D2.y - vector3D.y, vector3D2.z - vector3D.z};
                ((ODE_3D.ODEView)view).startOrbitAtPoint(dArray);
            } else {
                super.doMouseUp(mouseEvent, display, view, n, n2);
            }
        }

        public void drawWhileDragging(Graphics2D graphics2D, Display display, View view, int n, int n2) {
            if (this.throwing) {
                if (((View3D)view).getViewStyle() == 1) {
                    graphics2D.setColor(Color.YELLOW);
                } else {
                    graphics2D.setColor(view.getForeground());
                }
                graphics2D.drawLine(this.startX, this.startY, this.currentX, this.currentY);
            } else {
                super.drawWhileDragging(graphics2D, display, view, n, n2);
            }
        }

        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText");
        }
    }
}

