/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder2D;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import vmm.core.BasicMouseTask2D;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.ode.ODE_2D;

public abstract class ODE2ndOrder2D
extends ODE_2D {
    public ODE2ndOrder2D() {
        super(false, true, "x", "y", "x'", "y'");
        this.initialDataDefault = new double[]{1.0, 0.0, 0.0, 1.0};
        this.timeSpanDefault = 30.0;
    }

    protected void nextEulerPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        dArray[0] = d2 + d * d4;
        dArray[1] = d3 + d * d5;
        dArray[2] = d4 + d * this.xdotdot(d2, d3, d4, d5);
        dArray[3] = d5 + d * this.ydotdot(d2, d3, d4, d5);
    }

    protected void nextRungeKuttaPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = d * d4;
        double d7 = d * d5;
        double d8 = d * this.xdotdot(d2, d3, d4, d5);
        double d9 = d * this.ydotdot(d2, d3, d4, d5);
        double d10 = d * (d4 + d8 / 2.0);
        double d11 = d * (d5 + d9 / 2.0);
        double d12 = d * this.xdotdot(d2 + d6 / 2.0, d3 + d7 / 2.0, d4 + d8 / 2.0, d5 + d9 / 2.0);
        double d13 = d * this.ydotdot(d2 + d6 / 2.0, d3 + d7 / 2.0, d4 + d8 / 2.0, d5 + d9 / 2.0);
        double d14 = d * (d4 + d12 / 2.0);
        double d15 = d * (d5 + d13 / 2.0);
        double d16 = d * this.xdotdot(d2 + d10 / 2.0, d3 + d11 / 2.0, d4 + d12 / 2.0, d5 + d13 / 2.0);
        double d17 = d * this.ydotdot(d2 + d10 / 2.0, d3 + d11 / 2.0, d4 + d12 / 2.0, d5 + d13 / 2.0);
        double d18 = d * (d4 + d16);
        double d19 = d * (d5 + d17);
        double d20 = d * this.xdotdot(d2 + d14, d3 + d15, d4 + d16, d5 + d17);
        double d21 = d * this.ydotdot(d2 + d14, d3 + d15, d4 + d16, d5 + d17);
        double d22 = d6 / 6.0 + d10 / 3.0 + d14 / 3.0 + d18 / 6.0;
        double d23 = d7 / 6.0 + d11 / 3.0 + d15 / 3.0 + d19 / 6.0;
        double d24 = d8 / 6.0 + d12 / 3.0 + d16 / 3.0 + d20 / 6.0;
        double d25 = d9 / 6.0 + d13 / 3.0 + d17 / 3.0 + d21 / 6.0;
        dArray[0] = d2 + d22;
        dArray[1] = d3 + d23;
        dArray[2] = d4 + d24;
        dArray[3] = d5 + d25;
    }

    protected abstract double xdotdot(double var1, double var3, double var5, double var7);

    protected abstract double ydotdot(double var1, double var3, double var5, double var7);

    protected MouseTask makeDefaultMouseTask(ODE_2D.ODEView oDEView) {
        return new ThrowIt();
    }

    private class ThrowIt
    extends BasicMouseTask2D {
        int startX;
        int startY;
        int currentX;
        int currentY;
        boolean throwing;

        private ThrowIt() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isAltDown()) {
                this.throwing = true;
                this.startX = this.currentX = mouseEvent.getX();
                this.startY = this.currentY = mouseEvent.getY();
                return true;
            }
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.throwing) {
                this.currentX = mouseEvent.getX();
                this.currentY = mouseEvent.getY();
                view.forceRedraw();
            } else {
                super.doMouseDrag(mouseEvent, display, view, n, n2);
            }
        }

        public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.throwing) {
                this.throwing = false;
                Point2D.Double double_ = new Point2D.Double(this.startX, this.startY);
                Point2D.Double double_2 = new Point2D.Double(this.currentX, this.currentY);
                view.getTransform().viewportToWindow(double_);
                view.getTransform().viewportToWindow(double_2);
                double[] dArray = new double[]{((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX() - ((Point2D)double_).getX(), ((Point2D)double_2).getY() - ((Point2D)double_).getY()};
                ((ODE_2D.ODEView)view).startOrbitAtPoint(dArray);
            } else {
                super.doMouseUp(mouseEvent, display, view, n, n2);
            }
        }

        public void drawWhileDragging(Graphics2D graphics2D, Display display, View view, int n, int n2) {
            if (this.throwing) {
                graphics2D.setColor(view.getForeground());
                graphics2D.drawLine(this.startX, this.startY, this.currentX, this.currentY);
            } else {
                super.drawWhileDragging(graphics2D, display, view, n, n2);
            }
        }

        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText");
        }
    }
}

