/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder2D;

import vmm.core.RealParamAnimateable;
import vmm.ode.secondorder2D.CentralForce;

public class Higgs
extends CentralForce {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 2.0, 1.5, 2.5);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 2.0, -1.95, -2.05);

    public Higgs() {
        this.addParameter(this.cc);
        this.addParameter(this.aa);
        this.initialDataDefault = new double[]{1.0, 1.0, -0.2, 0.2};
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
    }

    protected double force(double d) {
        if (Math.abs(d) < 0.001) {
            return 0.0;
        }
        double d2 = Math.pow(d / this.cc.getValue(), 2.0);
        return -this.aa.getValue() * d * (1.0 - 1.0 / d2);
    }
}

