/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder2D;

import vmm.core.RealParamAnimateable;
import vmm.ode.secondorder2D.ODE2ndOrder2D;

public class FoucaultPendulum
extends ODE2ndOrder2D {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.ode.secondorder2D.FoucaultPendulum.ForceConstant", 1.0);
    private RealParamAnimateable b = new RealParamAnimateable("vmm.ode.secondorder2D.FoucaultPendulum.Rotation", 0.1);
    private RealParamAnimateable c = new RealParamAnimateable("vmm.ode.secondorder2D.FoucaultPendulum.Latitude", 45.0, 0.0, 45.0);

    public FoucaultPendulum() {
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.initialDataDefault = new double[]{0.7071, 0.7071, 0.0, 0.0, 0.05, 60.0};
    }

    protected double xdotdot(double d, double d2, double d3, double d4) {
        double d5 = this.a.getValue();
        return -d5 * d5 * d + 2.0 * this.b.getValue() * Math.sin(Math.PI * this.c.getValue() / 180.0) * d4;
    }

    protected double ydotdot(double d, double d2, double d3, double d4) {
        double d5 = this.a.getValue();
        return -d5 * d5 * d2 - 2.0 * this.b.getValue() * Math.sin(Math.PI * this.c.getValue() / 180.0) * d3;
    }
}

