/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.firstorder3D;

import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Vector3D;
import vmm.ode.ODE_3D;

public abstract class ODE1stOrder3DNonAutonomous
extends ODE_3D {
    protected abstract double xPrime(double var1, double var3, double var5, double var7);

    protected abstract double yPrime(double var1, double var3, double var5, double var7);

    protected abstract double zPrime(double var1, double var3, double var5, double var7);

    protected void nextEulerPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = d * this.xPrime(d3, d4, d5, d2);
        double d7 = d * this.yPrime(d3, d4, d5, d2);
        double d8 = d * this.zPrime(d3, d4, d5, d2);
        dArray[0] = d2 + d;
        dArray[1] = d3 + d6;
        dArray[2] = d4 + d7;
        dArray[3] = d5 + d8;
    }

    protected void nextRungeKuttaPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = d * this.xPrime(d3, d4, d5, d2);
        double d7 = d * this.yPrime(d3, d4, d5, d2);
        double d8 = d * this.zPrime(d3, d4, d5, d2);
        double d9 = d * this.xPrime(d3 + d6 / 2.0, d4 + d7 / 2.0, d5 + d8 / 2.0, d2 + d / 2.0);
        double d10 = d * this.yPrime(d3 + d6 / 2.0, d4 + d7 / 2.0, d5 + d8 / 2.0, d2 + d / 2.0);
        double d11 = d * this.zPrime(d3 + d6 / 2.0, d4 + d7 / 2.0, d5 + d8 / 2.0, d2 + d / 2.0);
        double d12 = d * this.xPrime(d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d2 + d / 2.0);
        double d13 = d * this.yPrime(d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d2 + d / 2.0);
        double d14 = d * this.zPrime(d3 + d9 / 2.0, d4 + d10 / 2.0, d5 + d11 / 2.0, d2 + d / 2.0);
        double d15 = d * this.xPrime(d3 + d12, d4 + d13, d5 + d14, d2 + d);
        double d16 = d * this.yPrime(d3 + d12, d4 + d13, d5 + d14, d2 + d);
        double d17 = d * this.zPrime(d3 + d12, d4 + d13, d5 + d14, d2 + d);
        double d18 = d6 / 6.0 + d9 / 3.0 + d12 / 3.0 + d15 / 6.0;
        double d19 = d7 / 6.0 + d10 / 3.0 + d13 / 3.0 + d16 / 6.0;
        double d20 = d8 / 6.0 + d11 / 3.0 + d14 / 3.0 + d17 / 4.0;
        dArray[0] = d2 + d;
        dArray[1] = d3 + d18;
        dArray[2] = d4 + d19;
        dArray[3] = d5 + d20;
    }

    public ODE1stOrder3DNonAutonomous() {
        super(false, false, "t", "x", "y", "z");
        this.initialDataDefault = new double[]{0.0, 1.0, 1.0, 1.0};
    }

    protected MouseTask makeDefaultMouseTask(ODE_3D.ODEView oDEView) {
        return new StartOrbit();
    }

    private class StartOrbit
    extends BasicMouseTask3D {
        private StartOrbit() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isAltDown()) {
                ODE_3D.ODEView oDEView = (ODE_3D.ODEView)view;
                double d = oDEView.getCurrentTimeFromControlPanel();
                Vector3D vector3D = ODE1stOrder3DNonAutonomous.this.screenPointTo3DPoint(oDEView, mouseEvent.getX(), mouseEvent.getY());
                if (vector3D != null) {
                    oDEView.startOrbitAtPoint(new double[]{d, vector3D.x, vector3D.y, vector3D.z});
                }
                return false;
            }
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText");
        }
    }
}

