/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.firstorder2D;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import vmm.core.BasicMouseTask2D;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.ode.ODE_2D;

public abstract class ODE1stOrder2D
extends ODE_2D {
    protected abstract double x1Prime(double var1, double var3);

    protected abstract double x2Prime(double var1, double var3);

    protected final double vectorField_x(double d, double d2, double d3) {
        return this.x1Prime(d, d2);
    }

    protected final double vectorField_y(double d, double d2, double d3) {
        return this.x2Prime(d, d2);
    }

    protected void nextEulerPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = d * this.x1Prime(d2, d3);
        double d5 = d * this.x2Prime(d2, d3);
        dArray[0] = d2 + d4;
        dArray[1] = d3 + d5;
    }

    protected void nextRungeKuttaPoint(double[] dArray, double d) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = d * this.x1Prime(d2, d3);
        double d5 = d * this.x2Prime(d2, d3);
        double d6 = d * this.x1Prime(d2 + d4 / 2.0, d3 + d5 / 2.0);
        double d7 = d * this.x2Prime(d2 + d4 / 2.0, d3 + d5 / 2.0);
        double d8 = d * this.x1Prime(d2 + d6 / 2.0, d3 + d7 / 2.0);
        double d9 = d * this.x2Prime(d2 + d6 / 2.0, d3 + d7 / 2.0);
        double d10 = d * this.x1Prime(d2 + d8, d3 + d9);
        double d11 = d * this.x2Prime(d2 + d8, d3 + d9);
        double d12 = d4 / 6.0 + d6 / 3.0 + d8 / 3.0 + d10 / 6.0;
        double d13 = d5 / 6.0 + d7 / 3.0 + d9 / 3.0 + d11 / 6.0;
        dArray[0] = d2 + d12;
        dArray[1] = d3 + d13;
    }

    public ODE1stOrder2D() {
        super(true, true, "x", "y");
    }

    protected MouseTask makeDefaultMouseTask(ODE_2D.ODEView oDEView) {
        return new StartOrbit();
    }

    private class StartOrbit
    extends BasicMouseTask2D {
        private StartOrbit() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isAltDown()) {
                ODE_2D.ODEView oDEView = (ODE_2D.ODEView)view;
                Point2D.Double double_ = new Point2D.Double(mouseEvent.getX(), mouseEvent.getY());
                view.getTransform().viewportToWindow(double_);
                oDEView.startOrbitAtPoint(new double[]{((Point2D)double_).getX(), ((Point2D)double_).getY()});
                return false;
            }
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText");
        }
    }
}

