/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import vmm.core.Display;
import vmm.core.Transform;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class OrbitPoints3D {
    public static final int LINES = 0;
    public static final int DOTS = 1;
    private ArrayList<Vector3D> points = new ArrayList();
    private Color color = null;
    private int style = 0;
    private double dotDiameter = 2.0;

    public int getPointCount() {
        return this.points.size();
    }

    public Vector3D getPoint(int n) {
        return this.points.get(n);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        if (this.style != n && (n == 1 || n == 0)) {
            this.style = n;
        }
    }

    public double getDotDiameter() {
        return this.dotDiameter;
    }

    public void setDotDiameter(double d) {
        this.dotDiameter = d < 1.0 ? 1.0 : d;
    }

    public void clear() {
        this.points.clear();
    }

    public void addPoint(Vector3D vector3D) {
        this.points.add(vector3D);
    }

    public void addPoints(Vector3D[] vector3DArray) {
        if (vector3DArray != null & vector3DArray.length > 0) {
            for (int i = 0; i < vector3DArray.length; ++i) {
                this.points.add(vector3DArray[i]);
            }
        }
    }

    public boolean addNow(View3D view3D, Vector3D vector3D) {
        this.points.add(vector3D);
        if (view3D != null && vector3D != null && (this.style == 1 || this.points.size() > 1 && this.points.get(this.points.size() - 2) != null)) {
            if (view3D.beginDrawToOffscreenImage()) {
                if (view3D.getViewStyle() == 1) {
                    view3D.setColor(Color.WHITE);
                } else if (this.color != null) {
                    view3D.setColor(this.color);
                }
                this.drawPoint(view3D, this.points.size() - 1);
                view3D.endDrawToOffscreenImage();
                Display display = view3D.getDisplay();
                if (display != null) {
                    display.repaint();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean addNow(View3D view3D, Vector3D[] vector3DArray) {
        if (view3D != null && vector3DArray != null && vector3DArray.length > 0) {
            this.addPoints(vector3DArray);
            if (view3D.beginDrawToOffscreenImage()) {
                if (this.color != null) {
                    view3D.getTransform().getGraphics().setColor(this.color);
                }
                for (int i = this.points.size() - vector3DArray.length; i < this.points.size(); ++i) {
                    this.drawPoint(view3D, i);
                }
                view3D.endDrawToOffscreenImage();
                Display display = view3D.getDisplay();
                if (display != null) {
                    display.repaint();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void drawPoint(View3D view3D, int n) {
        Vector3D vector3D = this.points.get(n);
        if (vector3D == null) {
            return;
        }
        switch (this.style) {
            case 0: {
                Vector3D vector3D2;
                Vector3D vector3D3 = vector3D2 = n == 0 ? vector3D : this.points.get(n - 1);
                if (vector3D2 == null) {
                    return;
                }
                view3D.drawLine(vector3D2, vector3D);
                break;
            }
            case 1: {
                view3D.drawDot(vector3D, this.dotDiameter);
            }
        }
    }

    public void draw(Graphics2D graphics2D, View3D view3D, Transform transform) {
        Color color = graphics2D.getColor();
        if (view3D.getViewStyle() == 1) {
            graphics2D.setColor(Color.WHITE);
        } else if (this.color != null) {
            graphics2D.setColor(this.color);
        }
        if (this.style == 0) {
            Vector3D[] vector3DArray = new Vector3D[this.points.size()];
            this.points.toArray(vector3DArray);
            view3D.drawCurve(vector3DArray);
        } else {
            for (Vector3D vector3D : this.points) {
                view3D.drawDot(vector3D, this.dotDiameter);
            }
        }
        if (this.color != null) {
            graphics2D.setColor(color);
        }
    }
}

