/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import vmm.core.Display;
import vmm.core.Transform;
import vmm.core.View;

public class OrbitPoints2D {
    public static final int LINES = 0;
    public static final int DOTS = 1;
    private ArrayList<Point2D> points = new ArrayList();
    private Color color = null;
    private int style = 0;
    private double dotDiameter = 2.5;

    public int getPointCount() {
        return this.points.size();
    }

    public Point2D getPoint(int n) {
        return this.points.get(n);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        if (this.style != n && (n == 1 || n == 0)) {
            this.style = n;
        }
    }

    public double getDotDiameter() {
        return this.dotDiameter;
    }

    public void setDotDiameter(double d) {
        this.dotDiameter = d < 1.0 ? 1.0 : d;
    }

    public void clear() {
        this.points.clear();
    }

    public void addPoint(Point2D point2D) {
        this.points.add(point2D);
    }

    public void addPoints(Point2D[] point2DArray) {
        if (point2DArray != null & point2DArray.length > 0) {
            for (int i = 0; i < point2DArray.length; ++i) {
                this.points.add(point2DArray[i]);
            }
        }
    }

    public boolean addNow(View view, Point2D point2D) {
        this.points.add(point2D);
        if (view != null && point2D != null && (this.style == 1 || this.points.size() > 1 && this.points.get(this.points.size() - 2) != null)) {
            if (view.beginDrawToOffscreenImage()) {
                if (this.color != null) {
                    view.setColor(this.color);
                }
                this.drawPoint(view, this.points.size() - 1);
                view.endDrawToOffscreenImage();
                Display display = view.getDisplay();
                if (display != null) {
                    display.repaint();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean addNow(View view, Point2D[] point2DArray) {
        if (view != null && point2DArray != null && point2DArray.length > 0) {
            this.addPoints(point2DArray);
            if (view.beginDrawToOffscreenImage()) {
                if (this.color != null) {
                    view.getTransform().getGraphics().setColor(this.color);
                }
                for (int i = this.points.size() - point2DArray.length; i < this.points.size(); ++i) {
                    this.drawPoint(view, i);
                }
                view.endDrawToOffscreenImage();
                Display display = view.getDisplay();
                if (display != null) {
                    display.repaint();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void drawPoint(View view, int n) {
        Point2D point2D = this.points.get(n);
        if (point2D == null) {
            return;
        }
        switch (this.style) {
            case 0: {
                Point2D point2D2;
                Point2D point2D3 = point2D2 = n == 0 ? point2D : this.points.get(n - 1);
                if (point2D2 == null) {
                    return;
                }
                view.drawLine(point2D2, point2D);
                break;
            }
            case 1: {
                view.drawDot(point2D, this.dotDiameter);
            }
        }
    }

    public void draw(Graphics2D graphics2D, View view, Transform transform) {
        Color color = graphics2D.getColor();
        if (this.color != null) {
            graphics2D.setColor(this.color);
        }
        if (this.style == 0) {
            Point2D[] point2DArray = new Point2D[this.points.size()];
            this.points.toArray(point2DArray);
            view.drawCurve(point2DArray);
        } else {
            for (Point2D point2D : this.points) {
                view.drawDot(point2D, this.dotDiameter);
            }
        }
        if (this.color != null) {
            graphics2D.setColor(color);
        }
    }
}

