/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.BasicMouseTask2D;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.SaveAndRestore;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.ode.OrbitPoints2D;

public abstract class ODE_2D
extends Exhibit {
    public static final int ORBIT_TYPE_RUNGE_KUTTA = 0;
    public static final int ORBIT_TYPE_BOTH = 1;
    public static final int ORBIT_TYPE_EULER = 2;
    private static final int DF_SPACING = 30;
    private static final Color DIRECTION_FIELD_COLOR = Color.GRAY;
    private static final Color RUNGE_KUTTA_ORBIT_COLOR = Color.RED;
    private static final Color EULER_ORBIT_COLOR = Color.GREEN;
    private static final Color OLD_RUNGE_KUTTA_ORBIT_COLOR = new Color(150, 80, 80);
    private static final Color OLD_EULER_ORBIT_COLOR = new Color(80, 150, 80);
    private static final Color RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR = Color.CYAN;
    private static final Color RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR = Color.MAGENTA;
    private static final Color EULER_PROJECTED_ORBIT_X_COLOR = new Color(100, 150, 150);
    private static final Color EULER_PROJECTED_ORBIT_Y_COLOR = new Color(150, 100, 150);
    protected final boolean isAutonomous;
    protected final boolean canShowVectorField;
    protected final String[] inputLabelNames;
    protected boolean addOrbitTypesToControlPanel = true;
    protected boolean addAnimateCheckBoxToControlPanel = true;
    protected boolean addLinesCheckBoxToControlPanel = true;
    protected boolean addProjectedOrbitsAction = true;
    protected double dtDefault = 0.05;
    protected double timeSpanDefault = 10.0;
    protected double[] initialDataDefault = null;

    protected abstract void nextEulerPoint(double[] var1, double var2);

    protected abstract void nextRungeKuttaPoint(double[] var1, double var2);

    protected Point2D extractPointFromData(double[] dArray) {
        if (this.isAutonomous) {
            return new Point2D.Double(dArray[0], dArray[1]);
        }
        return new Point2D.Double(dArray[1], dArray[2]);
    }

    protected double vectorField_x(double d, double d2, double d3) {
        return 0.0;
    }

    protected double vectorField_y(double d, double d2, double d3) {
        return 0.0;
    }

    protected MouseTask makeDefaultMouseTask(ODEView oDEView) {
        return new BasicMouseTask2D();
    }

    protected ODE_2D(boolean bl, boolean bl2, String ... stringArray) {
        this.setDefaultBackground(Color.BLACK);
        this.canShowVectorField = bl;
        this.isAutonomous = bl2;
        this.inputLabelNames = stringArray;
    }

    public TimerAnimation getCreateAnimation(View view) {
        if (view instanceof ODEView) {
            return ((ODEView)view).makeCreateAnimation();
        }
        return null;
    }

    protected void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        if (!this.canShowVectorField) {
            return;
        }
        if (!(view instanceof ODEView) || ((ODEView)view).showDirectionField) {
            this.drawDirectionField(view, transform);
        }
    }

    private void drawDirectionField(View view, Transform transform) {
        double d = 30.0 * transform.getPixelWidth();
        int n = (int)(transform.getXmin() / d) - 1;
        int n2 = (int)(transform.getXmax() / d) + 1;
        int n3 = (int)(transform.getYmin() / d) - 1;
        int n4 = (int)(transform.getYmax() / d) + 1;
        Color color = view.getColor();
        view.setColor(DIRECTION_FIELD_COLOR);
        double d2 = 0.0;
        if (view instanceof ODEView) {
            d2 = ((ODEView)view).currentTime;
        }
        for (int i = n; i <= n2; ++i) {
            double d3 = (double)i * d;
            for (int j = n3; j <= n4; ++j) {
                double d4;
                double d5 = (double)j * d;
                double d6 = this.vectorField_x(d3, d5, d2);
                double d7 = Math.sqrt(d6 * d6 + (d4 = this.vectorField_y(d3, d5, d2)) * d4);
                if (Double.isNaN(d7)) continue;
                if (Math.abs(d7) < 1.0E-6) {
                    view.drawPixel(d3, d5);
                    continue;
                }
                d6 = d6 / d7 * (d / 4.0);
                d4 = d4 / d7 * (d / 4.0);
                view.drawLine(d3 - d6, d5 - d4, d3 + d6, d5 + d4);
            }
        }
        view.setColor(color);
    }

    public View getDefaultView() {
        return new ODEView();
    }

    private class ControlPanel
    extends JPanel {
        ODEView owner;
        JTextField[] icInputs;
        JTextField dtInput;
        JTextField timeSpanInput;
        JButton startOrbitButton;

        ControlPanel(ODEView oDEView) {
            JRadioButton[] jRadioButtonArray;
            JComponent jComponent;
            JComponent jComponent2;
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1));
            this.add(jPanel);
            this.owner = oDEView;
            Font font = new Font("SansSerif", 1, 10);
            Font font2 = new Font("SansSerif", 0, 10);
            this.startOrbitButton = new JButton(I18n.tr("vmm.ode.command.StartOrbitAt"));
            this.startOrbitButton.setFont(font);
            jPanel.add(this.startOrbitButton);
            this.icInputs = new JTextField[ODE_2D.this.inputLabelNames.length];
            for (int i = 0; i < ODE_2D.this.inputLabelNames.length; ++i) {
                this.icInputs[i] = new JTextField(6);
                this.icInputs[i].setFont(font2);
                jComponent2 = new JPanel();
                jComponent = new JLabel(ODE_2D.this.inputLabelNames[i] + " =");
                jComponent.setFont(font);
                jComponent2.add(jComponent);
                jComponent2.add(this.icInputs[i]);
                jPanel.add(jComponent2);
            }
            this.dtInput = new JTextField("" + ODE_2D.this.dtDefault, 4);
            this.timeSpanInput = new JTextField("" + ODE_2D.this.timeSpanDefault, 3);
            this.dtInput.setFont(font2);
            this.timeSpanInput.setFont(font2);
            JPanel jPanel2 = new JPanel();
            jComponent2 = new JLabel(I18n.tr("vmm.ode.StepSize") + "=");
            jComponent2.setFont(font);
            jPanel2.add(jComponent2);
            jPanel2.add(this.dtInput);
            jPanel.add(jPanel2);
            jPanel2 = new JPanel();
            jComponent2 = new JLabel(I18n.tr("vmm.ode.TimeSpan") + "=");
            jComponent2.setFont(font);
            jPanel2.add(jComponent2);
            jPanel2.add(this.timeSpanInput);
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(1));
            jComponent = new JButton(oDEView.continueOrbitAction);
            jComponent.setFont(font);
            jPanel.add(jComponent);
            jComponent = new JButton(oDEView.eraseOrbitsAction);
            jComponent.setFont(font);
            jPanel.add(jComponent);
            if (ODE_2D.this.addAnimateCheckBoxToControlPanel) {
                jRadioButtonArray = this.owner.animateDrawingToggle.createCheckBox();
                jRadioButtonArray.setFont(font);
                jRadioButtonArray.setText(I18n.tr("vmm.ode.command.AnimateDrawing.short"));
                jPanel.add((Component)jRadioButtonArray);
            }
            if (ODE_2D.this.addLinesCheckBoxToControlPanel) {
                jRadioButtonArray = this.owner.connectDotsToggle.createCheckBox();
                jRadioButtonArray.setFont(font);
                jRadioButtonArray.setText(I18n.tr("vmm.ode.command.ConnectDotsOnOrbit.short"));
                jPanel.add((Component)jRadioButtonArray);
            }
            if (ODE_2D.this.addOrbitTypesToControlPanel) {
                for (JRadioButton jRadioButton : jRadioButtonArray = oDEView.orbitTypeSelect.createRadioButtons()) {
                    jRadioButton.setFont(font);
                    jPanel.add(jRadioButton);
                }
            }
            this.startOrbitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d;
                    double d2;
                    ControlPanel.this.owner.getDisplay().stopAnimation();
                    double[] dArray = new double[ControlPanel.this.icInputs.length];
                    for (int i = 0; i < ControlPanel.this.icInputs.length; ++i) {
                        try {
                            dArray[i] = Double.parseDouble(ControlPanel.this.icInputs[i].getText());
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(ControlPanel.this.owner.getDisplay(), I18n.tr("vmm.ode.error.BadNumberInput", ODE_2D.this.inputLabelNames[i]));
                            return;
                        }
                    }
                    try {
                        d2 = Double.parseDouble(ControlPanel.this.dtInput.getText());
                        if (d2 <= 0.0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(ControlPanel.this.owner.getDisplay(), I18n.tr("vmm.ode.error.BadPositiveNumberInput", "dt"));
                        return;
                    }
                    try {
                        d = Double.parseDouble(ControlPanel.this.timeSpanInput.getText());
                        if (d <= 0.0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(ControlPanel.this.owner.getDisplay(), I18n.tr("vmm.ode.error.BadPositiveNumberInput", I18n.tr("vmm.ode.TimeSpan")));
                        return;
                    }
                    ControlPanel.this.owner.startOrbitAtPoint(dArray, d2, d);
                }
            });
        }

        void resetStartPointInputText(double[] dArray) {
            for (int i = 0; i < this.icInputs.length; ++i) {
                try {
                    if (Math.abs(dArray[i] - Double.parseDouble(this.icInputs[i].getText())) < 5.0E-10) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string = String.format("%.4g", dArray[i]);
                this.icInputs[i].setText(string);
            }
        }
    }

    private class ExtendOrbitAnimation
    extends TimerAnimation {
        ODEView view;
        Orbit orbit;
        int finalNumberOfPoints;

        ExtendOrbitAnimation(ODEView oDEView, Orbit orbit, int n) {
            super(n, 15);
            this.view = oDEView;
            this.orbit = orbit;
            this.finalNumberOfPoints = orbit.getPointCount() + n;
            if (orbit.isCurrentOrbit && oDEView.projectedOrbitView != null) {
                oDEView.projectedOrbitView.setMaxPoints(orbit.getPointCount() + n + 1);
            }
        }

        protected void drawFrame() {
            if (!this.view.getAnimateDrawing()) {
                this.orbit.setPointCount(this.finalNumberOfPoints);
                this.cancel();
                return;
            }
            boolean bl = this.orbit.addNextPoint();
            if (!bl) {
                this.cancel();
            }
            if (ODE_2D.this.canShowVectorField && !ODE_2D.this.isAutonomous) {
                this.view.forceRedraw();
            }
        }

        protected void animationStarting() {
            if (ODE_2D.this.canShowVectorField && !ODE_2D.this.isAutonomous) {
                this.view.setShowDirectionField(true);
            }
        }

        protected void animationEnding() {
            this.orbit.forceRedraw();
            if (ODE_2D.this.canShowVectorField && !ODE_2D.this.isAutonomous) {
                this.view.setShowDirectionField(false);
            }
        }
    }

    private class Orbit
    extends Decoration {
        double[] initialData;
        double[] currentEulerData;
        double[] currentRungeKuttaData;
        OrbitPoints2D eulerPoints;
        OrbitPoints2D rungeKuttaPoints;
        ODEView view;
        boolean isCurrentOrbit;
        int orbitType;
        double dt;
        int pointCount;

        Orbit(ODEView oDEView, double[] dArray, int n, double d) {
            this.view = oDEView;
            this.initialData = dArray;
            this.orbitType = n;
            this.dt = d;
            this.eulerPoints = new OrbitPoints2D();
            this.rungeKuttaPoints = new OrbitPoints2D();
            this.eulerPoints.setColor(EULER_ORBIT_COLOR);
            this.eulerPoints.setStyle(1);
            this.rungeKuttaPoints.setColor(RUNGE_KUTTA_ORBIT_COLOR);
            this.rungeKuttaPoints.setStyle(1);
            Point2D point2D = ODE_2D.this.extractPointFromData(dArray);
            this.eulerPoints.addPoint(point2D);
            this.rungeKuttaPoints.addPoint(point2D);
            this.currentEulerData = n == 0 ? null : (double[])dArray.clone();
            this.currentRungeKuttaData = n == 2 ? null : (double[])dArray.clone();
            this.pointCount = 1;
        }

        void setStyle(int n) {
            this.eulerPoints.setStyle(n);
            this.rungeKuttaPoints.setStyle(n);
            this.fireDecorationChangeEvent();
        }

        int getOrbitType() {
            return this.orbitType;
        }

        OrbitPoints2D getEulerPoints() {
            return this.eulerPoints;
        }

        OrbitPoints2D getRungeKuttaPoints() {
            return this.rungeKuttaPoints;
        }

        int getPointCount() {
            return this.pointCount;
        }

        void setPointCount(int n) {
            this.pointCount = n;
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.setMaxPoints(this.pointCount);
            }
            this.forceRedraw();
        }

        void removePoints() {
            this.eulerPoints.clear();
            this.rungeKuttaPoints.clear();
            Point2D point2D = ODE_2D.this.extractPointFromData(this.initialData);
            this.eulerPoints.addPoint(point2D);
            this.rungeKuttaPoints.addPoint(point2D);
            this.currentEulerData = this.orbitType == 0 ? null : (double[])this.initialData.clone();
            this.currentRungeKuttaData = this.orbitType == 2 ? null : (double[])this.initialData.clone();
            this.pointCount = 1;
            this.forceRedraw();
        }

        Point2D getEulerPoint(int n) {
            if (n >= this.eulerPoints.getPointCount()) {
                return null;
            }
            return this.eulerPoints.getPoint(n);
        }

        Point2D getRungeKuttaPoint(int n) {
            if (n >= this.rungeKuttaPoints.getPointCount()) {
                return null;
            }
            return this.rungeKuttaPoints.getPoint(n);
        }

        void setOrbitType(int n) {
            this.orbitType = n;
            this.forceRedraw();
        }

        void setIsCurrentOrbit(boolean bl) {
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.clear();
            }
            this.isCurrentOrbit = bl;
            this.eulerPoints.setColor(this.isCurrentOrbit ? EULER_ORBIT_COLOR : OLD_EULER_ORBIT_COLOR);
            this.rungeKuttaPoints.setColor(this.isCurrentOrbit ? RUNGE_KUTTA_ORBIT_COLOR : OLD_RUNGE_KUTTA_ORBIT_COLOR);
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.setMaxPoints(this.pointCount);
                this.view.projectedOrbitView.resetPointsFromOrbit(this);
            }
        }

        boolean addNextPoint() {
            Point2D point2D = null;
            Point2D point2D2 = null;
            if (this.orbitType >= 1 && this.currentEulerData != null) {
                ODE_2D.this.nextEulerPoint(this.currentEulerData, this.dt);
                for (double d : this.currentEulerData) {
                    if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                    this.currentEulerData = null;
                    break;
                }
                if (this.currentEulerData != null) {
                    point2D = ODE_2D.this.extractPointFromData(this.currentEulerData);
                }
            }
            if (this.orbitType <= 1 && this.currentRungeKuttaData != null) {
                ODE_2D.this.nextRungeKuttaPoint(this.currentRungeKuttaData, this.dt);
                for (double d : this.currentRungeKuttaData) {
                    if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                    this.currentRungeKuttaData = null;
                    break;
                }
                if (this.currentRungeKuttaData != null) {
                    point2D2 = ODE_2D.this.extractPointFromData(this.currentRungeKuttaData);
                }
            }
            if (point2D == null && point2D2 == null) {
                return false;
            }
            if (!ODE_2D.this.isAutonomous) {
                double d = Double.NEGATIVE_INFINITY;
                if (this.currentEulerData != null) {
                    d = this.currentEulerData[0];
                }
                if (this.currentRungeKuttaData != null && this.currentRungeKuttaData[0] > d) {
                    d = this.currentRungeKuttaData[0];
                }
                this.view.currentTime = d;
            }
            ++this.pointCount;
            boolean bl = true;
            if (point2D != null) {
                bl = this.eulerPoints.addNow((View)this.view, point2D);
            }
            if (point2D2 != null) {
                boolean bl2 = bl = bl && this.rungeKuttaPoints.addNow((View)this.view, point2D2);
            }
            if (!bl) {
                this.view.forceRedraw();
            }
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.addPoints(point2D, point2D2);
            }
            return true;
        }

        public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
            if ((this.decorationNeedsRedraw || bl) && this.pointCount > 1) {
                int n;
                this.currentRungeKuttaData = null;
                this.currentEulerData = null;
                if (this.orbitType >= 1) {
                    this.currentEulerData = (double[])this.initialData.clone();
                    this.eulerPoints.clear();
                    this.eulerPoints.addPoint(ODE_2D.this.extractPointFromData(this.initialData));
                    for (n = 1; n < this.pointCount; ++n) {
                        ODE_2D.this.nextEulerPoint(this.currentEulerData, this.dt);
                        for (double d : this.currentEulerData) {
                            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                            this.currentEulerData = null;
                            break;
                        }
                        if (this.currentEulerData == null) break;
                        this.eulerPoints.addPoint(ODE_2D.this.extractPointFromData(this.currentEulerData));
                    }
                }
                if (this.orbitType <= 1) {
                    this.currentRungeKuttaData = (double[])this.initialData.clone();
                    this.rungeKuttaPoints.clear();
                    this.rungeKuttaPoints.addPoint(ODE_2D.this.extractPointFromData(this.initialData));
                    for (n = 1; n < this.pointCount; ++n) {
                        ODE_2D.this.nextRungeKuttaPoint(this.currentRungeKuttaData, this.dt);
                        for (double d : this.currentRungeKuttaData) {
                            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                            this.currentRungeKuttaData = null;
                            break;
                        }
                        if (this.currentRungeKuttaData == null) break;
                        this.rungeKuttaPoints.addPoint(ODE_2D.this.extractPointFromData(this.currentRungeKuttaData));
                    }
                }
                if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                    this.view.projectedOrbitView.resetPointsFromOrbit(this);
                }
            }
        }

        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            if (this.orbitType >= 1) {
                this.eulerPoints.draw(graphics2D, view, transform);
            }
            if (this.orbitType <= 1) {
                this.rungeKuttaPoints.draw(graphics2D, view, transform);
            }
        }
    }

    private class ProjectedOrbitView
    extends View {
        ArrayList<Point2D> eulerPoints;
        ArrayList<Point2D> rungeKuttaPoints;
        int maxNumberOfPoints;
        ODEView owner;

        ProjectedOrbitView(ODEView oDEView) {
            this.owner = oDEView;
            this.setPreserveAspect(false);
            this.setApplyGraphics2DTransform(false);
            this.setAntialiased(true);
            this.eulerPoints = new ArrayList();
            this.rungeKuttaPoints = new ArrayList();
            this.setExhibit(new Exhibit(){

                protected void doDraw(Graphics2D graphics2D, View view, Transform transform) {
                    ProjectedOrbitView.this.draw(graphics2D, transform);
                }

                public Color getDefaultBackground() {
                    return Color.BLACK;
                }

                public Transform getDefaultTransform(View view) {
                    return new POVTransform();
                }
            });
        }

        public MouseTask getDefaultMouseTask() {
            return null;
        }

        void setMaxPoints(int n) {
            this.maxNumberOfPoints = n;
            this.forceRedraw();
        }

        void resetPointsFromOrbit(Orbit orbit) {
            int n;
            int n2;
            OrbitPoints2D orbitPoints2D;
            this.eulerPoints.clear();
            this.rungeKuttaPoints.clear();
            if (orbit.getOrbitType() >= 1) {
                orbitPoints2D = orbit.getEulerPoints();
                n2 = orbitPoints2D.getPointCount();
                for (n = 0; n < n2; ++n) {
                    this.eulerPoints.add(orbitPoints2D.getPoint(n));
                }
            }
            if (orbit.getOrbitType() <= 1) {
                orbitPoints2D = orbit.getRungeKuttaPoints();
                n2 = orbitPoints2D.getPointCount();
                for (n = 0; n < n2; ++n) {
                    this.rungeKuttaPoints.add(orbitPoints2D.getPoint(n));
                }
            }
            this.forceRedraw();
        }

        void clear() {
            this.eulerPoints.clear();
            this.rungeKuttaPoints.clear();
            this.forceRedraw();
        }

        void addPoints(Point2D point2D, Point2D point2D2) {
            int n;
            this.eulerPoints.add(point2D);
            this.rungeKuttaPoints.add(point2D2);
            if (point2D == null && point2D2 == null) {
                return;
            }
            if (point2D != null && this.eulerPoints.size() > 1 && !this.drawLineNow(n = this.eulerPoints.size() - 1, this.eulerPoints.get(n - 1), this.eulerPoints.get(n), true)) {
                this.forceRedraw();
                return;
            }
            if (point2D2 != null && this.rungeKuttaPoints.size() > 1 && !this.drawLineNow(n = this.rungeKuttaPoints.size() - 1, this.rungeKuttaPoints.get(n - 1), this.rungeKuttaPoints.get(n), false)) {
                this.forceRedraw();
            }
        }

        boolean drawLineNow(int n, Point2D point2D, Point2D point2D2, boolean bl) {
            if (point2D == null || point2D2 == null) {
                return true;
            }
            if (!this.beginDrawToOffscreenImage()) {
                return false;
            }
            Transform transform = this.getTransform();
            ((POVTransform)transform).getLimitsFromOwner();
            double d = (transform.getXmax() - transform.getXmin()) / (double)transform.getWidth();
            double d2 = 15.0 * d;
            double d3 = transform.getXmin() + 3.0 * d2;
            double d4 = (transform.getXmax() - transform.getXmin() - 3.0 * d2) / (double)(this.maxNumberOfPoints - 1);
            double d5 = d3 + (double)n * d4;
            if (bl) {
                this.setColor(EULER_PROJECTED_ORBIT_X_COLOR);
                this.drawLine(d5 - d4, point2D.getX(), d5, point2D2.getX());
                this.setColor(EULER_PROJECTED_ORBIT_Y_COLOR);
                this.drawLine(d5 - d4, point2D.getY(), d5, point2D2.getY());
            } else {
                this.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR);
                this.drawLine(d5 - d4, point2D.getX(), d5, point2D2.getX());
                this.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR);
                this.drawLine(d5 - d4, point2D.getY(), d5, point2D2.getY());
            }
            return true;
        }

        void draw(Graphics2D graphics2D, Transform transform) {
            Point2D point2D;
            double d;
            int n;
            Point2D point2D2;
            ((POVTransform)transform).getLimitsFromOwner();
            double d2 = (transform.getXmax() - transform.getXmin()) / (double)transform.getWidth();
            double d3 = 15.0 * d2;
            graphics2D.setColor(Color.LIGHT_GRAY);
            this.drawLine(transform.getXmin() + 2.0 * d3, 0.0, transform.getXmax(), 0.0);
            this.drawLine(transform.getXmin() + 3.0 * d3, transform.getYmin(), transform.getXmin() + 3.0 * d3, transform.getYmax());
            double d4 = transform.getYmax() - transform.getYmin();
            graphics2D.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR);
            this.drawString("x", transform.getXmin() + d3, transform.getYmax() - d4 / 3.0 - 3.0 * d2);
            graphics2D.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR);
            this.drawString("y", transform.getXmin() + d3, transform.getYmax() - 2.0 * d4 / 3.0 - 3.0 * d2);
            double d5 = transform.getXmin() + 3.0 * d3;
            double d6 = (transform.getXmax() - transform.getXmin() - 3.0 * d3) / (double)(this.maxNumberOfPoints - 1);
            if (this.owner.getOrbitType() >= 1 && this.eulerPoints.size() > 0) {
                point2D2 = this.eulerPoints.get(0);
                for (n = 1; n < this.eulerPoints.size(); ++n) {
                    d = d5 + (double)n * d6;
                    point2D = this.eulerPoints.get(n);
                    if (point2D2 != null && point2D != null) {
                        graphics2D.setColor(EULER_PROJECTED_ORBIT_X_COLOR);
                        this.drawLine(d - d6, point2D2.getX(), d, point2D.getX());
                        graphics2D.setColor(EULER_PROJECTED_ORBIT_Y_COLOR);
                        this.drawLine(d - d6, point2D2.getY(), d, point2D.getY());
                    }
                    point2D2 = point2D;
                }
            }
            if (this.owner.getOrbitType() <= 1 && this.rungeKuttaPoints.size() > 0) {
                point2D2 = this.rungeKuttaPoints.get(0);
                for (n = 1; n < this.rungeKuttaPoints.size(); ++n) {
                    d = d5 + (double)n * d6;
                    point2D = this.rungeKuttaPoints.get(n);
                    if (point2D2 != null && point2D != null) {
                        graphics2D.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR);
                        this.drawLine(d - d6, point2D2.getX(), d, point2D.getX());
                        graphics2D.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR);
                        this.drawLine(d - d6, point2D2.getY(), d, point2D.getY());
                    }
                    point2D2 = point2D;
                }
            }
        }

        private class POVTransform
        extends Transform {
            private POVTransform() {
            }

            void getLimitsFromOwner() {
                Transform transform = ProjectedOrbitView.this.owner.getTransform();
                this.resetLimits(-1.0, 1.0, transform.getYmin(), transform.getYmax());
            }
        }
    }

    public class ODEView
    extends View {
        private boolean showDirectionField;
        @VMMSave
        private boolean showProjectedOrbits = false;
        @VMMSave
        private boolean showControlPanel = true;
        @VMMSave
        private int orbitType = 0;
        @VMMSave
        private boolean connectDotsOnOrbit;
        private boolean animateDrawing = true;
        private Orbit currentOrbit;
        private ControlPanel controlPanel;
        private ProjectedOrbitView projectedOrbitView;
        private double[] initialDataForCreateAnimation;
        private double currentTime;
        protected ToggleAction showDirectionFieldToggle;
        protected ToggleAction showProjectedOrbitsToggle = new ToggleAction(I18n.tr("vmm.ode.command.ShowProjectedOrbits"), false){

            public void actionPerformed(ActionEvent actionEvent) {
                ODEView.this.setShowProjectedOrbits(this.getState());
            }
        };
        protected ToggleAction animateDrawingToggle = new ToggleAction(I18n.tr("vmm.ode.command.AnimateDrawing"), true){

            public void actionPerformed(ActionEvent actionEvent) {
                ODEView.this.setAnimateDrawing(this.getState());
            }
        };
        protected ToggleAction showControlPanelToggle = new ToggleAction(I18n.tr("vmm.ode.command.ShowControlPanel"), true){

            public void actionPerformed(ActionEvent actionEvent) {
                ODEView.this.setShowControlPanel(this.getState());
            }
        };
        protected AbstractActionVMM continueOrbitAction = new AbstractActionVMM(I18n.tr("vmm.ode.command.ContinueOrbit")){

            public void actionPerformed(ActionEvent actionEvent) {
                Orbit orbit = ODEView.this.getCurrentOrbit();
                if (orbit != null) {
                    double d;
                    try {
                        d = Double.parseDouble(((ODEView)ODEView.this).controlPanel.timeSpanInput.getText());
                    }
                    catch (Exception exception) {
                        d = ODE_2D.this.timeSpanDefault;
                        ((ODEView)ODEView.this).controlPanel.timeSpanInput.setText("" + ODE_2D.this.timeSpanDefault);
                    }
                    int n = (int)(d / orbit.dt + 0.5);
                    ((ODEView)ODEView.this).controlPanel.dtInput.setText("" + orbit.dt);
                    if (ODEView.this.animateDrawing) {
                        ODEView.this.getDisplay().installAnimation(new ExtendOrbitAnimation(ODEView.this, orbit, n));
                    } else {
                        orbit.setPointCount(orbit.getPointCount() + n);
                    }
                }
            }
        };
        protected ToggleAction connectDotsToggle = new ToggleAction(I18n.tr("vmm.ode.command.ConnectDotsOnOrbit"), false){

            public void actionPerformed(ActionEvent actionEvent) {
                ODEView.this.setConnectDotsOnOrbit(this.getState());
            }
        };
        protected AbstractActionVMM eraseOrbitsAction = new AbstractActionVMM(I18n.tr("vmm.ode.command.EraseOrbits")){

            public void actionPerformed(ActionEvent actionEvent) {
                Decoration[] decorationArray;
                if (ODEView.this.getDisplay() != null) {
                    ODEView.this.getDisplay().stopAnimation();
                }
                ODEView.this.setCurrentOrbit(null);
                for (Decoration decoration : decorationArray = ODEView.this.getDecorations()) {
                    if (!(decoration instanceof Orbit)) continue;
                    ODEView.this.removeDecoration(decoration);
                }
            }
        };
        protected ActionRadioGroup orbitTypeSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm.ode.command.orbitType.RungeKutta"), I18n.tr("vmm.ode.command.orbitType.Euler"), I18n.tr("vmm.ode.command.orbitType.Both")}, 0){

            public void optionSelected(int n) {
                int n2 = n == 0 ? 0 : (n == 1 ? 2 : 1);
                ODEView.this.setOrbitType(n2);
            }
        };

        public ODEView() {
            this.setShowAxes(true);
            this.setAntialiased(true);
            this.continueOrbitAction.setEnabled(this.getCurrentOrbit() != null);
            this.controlPanel = new ControlPanel(this);
            boolean bl = this.showDirectionField = ODE_2D.this.isAutonomous && ODE_2D.this.canShowVectorField;
            if (ODE_2D.this.isAutonomous && ODE_2D.this.canShowVectorField) {
                this.showDirectionFieldToggle = new ToggleAction(I18n.tr("vmm.ode.command.ShowDirectionField"), true){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ODEView.this.setShowDirectionField(this.getState());
                    }
                };
            }
        }

        public boolean getShowDirectionField() {
            return this.showDirectionField;
        }

        public void setShowDirectionField(boolean bl) {
            if (!ODE_2D.this.canShowVectorField) {
                return;
            }
            if (this.showDirectionField == bl) {
                return;
            }
            this.showDirectionField = bl;
            if (this.showDirectionFieldToggle != null) {
                this.showDirectionFieldToggle.setState(bl);
            }
            this.forceRedraw();
        }

        public boolean getAnimateDrawing() {
            return this.animateDrawing;
        }

        public void setAnimateDrawing(boolean bl) {
            this.animateDrawing = bl;
            this.animateDrawingToggle.setState(bl);
        }

        protected Orbit getCurrentOrbit() {
            return this.currentOrbit;
        }

        protected void setCurrentOrbit(Orbit orbit) {
            if (this.currentOrbit == orbit) {
                return;
            }
            if (this.currentOrbit != null) {
                this.currentOrbit.setIsCurrentOrbit(false);
            }
            this.currentOrbit = orbit;
            if (this.currentOrbit != null) {
                this.currentOrbit.setIsCurrentOrbit(true);
            }
            this.continueOrbitAction.setEnabled(this.currentOrbit != null);
        }

        public boolean getConnectDotsOnOrbit() {
            return this.connectDotsOnOrbit;
        }

        public void setConnectDotsOnOrbit(boolean bl) {
            if (this.connectDotsOnOrbit == bl) {
                return;
            }
            this.connectDotsOnOrbit = bl;
            this.connectDotsToggle.setState(bl);
            if (this.currentOrbit != null) {
                this.currentOrbit.setStyle(bl ? 0 : 1);
            }
        }

        public boolean getShowProjectedOrbits() {
            return this.showProjectedOrbits;
        }

        public int getOrbitType() {
            return this.orbitType;
        }

        public void setOrbitType(int n) {
            if (n == this.orbitType) {
                return;
            }
            this.orbitType = n;
            if (this.currentOrbit != null) {
                this.currentOrbit.setOrbitType(this.orbitType);
                if (this.showProjectedOrbits) {
                    this.projectedOrbitView.forceRedraw();
                }
            }
        }

        public boolean getShowControlPanel() {
            return this.showControlPanel;
        }

        public void setShowControlPanel(boolean bl) {
            if (this.showControlPanel == bl) {
                return;
            }
            this.showControlPanel = bl;
            this.showControlPanelToggle.setState(bl);
            if (bl) {
                if (this.getDisplay() != null) {
                    this.getDisplay().getHolder().add((Component)this.controlPanel, "East");
                    this.getDisplay().getHolder().validate();
                }
            } else if (this.getDisplay() != null) {
                this.getDisplay().getHolder().remove(this.controlPanel);
                this.getDisplay().getHolder().validate();
            }
        }

        public void setShowProjectedOrbits(boolean bl) {
            if (this.showProjectedOrbits == bl) {
                return;
            }
            this.showProjectedOrbits = bl;
            this.showProjectedOrbitsToggle.setState(bl);
            if (bl) {
                this.projectedOrbitView = new ProjectedOrbitView(this);
                if (this.getCurrentOrbit() != null) {
                    this.projectedOrbitView.setMaxPoints(this.getCurrentOrbit().getPointCount());
                    this.projectedOrbitView.resetPointsFromOrbit(this.getCurrentOrbit());
                }
                if (this.getDisplay() != null) {
                    this.getDisplay().installAuxiliaryView(this, this.projectedOrbitView, 3, 0.2, true);
                }
            } else {
                this.projectedOrbitView = null;
                if (this.getDisplay() != null) {
                    this.getDisplay().installAuxiliaryView(this, null);
                }
            }
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(this.continueOrbitAction);
            actionList.add(this.eraseOrbitsAction);
            actionList.add(this.connectDotsToggle);
            actionList.add(this.animateDrawingToggle);
            actionList.add(null);
            actionList.add(this.orbitTypeSelect);
            actionList.add(null);
            if (this.showDirectionFieldToggle != null) {
                actionList.add(this.showDirectionFieldToggle);
            }
            actionList.add(this.showControlPanelToggle);
            if (ODE_2D.this.addProjectedOrbitsAction) {
                actionList.add(this.showProjectedOrbitsToggle);
            }
            return actionList;
        }

        public void setDisplay(Display display) {
            super.setDisplay(display);
            if (display != null) {
                display.setStopAnimationsOnResize(false);
            }
            if (display != null && this.projectedOrbitView != null) {
                display.installAuxiliaryView(this, this.projectedOrbitView, 3, 0.2, true);
            }
            if (display != null && this.showControlPanel) {
                display.getHolder().add((Component)this.controlPanel, "East");
                display.getHolder().validate();
            }
        }

        public void setExhibit(Exhibit exhibit) {
            super.setExhibit(exhibit);
            if (exhibit != null && exhibit == ODE_2D.this) {
                this.initialDataForCreateAnimation = ODE_2D.this.initialDataDefault;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            super.stateChanged(changeEvent);
            Object object = changeEvent.getSource();
            if (this.projectedOrbitView != null && object instanceof Transform) {
                this.projectedOrbitView.forceRedraw();
            }
        }

        public MouseTask getDefaultMouseTask() {
            return ODE_2D.this.makeDefaultMouseTask(this);
        }

        public double getCurrentTimeFromControlPanel() {
            if (ODE_2D.this.isAutonomous) {
                return 0.0;
            }
            try {
                return Double.parseDouble(this.controlPanel.icInputs[0].getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.controlPanel.icInputs[0].setText("0");
                return 0.0;
            }
        }

        public void startOrbitAtPoint(double[] dArray) {
            double d;
            double d2;
            try {
                d2 = Double.parseDouble(this.controlPanel.dtInput.getText());
                if (d2 <= 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                d2 = ODE_2D.this.dtDefault;
                this.controlPanel.dtInput.setText("" + ODE_2D.this.dtDefault);
            }
            try {
                d = Double.parseDouble(this.controlPanel.timeSpanInput.getText());
                if (d <= 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                d = ODE_2D.this.timeSpanDefault;
                this.controlPanel.timeSpanInput.setText("" + ODE_2D.this.timeSpanDefault);
            }
            this.controlPanel.resetStartPointInputText(dArray);
            this.startOrbitAtPoint(dArray, d2, d);
        }

        private TimerAnimation makeCreateAnimation() {
            int n;
            double d;
            double d2;
            Orbit orbit;
            if (!this.animateDrawing) {
                return null;
            }
            if (this.currentOrbit == null && this.initialDataForCreateAnimation == null) {
                return null;
            }
            if (this.currentOrbit != null) {
                orbit = this.currentOrbit;
                d2 = this.currentOrbit.dt;
                d = d2 * (double)this.currentOrbit.pointCount;
                this.currentOrbit.removePoints();
            } else {
                n = ODE_2D.this.inputLabelNames.length;
                d2 = this.initialDataForCreateAnimation.length > n && this.initialDataForCreateAnimation[n] > 0.0 ? this.initialDataForCreateAnimation[n] : ODE_2D.this.dtDefault;
                d = this.initialDataForCreateAnimation.length > n + 1 && this.initialDataForCreateAnimation[n + 1] > 0.0 ? this.initialDataForCreateAnimation[n + 1] : ODE_2D.this.timeSpanDefault;
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this.initialDataForCreateAnimation[i];
                }
                orbit = new Orbit(this, dArray, 0, d2);
                this.controlPanel.resetStartPointInputText(this.initialDataForCreateAnimation);
                this.addDecoration(orbit);
                this.setCurrentOrbit(orbit);
            }
            this.initialDataForCreateAnimation = null;
            n = (int)(d / d2) + 1;
            this.controlPanel.dtInput.setText("" + d2);
            this.controlPanel.timeSpanInput.setText("" + d);
            if (!ODE_2D.this.isAutonomous) {
                this.currentTime = orbit.initialData[0];
            }
            return new ExtendOrbitAnimation(this, orbit, n);
        }

        private void startOrbitAtPoint(double[] dArray, double d, double d2) {
            Orbit orbit = new Orbit(this, dArray, this.orbitType, d);
            this.addDecoration(orbit);
            this.setCurrentOrbit(orbit);
            if (this.getConnectDotsOnOrbit()) {
                orbit.setStyle(0);
            }
            int n = (int)(d2 / d + 0.5);
            if (!ODE_2D.this.isAutonomous) {
                this.currentTime = dArray[0];
            }
            if (this.animateDrawing) {
                this.getDisplay().installAnimation(new ExtendOrbitAnimation(this, orbit, n));
            } else {
                orbit.setPointCount(n + 1);
            }
        }

        public void addExtraXML(Document document, Element element) {
            super.addExtraXML(document, element);
            if (ODE_2D.this.isAutonomous && ODE_2D.this.canShowVectorField) {
                SaveAndRestore.addProperty(this, "showDirectionField", document, element);
            }
            for (Decoration decoration : this.getDecorations()) {
                if (!(decoration instanceof Orbit)) continue;
                Orbit orbit = (Orbit)decoration;
                Element element2 = document.createElement("orbit");
                element2.setAttribute("start", Util.toExternalString(orbit.initialData));
                element2.setAttribute("type", Util.toExternalString(orbit.orbitType));
                element2.setAttribute("dt", Util.toExternalString(orbit.dt));
                element2.setAttribute("points", Util.toExternalString(orbit.pointCount));
                element2.setAttribute("isCurrentOrbit", Util.toExternalString(orbit.isCurrentOrbit));
                element.appendChild(element2);
            }
        }

        public void readExtraXML(Element element) throws IOException {
            super.readExtraXML(element);
            NodeList nodeList = element.getElementsByTagName("orbit");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                double[] dArray = (double[])Util.externalStringToValue(element2.getAttribute("start"), double[].class);
                double d = (Double)Util.externalStringToValue(element2.getAttribute("dt"), Double.TYPE);
                int n = (Integer)Util.externalStringToValue(element2.getAttribute("type"), Integer.TYPE);
                int n2 = (Integer)Util.externalStringToValue(element2.getAttribute("points"), Integer.TYPE);
                boolean bl = (Boolean)Util.externalStringToValue(element2.getAttribute("isCurrentOrbit"), Boolean.TYPE);
                Orbit orbit = new Orbit(this, dArray, n, d);
                orbit.pointCount = n2;
                orbit.setIsCurrentOrbit(bl);
                this.addDecoration(orbit);
                if (!bl) continue;
                this.controlPanel.dtInput.setText("" + d);
                this.controlPanel.resetStartPointInputText(dArray);
                this.currentOrbit = orbit;
                this.continueOrbitAction.setEnabled(true);
            }
        }
    }
}

