/*
 * Decompiled with CFR 0.152.
 */
package vmm.latticemodel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionItem;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.MouseTask;
import vmm.core.Parameter;
import vmm.core.ParameterDialog;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.fourier.FourierSeries;
import vmm.functions.ParseError;

public abstract class LatticeModel
extends Exhibit3D {
    public static final int MAX_NUMBER_OF_NODES = 256;
    public static final int DISPLAY_TRANSVERSE = 0;
    public static final int DISPLAY_LONGITUDINAL = 1;
    public static final int DISPLAY_CIRCILAR = 2;
    public static final int DISPLAY_PENDULUM = 3;
    public static final int DISPLAY_BRIDGE = 4;
    public static final int DISPLAY_FPU_GRAPH = 5;
    public static final int BOUNDARY_CONDITION_ZERO = 0;
    public static final int BOUNDARY_CONDITION_PERIODIC = 1;
    public static final int INITIAL_SHAPE_SINUSOIDAL = 0;
    public static final int INITIAL_SHAPE_GAUSSIAN = 1;
    public static final int INITIAL_SHAPE_THERMAL = 2;
    public static final int INITIAL_SHAPE_KINK = 3;
    public static final int INITIAL_SHAPE_BREATHER = 4;
    public static final int INITIAL_MODE_FIRST = 0;
    public static final int INITIAL_MODE_SECOND = 1;
    public static final int INITIAL_MODE_FOURTH = 2;
    public static final int INITIAL_MODE_EIGHTH = 3;
    public static final int INITIAL_MODE_SIXTEENTH = 4;
    protected int numIterations;
    protected double defaultStepSize = 0.1;
    protected int defaultBoundaryCondition = 0;
    protected int defaultInitialShape = 0;
    protected int defaultInitialMode = 0;
    protected int defaultDisplayStyle = 0;
    protected boolean canShowNormalModeDisplay = true;
    protected double defaultLatticeLength = 6.2832;
    protected double defaultLatticeDensity = 1.0;
    protected double defaultAmplitude = 1.0;
    protected int defaultNumberOfNodes = 32;
    protected double defaultScaleFactor = 1.0;
    protected boolean MaxPermittedDisplacementExceeded;

    protected abstract double potentialEnergy(double var1, double var3);

    protected abstract double internalForceLaw(double var1, double var3);

    protected abstract double externalForceLaw(double var1, double var3);

    protected void drawTransverse(View3D view3D) {
        int n;
        Color color = view3D.getColor();
        LMView lMView = (LMView)view3D;
        LatticeData latticeData = lMView.getLatticeData();
        double d = lMView.controlPanel.getScaleFactor();
        if (((LMView)view3D).getShowNormalModeDisplay()) {
            latticeData.GetLatticeModeEnergies((LMView)view3D);
        }
        view3D.drawLine(0.0, 0.0, latticeData.latticeLength, 0.0);
        view3D.drawLine(0.0, -1.6 / d, 0.0, 1.6 / d);
        view3D.drawLine(latticeData.latticeLength, -1.6 / d, latticeData.latticeLength, 1.6 / d);
        for (n = 0; n < latticeData.nodeCount; ++n) {
            view3D.drawLine(latticeData.LatticeAbscissa(n, lMView), latticeData.currentDisplacement[n], latticeData.LatticeAbscissa(n + 1, lMView), latticeData.currentDisplacement[n + 1]);
        }
        view3D.setColor(Color.BLUE);
        for (n = 0; n < latticeData.nodeCount; ++n) {
            view3D.drawLine(latticeData.LatticeAbscissa(n, lMView), latticeData.currentVelocity[n], latticeData.LatticeAbscissa(n + 1, lMView), latticeData.currentVelocity[n + 1]);
        }
        view3D.setColor(color);
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        LMView lMView = (LMView)view3D;
        int n = lMView.getDisplayStyle();
        LatticeData latticeData = lMView.getLatticeData();
        double d = latticeData.latticeLength / (double)(transform3D.getWidth() - 30);
        double d2 = -15.0 * d;
        double d3 = latticeData.latticeLength + 15.0 * d;
        double d4 = 1.0;
        if (n == 0) {
            d4 = lMView.controlPanel.getScaleFactor();
            double d5 = 2.0 / d4;
            double d6 = -d5;
            ((LMTransform)transform3D).resetXYLimits(d2, d3, d6, d5);
            this.drawTransverse(view3D);
        }
        if (n == 3) {
            view3D.setViewPoint(new Vector3D(0.0, -5.0 * latticeData.latticeLength, 0.0));
        } else if (n == 4) {
            view3D.setViewPoint(new Vector3D(latticeData.latticeLength, -5.0 * latticeData.latticeLength, latticeData.latticeLength));
        }
        if (view3D.getEnableThreeD()) {
            view3D.drawString("(3D) Step number = " + latticeData.stepNumber, new Vector3D(0.0, 0.0, 1.0));
        } else {
            view3D.drawString("  TNE = " + (double)Math.round(100000.0 * latticeData.LatticeTotalEnergy(lMView)) / 100000.0, 0.0, -1.25 / d4);
        }
        view3D.drawString("  Time = " + (double)Math.round(4.0 * latticeData.currentTime) / 4.0, 0.0, -1.55 / d4);
        if (((LMView)view3D).getShowNormalModeDisplay()) {
            // empty if block
        }
    }

    public View getDefaultView() {
        return new LMView();
    }

    public Animation getCreateAnimation(View view) {
        LMView lMView;
        LMView lMView2 = lMView = (LMView)view;
        lMView2.getClass();
        return lMView2.new LMView.EvolveLattice(true);
    }

    public ActionList getSettingsCommandsForView(View view) {
        ActionList actionList = super.getSettingsCommandsForView(view);
        ActionItem actionItem = actionList.getItem(actionList.getItemCount() - 1);
        if (actionItem instanceof AbstractActionVMM) {
            ((AbstractActionVMM)actionItem).setEnabled(false);
        }
        return actionList;
    }

    public Transform getDefaultTransform(View view) {
        return new LMTransform();
    }

    public class LMView
    extends View3D {
        protected AbstractActionVMM restartAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Start")){

            public void actionPerformed(ActionEvent actionEvent) {
                LMView.this.doRestart();
            }
        };
        protected AbstractActionVMM stopAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Stop")){

            public void actionPerformed(ActionEvent actionEvent) {
                LMView.this.doStop();
            }
        };
        protected AbstractActionVMM continueAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Continue")){

            public void actionPerformed(ActionEvent actionEvent) {
                LMView.this.doContinue();
            }
        };
        protected AbstractActionVMM stepAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Step")){

            public void actionPerformed(ActionEvent actionEvent) {
                LMView.this.doStep();
            }
        };
        protected ActionRadioGroup displayStyleSelect = new ActionRadioGroup(){

            public void optionSelected(int n) {
                LMView.this.setDisplayStyle(this.getSelectedIndex());
            }
        };
        protected ActionRadioGroup initialModeSelect = new ActionRadioGroup(){

            public void optionSelected(int n) {
                LMView.this.setInitialMode(this.getSelectedIndex());
            }
        };
        protected ActionRadioGroup initialShapeSelect = new ActionRadioGroup(){

            public void optionSelected(int n) {
                LMView.this.setInitialShape(this.getSelectedIndex());
            }
        };
        protected ActionRadioGroup boundaryConditionSelect = new ActionRadioGroup(){

            public void optionSelected(int n) {
                LMView.this.setBoundaryCondition(this.getSelectedIndex());
            }
        };
        protected ToggleAction showNormalModeToggle;
        protected ToggleAction showControlPanelToggle;
        protected RealParam latticeLength;
        protected RealParam latticeDensity;
        protected RealParam amplitude;
        protected IntegerParam numberOfNodes;
        @VMMSave
        private int displayStyle;
        @VMMSave
        private int initialShape;
        @VMMSave
        private int initialMode;
        @VMMSave
        private int boundaryCondition;
        @VMMSave
        private boolean showControlPanel;
        @VMMSave
        private boolean showNormalModeDisplay;
        protected LatticeData latticeData;
        private ControlPanel controlPanel;

        public LMView() {
            this.showNormalModeToggle = new ToggleAction(I18n.tr("vmm.latticemodel.ShowNormalModeDisplay"), LatticeModel.this.canShowNormalModeDisplay){

                public void actionPerformed(ActionEvent actionEvent) {
                    LMView.this.setShowNormalModeDisplay(this.getState());
                }
            };
            this.showControlPanelToggle = new ToggleAction(I18n.tr("vmm.latticemodel.ShowControlPanel"), true){

                public void actionPerformed(ActionEvent actionEvent) {
                    LMView.this.setShowControlPanel(this.getState());
                }
            };
            this.latticeLength = new RealParam("vmm.latticeModel.LatticeLength", LatticeModel.this.defaultLatticeLength);
            this.latticeDensity = new RealParam("vmm.latticeModel.LatticeDensity", LatticeModel.this.defaultLatticeDensity);
            this.amplitude = new RealParam("vmm.latticeModel.Amplitude", LatticeModel.this.defaultAmplitude);
            this.numberOfNodes = new IntegerParam("vmm.latticeModel.NumberOfNodes", LatticeModel.this.defaultNumberOfNodes){

                public ParameterInput createParameterInput(int n) {
                    return new ParameterInput(this, n){

                        public String checkContents() {
                            String string = this.getText();
                            double d = 0.0;
                            try {
                                d = Util.parseConstantExpression(string).value();
                            }
                            catch (ParseError parseError) {
                                this.requestFocus();
                                this.selectAll();
                                return I18n.tr("vmm.core.ParameterInput.badExpression", this.getTitle(), string, parseError.getMessage());
                            }
                            int n = d > 0.0 ? (int)(d + 1.0E-8) : (int)(d - 1.0E-8);
                            if (Math.abs(d - (double)n) > 5.0E-9) {
                                this.requestFocus();
                                this.selectAll();
                                return I18n.tr("vmm.core.ParameterInput.badint", this.getTitle());
                            }
                            if (n < 3 || n > 65 && n != 128 && n != 256) {
                                this.requestFocus();
                                this.selectAll();
                                return I18n.tr("vmm.latticemodel.LatticeModel.badNumberOfNodes");
                            }
                            return null;
                        }
                    };
                }
            };
            this.displayStyle = 0;
            this.initialMode = LatticeModel.this.defaultInitialMode;
            this.showControlPanel = true;
            this.showNormalModeDisplay = LatticeModel.this.canShowNormalModeDisplay;
            this.setAntialiased(true);
            this.addParameter(this.latticeLength);
            this.latticeLength.setMinimumValueForInput(Double.MIN_VALUE);
            this.addParameter(this.latticeDensity);
            this.addParameter(this.amplitude);
            this.latticeDensity.setMinimumValueForInput(Double.MIN_VALUE);
            this.addParameter(this.numberOfNodes);
            this.numberOfNodes.setMinimumValueForInput(3);
            this.numberOfNodes.setMaximumValueForInput(512);
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.TransverseDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.LongitudinalDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.CircularDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.PendulumDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.BridgeDisplay"));
            this.displayStyleSelect.setSelectedIndex(LatticeModel.this.defaultDisplayStyle);
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.SinusoidalInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.GaussianInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.ThermalInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.KinkInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.BreatherInitialShape"));
            this.initialShapeSelect.setSelectedIndex(LatticeModel.this.defaultInitialShape);
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.First"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Second"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Fourth"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Eighth"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Sixteenth"));
            this.initialModeSelect.setSelectedIndex(LatticeModel.this.defaultInitialMode);
            this.boundaryConditionSelect.addItem(I18n.tr("vmm.latticeModel.ZeroBoundaryCondition"));
            this.boundaryConditionSelect.addItem(I18n.tr("vmm.latticeModel.PeriodicBoundaryCondition"));
            this.boundaryConditionSelect.setSelectedIndex(LatticeModel.this.defaultBoundaryCondition);
            this.stopAction.setEnabled(false);
            this.setEnableThreeD(false);
            this.setTransform(new LMTransform());
            this.showAxesAction.setEnabled(false);
            this.setApplyGraphics2DTransform(false);
            this.setPreserveAspect(false);
        }

        public int getNumberOfNodes() {
            int n = this.numberOfNodes.getValue();
            if (n < 3) {
                return 3;
            }
            if (n <= 64) {
                return n;
            }
            if (n <= 128) {
                return 128;
            }
            return 256;
        }

        public LatticeData getLatticeData() {
            if (this.latticeData == null) {
                this.latticeData = new LatticeData(this);
            }
            return this.latticeData;
        }

        public int getDisplayStyle() {
            return this.displayStyle;
        }

        public void setDisplayStyle(int n) {
            if (n < 0 || n >= this.displayStyleSelect.getItemCount()) {
                return;
            }
            if (this.displayStyle == n) {
                return;
            }
            this.displayStyle = n;
            this.displayStyleSelect.setSelectedIndex(n);
            this.forceRedraw();
            boolean bl = n == 3 || n == 4;
            boolean bl2 = bl != this.getEnableThreeD();
            this.setEnableThreeD(bl);
            if (bl && bl2) {
                this.setViewStyle(1);
                this.setViewpointAction.setEnabled(false);
            }
            if (n == 0) {
                this.controlPanel.showScaleFactor(I18n.tr("vmm.latticemodel.yScaleFactor"));
            } else if (n == 5) {
                this.controlPanel.showScaleFactor(I18n.tr("vmm.latticemodel.xScaleFactor"));
            } else {
                this.controlPanel.hideScaleFactor();
            }
            if (n == 0) {
                this.controlPanel.setScaleFactor(LatticeModel.this.defaultScaleFactor);
            } else if (n == 5) {
                this.controlPanel.setScaleFactor(0.005);
            }
            if (bl2 && this.getDisplay() != null) {
                this.getDisplay().installMouseTask(this.getDefaultMouseTask());
            }
        }

        public int getBoundaryCondition() {
            return this.boundaryCondition;
        }

        public void setBoundaryCondition(int n) {
            if (n != 0 && n != 1) {
                return;
            }
            if (this.boundaryCondition == n) {
                return;
            }
            this.boundaryCondition = n;
            this.boundaryConditionSelect.setSelectedIndex(n);
            this.initialConditionChanged();
        }

        public int getInitialShape() {
            return this.initialShape;
        }

        public void setInitialShape(int n) {
            if (n < 0 || n >= this.initialShapeSelect.getItemCount()) {
                return;
            }
            if (this.initialShape == n) {
                return;
            }
            this.initialShape = n;
            this.initialShapeSelect.setSelectedIndex(n);
            this.initialModeSelect.setEnabled(n == 0);
            this.initialConditionChanged();
        }

        public int getInitialMode() {
            return this.initialMode;
        }

        public void setInitialMode(int n) {
            if (n < 0 || n >= this.initialModeSelect.getItemCount()) {
                return;
            }
            if (this.initialMode == n) {
                return;
            }
            this.initialMode = n;
            this.initialModeSelect.setSelectedIndex(n);
            this.initialConditionChanged();
        }

        public MouseTask getDefaultMouseTask() {
            if (this.getEnableThreeD()) {
                return null;
            }
            return new LatticeMouseTask2D();
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(this.stopAction);
            actionList.add(this.continueAction);
            actionList.add(this.stepAction);
            actionList.add(null);
            ActionList actionList2 = new ActionList(I18n.tr("vmm.latticemodel.BoundaryCondition"));
            actionList2.add(this.boundaryConditionSelect);
            actionList.add(actionList2);
            ActionList actionList3 = new ActionList(I18n.tr("vmm.latticemodel.InitialShape"));
            actionList3.add(this.initialShapeSelect);
            actionList.add(actionList3);
            ActionList actionList4 = new ActionList(I18n.tr("vmm.latticemodel.InitialMode"));
            actionList4.add(this.initialModeSelect);
            actionList.add(actionList4);
            actionList.add(null);
            ActionList actionList5 = new ActionList(I18n.tr("vmm.latticemodel.DisplayStyle"));
            actionList5.add(this.displayStyleSelect);
            actionList.add(actionList5);
            actionList.add(null);
            if (LatticeModel.this.canShowNormalModeDisplay) {
                actionList.add(this.showNormalModeToggle);
            }
            actionList.add(this.showControlPanelToggle);
            return actionList;
        }

        public boolean getShowControlPanel() {
            return this.showControlPanel;
        }

        public void setShowControlPanel(boolean bl) {
            if (this.showControlPanel == bl) {
                return;
            }
            this.showControlPanel = bl;
            this.showControlPanelToggle.setState(bl);
            if (bl) {
                if (this.getDisplay() != null) {
                    this.getDisplay().getHolder().add((Component)this.getControlPanel(), "East");
                    this.getDisplay().getHolder().validate();
                }
            } else if (this.getDisplay() != null && this.controlPanel != null) {
                this.getDisplay().getHolder().remove(this.controlPanel);
                this.getDisplay().getHolder().validate();
            }
        }

        public boolean getShowNormalModeDisplay() {
            return this.showNormalModeDisplay;
        }

        public void setShowNormalModeDisplay(boolean bl) {
            if (!LatticeModel.this.canShowNormalModeDisplay) {
                bl = false;
            }
            if (this.showNormalModeDisplay == bl) {
                return;
            }
            this.showNormalModeDisplay = bl;
            this.showNormalModeToggle.setState(bl);
            this.forceRedraw();
        }

        public void parameterChanged(Parameter parameter, Object object, Object object2) {
            super.parameterChanged(parameter, object, object2);
            this.initialConditionChanged();
        }

        public void setDisplay(Display display) {
            super.setDisplay(display);
            if (display != null) {
                display.setStopAnimationsOnResize(false);
            }
            if (display != null && this.showControlPanel) {
                display.getHolder().add((Component)this.getControlPanel(), "East");
                display.getHolder().validate();
            }
        }

        ControlPanel getControlPanel() {
            if (this.controlPanel == null) {
                this.controlPanel = new ControlPanel();
            }
            return this.controlPanel;
        }

        private void initialConditionChanged() {
            if (this.getDisplay() != null) {
                this.getDisplay().stopAnimation();
            }
            this.latticeData = null;
            this.restartAction.putValue("Name", I18n.tr("vmm.latticemodel.command.Start"));
            this.forceRedraw();
        }

        private void doRestart() {
            this.getDisplay().stopAnimation();
            this.getDisplay().installAnimation(new EvolveLattice(true));
        }

        private void doStop() {
            this.getDisplay().stopAnimation();
        }

        private void doStep() {
            LatticeData latticeData = this.getLatticeData();
            latticeData.stepSize = this.getControlPanel().getStepSize();
            latticeData.step(this);
            this.forceRedraw();
        }

        private void doContinue() {
            this.getDisplay().installAnimation(new EvolveLattice(false));
        }

        protected class ControlPanel
        extends JPanel {
            JTextField stepSizeInput;
            JTextField scaleFactorInput;
            boolean scaleFactorShown = true;
            JLabel scaleFactorLabel;
            JPanel scaleFactorPanel;
            JPanel componentPanel;
            Font font;

            ControlPanel() {
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                this.componentPanel = new JPanel();
                this.componentPanel.setLayout(new GridLayout(0, 1));
                this.add(this.componentPanel);
                this.font = new Font("SansSerif", 1, 10);
                Font font = new Font("SansSerif", 0, 10);
                JButton jButton = new JButton(LMView.this.restartAction);
                jButton.setFont(this.font);
                this.componentPanel.add(jButton);
                JButton jButton2 = new JButton(LMView.this.stopAction);
                jButton2.setFont(this.font);
                this.componentPanel.add(jButton2);
                JButton jButton3 = new JButton(LMView.this.continueAction);
                jButton3.setFont(this.font);
                this.componentPanel.add(jButton3);
                JButton jButton4 = new JButton(LMView.this.stepAction);
                jButton4.setFont(this.font);
                this.componentPanel.add(jButton4);
                this.componentPanel.add(Box.createVerticalStrut(1));
                this.stepSizeInput = new JTextField("" + LatticeModel.this.defaultStepSize, 6);
                this.stepSizeInput.setFont(font);
                JLabel jLabel = new JLabel(I18n.tr("vmm.latticemodel.StepSize") + "=");
                jLabel.setFont(this.font);
                JPanel jPanel = new JPanel();
                jPanel.add(jLabel);
                jPanel.add(this.stepSizeInput);
                this.componentPanel.add(jPanel);
                this.scaleFactorInput = new JTextField("" + LatticeModel.this.defaultScaleFactor, 5);
                this.scaleFactorInput.setFont(font);
                this.scaleFactorLabel = new JLabel(I18n.tr("vmm.latticemodel.yScaleFactor") + "=");
                this.scaleFactorLabel.setFont(this.font);
                this.scaleFactorPanel = new JPanel();
                this.scaleFactorPanel.add(this.scaleFactorLabel);
                this.scaleFactorPanel.add(this.scaleFactorInput);
                this.componentPanel.add(this.scaleFactorPanel);
                JRadioButton[] jRadioButtonArray = LMView.this.displayStyleSelect.createRadioButtons();
                for (JRadioButton jRadioButton : jRadioButtonArray) {
                    jRadioButton.setFont(this.font);
                    this.componentPanel.add(jRadioButton);
                }
                this.componentPanel.add(Box.createVerticalStrut(1));
                JButton jButton5 = new JButton(I18n.tr("vmm.latticemodel.setParams"));
                jButton5.setFont(this.font);
                this.componentPanel.add(jButton5);
                jButton5.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LMView.this.getDisplay().stopAnimation();
                        Parameter[] parameterArray = LMView.this.getViewAndExhibitParameters();
                        ParameterDialog.showDialog(LMView.this.getDisplay(), I18n.tr("vmm.core.dialogtitle.SetParameters"), parameterArray);
                    }
                });
            }

            double getStepSize() {
                try {
                    double d = Double.parseDouble(this.stepSizeInput.getText().trim());
                    if (d <= 0.0) {
                        throw new NumberFormatException();
                    }
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    this.stepSizeInput.setText("" + LatticeModel.this.defaultStepSize);
                    return LatticeModel.this.defaultStepSize;
                }
            }

            double getScaleFactor() {
                try {
                    double d = Double.parseDouble(this.scaleFactorInput.getText().trim());
                    if (d <= 0.0) {
                        throw new NumberFormatException();
                    }
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    this.scaleFactorInput.setText("" + LatticeModel.this.defaultScaleFactor);
                    return LatticeModel.this.defaultScaleFactor;
                }
            }

            void setScaleFactor(double d) {
                String string = String.format("%.4f", d);
                this.scaleFactorInput.setText(string);
            }

            boolean isScaleFactorShown() {
                return this.scaleFactorShown;
            }

            void hideScaleFactor() {
                if (this.scaleFactorShown) {
                    this.componentPanel.remove(6);
                    this.componentPanel.add(Box.createVerticalStrut(1), 6);
                    this.scaleFactorShown = false;
                    this.validate();
                }
            }

            void showScaleFactor(String string) {
                this.scaleFactorLabel.setText(string);
                if (!this.scaleFactorShown) {
                    this.componentPanel.remove(6);
                    this.componentPanel.add((Component)this.scaleFactorPanel, 6);
                    this.scaleFactorShown = true;
                }
                this.validate();
            }
        }

        private class EvolveLattice
        extends TimerAnimation {
            boolean create;

            EvolveLattice(boolean bl) {
                this.setMillisecondsPerFrame(5);
                this.create = bl;
            }

            protected void drawFrame() {
                LMView.this.doStep();
            }

            protected void animationStarting() {
                if (this.create) {
                    LMView.this.latticeData = null;
                }
                LMView.this.continueAction.setEnabled(false);
                LMView.this.stepAction.setEnabled(false);
                LMView.this.stopAction.setEnabled(true);
                LMView.this.restartAction.putValue("Name", I18n.tr("vmm.latticemodel.command.Restart"));
            }

            protected void animationEnding() {
                LMView.this.continueAction.setEnabled(true);
                LMView.this.stepAction.setEnabled(true);
                LMView.this.stopAction.setEnabled(false);
            }
        }

        private class LatticeMouseTask2D
        extends MouseTask {
            int startY;
            int startX;
            double initialScaleFactor;
            boolean dragging;

            private LatticeMouseTask2D() {
            }

            public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
                if (!LMView.this.controlPanel.isScaleFactorShown()) {
                    this.dragging = false;
                    return false;
                }
                this.startX = mouseEvent.getX();
                this.startY = mouseEvent.getY();
                this.initialScaleFactor = LMView.this.controlPanel.getScaleFactor();
                this.dragging = true;
                return true;
            }

            public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
                if (!this.dragging) {
                    return;
                }
                double d = Math.exp((double)(this.startY - mouseEvent.getY() + (mouseEvent.getX() - this.startX)) / 250.0);
                LMView.this.controlPanel.setScaleFactor(this.initialScaleFactor * d);
                LMView.this.forceRedraw();
            }

            public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
                this.dragging = false;
            }
        }
    }

    protected class LMTransform
    extends Transform3D {
        protected LMTransform() {
        }

        public void resetXYLimits(double d, double d2, double d3, double d4) {
            this.resetLimits(d, d2, d3, d4);
        }
    }

    protected class LatticeData {
        public double currentTime = 0.0;
        public double stepNumber = 0.0;
        int nodeCount;
        public double stepSize;
        public double density;
        public double maxDisplacement;
        public double youngsModulus;
        public double latticeLength;
        public int latticeBoundaryCondition;
        public int latticeInitialShape;
        public int latticeInitialMode;
        public double TotalModalEnergy;
        public double[] currentDisplacement = new double[513];
        public double[] currentVelocity = new double[513];
        public double[] RealNormalModeAngularFrequencies = new double[513];
        public double[] MyWaveArray = new double[513];
        public double[] MyVelocityArray = new double[513];

        private void CopyCurrentDisplacementsAndCurrentVelocitiesToMyWaveArrayAndMyVelocityArray() {
            for (int i = 1; i <= this.nodeCount; ++i) {
                this.MyWaveArray[i] = this.currentDisplacement[i];
                this.MyVelocityArray[i] = this.currentVelocity[i];
            }
        }

        private void GetRealNormalModeAngularFrequencies(LMView lMView) {
            double d = Math.sqrt(this.youngsModulus / (this.massPerNode(lMView) * 16.0 * this.latticeSpacing(lMView)));
            for (int i = 1; i <= this.nodeCount; ++i) {
                this.RealNormalModeAngularFrequencies[i] = 2.0 * d * Math.sin((double)i * Math.PI / (double)(2 * this.nodeCount));
            }
        }

        private void DSTMyWaveArrayAndMyVelocityArray() {
            FourierSeries.DSTinPlace(this.MyWaveArray, this.nodeCount);
            FourierSeries.DSTinPlace(this.MyVelocityArray, this.nodeCount);
        }

        private void IDSTMyWaveArrayAndMyVelocityArray() {
            FourierSeries.IDSTinPlace(this.MyWaveArray, this.nodeCount);
            FourierSeries.IDSTinPlace(this.MyVelocityArray, this.nodeCount);
        }

        double sqr(double d) {
            return d * d;
        }

        private double PotentialEnergyOfMode(int n) {
            return 17.77 * Math.sqrt(2.0) * this.sqr(this.RealNormalModeAngularFrequencies[n]) * this.sqr(this.MyWaveArray[n]);
        }

        private double KineticEnergyOfMode(int n) {
            return 17.77 * Math.sqrt(2.0) * this.sqr(this.MyVelocityArray[n]);
        }

        private double TotalEnergyOfMode(int n) {
            return this.KineticEnergyOfMode(n) + this.PotentialEnergyOfMode(n);
        }

        private void GetLatticeModeEnergies(LMView lMView) {
            this.CopyCurrentDisplacementsAndCurrentVelocitiesToMyWaveArrayAndMyVelocityArray();
            this.DSTMyWaveArrayAndMyVelocityArray();
            this.GetRealNormalModeAngularFrequencies(lMView);
            this.TotalModalEnergy = 0.0;
            for (int i = 1; i <= this.nodeCount; ++i) {
                double d = this.KineticEnergyOfMode(i) + this.PotentialEnergyOfMode(i);
                this.TotalModalEnergy += d;
            }
        }

        public double latticeSpacing(LMView lMView) {
            return this.latticeLength / (double)lMView.getNumberOfNodes();
        }

        private double LatticeAbscissa(int n, LMView lMView) {
            return (double)n * this.latticeSpacing(lMView);
        }

        public double massPerNode(LMView lMView) {
            return this.density * this.latticeSpacing(lMView);
        }

        public double pulseWidth() {
            return 1.0 / Math.pow(2.0, this.latticeInitialMode);
        }

        public double waveNumber() {
            return 1.0 / (2.0 * this.pulseWidth());
        }

        private double SineWave(double d, double d2, double d3) {
            return this.maxDisplacement * Math.sin(Math.PI * 2 * this.waveNumber() / d3 * d);
        }

        private double Breather(double d, double d2) {
            return 4.0 * Math.atan(Math.sqrt(1.0 - d2 * d2) / d2 * (1.0 / Math.cosh(Math.sqrt(1.0 - d2 * d2) * d)));
        }

        private double Kink(double d, double d2) {
            return 4.0 * Math.atan(Math.exp(d / Math.sqrt(1.0 - d2 * d2)));
        }

        private double Gaussian(double d, double d2) {
            return 1.0 / (d2 * Math.sqrt(Math.PI * 2)) * Math.exp(-(d * d / (d2 * d2)));
        }

        private double shapeFunction(double d, double d2, double d3) {
            switch (this.latticeInitialShape) {
                case 0: {
                    return Math.sqrt(2.0) * this.SineWave(d, this.waveNumber(), this.latticeLength);
                }
                case 1: {
                    return this.Gaussian(d, d2);
                }
                case 2: {
                    return 0.0;
                }
                case 3: {
                    return this.Kink(d, d3);
                }
                case 4: {
                    return this.Breather(d, d3);
                }
            }
            return 0.0;
        }

        private void InitializeDisplacementsAndVelocities(LMView lMView) {
            for (int i = 1; i <= lMView.getNumberOfNodes(); ++i) {
                this.currentVelocity[i] = 0.0;
                this.currentDisplacement[i] = this.shapeFunction(this.LatticeAbscissa(i, lMView), 1.0, 1.0);
                this.currentVelocity[0] = 0.0;
                this.currentDisplacement[0] = this.currentDisplacement[lMView.getNumberOfNodes()];
            }
        }

        public LatticeData(LMView lMView) {
            this.nodeCount = lMView.getNumberOfNodes();
            this.density = lMView.latticeDensity.getValue();
            this.maxDisplacement = lMView.amplitude.getValue();
            this.youngsModulus = 1.0;
            this.latticeLength = lMView.latticeLength.getValue();
            this.latticeBoundaryCondition = lMView.getBoundaryCondition();
            this.latticeInitialShape = lMView.getInitialShape();
            this.latticeInitialMode = lMView.getInitialMode();
            this.InitializeDisplacementsAndVelocities(lMView);
        }

        private int NextNodeIndex(int n, int n2) {
            if (n >= n2 || n < 0) {
                return 0;
            }
            return n + 1;
        }

        private double PotentialEnergyOfSpring(LMView lMView, int n) {
            return LatticeModel.this.potentialEnergy(this.currentDisplacement[this.NextNodeIndex(n, this.nodeCount)] - this.currentDisplacement[n], this.latticeSpacing(lMView));
        }

        private double KineticEnergyOfNode(LMView lMView, int n) {
            return 0.5 * this.massPerNode(lMView) * this.currentVelocity[n] * this.currentVelocity[n];
        }

        private double LatticeTotalKineticEnergy(LMView lMView) {
            double d = 0.0;
            for (int i = 1; i <= this.nodeCount; ++i) {
                d += this.KineticEnergyOfNode(lMView, i);
            }
            return d;
        }

        private double LatticeTotalPotentialEnergy(LMView lMView) {
            double d = 0.0;
            for (int i = 0; i <= this.nodeCount; ++i) {
                d += this.PotentialEnergyOfSpring(lMView, i);
            }
            return d;
        }

        protected double LatticeTotalEnergy(LMView lMView) {
            return this.LatticeTotalPotentialEnergy(lMView) + this.LatticeTotalKineticEnergy(lMView);
        }

        private double Acceleration(LMView lMView, int n, double d, double d2, double d3) {
            if (this.latticeBoundaryCondition == 0 & (n == 0 || n == this.nodeCount)) {
                return 0.0;
            }
            double d4 = LatticeModel.this.internalForceLaw(d2 - d, this.latticeSpacing(lMView)) - LatticeModel.this.internalForceLaw(d3 - d2, this.latticeSpacing(lMView));
            double d5 = LatticeModel.this.externalForceLaw(d2, this.latticeSpacing(lMView));
            double d6 = d4 + d5;
            return d6 / this.massPerNode(lMView);
        }

        protected void RungeKuttaLattice(double[] dArray, double[] dArray2, LMView lMView) {
            int n;
            double d = this.stepSize;
            double[] dArray3 = new double[this.nodeCount + 1];
            double[] dArray4 = new double[this.nodeCount + 1];
            double[] dArray5 = new double[this.nodeCount + 1];
            double[] dArray6 = new double[this.nodeCount + 1];
            double[] dArray7 = new double[this.nodeCount + 1];
            double[] dArray8 = new double[this.nodeCount + 1];
            double[] dArray9 = new double[this.nodeCount + 1];
            double[] dArray10 = new double[this.nodeCount + 1];
            for (n = 1; n <= this.nodeCount; ++n) {
                dArray3[n] = d * dArray2[n];
                dArray4[n] = d * this.Acceleration(lMView, n, dArray[n - 1], dArray[n], dArray[this.NextNodeIndex(n, this.nodeCount)]);
            }
            dArray3[0] = dArray3[this.nodeCount];
            dArray4[0] = dArray4[this.nodeCount];
            for (n = 1; n <= this.nodeCount; ++n) {
                dArray5[n] = d * (dArray2[n] + dArray4[n] / 2.0);
                dArray6[n] = d * this.Acceleration(lMView, n, dArray[n - 1] + dArray3[n - 1] / 2.0, dArray[n] + dArray3[n] / 2.0, dArray[this.NextNodeIndex(n, this.nodeCount)] + dArray3[this.NextNodeIndex(n, this.nodeCount)] / 2.0);
            }
            dArray5[0] = dArray5[this.nodeCount];
            dArray6[0] = dArray6[this.nodeCount];
            for (n = 1; n <= this.nodeCount; ++n) {
                dArray7[n] = d * (dArray2[n] + dArray6[n] / 2.0);
                dArray8[n] = d * this.Acceleration(lMView, n, dArray[n - 1] + dArray5[n - 1] / 2.0, dArray[n] + dArray5[n] / 2.0, dArray[this.NextNodeIndex(n, this.nodeCount)] + dArray5[this.NextNodeIndex(n, this.nodeCount)] / 2.0);
            }
            dArray7[0] = dArray7[this.nodeCount];
            dArray8[0] = dArray8[this.nodeCount];
            for (n = 1; n <= this.nodeCount; ++n) {
                dArray9[n] = d * (dArray2[n] + dArray8[n]);
                dArray10[n] = d * this.Acceleration(lMView, n, dArray[n - 1] + dArray7[n - 1], dArray[n] + dArray7[n], dArray[this.NextNodeIndex(n, this.nodeCount)] + dArray7[this.NextNodeIndex(n, this.nodeCount)]);
            }
            dArray9[0] = dArray9[this.nodeCount];
            dArray10[0] = dArray10[this.nodeCount];
            for (n = 0; n <= this.nodeCount; ++n) {
                dArray[n] = dArray[n] + dArray3[n] / 6.0 + dArray5[n] / 3.0 + dArray7[n] / 3.0 + dArray9[n] / 6.0;
                dArray2[n] = dArray2[n] + dArray4[n] / 6.0 + dArray6[n] / 3.0 + dArray8[n] / 3.0 + dArray10[n] / 6.0;
            }
        }

        public void step(LMView lMView) {
            LatticeModel.this.numIterations = 3;
            for (int i = 0; i < LatticeModel.this.numIterations; ++i) {
                this.RungeKuttaLattice(this.currentDisplacement, this.currentVelocity, lMView);
                this.currentTime += this.stepSize;
            }
            this.stepNumber += 1.0;
        }
    }
}

