/*
 * Decompiled with CFR 0.152.
 */
package vmm.latticemodel;

import java.awt.Graphics2D;
import vmm.core.I18n;
import vmm.core.RealParam;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.View3D;
import vmm.latticemodel.LatticeModel;

public class FermiPastaUlam
extends LatticeModel {
    protected RealParam a = new RealParam("vmm.latticeModel.FermiPastaUlam.a", 1.0);
    protected RealParam b = new RealParam("vmm.latticeModel.FermiPastaUlam.b", 0.25);
    protected RealParam c = new RealParam("vmm.latticeModel.FermiPastaUlam.c", 0.0);
    protected RealParam d = new RealParam("vmm.latticeModel.FermiPastaUlam.d", 0.0);

    protected double potentialEnergy(double d, double d2) {
        return d * d * (this.a.getValue() / 2.0 + d * (this.b.getValue() / 3.0 + d * (this.c.getValue() / 4.0 + d * this.d.getValue() / 5.0))) / (16.0 * d2);
    }

    protected double internalForceLaw(double d, double d2) {
        return -d * (this.a.getValue() + d * (this.b.getValue() + d * (this.c.getValue() + d * this.d.getValue()))) / (16.0 * d2);
    }

    protected double externalForceLaw(double d, double d2) {
        return 0.0;
    }

    public FermiPastaUlam() {
        this.canShowNormalModeDisplay = true;
        this.defaultAmplitude = 1.0;
        this.addParameter(this.d);
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        int n = ((LatticeModel.LMView)view3D).getDisplayStyle();
        if (n != 5) {
            super.doDraw3D(graphics2D, view3D, transform3D);
            return;
        }
        view3D.drawString("FPU Graph Display", 0.0, 1.0);
        if (((LatticeModel.LMView)view3D).getShowNormalModeDisplay()) {
            // empty if block
        }
    }

    public View getDefaultView() {
        return new FPUView();
    }

    public class FPUView
    extends LatticeModel.LMView {
        public FPUView() {
            super(FermiPastaUlam.this);
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.FermiPastaUlam.FPUGraphDisplay"));
        }

        public LatticeModel.LatticeData getLatticeData() {
            if (this.latticeData == null) {
                this.latticeData = new FPULatticeData(this);
            }
            return this.latticeData;
        }
    }

    protected class FPULatticeData
    extends LatticeModel.LatticeData {
        FPULatticeData(FPUView fPUView) {
            super(FermiPastaUlam.this, fPUView);
            this.youngsModulus = FermiPastaUlam.this.a.getValue();
        }

        public void step(LatticeModel.LMView lMView) {
            super.step(lMView);
            FPUView fPUView = (FPUView)lMView;
        }
    }
}

