/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import java.util.ArrayList;
import vmm.functions.ComplexVariable;
import vmm.functions.EvalStack;
import vmm.functions.StackOp;
import vmm.functions.Type;
import vmm.functions.Variable;

final class ProgFunction {
    private ProgCommand[] commands;
    private int argCount;
    private Type argType;
    private Type type;

    private ProgFunction() {
    }

    int getArgCount() {
        return this.argCount;
    }

    Type getArgType() {
        return this.argType;
    }

    Type getType() {
        return this.type;
    }

    void apply(EvalStack evalStack) {
        if (this.argCount == 0) {
            for (ProgCommand progCommand : this.commands) {
                progCommand.apply(evalStack);
            }
        } else {
            int n = this.argType == Type.COMPLEX ? 2 * this.argCount : this.argCount;
            evalStack.startFunctionCall(n);
            for (ProgCommand progCommand : this.commands) {
                progCommand.apply(evalStack);
            }
            if (this.type == Type.COMPLEX) {
                evalStack.endComplexValuedFunction(n);
            } else {
                evalStack.endRealValuedFunction(n);
            }
        }
    }

    static /* synthetic */ ProgCommand[] access$402(ProgFunction progFunction, ProgCommand[] progCommandArray) {
        progFunction.commands = progCommandArray;
        return progCommandArray;
    }

    private class FunctionRef
    extends ProgCommand {
        ProgFunction func;

        FunctionRef(ProgFunction progFunction2) {
            this.func = progFunction2;
        }

        void apply(EvalStack evalStack) {
            this.func.apply(evalStack);
        }
    }

    private class ComplexVarRef
    extends ProgCommand {
        ComplexVariable variable;

        ComplexVarRef(ComplexVariable complexVariable) {
            this.variable = complexVariable;
        }

        void apply(EvalStack evalStack) {
            evalStack.push(this.variable.getRe(), this.variable.getIm());
        }
    }

    private class VarRef
    extends ProgCommand {
        Variable variable;

        VarRef(Variable variable) {
            this.variable = variable;
        }

        void apply(EvalStack evalStack) {
            evalStack.push(this.variable.getVal());
        }
    }

    private class ComplexConstRef
    extends ConstRef {
        double im;

        ComplexConstRef(double d, double d2) {
            super(d);
            this.im = d2;
        }

        void apply(EvalStack evalStack) {
            evalStack.push(this.re, this.im);
        }
    }

    private class ConstRef
    extends ProgCommand {
        double re;

        ConstRef(double d) {
            this.re = d;
        }

        void apply(EvalStack evalStack) {
            evalStack.push(this.re);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Conditional
    extends ProgCommand {
        ProgCommand[] trueCase;
        ProgCommand[] falseCase;

        Conditional(ArrayList<ProgCommand> arrayList, ArrayList<ProgCommand> arrayList2) {
            this.trueCase = new ProgCommand[arrayList.size()];
            arrayList.toArray(this.trueCase);
            this.falseCase = new ProgCommand[arrayList2.size()];
            arrayList2.toArray(this.falseCase);
        }

        @Override
        void apply(EvalStack evalStack) {
            if (evalStack.pop() == 0.0) {
                for (ProgCommand progCommand : this.falseCase) {
                    progCommand.apply(evalStack);
                }
            } else {
                for (ProgCommand progCommand : this.trueCase) {
                    progCommand.apply(evalStack);
                }
            }
        }
    }

    private class StackOpRef
    extends ProgCommand {
        StackOp op;

        StackOpRef(StackOp stackOp) {
            this.op = stackOp;
        }

        void apply(EvalStack evalStack) {
            evalStack.apply(this.op);
        }
    }

    private class ArgRef
    extends ProgCommand {
        int argNum;

        ArgRef(int n) {
            this.argNum = n;
        }

        void apply(EvalStack evalStack) {
            if (ProgFunction.this.argType == Type.COMPLEX) {
                evalStack.fetchComplex(this.argNum * 2);
            } else {
                evalStack.fetch(this.argNum);
            }
        }
    }

    private abstract class ProgCommand {
        private ProgCommand() {
        }

        abstract void apply(EvalStack var1);
    }

    static class Builder {
        private ProgFunction func;
        private ArrayList<ProgCommand> commands;
        private ArrayList<ProgCommand> currentSubProg;
        private ArrayList<ArrayList<ProgCommand>> pendingSubProgs;
        private ArrayList<ArrayList<ProgCommand>> subProgs;
        private ArrayList<ConstRef> constants;

        Builder() {
        }

        private void add(ProgCommand progCommand) {
            assert (this.func != null);
            assert (progCommand != null);
            if (this.currentSubProg != null) {
                this.currentSubProg.add(progCommand);
            } else {
                this.commands.add(progCommand);
            }
        }

        void start(int n, Type type) {
            assert (this.func == null);
            this.func = new ProgFunction();
            this.func.argType = type;
            this.func.argCount = n;
            this.commands = new ArrayList();
        }

        void addStackOp(StackOp stackOp) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new StackOpRef(stackOp));
        }

        void addArgumentReference(int n) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new ArgRef(n));
        }

        void addConditional(int n, int n2, boolean bl) {
            if (bl) {
                ProgFunction progFunction = this.func;
                progFunction.getClass();
                this.subProgs.get(n).add(progFunction.new StackOpRef(StackOp.REAL_TO_COMPLEX));
            }
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new Conditional(this.subProgs.get(n), this.subProgs.get(n2)));
        }

        void addFunctionRef(ProgFunction progFunction) {
            ProgFunction progFunction2 = progFunction;
            progFunction2.getClass();
            this.add(progFunction2.new FunctionRef(progFunction));
        }

        void addRealConstant(double d) {
            if (this.constants == null) {
                this.constants = new ArrayList();
            }
            for (ConstRef constRef : this.constants) {
                if (constRef instanceof ComplexConstRef || constRef.re != d) continue;
                this.add(constRef);
                return;
            }
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            ConstRef constRef = progFunction.new ConstRef(d);
            this.constants.add(constRef);
            this.add(constRef);
        }

        void addComplexConstant(double d, double d2) {
            if (this.constants == null) {
                this.constants = new ArrayList();
            }
            for (ConstRef constRef : this.constants) {
                if (!(constRef instanceof ComplexConstRef) || constRef.re != d || ((ComplexConstRef)constRef).im != d2) continue;
                this.add(constRef);
                return;
            }
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            ComplexConstRef complexConstRef = progFunction.new ComplexConstRef(d, d2);
            this.constants.add(complexConstRef);
            this.add(complexConstRef);
        }

        void addVariableRef(Variable variable) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new VarRef(variable));
        }

        void addComplexVariableRef(ComplexVariable complexVariable) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new ComplexVarRef(complexVariable));
        }

        int startSubProg() {
            assert (this.func != null);
            if (this.currentSubProg != null) {
                this.pendingSubProgs = new ArrayList();
                this.pendingSubProgs.add(this.currentSubProg);
            }
            this.currentSubProg = new ArrayList();
            if (this.subProgs == null) {
                this.subProgs = new ArrayList();
            }
            this.subProgs.add(this.currentSubProg);
            return this.subProgs.size() - 1;
        }

        void finishSubProg() {
            assert (this.currentSubProg != null);
            this.currentSubProg = this.pendingSubProgs != null && this.pendingSubProgs.size() > 0 ? this.pendingSubProgs.remove(this.pendingSubProgs.size() - 1) : null;
        }

        ProgFunction finish(Type type) {
            assert (this.func != null);
            assert (this.currentSubProg == null);
            this.func.type = type;
            ProgFunction.access$402(this.func, new ProgCommand[this.commands.size()]);
            this.commands.toArray(this.func.commands);
            ProgFunction progFunction = this.func;
            this.reset();
            return progFunction;
        }

        void reset() {
            this.func = null;
            this.commands = null;
            this.subProgs = null;
            this.currentSubProg = null;
            this.pendingSubProgs = null;
            this.constants = null;
        }
    }
}

