/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vmm.core.I18n;
import vmm.functions.ComplexExpression;
import vmm.functions.ComplexFunction;
import vmm.functions.ComplexFunction1;
import vmm.functions.ComplexFunction2;
import vmm.functions.ComplexFunction3;
import vmm.functions.ComplexVariable;
import vmm.functions.Expression;
import vmm.functions.Function;
import vmm.functions.Function1;
import vmm.functions.Function2;
import vmm.functions.Function3;
import vmm.functions.ParseError;
import vmm.functions.ProgFunction;
import vmm.functions.StackOp;
import vmm.functions.StandardFunction;
import vmm.functions.Type;
import vmm.functions.Variable;

public class Parser {
    private static Variable PI = new Variable("pi", Math.PI);
    private static Variable E = new Variable("e", Math.E);
    private static ComplexVariable I = new ComplexVariable("i", 0.0, 1.0);
    private static EnumSet<Token> relationalOps = EnumSet.of(Token.EQUAL, new Token[]{Token.NOT_EQUAL, Token.GREATER, Token.GREATER_EQUAL, Token.LESS, Token.LESS_EQUAL});
    private static EnumSet<Token> canStartFactor = EnumSet.of(Token.NUMBER, new Token[]{Token.VARIABLE, Token.COMPLEX_VARIABLE, Token.ARGUMENT, Token.COMPLEX_ARGUMENT, Token.FUNCTION, Token.COMPLEX_FUNCTION, Token.STANDARD_FUNCTION, Token.FUNCTION_COMPLEX_TO_REAL, Token.LEFT_BRACE, Token.LEFT_PAREN, Token.LEFT_BRACKET, Token.TIMES, Token.DIVIDE});
    private static EnumSet<StackOp> needRealToComplex = EnumSet.of(StackOp.SQRT, new StackOp[]{StackOp.CUBERT, StackOp.LOG, StackOp.LOG2, StackOp.LOG10, StackOp.ARCSIN, StackOp.ARCCOS, StackOp.ARCTAN, StackOp.ARCSINH, StackOp.ARCCOSH, StackOp.ARCTANH});
    private SymbolTable symbolTable;

    public Parser() {
        this(null);
    }

    public Parser(Parser parser) {
        if (parser != null) {
            this.symbolTable = new SymbolTable(parser.symbolTable);
        } else {
            StandardFunction[] standardFunctionArray;
            this.symbolTable = new SymbolTable();
            this.add(PI);
            this.add(E);
            this.add(I);
            for (StandardFunction standardFunction : standardFunctionArray = StandardFunction.getFunctions()) {
                this.symbolTable.put(standardFunction.getName().toLowerCase(), standardFunction);
            }
        }
    }

    public Expression parse(String string) {
        return this.parseExpression(string);
    }

    public Expression parseExpression(String string) {
        Context context = new Context(string, this.symbolTable, false);
        context.bldr.start(0, Type.REAL);
        Type type = this.doParse(context);
        if (type == Type.COMPLEX) {
            this.error(context, "vmm.parser.ExpectedRealFoundComplex", new Object[0]);
        }
        if (type == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedRealFoundBoolean", new Object[0]);
        }
        return new Expression(context.bldr.finish(Type.REAL));
    }

    public Function1 parseFunction1(String string, String string2, String string3) {
        return (Function1)this.parseFunction(string, string2, string3);
    }

    public Function2 parseFunction2(String string, String string2, String string3, String string4) {
        return (Function2)this.parseFunction(string, string2, string3, string4);
    }

    public Function3 parseFunction3(String string, String string2, String string3, String string4, String string5) {
        return (Function3)this.parseFunction(string, string2, string3, string4, string5);
    }

    public Function parseFunction(String string, String string2, String ... stringArray) {
        Context context;
        Object object;
        int n;
        if (stringArray != null && stringArray.length > 0) {
            n = stringArray.length;
            object = new SymbolTable(this.symbolTable);
            for (int i = 0; i < stringArray.length; ++i) {
                object.put(stringArray[i].toLowerCase(), new Argument(i));
            }
            context = new Context(string2, (SymbolTable)object, false);
        } else {
            n = 0;
            context = new Context(string2, this.symbolTable, false);
        }
        context.bldr.start(n, Type.REAL);
        object = this.doParse(context);
        if (object == Type.COMPLEX) {
            this.error(context, "vmm.parser.ExpectedRealFoundComplex", new Object[0]);
        }
        if (object == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedRealFoundBoolean", new Object[0]);
        }
        ProgFunction progFunction = context.bldr.finish(Type.REAL);
        if (n == 1) {
            return new Function1(string, progFunction);
        }
        if (n == 2) {
            return new Function2(string, progFunction);
        }
        if (n == 3) {
            return new Function3(string, progFunction);
        }
        return new Function(string, progFunction);
    }

    public ComplexExpression parseComplexExpression(String string) {
        Context context = new Context(string, this.symbolTable, true);
        context.bldr.start(0, Type.COMPLEX);
        Type type = this.doParse(context);
        if (type == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedCompplexFoundBoolean", new Object[0]);
        }
        if (type == Type.REAL) {
            context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
        }
        return new ComplexExpression(context.bldr.finish(Type.COMPLEX));
    }

    public ComplexFunction1 parseComplexFunction1(String string, String string2, String string3) {
        return (ComplexFunction1)this.parseComplexFunction(string, string2, string3);
    }

    public ComplexFunction2 parseComplexFunction2(String string, String string2, String string3, String string4) {
        return (ComplexFunction2)this.parseComplexFunction(string, string2, string3, string4);
    }

    public ComplexFunction3 parseComplexFunction3(String string, String string2, String string3, String string4, String string5) {
        return (ComplexFunction3)this.parseComplexFunction(string, string2, string3, string4, string5);
    }

    public ComplexFunction parseComplexFunction(String string, String string2, String ... stringArray) {
        Context context;
        Object object;
        int n;
        if (stringArray != null && stringArray.length > 0) {
            n = stringArray.length;
            object = new SymbolTable(this.symbolTable);
            for (int i = 0; i < stringArray.length; ++i) {
                object.put(stringArray[i].toLowerCase(), new ComplexArgument(i));
            }
            context = new Context(string2, (SymbolTable)object, false);
        } else {
            n = 0;
            context = new Context(string2, this.symbolTable, true);
        }
        context.bldr.start(n, Type.COMPLEX);
        object = this.doParse(context);
        if (object == Type.BOOLEAN) {
            this.error(context, "vmm.parser.ExpectedCompplexFoundBoolean", new Object[0]);
        }
        if (object == Type.REAL) {
            context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
        }
        ProgFunction progFunction = context.bldr.finish(Type.COMPLEX);
        if (n == 1) {
            return new ComplexFunction1(string, progFunction);
        }
        if (n == 2) {
            return new ComplexFunction2(string, progFunction);
        }
        if (n == 3) {
            return new ComplexFunction3(string, progFunction);
        }
        return new ComplexFunction(string, progFunction);
    }

    public void add(Variable variable) {
        this.symbolTable.put(variable.getName().toLowerCase(), variable);
    }

    public void add(ComplexVariable complexVariable) {
        this.symbolTable.put(complexVariable.getName().toLowerCase(), complexVariable);
    }

    public void add(Function function) {
        this.symbolTable.put(function.getName().toLowerCase(), function);
    }

    public void add(ComplexFunction complexFunction) {
        this.symbolTable.put(complexFunction.getName().toLowerCase(), complexFunction);
    }

    public Object get(String string) {
        return this.symbolTable.get(string.toLowerCase());
    }

    public void remove(String string) {
        this.symbolTable.remove(string.toLowerCase());
    }

    private void error(Context context, String string, Object ... objectArray) {
        String string2 = I18n.tr(string);
        if (objectArray != null && objectArray.length > 0) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        context.bldr.reset();
        throw new ParseError(string2, context.pos, context.str);
    }

    private Type doParse(Context context) {
        if (context.peek() == Token.EOS) {
            this.error(context, "vmm.parser.EmpytDefinition", new Object[0]);
        }
        Type type = this.parseBExpr(context);
        if (context.peek() != Token.EOS) {
            this.error(context, "vmm.parser.ExtraStuff", new Object[0]);
        }
        return type;
    }

    private Type parseBExpr(Context context) {
        Type type = this.parseBTerm(context);
        while (context.peek() == Token.OR) {
            if (type != Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequriesBoolean", "OR");
            }
            context.next();
            Type type2 = this.parseBTerm(context);
            if (type2 != Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequriesBoolean", "OR");
            }
            context.bldr.addStackOp(StackOp.OR);
        }
        if (context.peek() == Token.QUESTION) {
            Type type3;
            if (type != Type.BOOLEAN) {
                this.error(context, "vmm.parser.ConditionalRequiresBoolean", new Object[0]);
            }
            context.next();
            int n = context.bldr.startSubProg();
            type = this.parseNumericalExpr(context);
            if (type == Type.BOOLEAN) {
                this.error(context, "vmm.parser.ConditionalExpressionsMustBeNumerical", new Object[0]);
            }
            context.bldr.finishSubProg();
            int n2 = context.bldr.startSubProg();
            if (context.peek() != Token.COLON) {
                type3 = type;
                if (type == Type.REAL) {
                    context.bldr.addRealConstant(Double.NaN);
                } else {
                    context.bldr.addComplexConstant(Double.NaN, Double.NaN);
                }
            } else {
                context.next();
                type3 = this.parseBExpr(context);
                if (type3 == Type.BOOLEAN) {
                    this.error(context, "vmm.parser.ConditionalExpressionsMustBeNumerical", new Object[0]);
                }
                if (type == Type.COMPLEX && type3 == Type.REAL) {
                    context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                }
            }
            context.bldr.finishSubProg();
            if (type == Type.REAL && type3 == Type.COMPLEX) {
                context.bldr.addConditional(n, n2, true);
                type = Type.COMPLEX;
            } else {
                context.bldr.addConditional(n, n2, false);
            }
        }
        return type;
    }

    private Type parseBTerm(Context context) {
        Type type = this.parseBFactor(context);
        while (context.peek() == Token.AND) {
            if (type != Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequriesBoolean", "AND");
            }
            context.next();
            Type type2 = this.parseBFactor(context);
            if (type2 != Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequriesBoolean", "AND");
            }
            context.bldr.addStackOp(StackOp.AND);
        }
        return type;
    }

    private Type parseBFactor(Context context) {
        int n = 0;
        while (context.peek() == Token.NOT) {
            ++n;
            context.next();
        }
        Type type = this.parseRelation(context);
        if (n > 0 && type != Type.BOOLEAN) {
            this.error(context, "vmm.parser.OperatorRequriesBoolean", "NOT");
        }
        if (n % 2 == 1) {
            context.bldr.addStackOp(StackOp.NOT);
        }
        return type;
    }

    private Type parseRelation(Context context) {
        Type type = this.parseNumericalExpr(context);
        if (relationalOps.contains((Object)context.peek())) {
            Type type2;
            Token token = context.next();
            String string = context.tokstr;
            if (type == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if (type == Type.COMPLEX && token != Token.EQUAL && token != Token.NOT_EQUAL) {
                this.error(context, "vmm.parser.RelationNotDefinedForComplex", string);
            }
            if ((type2 = this.parseNumericalExpr(context)) == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if (type2 == Type.COMPLEX && token != Token.EQUAL && token != Token.NOT_EQUAL) {
                this.error(context, "vmm.parser.RelationNotDefinedForComplex", string);
            }
            if (type == Type.REAL && type2 == Type.COMPLEX) {
                context.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                type = Type.COMPLEX;
            }
            switch (token) {
                case EQUAL: {
                    context.bldr.addStackOp(type == Type.COMPLEX ? StackOp.C_EQ : StackOp.EQ);
                    break;
                }
                case NOT_EQUAL: {
                    context.bldr.addStackOp(type == Type.COMPLEX ? StackOp.C_NE : StackOp.NE);
                    break;
                }
                case GREATER: {
                    context.bldr.addStackOp(StackOp.GT);
                    break;
                }
                case LESS: {
                    context.bldr.addStackOp(StackOp.LT);
                    break;
                }
                case GREATER_EQUAL: {
                    context.bldr.addStackOp(StackOp.GE);
                    break;
                }
                case LESS_EQUAL: {
                    context.bldr.addStackOp(StackOp.LE);
                }
            }
            if (relationalOps.contains((Object)context.peek())) {
                this.error(context, "vmm.parser.CantStringRelations", new Object[0]);
            }
            return Type.BOOLEAN;
        }
        return type;
    }

    private Type parseNumericalExpr(Context context) {
        Token token = null;
        if (context.peek() == Token.PLUS || context.peek() == Token.MINUS) {
            token = context.next();
        }
        Type type = this.parseNumericalTerm(context);
        if (token != null) {
            if (type == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", token == Token.PLUS ? "+" : "-");
            }
            if (token == Token.MINUS) {
                context.bldr.addStackOp(type == Type.REAL ? StackOp.UNARY_MINUS : StackOp.C_UNARY_MINUS);
            }
        }
        while (context.peek() == Token.PLUS || context.peek() == Token.MINUS) {
            Type type2;
            Token token2 = context.next();
            String string = context.tokstr;
            if (type == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if ((type2 = this.parseNumericalTerm(context)) == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if (type == Type.REAL && type2 == Type.COMPLEX) {
                context.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                type = Type.COMPLEX;
            } else if (type == Type.COMPLEX && type2 == Type.REAL) {
                context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
            }
            if (type == Type.REAL) {
                context.bldr.addStackOp(token2 == Token.PLUS ? StackOp.PLUS : StackOp.MINUS);
                continue;
            }
            context.bldr.addStackOp(token2 == Token.PLUS ? StackOp.C_PLUS : StackOp.C_MINUS);
        }
        return type;
    }

    private Type parseNumericalTerm(Context context) {
        Type type = this.parseNumericalFactor(context);
        while (canStartFactor.contains((Object)context.peek())) {
            Type type2;
            String string;
            Token token;
            if (context.peek() == Token.TIMES || context.peek() == Token.DIVIDE) {
                token = context.next();
                string = context.tokstr;
            } else {
                token = Token.TIMES;
                string = "*";
            }
            if (type == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if ((type2 = this.parseNumericalFactor(context)) == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if (type == Type.REAL && type2 == Type.COMPLEX) {
                context.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                type = Type.COMPLEX;
            } else if (type == Type.COMPLEX && type2 == Type.REAL) {
                context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
            }
            if (type == Type.REAL) {
                context.bldr.addStackOp(token == Token.TIMES ? StackOp.TIMES : StackOp.DIVIDE);
                continue;
            }
            context.bldr.addStackOp(token == Token.TIMES ? StackOp.C_TIMES : StackOp.C_DIVIDE);
        }
        return type;
    }

    private Type parseNumericalFactor(Context context) {
        Type type = this.parseNumericalPrimary(context);
        while (context.peek() == Token.POWER) {
            Type type2;
            context.next();
            String string = context.tokstr;
            if (type == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if ((type2 = this.parseNumericalPrimary(context)) == Type.BOOLEAN) {
                this.error(context, "vmm.parser.OperatorRequiresNumerical", string);
            }
            if (type == Type.REAL) {
                if (type2 == Type.COMPLEX) {
                    context.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                    type = Type.COMPLEX;
                } else if (context.complexOnly) {
                    context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                    context.bldr.addStackOp(StackOp.FIRST_OP_TO_COMPLEX);
                    type = type2 = Type.COMPLEX;
                }
            }
            if (type == Type.COMPLEX && type2 == Type.REAL) {
                context.bldr.addStackOp(StackOp.C_REAL_POWER);
                continue;
            }
            if (type == Type.REAL) {
                context.bldr.addStackOp(StackOp.POWER);
                continue;
            }
            context.bldr.addStackOp(StackOp.C_POWER);
        }
        return type;
    }

    private Type parseNumericalPrimary(Context context) {
        Token token = context.next();
        switch (token) {
            case NUMBER: {
                context.bldr.addRealConstant(context.number);
                return Type.REAL;
            }
            case VARIABLE: {
                context.bldr.addVariableRef((Variable)context.symbol);
                return Type.REAL;
            }
            case ARGUMENT: {
                context.bldr.addArgumentReference(((Argument)context.symbol).argnum);
                return Type.REAL;
            }
            case COMPLEX_VARIABLE: {
                context.bldr.addComplexVariableRef((ComplexVariable)context.symbol);
                return Type.COMPLEX;
            }
            case COMPLEX_ARGUMENT: {
                context.bldr.addArgumentReference(((ComplexArgument)context.symbol).argnum);
                return Type.COMPLEX;
            }
            case FUNCTION: 
            case COMPLEX_FUNCTION: 
            case STANDARD_FUNCTION: 
            case FUNCTION_COMPLEX_TO_REAL: {
                StandardFunction standardFunction;
                Token token2 = token;
                Object object = context.symbol;
                String string = context.tokstr;
                Token token3 = context.next();
                if (token3 != Token.LEFT_PAREN && token3 != Token.LEFT_BRACE && token3 != Token.LEFT_BRACKET) {
                    this.error(context, "vmm.parser.FunctionRequiresParen", string);
                }
                int n = 0;
                int n2 = token2 == Token.FUNCTION ? ((Function)object).getArity() : (token2 == Token.COMPLEX_FUNCTION ? ((ComplexFunction)object).getArity() : (token2 == Token.STANDARD_FUNCTION ? 1 : 2));
                Type type = null;
                while ((token = context.peek()) != Token.RIGHT_PAREN && token != Token.RIGHT_BRACE && token != Token.RIGHT_BRACKET) {
                    if (++n > n2) {
                        this.error(context, "vmm.parser.TooManyArguments", string);
                    }
                    type = this.parseBExpr(context);
                    if (token2 == Token.FUNCTION || token2 == Token.FUNCTION_COMPLEX_TO_REAL) {
                        if (type != Type.REAL) {
                            this.error(context, "vmm.parser.NeedRealArgument", string);
                        }
                    } else if (token2 == Token.COMPLEX_FUNCTION) {
                        if (type == Type.BOOLEAN) {
                            this.error(context, "vmm.parser.NeedComplexArgument", string);
                        }
                        if (type == Type.REAL) {
                            context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                        }
                    } else if (token2 == Token.STANDARD_FUNCTION) {
                        standardFunction = (StandardFunction)object;
                        if (type == Type.COMPLEX) {
                            if (standardFunction.getComplexArgOp() == null) {
                                this.error(context, "vmm.parser.NeedRealArgument", string);
                            }
                        } else if (type == Type.REAL) {
                            if (standardFunction.getRealArgOp() == null || context.complexOnly && needRealToComplex.contains((Object)standardFunction.getRealArgOp())) {
                                context.bldr.addStackOp(StackOp.REAL_TO_COMPLEX);
                                type = Type.COMPLEX;
                            }
                        } else if (standardFunction.getRealArgOp() == null || context.complexOnly && needRealToComplex.contains((Object)standardFunction.getRealArgOp())) {
                            this.error(context, "vmm.parser.NeedComplexArgument", string);
                        } else {
                            this.error(context, "vmm.parser.NeedRealArgument", string);
                        }
                    }
                    if ((token = context.peek()) != Token.COMMA) break;
                    context.next();
                }
                token = context.next();
                if (n < n2) {
                    this.error(context, "vmm.parser.NotEnoughArguments", string);
                }
                if (token3 == Token.LEFT_PAREN && token != Token.RIGHT_PAREN) {
                    this.error(context, "vmm.parser.MissingCloseOfArgumentList", ")");
                }
                if (token3 == Token.LEFT_BRACE && token != Token.RIGHT_BRACE) {
                    this.error(context, "vmm.parser.MissingCloseOfArgumentList", "}");
                }
                if (token3 == Token.LEFT_BRACKET && token != Token.RIGHT_BRACKET) {
                    this.error(context, "vmm.parser.MissingCloseOfArgumentList", "]");
                }
                if (token2 == Token.FUNCTION) {
                    context.bldr.addFunctionRef(((Function)object).getProgFunction());
                    return Type.REAL;
                }
                if (token2 == Token.COMPLEX_FUNCTION) {
                    context.bldr.addFunctionRef(((ComplexFunction)object).getProgFunction());
                    return Type.COMPLEX;
                }
                if (token2 == Token.FUNCTION_COMPLEX_TO_REAL) {
                    return Type.COMPLEX;
                }
                standardFunction = (StandardFunction)object;
                context.bldr.addStackOp(type == Type.COMPLEX ? standardFunction.getComplexArgOp() : standardFunction.getRealArgOp());
                return type == Type.COMPLEX ? standardFunction.getReturnTypeForComplexArg() : standardFunction.getReturnTypeForRealArg();
            }
            case LEFT_PAREN: {
                Type type = this.parseBExpr(context);
                token = context.next();
                if (token == Token.EOS) {
                    this.error(context, "vmm.parser.MissingRightGroupThingAtEOS", ")", "(");
                }
                if (token != Token.RIGHT_PAREN) {
                    this.error(context, "vmm.parser.MissingRightGroupThing", ")", "(", context.tokstr);
                }
                return type;
            }
            case LEFT_BRACE: {
                Type type = this.parseBExpr(context);
                token = context.next();
                if (token == Token.EOS) {
                    this.error(context, "vmm.parser.MissingRightGroupThingAtEOS", "]", "[");
                }
                if (token != Token.RIGHT_BRACE) {
                    this.error(context, "vmm.parser.MissingRightGroupThing", "]", "[", context.tokstr);
                }
                return type;
            }
            case LEFT_BRACKET: {
                Type type = this.parseBExpr(context);
                token = context.next();
                if (token == Token.EOS) {
                    this.error(context, "vmm.parser.MissingRightGroupThingAtEOS", "}", "{");
                }
                if (token != Token.RIGHT_PAREN) {
                    this.error(context, "vmm.parser.MissingRightGroupThing", "}", "{", context.tokstr);
                }
                return type;
            }
            case RIGHT_PAREN: {
                this.error(context, "vmm.parser.ExtraRightGroupThing", ")", "(");
                return null;
            }
            case RIGHT_BRACE: {
                this.error(context, "vmm.parser.ExtraRightGroupThing", "}", "{");
                return null;
            }
            case RIGHT_BRACKET: {
                this.error(context, "vmm.parser.ExtraRightGroupThing", "]", "[");
                return null;
            }
            case UNKNOWN_CHAR: {
                this.error(context, "vmm.parser.UnknownChar", context.tokstr);
                return null;
            }
            case UNKNOWN_WORD: {
                this.error(context, "vmm.parser.UndefinedWord", context.tokstr);
                return null;
            }
            case ILLEGAL_NUMBER: {
                this.error(context, "vmm.parser.IllegalNumber", context.tokstr);
                return null;
            }
            case EOS: {
                this.error(context, "vmm.parser.IncompleteExpression", new Object[0]);
            }
        }
        this.error(context, "vmm.parser.UnexcpectedToken", context.tokstr);
        return null;
    }

    private static class ComplexArgument {
        int argnum;

        ComplexArgument(int n) {
            this.argnum = n;
        }
    }

    private static class Argument {
        int argnum;

        Argument(int n) {
            this.argnum = n;
        }
    }

    private static class SymbolTable {
        private SymbolTable parent;
        private HashMap<String, Object> table = new HashMap();

        SymbolTable() {
        }

        SymbolTable(SymbolTable symbolTable) {
            this.parent = symbolTable;
        }

        void put(String string, Object object) {
            this.table.put(string, object);
        }

        void remove(String string) {
            if (string != null) {
                this.table.remove(string.toLowerCase());
            }
        }

        Object get(String string) {
            Object object = this.table.get(string);
            if (object == null && this.parent != null) {
                return this.parent.get(string);
            }
            return object;
        }
    }

    private static class Context {
        private static final Pattern numberRegex = Pattern.compile("(\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?");
        private Matcher numberMatcher;
        private SymbolTable symbolTable;
        private Token currentToken;
        ProgFunction.Builder bldr;
        boolean complexOnly;
        Object symbol;
        String str;
        int pos;
        double number;
        String tokstr;

        Context(String string, SymbolTable symbolTable, boolean bl) {
            this.str = string;
            this.pos = 0;
            this.symbolTable = symbolTable;
            this.complexOnly = bl;
            this.bldr = new ProgFunction.Builder();
        }

        Token peek() {
            if (this.currentToken == null) {
                this.currentToken = this.readToken();
            }
            return this.currentToken;
        }

        Token next() {
            Token token = this.peek();
            this.currentToken = null;
            return token;
        }

        private Token readToken() {
            this.symbol = null;
            if (this.str == null) {
                return Token.EOS;
            }
            while (this.pos < this.str.length() && Character.isWhitespace(this.str.charAt(this.pos))) {
                ++this.pos;
            }
            if (this.pos >= this.str.length()) {
                return Token.EOS;
            }
            char c = this.str.charAt(this.pos);
            if (Character.isLetter(c) || c == '_') {
                this.tokstr = "";
                while (this.pos < this.str.length() && (Character.isLetterOrDigit(this.str.charAt(this.pos)) || this.str.charAt(this.pos) == '_')) {
                    this.tokstr = this.tokstr + this.str.charAt(this.pos);
                    ++this.pos;
                }
                while (this.pos < this.str.length() && this.str.charAt(this.pos) == '\'') {
                    this.tokstr = this.tokstr + '\'';
                    ++this.pos;
                }
                String string = this.tokstr.toLowerCase();
                this.symbol = this.symbolTable.get(string);
                if (this.symbol != null) {
                    if (this.symbol instanceof Variable) {
                        return Token.VARIABLE;
                    }
                    if (this.symbol instanceof ComplexVariable) {
                        return Token.COMPLEX_VARIABLE;
                    }
                    if (this.symbol instanceof Function) {
                        return Token.FUNCTION;
                    }
                    if (this.symbol instanceof ComplexFunction) {
                        return Token.COMPLEX_FUNCTION;
                    }
                    if (this.symbol instanceof Argument) {
                        return Token.ARGUMENT;
                    }
                    if (this.symbol instanceof ComplexArgument) {
                        return Token.COMPLEX_ARGUMENT;
                    }
                    if (this.symbol instanceof StandardFunction) {
                        return Token.STANDARD_FUNCTION;
                    }
                    throw new IllegalStateException("internal error: unknown object type in symbol table");
                }
                if (string.equals("complex")) {
                    return Token.FUNCTION_COMPLEX_TO_REAL;
                }
                if (string.equals("and")) {
                    return Token.AND;
                }
                if (string.equals("or")) {
                    return Token.OR;
                }
                if (string.equals("not")) {
                    return Token.NOT;
                }
                return Token.UNKNOWN_WORD;
            }
            if (Character.isDigit(c) || c == '.') {
                if (this.numberMatcher == null) {
                    this.numberMatcher = numberRegex.matcher(this.str);
                }
                this.numberMatcher.region(this.pos, this.str.length());
                if (this.numberMatcher.lookingAt()) {
                    this.tokstr = this.numberMatcher.group();
                    this.pos = this.numberMatcher.end();
                    try {
                        this.number = Double.parseDouble(this.tokstr);
                        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Token.ILLEGAL_NUMBER;
                    }
                    return Token.NUMBER;
                }
                ++this.pos;
                this.tokstr = ".";
                return Token.ILLEGAL_NUMBER;
            }
            if (c == '=') {
                this.tokstr = "=";
                ++this.pos;
                if (this.pos == this.str.length()) {
                    return Token.EQUAL;
                }
                if (this.str.charAt(this.pos) == '=') {
                    this.tokstr = this.tokstr + '=';
                    ++this.pos;
                    return Token.EQUAL;
                }
                if (this.str.charAt(this.pos) == '>') {
                    this.tokstr = this.tokstr + '>';
                    ++this.pos;
                    return Token.GREATER_EQUAL;
                }
                if (this.str.charAt(this.pos) == '<') {
                    this.tokstr = this.tokstr + '<';
                    ++this.pos;
                    return Token.LESS_EQUAL;
                }
                return Token.EQUAL;
            }
            if (c == '<') {
                this.tokstr = "<";
                ++this.pos;
                if (this.pos == this.str.length()) {
                    return Token.LESS;
                }
                if (this.str.charAt(this.pos) == '=') {
                    ++this.pos;
                    this.tokstr = this.tokstr + '=';
                    return Token.LESS_EQUAL;
                }
                if (this.str.charAt(this.pos) == '>') {
                    ++this.pos;
                    this.tokstr = this.tokstr + '>';
                    return Token.NOT_EQUAL;
                }
                return Token.LESS;
            }
            if (c == '>') {
                this.tokstr = ">";
                ++this.pos;
                if (this.pos == this.str.length()) {
                    return Token.GREATER;
                }
                if (this.str.charAt(this.pos) == '=') {
                    this.tokstr = this.tokstr + '=';
                    ++this.pos;
                    return Token.GREATER_EQUAL;
                }
                if (this.str.charAt(this.pos) == '>') {
                    this.tokstr = this.tokstr + '>';
                    ++this.pos;
                    return Token.NOT_EQUAL;
                }
                return Token.GREATER;
            }
            if (c == '!') {
                this.tokstr = "!";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '=') {
                    this.tokstr = this.tokstr + '=';
                    ++this.pos;
                    return Token.NOT_EQUAL;
                }
                return Token.UNKNOWN_CHAR;
            }
            if (c == '*') {
                this.tokstr = "*";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '*') {
                    this.tokstr = this.tokstr + '*';
                    ++this.pos;
                    return Token.POWER;
                }
                return Token.TIMES;
            }
            if (c == '&') {
                this.tokstr = "&";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '&') {
                    this.tokstr = this.tokstr + '&';
                    ++this.pos;
                }
                return Token.AND;
            }
            if (c == '|') {
                this.tokstr = "|";
                ++this.pos;
                if (this.pos < this.str.length() && this.str.charAt(this.pos) == '|') {
                    this.tokstr = this.tokstr + '|';
                    ++this.pos;
                }
                return Token.OR;
            }
            this.tokstr = "" + c;
            ++this.pos;
            switch (c) {
                case '(': {
                    return Token.LEFT_PAREN;
                }
                case ')': {
                    return Token.RIGHT_PAREN;
                }
                case '{': {
                    return Token.LEFT_BRACE;
                }
                case '}': {
                    return Token.RIGHT_BRACE;
                }
                case '[': {
                    return Token.LEFT_BRACKET;
                }
                case ']': {
                    return Token.RIGHT_BRACKET;
                }
                case '?': {
                    return Token.QUESTION;
                }
                case ':': {
                    return Token.COLON;
                }
                case ',': {
                    return Token.COMMA;
                }
                case '+': {
                    return Token.PLUS;
                }
                case '-': {
                    return Token.MINUS;
                }
                case '/': {
                    return Token.DIVIDE;
                }
                case '^': {
                    return Token.POWER;
                }
                case '~': {
                    return Token.NOT;
                }
            }
            return Token.UNKNOWN_CHAR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Token {
        NUMBER,
        ILLEGAL_NUMBER,
        FUNCTION,
        COMPLEX_FUNCTION,
        STANDARD_FUNCTION,
        FUNCTION_COMPLEX_TO_REAL,
        VARIABLE,
        COMPLEX_VARIABLE,
        ARGUMENT,
        COMPLEX_ARGUMENT,
        UNKNOWN_WORD,
        LEFT_PAREN,
        RIGHT_PAREN,
        LEFT_BRACE,
        RIGHT_BRACE,
        LEFT_BRACKET,
        RIGHT_BRACKET,
        PLUS,
        MINUS,
        TIMES,
        DIVIDE,
        POWER,
        AND,
        OR,
        NOT,
        EQUAL,
        NOT_EQUAL,
        GREATER,
        LESS,
        GREATER_EQUAL,
        LESS_EQUAL,
        QUESTION,
        COLON,
        COMMA,
        UNKNOWN_CHAR,
        EOS;

    }
}

