/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import vmm.functions.EvalStack;
import vmm.functions.ProgFunction;
import vmm.functions.Type;

public class Function {
    protected ProgFunction func;
    private String name;

    Function(String string, ProgFunction progFunction) {
        assert (progFunction.getArgType() == Type.REAL && progFunction.getType() == Type.REAL);
        this.func = progFunction;
        this.name = string;
    }

    ProgFunction getProgFunction() {
        return this.func;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getArity() {
        return this.func.getArgCount();
    }

    public synchronized double value(double[] dArray) {
        return this.value(dArray, EvalStack.perThread());
    }

    public double value(double[] dArray, EvalStack evalStack) {
        int n = this.func.getArgCount();
        if (n == 0) {
            if (dArray != null && dArray.length > 0) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            this.func.apply(evalStack);
            return evalStack.pop();
        }
        if (dArray == null || dArray.length != n) {
            throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
        }
        for (double d : dArray) {
            evalStack.push(d);
        }
        this.func.apply(evalStack);
        return evalStack.pop();
    }
}

