/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import java.util.HashMap;
import vmm.core.Complex;
import vmm.functions.StackOp;

public final class EvalStack {
    private double[] stack;
    private int top;
    private int addressBase;
    private static HashMap<Thread, EvalStack> perThreadStacks = new HashMap();

    public EvalStack() {
        this(30);
    }

    public EvalStack(int n) {
        if (n < 1) {
            n = 1;
        }
        this.stack = new double[n];
    }

    public static final EvalStack perThread() {
        return EvalStack.perThread(Thread.currentThread());
    }

    public static final EvalStack perThread(Thread thread) {
        EvalStack evalStack = perThreadStacks.get(thread);
        if (evalStack == null && thread != null) {
            evalStack = new EvalStack();
            perThreadStacks.put(thread, evalStack);
        }
        return evalStack;
    }

    public static void perThreadRelease(Thread thread) {
        perThreadStacks.remove(thread);
    }

    void reset() {
        this.addressBase = 0;
        this.top = 0;
    }

    boolean isEmpty() {
        return this.top == 0;
    }

    void startFunctionCall(int n) {
        this.push(this.addressBase);
        this.addressBase = this.top - 1 - n;
    }

    void endRealValuedFunction(int n) {
        double d = this.pop();
        this.addressBase = (int)this.pop();
        this.top -= n;
        this.push(d);
    }

    void endComplexValuedFunction(int n) {
        double d = this.pop();
        double d2 = this.pop();
        this.addressBase = (int)this.pop();
        this.top -= n;
        this.push(d2);
        this.push(d);
    }

    void push(double d) {
        if (this.stack.length == this.top) {
            double[] dArray = new double[this.top * 2];
            System.arraycopy(this.stack, 0, dArray, 0, this.top);
            this.stack = dArray;
        }
        this.stack[this.top++] = d;
    }

    void push(double d, double d2) {
        this.push(d);
        this.push(d2);
    }

    void push(Complex complex) {
        this.push(complex.re);
        this.push(complex.im);
    }

    double pop() {
        return this.stack[--this.top];
    }

    Complex popComplex() {
        double d = this.pop();
        double d2 = this.pop();
        return new Complex(d2, d);
    }

    void popComplex(Complex complex) {
        complex.im = this.pop();
        complex.re = this.pop();
    }

    void fetch(int n) {
        this.push(this.stack[n + this.addressBase]);
    }

    void fetchComplex(int n) {
        this.push(this.stack[n + this.addressBase]);
        this.push(this.stack[n + this.addressBase + 1]);
    }

    void apply(StackOp stackOp) {
        switch (stackOp) {
            case COMPLEX_TO_REAL: {
                this.pop();
                break;
            }
            case REAL_TO_COMPLEX: {
                this.push(0.0);
                break;
            }
            case FIRST_OP_TO_COMPLEX: {
                double d = this.pop();
                double d2 = this.pop();
                this.push(0.0);
                this.push(d2);
                this.push(d);
                break;
            }
            case IMAGINARY_PART: {
                double d = this.pop();
                this.pop();
                this.push(d);
                break;
            }
            case PLUS: {
                this.push(this.pop() + this.pop());
                break;
            }
            case MINUS: {
                double d = this.pop();
                this.push(this.pop() - d);
                break;
            }
            case TIMES: {
                this.push(this.pop() * this.pop());
                break;
            }
            case DIVIDE: {
                double d = this.pop();
                this.push(this.pop() / d);
                break;
            }
            case POWER: {
                double d = this.pop();
                this.push(Math.pow(this.pop(), d));
                break;
            }
            case C_PLUS: {
                double d = this.pop();
                double d3 = this.pop();
                double d4 = this.pop();
                double d5 = this.pop();
                this.push(d5 + d3, d4 + d);
                break;
            }
            case C_MINUS: {
                double d = this.pop();
                double d6 = this.pop();
                double d7 = this.pop();
                double d8 = this.pop();
                this.push(d8 - d6, d7 - d);
                break;
            }
            case C_TIMES: {
                double d = this.pop();
                double d9 = this.pop();
                double d10 = this.pop();
                double d11 = this.pop();
                this.push(d11 * d9 - d10 * d, d11 * d + d9 * d10);
                break;
            }
            case C_DIVIDE: {
                double d = this.pop();
                double d12 = this.pop();
                double d13 = this.pop();
                double d14 = this.pop();
                double d15 = d12 * d12 + d * d;
                this.push((d14 * d12 + d13 * d) / d15, (d13 * d12 - d14 * d) / d15);
                break;
            }
            case C_POWER: {
                double d = this.pop();
                double d16 = this.pop();
                double d17 = this.pop();
                double d18 = this.pop();
                double d19 = Math.sqrt(d18 * d18 + d17 * d17);
                double d20 = Math.log(d19);
                double d21 = Math.atan2(d17, d18);
                double d22 = Math.exp(d16 * d20 - d * d21);
                double d23 = d * d20 + d16 * d21;
                this.push(d22 * Math.cos(d23), d22 * Math.sin(d23));
                break;
            }
            case C_REAL_POWER: {
                double d = this.pop();
                double d24 = this.pop();
                double d25 = this.pop();
                double d26 = Math.sqrt(d24 * d24 + d25 * d25);
                double d27 = Math.atan2(d24, d25);
                double d28 = Math.log(d26);
                double d29 = d27;
                double d30 = d * d28;
                double d31 = d * d29;
                double d32 = Math.exp(d30);
                this.push(d32 * Math.cos(d31), d32 * Math.sin(d31));
                break;
            }
            case EQ: {
                this.push(this.pop() == this.pop() ? 1.0 : 0.0);
                break;
            }
            case NE: {
                this.push(this.pop() != this.pop() ? 1.0 : 0.0);
                break;
            }
            case GE: {
                this.push(this.pop() <= this.pop() ? 1.0 : 0.0);
                break;
            }
            case GT: {
                this.push(this.pop() < this.pop() ? 1.0 : 0.0);
                break;
            }
            case LE: {
                this.push(this.pop() >= this.pop() ? 1.0 : 0.0);
                break;
            }
            case LT: {
                this.push(this.pop() > this.pop() ? 1.0 : 0.0);
                break;
            }
            case C_EQ: {
                double d = this.pop();
                double d33 = this.pop();
                double d34 = this.pop();
                double d35 = this.pop();
                this.push(d35 == d33 && d34 == d ? 1.0 : 0.0);
                break;
            }
            case C_NE: {
                double d = this.pop();
                double d36 = this.pop();
                double d37 = this.pop();
                double d38 = this.pop();
                this.push(d38 == d36 && d37 == d ? 0.0 : 1.0);
                break;
            }
            case AND: {
                double d = this.pop();
                double d39 = this.pop();
                this.push(d39 != 0.0 && d != 0.0 ? 1.0 : 0.0);
                break;
            }
            case OR: {
                double d = this.pop();
                double d40 = this.pop();
                this.push(d40 != 0.0 || d != 0.0 ? 1.0 : 0.0);
                break;
            }
            case NOT: {
                this.push(this.pop() != 0.0 ? 0.0 : 1.0);
                break;
            }
            case UNARY_MINUS: {
                this.push(-this.pop());
                break;
            }
            case C_UNARY_MINUS: {
                double d = this.pop();
                double d41 = this.pop();
                this.push(-d41, -d);
                break;
            }
            case ABS: {
                this.push(Math.abs(this.pop()));
                break;
            }
            case SQRT: {
                this.push(Math.sqrt(this.pop()));
                break;
            }
            case CUBERT: {
                this.push(Math.cbrt(this.pop()));
                break;
            }
            case EXP: {
                this.push(Math.exp(this.pop()));
                break;
            }
            case LOG: {
                this.push(Math.log(this.pop()));
                break;
            }
            case LOG2: {
                this.push(Math.log(this.pop()) / Math.log(2.0));
                break;
            }
            case LOG10: {
                this.push(Math.log10(this.pop()));
                break;
            }
            case C_ABS: {
                double d = this.pop();
                double d42 = this.pop();
                this.push(Math.sqrt(d42 * d42 + d * d));
                break;
            }
            case C_SQRT: {
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                break;
            }
            case C_CUBERT: {
                this.push(0.3333333333333333);
                this.apply(StackOp.C_REAL_POWER);
                break;
            }
            case C_EXP: {
                double d = this.pop();
                double d43 = this.pop();
                double d44 = Math.exp(d43);
                this.push(d44 * Math.cos(d), d44 * Math.sin(d));
                break;
            }
            case C_LOG: {
                double d = this.pop();
                double d45 = this.pop();
                this.push(0.5 * Math.log(d45 * d45 + d * d), Math.atan2(d, d45));
                break;
            }
            case C_LOG2: {
                this.apply(StackOp.C_LOG);
                this.push(Math.log(2.0), 0.0);
                this.apply(StackOp.C_DIVIDE);
                break;
            }
            case C_LOG10: {
                this.apply(StackOp.C_LOG);
                this.push(Math.log(10.0), 0.0);
                this.apply(StackOp.C_DIVIDE);
                break;
            }
            case ARG: {
                double d = this.pop();
                double d46 = this.pop();
                this.push(Math.atan2(d, d46));
                break;
            }
            case TRUNC: {
                this.push((int)this.pop());
                break;
            }
            case ROUND: {
                this.push((int)Math.round(this.pop()));
                break;
            }
            case CEILING: {
                this.push(Math.ceil(this.pop()));
                break;
            }
            case FLOOR: {
                this.push(Math.floor(this.pop()));
                break;
            }
            case SIGNUM: {
                this.push(Math.signum(this.pop()));
                break;
            }
            case SIN: {
                this.push(Math.sin(this.pop()));
                break;
            }
            case COS: {
                this.push(Math.cos(this.pop()));
                break;
            }
            case TAN: {
                this.push(Math.tan(this.pop()));
                break;
            }
            case SEC: {
                this.push(1.0 / Math.cos(this.pop()));
                break;
            }
            case COT: {
                double d = this.pop();
                this.push(Math.cos(d) / Math.sin(d));
                break;
            }
            case CSC: {
                this.push(1.0 / Math.sin(this.pop()));
                break;
            }
            case SINH: {
                this.push(Math.sinh(this.pop()));
                break;
            }
            case COSH: {
                this.push(Math.cosh(this.pop()));
                break;
            }
            case TANH: {
                this.push(Math.tanh(this.pop()));
                break;
            }
            case SECH: {
                this.push(1.0 / Math.cosh(this.pop()));
                break;
            }
            case COTH: {
                double d = this.pop();
                this.push(Math.cosh(d) / Math.sinh(d));
                break;
            }
            case CSCH: {
                this.push(1.0 / Math.sinh(this.pop()));
                break;
            }
            case ARCSIN: {
                this.push(Math.asin(this.pop()));
                break;
            }
            case ARCCOS: {
                this.push(Math.acos(this.pop()));
                break;
            }
            case ARCTAN: {
                this.push(Math.atan(this.pop()));
                break;
            }
            case ARCSINH: {
                double d = this.pop();
                this.push(Math.log(Math.sqrt(d * d + 1.0) + d));
                break;
            }
            case ARCCOSH: {
                double d = this.pop();
                this.push(d < 1.0 ? Double.NaN : Math.log(Math.sqrt(d * d - 1.0) + d));
                break;
            }
            case ARCTANH: {
                double d = this.pop();
                this.push(Math.abs(d) >= 1.0 ? Double.NaN : Math.log((1.0 + d) / (1.0 - d)) / 2.0);
                break;
            }
            case C_SIN: {
                double d = this.pop();
                double d47 = this.pop();
                double d48 = Math.exp(d);
                double d49 = 1.0 / d48;
                this.push((d49 + d48) * Math.sin(d47) / 2.0, (d48 - d49) * Math.cos(d47) / 2.0);
                break;
            }
            case C_COS: {
                double d = this.pop();
                double d50 = this.pop();
                double d51 = Math.exp(d);
                double d52 = 1.0 / d51;
                this.push((d52 + d51) * Math.cos(d50) / 2.0, (d52 - d51) * Math.sin(d50) / 2.0);
                break;
            }
            case C_TAN: {
                double d = this.pop();
                double d53 = this.pop();
                double d54 = Math.exp(d);
                double d55 = 1.0 / d54;
                double d56 = (d55 + d54) * Math.sin(d53) / 2.0;
                double d57 = (d54 - d55) * Math.cos(d53) / 2.0;
                double d58 = (d55 + d54) * Math.cos(d53) / 2.0;
                double d59 = (d55 - d54) * Math.sin(d53) / 2.0;
                double d60 = d58 * d58 + d59 * d59;
                this.push((d56 * d58 + d57 * d59) / d60, (d57 * d58 - d56 * d59) / d60);
                break;
            }
            case C_SEC: {
                double d = this.pop();
                double d61 = this.pop();
                double d62 = Math.exp(d);
                double d63 = 1.0 / d62;
                double d64 = (d63 + d62) * Math.cos(d61) / 2.0;
                double d65 = (d63 - d62) * Math.sin(d61) / 2.0;
                double d66 = d64 * d64 + d65 * d65;
                this.push(d64 / d66, -d65 / d66);
                break;
            }
            case C_COT: {
                double d = this.pop();
                double d67 = this.pop();
                double d68 = Math.exp(d);
                double d69 = 1.0 / d68;
                double d70 = (d69 + d68) * Math.cos(d67) / 2.0;
                double d71 = (d69 - d68) * Math.sin(d67) / 2.0;
                double d72 = (d69 + d68) * Math.sin(d67) / 2.0;
                double d73 = (d68 - d69) * Math.cos(d67) / 2.0;
                double d74 = d72 * d72 + d73 * d73;
                this.push((d70 * d72 + d71 * d73) / d74, (d71 * d72 - d70 * d73) / d74);
                break;
            }
            case C_CSC: {
                double d = this.pop();
                double d75 = this.pop();
                double d76 = Math.exp(d);
                double d77 = 1.0 / d76;
                double d78 = (d77 + d76) * Math.sin(d75) / 2.0;
                double d79 = (d76 - d77) * Math.cos(d75) / 2.0;
                double d80 = d78 * d78 + d79 * d79;
                this.push(d78 / d80, -d79 / d80);
                break;
            }
            case C_SINH: {
                double d = this.pop();
                double d81 = this.pop();
                double d82 = Math.exp(d81);
                double d83 = 1.0 / d82;
                this.push((d82 - d83) * Math.cos(d) / 2.0, (d83 + d82) * Math.sin(d) / 2.0);
                break;
            }
            case C_COSH: {
                double d = this.pop();
                double d84 = this.pop();
                double d85 = Math.exp(d84);
                double d86 = 1.0 / d85;
                this.push((d86 + d85) * Math.cos(d) / 2.0, (d85 - d86) * Math.sin(d) / 2.0);
                break;
            }
            case C_TANH: {
                double d = this.pop();
                double d87 = this.pop();
                double d88 = Math.exp(d87);
                double d89 = 1.0 / d88;
                double d90 = (d88 - d89) * Math.cos(d) / 2.0;
                double d91 = (d89 + d88) * Math.sin(d) / 2.0;
                double d92 = (d89 + d88) * Math.cos(d) / 2.0;
                double d93 = (d88 - d89) * Math.sin(d) / 2.0;
                double d94 = d92 * d92 + d93 * d93;
                this.push((d90 * d92 + d91 * d93) / d94, (d91 * d92 - d90 * d93) / d94);
                break;
            }
            case C_SECH: {
                double d = this.pop();
                double d95 = this.pop();
                double d96 = Math.exp(d95);
                double d97 = 1.0 / d96;
                double d98 = (d97 + d96) * Math.cos(d) / 2.0;
                double d99 = (d96 - d97) * Math.sin(d) / 2.0;
                double d100 = d98 * d98 + d99 * d99;
                this.push(d98 / d100, -d99 / d100);
                break;
            }
            case C_COTH: {
                double d = this.pop();
                double d101 = this.pop();
                double d102 = Math.exp(d101);
                double d103 = 1.0 / d102;
                double d104 = (d103 + d102) * Math.cos(d) / 2.0;
                double d105 = (d102 - d103) * Math.sin(d) / 2.0;
                double d106 = (d102 - d103) * Math.cos(d) / 2.0;
                double d107 = (d103 + d102) * Math.sin(d) / 2.0;
                double d108 = d106 * d106 + d107 * d107;
                this.push((d104 * d106 + d105 * d107) / d108, (d105 * d106 - d104 * d107) / d108);
                break;
            }
            case C_CSCH: {
                double d = this.pop();
                double d109 = this.pop();
                double d110 = Math.exp(d109);
                double d111 = 1.0 / d110;
                double d112 = (d110 - d111) * Math.cos(d) / 2.0;
                double d113 = (d111 + d110) * Math.sin(d) / 2.0;
                double d114 = d112 * d112 + d113 * d113;
                this.push(d112 / d114, -d113 / d114);
                break;
            }
            case C_ARCSIN: {
                double d = this.pop();
                double d115 = this.pop();
                this.push(-d, d115);
                this.push(1.0, 0.0);
                this.push(d115, d);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_MINUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                d = this.pop();
                d115 = this.pop();
                this.push(d, -d115);
                break;
            }
            case C_ARCCOS: {
                double d = this.pop();
                double d116 = this.pop();
                this.push(d116, d);
                this.push(1.0, 0.0);
                this.push(d116, d);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_MINUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                d = this.pop();
                d116 = this.pop();
                this.push(-d, d116);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                d = this.pop();
                d116 = this.pop();
                this.push(d, -d116);
                break;
            }
            case C_ARCTAN: {
                double d = this.pop();
                double d117 = this.pop();
                this.push(d117, d + 1.0);
                this.push(-d117, 1.0 - d);
                this.apply(StackOp.C_DIVIDE);
                this.apply(StackOp.C_LOG);
                d = this.pop();
                d117 = this.pop();
                this.push(-d / 2.0, d117 / 2.0);
                break;
            }
            case C_ARCSINH: {
                double d = this.pop();
                double d118 = this.pop();
                this.push(d118, d);
                this.push(d118, d);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.push(1.0, 0.0);
                this.apply(StackOp.C_PLUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                break;
            }
            case C_ARCCOSH: {
                double d = this.pop();
                double d119 = this.pop();
                this.push(d119, d);
                this.push(d119, d);
                this.push(2.0);
                this.apply(StackOp.C_REAL_POWER);
                this.push(1.0, 0.0);
                this.apply(StackOp.C_MINUS);
                this.push(0.5);
                this.apply(StackOp.C_REAL_POWER);
                this.apply(StackOp.C_PLUS);
                this.apply(StackOp.C_LOG);
                break;
            }
            case C_ARCTANH: {
                double d = this.pop();
                double d120 = this.pop();
                this.push(d120 + 1.0, d);
                this.push(1.0 - d120, -d);
                this.apply(StackOp.C_DIVIDE);
                this.apply(StackOp.C_LOG);
                d = this.pop();
                d120 = this.pop();
                this.push(d120 / 2.0, d / 2.0);
                break;
            }
            case CONJ: {
                double d = this.pop();
                this.push(-d);
            }
        }
    }
}

