/*
 * Decompiled with CFR 0.152.
 */
package vmm.functions;

import vmm.core.Complex;
import vmm.functions.EvalStack;
import vmm.functions.ProgFunction;
import vmm.functions.Type;

public class ComplexFunction {
    protected ProgFunction func;
    private String name;

    ComplexFunction(String string, ProgFunction progFunction) {
        assert (progFunction.getArgType() == Type.COMPLEX && progFunction.getType() == Type.COMPLEX);
        this.func = progFunction;
        this.name = string;
    }

    ProgFunction getProgFunction() {
        return this.func;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getArity() {
        return this.func.getArgCount();
    }

    public synchronized Complex value(Complex[] complexArray) {
        return this.value(complexArray, EvalStack.perThread());
    }

    public synchronized Complex value(double ... dArray) {
        return this.value(dArray, EvalStack.perThread());
    }

    public Complex value(Complex[] complexArray, EvalStack evalStack) {
        Complex complex = new Complex();
        this.value(complexArray, evalStack, complex);
        return complex;
    }

    public Complex value(double[] dArray, EvalStack evalStack) {
        Complex complex = new Complex();
        this.value(dArray, evalStack, complex);
        return complex;
    }

    public void value(Complex[] complexArray, EvalStack evalStack, Complex complex) {
        if (complex == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        int n = this.func.getArgCount();
        if (n == 0) {
            if (complexArray != null && complexArray.length > 0) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            this.func.apply(evalStack);
            evalStack.popComplex(complex);
        } else {
            if (complexArray == null || complexArray.length != n) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            for (Complex complex2 : complexArray) {
                evalStack.push(complex2);
            }
            this.func.apply(evalStack);
            evalStack.popComplex(complex);
        }
    }

    public void value(double[] dArray, EvalStack evalStack, Complex complex) {
        if (complex == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        int n = this.func.getArgCount();
        if (n == 0) {
            if (dArray != null && dArray.length > 0) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            this.func.apply(evalStack);
            evalStack.popComplex(complex);
        } else {
            if (dArray == null || dArray.length != 2 * n) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            for (double d : dArray) {
                evalStack.push(d);
            }
            this.func.apply(evalStack);
            evalStack.popComplex(complex);
        }
    }
}

