/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import java.awt.event.ActionEvent;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.fractals.RepeatedSegmentFractal;

public class Sierpinski
extends RepeatedSegmentFractal {
    Complex[] helpSierpinskiCurve;
    @VMMSave
    private boolean useInjectiveCurves = true;
    private ToggleAction segmentChoiceToggle;

    public Sierpinski() {
        this.fractality.reset(0.5, 0.3333333333333333, 0.5);
        this.fractality.setMaximumValueForInput(0.5);
        this.fractality.setMinimumValueForInput(0.3333333333333333);
        this.recursionLevel.reset(9);
        this.recursionLevel.setMaximumValueForInput(11);
        this.recursionLevel.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.0, 1.0, -0.75, 1.25);
        this.colorRepeatFactor = 2;
        this.fastDrawRecursionLevel = 6;
        this.segmentChoiceToggle = new ToggleAction(I18n.tr("vmm.fractals.Sierpinski.segmentchoice"), true){

            public void actionPerformed(ActionEvent actionEvent) {
                Sierpinski.this.setUseInjectiveCurves(this.getState());
            }
        };
    }

    public boolean getUseInjectiveCurve() {
        return this.useInjectiveCurves;
    }

    public void setUseInjectiveCurves(boolean bl) {
        if (this.useInjectiveCurves == bl) {
            return;
        }
        this.useInjectiveCurves = bl;
        this.segmentChoiceToggle.setState(bl);
        this.forceRedraw();
    }

    public ActionList getActionsForView(View view) {
        ActionList actionList = super.getActionsForView(view);
        actionList.add(null);
        actionList.add(this.segmentChoiceToggle);
        return actionList;
    }

    private boolean turnsLeft(Complex complex, Complex complex2, Complex complex3) {
        return -(complex2.im - complex.im) * (complex3.re - complex2.re) + (complex2.re - complex.re) * (complex3.im - complex2.im) > 0.0;
    }

    protected Complex[] computeNextLevel(Complex[] complexArray, int n) {
        Complex[] complexArray2;
        double d = this.fractality.getValue();
        double d2 = Math.sqrt(0.5 * d * (1.0 + 1.5 * d) - 0.25);
        Complex complex = new Complex((1.0 + d) / 2.0, -d2);
        Complex complex2 = new Complex((1.0 - d) / 2.0, d2);
        if (n == 0) {
            double d3 = 0.5;
            Complex complex3 = new Complex(-1.0, -1.0 / Math.sqrt(3.0));
            Complex complex4 = new Complex(1.0, -1.0 / Math.sqrt(3.0));
            Complex complex5 = new Complex(0.0, 2.0 / Math.sqrt(3.0));
            this.helpSierpinskiCurve = new Complex[7];
            this.helpSierpinskiCurve[0] = new Complex(complex3.realLinComb(d3, d3, complex4));
            this.helpSierpinskiCurve[1] = new Complex(complex4);
            this.helpSierpinskiCurve[2] = new Complex(complex4.realLinComb(d3, d3, complex5));
            this.helpSierpinskiCurve[3] = new Complex(complex5);
            this.helpSierpinskiCurve[4] = new Complex(complex5.realLinComb(d3, d3, complex3));
            this.helpSierpinskiCurve[5] = new Complex(complex3);
            this.helpSierpinskiCurve[6] = new Complex(complex3.realLinComb(d3, d3, complex4));
            complexArray2 = new Complex[]{new Complex(this.helpSierpinskiCurve[0]), new Complex(this.helpSierpinskiCurve[2]), new Complex(this.helpSierpinskiCurve[4]), new Complex(this.helpSierpinskiCurve[6])};
        } else {
            int n2;
            int n3 = this.helpSierpinskiCurve.length;
            complexArray2 = new Complex[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                complexArray2[n2] = this.helpSierpinskiCurve[n2];
            }
            this.helpSierpinskiCurve = new Complex[3 * this.helpSierpinskiCurve.length - 2];
            int n4 = 0;
            this.helpSierpinskiCurve[n4] = complexArray2[n4];
            for (n2 = 0; n2 < n3 - 1; n2 += 2) {
                boolean bl = this.turnsLeft(complexArray2[n2], complexArray2[n2 + 1], complexArray2[n2 + 2]);
                this.helpSierpinskiCurve[++n4] = d == 0.3333333333333333 ? new Complex(complexArray2[n2].realLinComb((1.0 + d) / 2.0, (1.0 - d) / 2.0, complexArray2[n2 + 1])) : (bl ? new Complex(complexArray2[n2].complexLinComb(complex, complex2, complexArray2[n2 + 1])) : new Complex(complexArray2[n2].complexLinComb(complex.conj(), complex2.conj(), complexArray2[n2 + 1])));
                this.helpSierpinskiCurve[++n4] = new Complex(complexArray2[n2].realLinComb(d, 1.0 - d, complexArray2[n2 + 1]));
                this.helpSierpinskiCurve[++n4] = new Complex(complexArray2[n2 + 1]);
                this.helpSierpinskiCurve[++n4] = new Complex(complexArray2[n2 + 1].realLinComb(1.0 - d, d, complexArray2[n2 + 2]));
                this.helpSierpinskiCurve[++n4] = d == 0.3333333333333333 ? new Complex(complexArray2[n2 + 1].realLinComb((1.0 - d) / 2.0, (1.0 + d) / 2.0, complexArray2[n2 + 2])) : (bl ? new Complex(complexArray2[n2 + 1].complexLinComb(complex2.conj(), complex.conj(), complexArray2[n2 + 2])) : new Complex(complexArray2[n2 + 1].complexLinComb(complex2, complex, complexArray2[n2 + 2])));
                this.helpSierpinskiCurve[++n4] = new Complex(complexArray2[n2 + 2]);
            }
            complexArray2 = new Complex[(this.helpSierpinskiCurve.length + 1) / 2];
            for (n2 = 0; n2 < complexArray2.length; ++n2) {
                complexArray2[n2] = this.helpSierpinskiCurve[2 * n2];
            }
        }
        if (!this.getUseInjectiveCurve()) {
            return this.helpSierpinskiCurve;
        }
        return complexArray2;
    }
}

