/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import java.awt.Color;
import java.awt.Graphics2D;
import vmm.core.Animation;
import vmm.core.Complex;
import vmm.core.Exhibit;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.View;

public abstract class RepeatedSegmentFractal
extends Exhibit {
    private Complex[] curvePoints;
    private int computedLevel = 0;
    protected int colorRepeatFactor = 3;
    protected int fastDrawRecursionLevel = 5;
    protected RealParamAnimateable fractality = new RealParamAnimateable("vmm.fractals.RepeatedSegmentFractal.fractality", 0.3333333333333333, 0.25, 0.5);
    protected IntegerParam recursionLevel = new IntegerParam("vmm.fractals.RepeatedSegmentFractal.recurseLvl", 6);

    protected abstract Complex[] computeNextLevel(Complex[] var1, int var2);

    public RepeatedSegmentFractal() {
        this.setDefaultBackground(Color.BLACK);
        this.addParameter(this.fractality);
        this.fractality.setMaximumValueForInput(0.5);
        this.fractality.setMinimumValueForInput(0.25);
        this.addParameter(this.recursionLevel);
        this.recursionLevel.setMaximumValueForInput(10);
        this.recursionLevel.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.0, 1.0, -1.0, 1.0);
        this.setUseFilmstripForMorphing(true);
        this.setFramesForMorphing(25);
    }

    protected void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
        RSFView rSFView = (RSFView)view;
        int n = rSFView.desiredLevel == -1 ? this.recursionLevel.getValue() : rSFView.desiredLevel;
        if (rSFView.getFastDrawing()) {
            n = Math.min(n, this.fastDrawRecursionLevel);
        }
        if (bl || n < this.computedLevel) {
            this.computedLevel = 0;
        }
        while (this.computedLevel < n) {
            this.curvePoints = this.computeNextLevel(this.curvePoints, this.computedLevel);
            ++this.computedLevel;
        }
    }

    protected void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        for (int i = 0; i < this.curvePoints.length - 1; ++i) {
            graphics2D.setColor(Color.getHSBColor((float)this.colorRepeatFactor * (float)i / (float)this.curvePoints.length, 1.0f, 1.0f));
            view.drawLine(this.curvePoints[i].re, this.curvePoints[i].im, this.curvePoints[i + 1].re, this.curvePoints[i + 1].im);
        }
    }

    public Animation getCreateAnimation(View view) {
        final RSFView rSFView = (RSFView)view;
        return new TimerAnimation(this.recursionLevel.getValue() - 1, 400){

            protected void animationStarting() {
                rSFView.desiredLevel = 1;
            }

            protected void animationEnding() {
                rSFView.desiredLevel = -1;
                rSFView.forceRedraw();
            }

            protected void drawFrame() {
                rSFView.desiredLevel = this.frameNumber + 1;
                rSFView.forceRedraw();
            }
        };
    }

    public View getDefaultView() {
        return new RSFView();
    }

    public class RSFView
    extends View {
        private int desiredLevel = -1;
    }
}

