/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.BasicMouseTask2D;
import vmm.core.Complex;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.MouseTask;
import vmm.core.Parameter;
import vmm.core.RealParam;
import vmm.core.TaskManager;
import vmm.core.Transform;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;

public class Mandelbrot
extends Exhibit {
    private JuliaSetAndOrbitDecoration juliaAndOrbitDecoration;
    private IntegerParam pointsOnOrbit = new IntegerParam("vmm.fractals.Mandelbrot.PointsOnOrbit", 100);
    private RealParam juliaPointX = new RealParam("vmm.fractals.Mandelbrot.juliaPointX", 0.25);
    private RealParam juliaPointY = new RealParam("vmm.fractals.Mandelbrot.juliaPointY", 0.45);
    private TaskManager taskManager;
    private double[][] exampleData = new double[][]{{-0.7241608526756182, -0.7241608526694334, 0.36158285101080495, 0.3615828510154436, 1000.0, 250.0}, {-1.9072326638218555, -1.9072326346322426, -1.0859414558092964E-8, 1.103279515362283E-8, 500.0, 100.0}, {0.35471345463684467, 0.35473822122425647, 0.095401040922098, 0.09541961586265685, 4000.0, 2500.0}, {0.2726031397857463, 0.2726031483804942, 0.0053565210436868176, 0.005356527489747753, 7500.0, 2500.0}, {0.28601560167064516, 0.2860156017191516, 0.011537485975923616, 0.011537486012303432, 3000.0, 250.0}, {-1.6744096756044493, -1.6744096717769306, 4.716419197284976E-5, 4.7167062611931696E-5, 7500.0, 1000.0}, {0.25989953593561266, 0.259899641345385, 0.001612579325834812, 0.0016126583831640785, 2000.0, 250.0}, {-1.674409674093473, -1.6744096740931858, 4.716540768697223E-5, 4.716540790246652E-5, 10000.0, 250.0}, {-1.4035289973308978, -1.4035289973294278, 0.02930868838864931, 0.029308688389751928, 2500.0, 500.0}, {-1.9072311984370052, -1.9072311928858665, 1.5197004423572747E-5, 1.5201167777464862E-5, 7500.0, 250.0}, {-0.753231765876289, -0.7532317565038811, 0.04633550302364065, 0.046335510285468194, 10000.0, 250.0}, {-1.9963806954442953, -1.996380695443582, 2.62870483517615E-7, 2.628710361171417E-7, 1500.0, 250.0}, {0.29768460024540017, 0.297684633418743, 0.020961285679467805, 0.020961312432163624, 5000.0, 1000.0}};

    public Mandelbrot() {
        this.addParameter(this.juliaPointY);
        this.addParameter(this.juliaPointX);
        this.addParameter(this.pointsOnOrbit);
        this.pointsOnOrbit.setMinimumValueForInput(1);
        this.pointsOnOrbit.setMaximumValueForInput(1000);
        this.juliaPointX.setMinimumValueForInput(-4.0);
        this.juliaPointX.setMaximumValueForInput(3.0);
        this.juliaPointY.setMinimumValueForInput(-3.0);
        this.juliaPointY.setMaximumValueForInput(3.0);
        this.juliaAndOrbitDecoration = new JuliaSetAndOrbitDecoration();
        this.juliaAndOrbitDecoration.setStartPoint(new Point2D.Double(this.juliaPointX.getValue(), this.juliaPointY.getValue()));
        this.addDecoration(this.juliaAndOrbitDecoration);
        this.setDefaultWindow(-2.25, 0.85, -1.25, 1.25);
    }

    public void removeView(View view) {
        super.removeView(view);
        if (this.taskManager != null && (this.getViews() == null || this.getViews().size() == 0)) {
            this.taskManager.shutDown();
            this.taskManager = null;
        }
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.juliaAndOrbitDecoration.setStartPoint(new Point2D.Double(this.juliaPointX.getValue(), this.juliaPointY.getValue()));
    }

    private void drawMandelbrot(View view, Transform transform) {
        int n = transform.getHeight();
        MandelbrotView mandelbrotView = (MandelbrotView)view;
        mandelbrotView.cancelAsyncComputeJob();
        if (view.getFastDrawing()) {
            int n2 = mandelbrotView.maxCount.getValue();
            int n3 = mandelbrotView.paletteLength.getValue();
            int n4 = transform.getWidth();
            Point2D.Double double_ = new Point2D.Double();
            int n5 = 10;
            if (n2 <= 50) {
                n5 = 3;
            } else if (n2 <= 500) {
                n5 = 6;
            }
            for (int i = n5; i < n + n5; i += n5 * 2) {
                for (int j = n5; j < n4 + n5; j += n5 * 2) {
                    Color color;
                    ((Point2D)double_).setLocation(j, i);
                    transform.viewportToWindow(double_);
                    double d = ((Point2D)double_).getX();
                    double d2 = ((Point2D)double_).getY();
                    int n6 = this.iterate(d, d2, n2);
                    if (n6 == n2) {
                        color = Color.BLACK;
                    } else {
                        float f = n3 > 0 ? (float)(n6 % n3) / (float)n3 : (float)n6 / (float)n2;
                        color = Color.getHSBColor(f, 1.0f, 1.0f);
                    }
                    mandelbrotView.setColor(color);
                    mandelbrotView.fillRectDirect(j - n5, i - n5, n5 * 2, n5 * 2);
                }
            }
        } else {
            view.getDisplay().setCursor(Cursor.getPredefinedCursor(3));
            if (this.taskManager == null) {
                this.taskManager = new TaskManager();
            }
            mandelbrotView.fillCanvasWithGray();
            TaskManager.Job job = this.taskManager.createJob();
            int n7 = ++mandelbrotView.asyncJobNum;
            for (int i = 0; i < n; ++i) {
                job.add(new ComputeRow(i, mandelbrotView, n7));
            }
            job.close();
            if (!job.await(500)) {
                mandelbrotView.startAsyncComputeJob(job);
            } else {
                view.getDisplay().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int iterate(double d, double d2, int n) {
        int n2;
        double d3 = d;
        double d4 = d2;
        for (n2 = 0; n2 < n && d3 * d3 + d4 * d4 <= 4.0; ++n2) {
            double d5 = d3 * d3 - d4 * d4 + d;
            d4 = 2.0 * d3 * d4 + d2;
            d3 = d5;
        }
        return n2;
    }

    public ActionList getActionsForView(final View view) {
        ActionList actionList = super.getActionsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.DragToShowCoords")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().installOneShotMouseTask(new ShowCoordsMouseTask());
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.RecenterOnPointMenuItem") + "..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Mandelbrot.this.doCenterOnUserPoint(view);
            }
        });
        ActionList actionList2 = new ActionList(I18n.tr("vmm.fractals.Mandelbrot.ZoomIn"));
        for (int i = 2; i <= 32; i *= 2) {
            final double d = i;
            actionList2.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.ZoomIn") + " " + i + "X"){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((MandelbrotView)view).doZoom(d);
                }
            });
        }
        actionList.add(actionList2);
        ActionList actionList3 = new ActionList(I18n.tr("vmm.fractals.Mandelbrot.ZoomOut"));
        for (int i = 2; i <= 32; i *= 2) {
            final double d = 1.0 / (double)i;
            actionList3.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.ZoomOut") + " " + i + "X"){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((MandelbrotView)view).doZoom(d);
                }
            });
        }
        actionList.add(actionList3);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.RestoreDefaults")){

            public void actionPerformed(ActionEvent actionEvent) {
                MandelbrotView mandelbrotView = (MandelbrotView)view;
                mandelbrotView.maxCount.setValue(mandelbrotView.maxCount.getDefaultValue());
                mandelbrotView.paletteLength.setValue(mandelbrotView.paletteLength.getDefaultValue());
                mandelbrotView.setWindow(Mandelbrot.this.getDefaultWindow());
                mandelbrotView.setShowJuliaAndOrbit(3);
            }
        });
        ActionList actionList4 = new ActionList(I18n.tr("vmm.fractals.Mandelbrot.Examples"));
        for (int i = 0; i < this.exampleData.length; ++i) {
            final int n = i;
            actionList4.add(new AbstractActionVMM("  " + (i + 1) + "  "){

                public void actionPerformed(ActionEvent actionEvent) {
                    double[] dArray = Mandelbrot.this.exampleData[n];
                    MandelbrotView mandelbrotView = (MandelbrotView)view;
                    mandelbrotView.setWindow(dArray[0], dArray[1], dArray[2], dArray[3]);
                    mandelbrotView.maxCount.setValue((int)dArray[4]);
                    mandelbrotView.paletteLength.setValue((int)dArray[5]);
                    mandelbrotView.setShowJuliaAndOrbit(3);
                }
            });
        }
        actionList.add(actionList4);
        actionList.add(null);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.fractals.Mandelbrot.MoveJuliaPoint")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().installOneShotMouseTask(new MoveJuliaStartByMouseClick());
            }
        });
        return actionList;
    }

    private void doCenterOnUserPoint(View view) {
        Point2D point2D = Util.getPoint2DFromUser(view.getDisplay(), I18n.tr("vmm.fractals.Mandelbrot.RecenterOnPointPrompt"));
        if (point2D == null) {
            return;
        }
        Transform transform = view.getTransform();
        double d = (transform.getXmax() + transform.getXmin()) / 2.0;
        double d2 = (transform.getYmax() + transform.getYmin()) / 2.0;
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        double d5 = d3 - d;
        double d6 = d4 - d2;
        if (d5 == 0.0 && d6 == 0.0) {
            return;
        }
        transform.setLimits(transform.getXmin() + d5, transform.getXmax() + d5, transform.getYmin() + d6, transform.getYmax() + d6);
    }

    public View getDefaultView() {
        return new MandelbrotView();
    }

    private class JuliaSetAndOrbitDecoration
    extends Decoration {
        Complex[] juliaStart = new Complex[1024];
        Complex[] juliaAux = new Complex[1024];
        Complex firstFixedPoint;
        Complex secondFixedPoint;
        int currentJuliaLength = 0;
        double cx;
        double cy;

        private JuliaSetAndOrbitDecoration() {
        }

        public void setStartPoint(Point2D point2D) {
            this.cx = point2D.getX();
            this.cy = point2D.getY();
            this.forceRedraw();
        }

        private void computeFixedPoints() {
            Complex complex = new Complex(0.25 - this.cx, -this.cy);
            complex = complex.power(0.5);
            this.firstFixedPoint = complex.plus(0.5);
            this.secondFixedPoint = complex.times(-1.0).plus(0.5);
            if (this.firstFixedPoint.r() < this.secondFixedPoint.r()) {
                complex = this.secondFixedPoint;
                this.secondFixedPoint = this.firstFixedPoint;
                this.firstFixedPoint = complex;
            }
        }

        private void makeJuliaStart() {
            Complex complex = new Complex(this.cx, this.cy);
            this.computeFixedPoints();
            this.juliaStart[0] = this.firstFixedPoint;
            this.juliaStart[2] = this.firstFixedPoint.times(-1.0);
            Complex complex2 = this.juliaStart[2].minus(complex).power(0.5);
            if (complex2.re * this.juliaStart[0].im - complex2.im * this.juliaStart[0].re < 0.0) {
                complex2 = complex2.times(-1.0);
            }
            this.juliaStart[1] = complex2;
            this.juliaStart[3] = complex2.times(-1.0);
            this.currentJuliaLength = 4;
            for (int i = 1; i < 9; ++i) {
                int n;
                this.juliaAux[0] = this.juliaStart[0];
                this.juliaAux[0 + this.currentJuliaLength] = this.juliaStart[0].times(-1.0);
                for (n = 1; n < this.currentJuliaLength; ++n) {
                    this.juliaAux[n] = this.juliaStart[n].minus(complex).squareRootNearer(this.juliaAux[n - 1]);
                    this.juliaAux[n + this.currentJuliaLength] = this.juliaAux[n].times(-1.0);
                }
                this.currentJuliaLength = 2 * this.currentJuliaLength;
                for (n = 1; n < this.currentJuliaLength; ++n) {
                    this.juliaStart[n] = this.juliaAux[n];
                }
            }
        }

        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            int n;
            int n2;
            int n3;
            MandelbrotView mandelbrotView = (MandelbrotView)view;
            if (mandelbrotView.getShowJuliaAndOrbit() == 3) {
                return;
            }
            Color color = graphics2D.getColor();
            double d = this.cx;
            double d2 = this.cy;
            Point2D.Double double_ = new Point2D.Double();
            ((Point2D)double_).setLocation(this.cx, this.cy);
            transform.windowToViewport(double_);
            int n4 = (int)(((Point2D)double_).getX() + 0.499);
            int n5 = (int)(((Point2D)double_).getY() + 0.499);
            graphics2D.setColor(Color.WHITE);
            if (mandelbrotView.getShowJuliaAndOrbit() == 0 || mandelbrotView.getShowJuliaAndOrbit() == 2) {
                this.makeJuliaStart();
                for (n3 = 0; n3 < this.currentJuliaLength; ++n3) {
                    d = this.juliaStart[n3].re;
                    d2 = this.juliaStart[n3].im;
                    ((Point2D)double_).setLocation(d, d2);
                    transform.windowToViewport(double_);
                    n2 = (int)(((Point2D)double_).getX() + 0.499);
                    n = (int)(((Point2D)double_).getY() + 0.499);
                    mandelbrotView.drawLineDirect(n2 - 1, n, n2 + 1, n);
                    mandelbrotView.drawLineDirect(n2, n - 1, n2, n + 1);
                }
            }
            n3 = n4 - 7;
            n2 = n4 + 7;
            n = n5 - 7;
            int n6 = n5 + 7;
            graphics2D.setColor(Color.BLACK);
            mandelbrotView.drawLineDirect(n4 - 2, n, n4 - 2, n6);
            mandelbrotView.drawLineDirect(n4 + 1, n, n4 + 1, n6);
            mandelbrotView.drawLineDirect(n3, n5 - 2, n2, n5 - 2);
            mandelbrotView.drawLineDirect(n3, n5 + 1, n2, n5 + 1);
            if (mandelbrotView.getShowJuliaAndOrbit() == 1 || mandelbrotView.getShowJuliaAndOrbit() == 2) {
                d = this.cx;
                d2 = this.cy;
                int n7 = Mandelbrot.this.pointsOnOrbit.getValue();
                for (int i = 0; i < n7; ++i) {
                    ((Point2D)double_).setLocation(d, d2);
                    transform.windowToViewport(double_);
                    int n8 = (int)((Point2D)double_).getX();
                    int n9 = (int)((Point2D)double_).getY();
                    mandelbrotView.fillOvalDirect(Color.getHSBColor((float)(0.75 * (double)(n7 - i)) / (float)n7, 0.6f, 1.0f), n8 - 3, n9 - 3, 5, 5);
                    mandelbrotView.drawOvalDirect(Color.GRAY, n8 - 3, n9 - 3, 6, 6);
                    double d3 = d * d - d2 * d2 + this.cx;
                    d2 = 2.0 * d * d2 + this.cy;
                    d = d3;
                }
            }
            graphics2D.setColor(Color.WHITE);
            mandelbrotView.drawLineDirect(n4 - 1, n, n4 - 1, n6);
            mandelbrotView.drawLineDirect(n4, n, n4, n6);
            mandelbrotView.drawLineDirect(n3, n5 - 1, n2, n5 - 1);
            mandelbrotView.drawLineDirect(n3, n5, n2, n5);
            graphics2D.setColor(color);
        }
    }

    private class MoveJuliaStartByMouseClick
    extends MouseTask {
        private MoveJuliaStartByMouseClick() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            Point2D.Double double_ = new Point2D.Double(mouseEvent.getX(), mouseEvent.getY());
            view.getTransform().viewportToWindow(double_);
            Mandelbrot.this.juliaPointX.setValue(((Point2D)double_).getX());
            Mandelbrot.this.juliaPointY.setValue(((Point2D)double_).getY());
            if (((MandelbrotView)view).getShowJuliaAndOrbit() == 3) {
                ((MandelbrotView)view).setShowJuliaAndOrbit(2);
            }
            return false;
        }

        public Cursor getCursor(Display display, View view) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private class DragJuliaStartMouseTask
    extends BasicMouseTask2D {
        boolean draggingStartPoint;
        int offsetX;
        int offsetY;

        private DragJuliaStartMouseTask() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            this.draggingStartPoint = false;
            if (((MandelbrotView)view).getShowJuliaAndOrbit() == 3) {
                return super.doMouseDown(mouseEvent, display, view, n, n2);
            }
            Point2D.Double double_ = new Point2D.Double(Mandelbrot.this.juliaPointX.getValue(), Mandelbrot.this.juliaPointY.getValue());
            view.getTransform().windowToViewport(double_);
            this.offsetX = (int)((Point2D)double_).getX() - mouseEvent.getX();
            this.offsetY = (int)((Point2D)double_).getY() - mouseEvent.getY();
            if (Math.abs(this.offsetX) <= 7 && Math.abs(this.offsetY) <= 7) {
                this.draggingStartPoint = true;
                return true;
            }
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (!this.draggingStartPoint) {
                super.doMouseDrag(mouseEvent, display, view, n, n2);
                return;
            }
            Point2D.Double double_ = new Point2D.Double(mouseEvent.getX() + this.offsetX, mouseEvent.getY() + this.offsetY);
            view.getTransform().viewportToWindow(double_);
            Mandelbrot.this.juliaPointX.setValue(((Point2D)double_).getX());
            Mandelbrot.this.juliaPointY.setValue(((Point2D)double_).getY());
            display.setStatusText("(cx,cy) = " + ((MandelbrotView)view).getCoordString(mouseEvent.getX(), mouseEvent.getY()));
        }

        public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (!this.draggingStartPoint) {
                super.doMouseUp(mouseEvent, display, view, n, n2);
            } else {
                display.setStatusText(null);
            }
        }

        public void drawWhileDragging(Graphics2D graphics2D, Display display, View view, int n, int n2) {
            if (!this.draggingStartPoint) {
                super.drawWhileDragging(graphics2D, display, view, n, n2);
            }
        }

        public Cursor getCursorForDragging(MouseEvent mouseEvent, Display display, View view) {
            if (this.draggingStartPoint) {
                return Cursor.getDefaultCursor();
            }
            return super.getCursorForDragging(mouseEvent, display, view);
        }
    }

    private class ShowCoordsMouseTask
    extends MouseTask {
        private ShowCoordsMouseTask() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            display.setStatusText("(x,y) = " + ((MandelbrotView)view).getCoordString(mouseEvent.getX(), mouseEvent.getY()));
            return true;
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            display.setStatusText("(x,y) = " + ((MandelbrotView)view).getCoordString(mouseEvent.getX(), mouseEvent.getY()));
        }

        public Cursor getCursor(Display display, View view) {
            return Cursor.getPredefinedCursor(1);
        }

        public String getStatusText() {
            return I18n.tr("vmm.fractals.Mandelbrot.DragToShowCoordsStatusText");
        }
    }

    public class MandelbrotView
    extends View {
        public static final int SHOW_JULIA = 0;
        public static final int SHOW_ORBIT = 1;
        public static final int SHOW_BOTH = 2;
        public static final int SHOW_NONE = 3;
        @VMMSave
        private int showJuliaAndOrbit = 3;
        private ActionRadioGroup showJuliaAndOrbitSelect;
        private Transform previousTransform = null;
        private boolean bitmapNeedsRedraw = true;
        private volatile int asyncJobNum;
        private volatile Thread asyncComputeThread;
        private volatile TaskManager.Job asyncComputeJob;
        private IntegerParam maxCount = new IntegerParam("vmm.fractals.Mandelbrot.MaxIters", 50);
        private IntegerParam paletteLength = new IntegerParam("vmm.fractals.Mandelbrot.PaletteLength", 0);

        public MandelbrotView() {
            this.addParameter(this.paletteLength);
            this.addParameter(this.maxCount);
            this.maxCount.setMinimumValueForInput(10);
            this.maxCount.setMaximumValueForInput(100000);
            this.paletteLength.setMinimumValueForInput(0);
            this.paletteLength.setMaximumValueForInput(100000);
            this.showJuliaAndOrbitSelect = new ActionRadioGroup(){

                public void optionSelected(int n) {
                    MandelbrotView.this.setShowJuliaAndOrbit(n);
                }
            };
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.julia"));
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.orbit"));
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.both"));
            this.showJuliaAndOrbitSelect.addItem(I18n.tr("vmm.fractals.Mandelbrot.showJuliaAndOrbit.none"));
            this.showJuliaAndOrbitSelect.setSelectedIndex(this.showJuliaAndOrbit);
            this.backgroundCommands.setEnabled(false);
        }

        public void doZoom(double d) {
            double[] dArray = this.getRequestedWindow();
            double d2 = dArray[1] - dArray[0];
            double d3 = dArray[3] - dArray[2];
            double d4 = dArray[0] + d2 / 2.0;
            double d5 = dArray[2] + d3 / 2.0;
            double d6 = d2 / d;
            double d7 = d3 / d;
            this.setWindow(d4 - d6 / 2.0, d4 + d6 / 2.0, d5 - d7 / 2.0, d5 + d7 / 2.0);
        }

        String getCoordString(int n, int n2) {
            double d;
            double[] dArray = this.getWindow();
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = dArray[2];
            double d5 = dArray[3];
            double d6 = this.getTransform().getWidth();
            double d7 = this.getTransform().getHeight();
            double d8 = d2 + (double)n / d6 * (d3 - d2);
            double d9 = d5 - (double)n2 / d7 * (d5 - d4);
            int n3 = 4;
            if (d > 0.0) {
                for (d = d3 - d2; d < 1.0; d *= 10.0) {
                    ++n3;
                }
            }
            String string = String.format("%1." + n3 + "f", d8);
            String string2 = String.format("%1." + n3 + "f", d9);
            return "(" + string + ", " + string2 + ")";
        }

        public int getShowJuliaAndOrbit() {
            return this.showJuliaAndOrbit;
        }

        public void setShowJuliaAndOrbit(int n) {
            if (this.showJuliaAndOrbit == n) {
                return;
            }
            this.showJuliaAndOrbit = n;
            this.showJuliaAndOrbitSelect.setSelectedIndex(n);
            if (this.getDisplay() != null) {
                this.getDisplay().setStatusText();
            }
            this.forceRedraw();
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(this.showJuliaAndOrbitSelect);
            return actionList;
        }

        public String getStatusText() {
            if (this.showJuliaAndOrbit == 3) {
                if (!Util.isMacOS()) {
                    return I18n.tr("vmm.fractals.Mandelbrot.statusText.DragToZoom");
                }
                return I18n.tr("vmm.fractals.Mandelbrot.statusText.DragToZoomMac");
            }
            return I18n.tr("vmm.fractals.Mandelbrot.statusText.dragCross");
        }

        public void setFastDrawing(boolean bl, boolean bl2) {
            super.setFastDrawing(bl, bl2);
            this.bitmapNeedsRedraw = true;
            this.forceRedraw();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            super.stateChanged(changeEvent);
            if (changeEvent.getSource() instanceof Transform) {
                this.bitmapNeedsRedraw = true;
            }
        }

        public void parameterChanged(Parameter parameter, Object object, Object object2) {
            super.parameterChanged(parameter, object, object2);
            if (parameter == this.maxCount || parameter == this.paletteLength) {
                this.bitmapNeedsRedraw = true;
            }
        }

        public void drawOvalDirect(Color color, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = this.getTransform().getUntransformedGraphics();
            graphics2D.setColor(color);
            graphics2D.drawOval(n, n2, n3, n4);
        }

        public void fillOvalDirect(Color color, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = this.getTransform().getUntransformedGraphics();
            graphics2D.setColor(color);
            graphics2D.fillOval(n, n2, n3, n4);
        }

        public void render(Graphics2D graphics2D, int n, int n2) {
            int n3;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            this.getTransform().setUpDrawInfo(graphics2D, 0, 0, n, n2, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
            if (this.fullOSI == null || this.getTransform().getWidth() != this.fullOSI.getWidth() || this.getTransform().getHeight() != this.fullOSI.getHeight()) {
                this.bitmapNeedsRedraw = true;
                try {
                    this.createOSI(n, n2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    graphics2D2.setColor(Color.WHITE);
                    graphics2D2.fillRect(0, 0, n, n2);
                    graphics2D2.setColor(Color.RED);
                    graphics2D2.drawString(I18n.tr("vmm.core.OutOfMemoryError"), 20, 35);
                    return;
                }
            }
            this.prepareOSIForDrawing();
            if (this.bitmapNeedsRedraw) {
                Mandelbrot.this.drawMandelbrot(this, this.getTransform());
            }
            this.bitmapNeedsRedraw = false;
            graphics2D2.drawImage((Image)this.fullOSI, 0, 0, null);
            graphics2D.setColor(this.getForeground());
            graphics2D.setBackground(this.getBackground());
            if (this.getAntialiased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.getTransform().setUpDrawInfo(graphics2D2, 0, 0, n, n2, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
            this.currentGraphics = graphics2D2;
            Decoration[] decorationArray = this.getDecorations();
            for (n3 = 0; n3 < decorationArray.length; ++n3) {
                decorationArray[n3].computeDrawData(this, Mandelbrot.this.exhibitNeedsRedraw, this.previousTransform, this.getTransform());
                decorationArray[n3].doDraw(graphics2D2, this, this.getTransform());
            }
            decorationArray = Mandelbrot.this.getDecorations();
            for (n3 = 0; n3 < decorationArray.length; ++n3) {
                decorationArray[n3].computeDrawData(this, Mandelbrot.this.exhibitNeedsRedraw, this.previousTransform, this.getTransform());
                decorationArray[n3].doDraw(graphics2D2, this, this.getTransform());
            }
            this.getTransform().finishDrawing();
            this.needsRedraw = false;
        }

        public BufferedImage getImage(boolean bl) {
            if (this.getDisplay() == null || this.getExhibit() == null || this.fullOSI == null) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(this.fullOSI.getWidth(), this.fullOSI.getHeight(), this.offscreenImageType);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.render(graphics2D, this.fullOSI.getWidth(), this.fullOSI.getHeight());
            graphics2D.dispose();
            return bufferedImage;
        }

        public void takeExhibit(View view, boolean bl) {
            super.takeExhibit(view, bl);
            if (bl && view instanceof MandelbrotView) {
                this.maxCount.setValue(((MandelbrotView)view).maxCount.getValue());
                this.paletteLength.setValue(((MandelbrotView)view).paletteLength.getValue());
            }
        }

        public MouseTask getDefaultMouseTask() {
            return new DragJuliaStartMouseTask();
        }

        private void fillCanvasWithGray() {
            Graphics graphics = this.fullOSI.getGraphics();
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(0, 0, this.fullOSI.getWidth(), this.fullOSI.getHeight());
            graphics.dispose();
        }

        private synchronized void pixelRow(int[] nArray, int n) {
            this.fullOSI.setRGB(0, n, this.fullOSI.getWidth(), 1, nArray, 0, this.fullOSI.getWidth());
        }

        private synchronized void startAsyncComputeJob(TaskManager.Job job) {
            this.asyncComputeJob = job;
            this.asyncComputeThread = new Thread(){
                TaskManager.Job myJob;
                {
                    this.myJob = MandelbrotView.this.asyncComputeJob;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!this.myJob.await(1000)) {
                        this.doRepaint();
                    }
                    MandelbrotView mandelbrotView = MandelbrotView.this;
                    synchronized (mandelbrotView) {
                        if (this.myJob == MandelbrotView.this.asyncComputeJob && !this.myJob.isCanceled()) {
                            this.doRepaint();
                            if (MandelbrotView.this.getDisplay() != null) {
                                MandelbrotView.this.getDisplay().setCursor(Cursor.getDefaultCursor());
                            }
                        }
                        if (this.myJob == MandelbrotView.this.asyncComputeJob) {
                            MandelbrotView.this.asyncComputeJob = null;
                            MandelbrotView.this.asyncComputeThread = null;
                        }
                    }
                }

                synchronized void doRepaint() {
                    if (MandelbrotView.this.getDisplay() != null) {
                        MandelbrotView.this.getDisplay().repaint();
                        try {
                            this.wait(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.asyncComputeThread.start();
        }

        private synchronized void cancelAsyncComputeJob() {
            if (this.asyncComputeJob != null) {
                this.asyncComputeJob.cancel();
                this.asyncComputeJob = null;
                this.asyncComputeThread = null;
                if (this.getDisplay() != null) {
                    this.getDisplay().setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ComputeRow
    implements Runnable {
        int jobNum;
        int row;
        MandelbrotView view;
        Transform transform;
        int max;
        int paletteLength;

        ComputeRow(int n, MandelbrotView mandelbrotView, int n2) {
            this.row = n;
            this.view = mandelbrotView;
            this.jobNum = n2;
            this.transform = (Transform)mandelbrotView.getTransform().clone();
            this.max = mandelbrotView.maxCount.getValue();
            this.paletteLength = mandelbrotView.paletteLength.getValue();
        }

        public void run() {
            Point2D.Double double_ = new Point2D.Double();
            int n = this.transform.getWidth();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                ((Point2D)double_).setLocation(i, this.row);
                this.transform.viewportToWindow(double_);
                double d = ((Point2D)double_).getX();
                double d2 = ((Point2D)double_).getY();
                int n2 = Mandelbrot.this.iterate(d, d2, this.max);
                if (n2 == this.max) {
                    nArray[i] = 0;
                    continue;
                }
                float f = this.paletteLength > 0 ? (float)(n2 % this.paletteLength) / (float)this.paletteLength : (float)n2 / (float)this.max;
                nArray[i] = Color.HSBtoRGB(f, 1.0f, 1.0f);
            }
            if (this.jobNum == this.view.asyncJobNum) {
                this.view.pixelRow(nArray, this.row);
            }
        }
    }
}

