/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.core.Complex;
import vmm.fractals.RepeatedSegmentFractal;

public class KochEscher
extends RepeatedSegmentFractal {
    public KochEscher() {
        this.setDefaultWindow(-2.2, 1.2, -0.4, 2.1);
        this.fractality.reset(0.25, 0.0, 0.3333333333333333);
        this.fractality.setMaximumValueForInput(0.3333333333333333);
        this.fractality.setMinimumValueForInput(0.0);
        this.recursionLevel.reset(9);
        this.colorRepeatFactor = 20;
    }

    protected Complex[] computeNextLevel(Complex[] complexArray, int n) {
        Complex[] complexArray2;
        double d = Math.sqrt(3.0);
        if (n == 0) {
            complexArray2 = new Complex[]{new Complex(0.5, d / 2.0), new Complex(0.0, 0.0), new Complex(1.0, 0.0), new Complex(0.5, d / 2.0), new Complex(0.0, d), new Complex(1.0, d), new Complex(0.5, d / 2.0), new Complex(-0.5, d / 2.0), new Complex(-1.0, d), new Complex(0.0, d), new Complex(-0.5, d / 2.0), new Complex(-1.0, 0.0), new Complex(0.0, 0.0), new Complex(-0.5, d / 2.0), new Complex(-1.5, d / 2.0), new Complex(-1.0, d), new Complex(-2.0, d), new Complex(-1.5, d / 2.0), new Complex(-1.0, 0.0), new Complex(-2.0, 0.0), new Complex(-1.5, d / 2.0)};
        } else {
            complexArray2 = new Complex[3 * complexArray.length - 2];
            double d2 = -Math.PI * this.fractality.getValue();
            Complex complex = new Complex((-0.5 + Math.cos(d2)) / 3.0, Math.sin(d2) / 3.0);
            int n2 = 0;
            for (int i = 0; i < complexArray.length - 1; ++i) {
                Complex complex2 = complexArray[i];
                Complex complex3 = complexArray[i + 1];
                Complex complex4 = complex2.plus(complex3).times(0.5);
                Complex complex5 = complex2.minus(complex3).times(complex);
                complexArray2[n2++] = new Complex(complex2);
                complexArray2[n2++] = complex4.plus(complex5);
                complexArray2[n2++] = complex4.minus(complex5);
            }
            complexArray2[n2] = complexArray[complexArray.length - 1];
        }
        return complexArray2;
    }
}

