/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.core.Complex;
import vmm.fractals.RepeatedSegmentFractal;

public class Koch
extends RepeatedSegmentFractal {
    protected Complex[] computeNextLevel(Complex[] complexArray, int n) {
        Complex[] complexArray2;
        double d = Math.sqrt(3.0) / 6.0;
        if (n == 0) {
            complexArray2 = new Complex[]{new Complex(-2.0 * d, 0.0), new Complex(d, 0.5), new Complex(d, -0.5), complexArray2[0]};
        } else {
            complexArray2 = new Complex[4 * complexArray.length - 3];
            double d2 = Math.min(0.5, Math.max(this.fractality.getValue(), 0.25));
            double d3 = Math.sqrt(d2 - 0.25) / d2;
            Complex complex = new Complex(0.0, d3);
            int n2 = 0;
            for (int i = 0; i < complexArray.length - 1; ++i) {
                Complex complex2 = complexArray[i];
                Complex complex3 = complexArray[i + 1];
                Complex complex4 = complex2.plus(complex3);
                complex4.re /= 2.0;
                complex4.im /= 2.0;
                Complex complex5 = complex3.minus(complex2).times(d2);
                complexArray2[n2++] = complex2;
                complexArray2[n2++] = complex2.plus(complex5);
                complexArray2[n2++] = complex4.plus(complex.times(complex5));
                complexArray2[n2++] = complex3.minus(complex5);
            }
            complexArray2[n2] = complexArray[complexArray.length - 1];
        }
        return complexArray2;
    }
}

