/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.fractals.RepeatedSegmentFractal;

public class Hilbert
extends RepeatedSegmentFractal {
    @VMMSave
    private int segmentChoice = 2;
    private ActionRadioGroup segmentChoiceSelect;

    public Hilbert() {
        this.fractality.reset(0.5, 0.25, 0.5);
        this.recursionLevel.reset(8);
        this.setDefaultWindow(0.0, 1.0, -0.1, 1.1);
        this.colorRepeatFactor = 4;
        this.fastDrawRecursionLevel = 5;
        this.segmentChoiceSelect = new ActionRadioGroup(){

            public void optionSelected(int n) {
                Hilbert.this.setSegmentChoice(n + 1);
            }
        };
        this.segmentChoiceSelect.addItem("1");
        this.segmentChoiceSelect.addItem("2");
        this.segmentChoiceSelect.addItem("3");
        this.segmentChoiceSelect.addItem("4");
        this.segmentChoiceSelect.setSelectedIndex(this.segmentChoice - 1);
    }

    public int getSegmentChoice() {
        return this.segmentChoice;
    }

    public void setSegmentChoice(int n) {
        if (this.segmentChoice != n && n >= 1 && n <= 4) {
            this.segmentChoice = n;
            this.segmentChoiceSelect.setSelectedIndex(n - 1);
            this.forceRedraw();
        }
    }

    public ActionList getActionsForView(View view) {
        ActionList actionList = super.getActionsForView(view);
        ActionList actionList2 = new ActionList(I18n.tr("vmm.fractals.Hilbert.segmentchoice"));
        actionList2.add(this.segmentChoiceSelect);
        actionList.add(null);
        actionList.add(actionList2);
        return actionList;
    }

    protected Complex[] computeNextLevel(Complex[] complexArray, int n) {
        Complex[] complexArray2;
        double d = Math.min(0.5, Math.max(this.fractality.getValue(), 0.0));
        double d2 = 0.5 - d;
        double d3 = Math.sqrt(d - 0.25);
        Complex complex = new Complex(d2, d3);
        Complex complex2 = new Complex(d2 + 2.0 * d, d3);
        if (n == 0) {
            complexArray2 = this.computeHilbertDecoration();
        } else {
            complexArray2 = new Complex[4 * complexArray.length];
            int n2 = complexArray.length;
            for (int i = 0; i < n2; ++i) {
                Complex complex3 = complexArray[i];
                complexArray2[i] = complex3.conj().times(complex);
                complexArray2[i + n2] = complex3.times(d).plus(complex);
                complexArray2[i + 2 * n2] = complexArray2[i + n2].plus(d);
                complexArray2[i + 3 * n2] = complex3.conj().times(complex.conj()).plus(complex2);
            }
        }
        return complexArray2;
    }

    private Complex[] computeHilbertDecoration() {
        Complex[] complexArray = this.segmentChoice == 1 ? new Complex[]{new Complex(0.02, 0.02), new Complex(0.25, 0.25), new Complex(0.25, 0.75), new Complex(0.75, 0.75), new Complex(0.75, 0.25), new Complex(0.98, 0.02)} : (this.segmentChoice == 2 ? new Complex[]{new Complex(0.25, 0.25), new Complex(0.25, 0.75), new Complex(0.75, 0.75), new Complex(0.75, 0.25)} : (this.segmentChoice == 3 ? new Complex[]{new Complex(0.02, 0.02), new Complex(0.98, 0.02)} : new Complex[]{new Complex(0.02, 0.02), new Complex(0.1, 0.05), new Complex(0.25, 0.5), new Complex(0.5, 0.15), new Complex(0.75, 0.25), new Complex(0.98, 0.02)}));
        return complexArray;
    }
}

