/*
 * Decompiled with CFR 0.152.
 */
package vmm.fractals;

import vmm.core.Complex;
import vmm.fractals.RepeatedSegmentFractal;

public class Dragon
extends RepeatedSegmentFractal {
    public Dragon() {
        this.fractality.reset(0.5, 0.0, 0.5);
        this.fractality.setMaximumValueForInput(0.5);
        this.fractality.setMinimumValueForInput(0.0);
        this.recursionLevel.reset(14);
        this.recursionLevel.setMaximumValueForInput(20);
        this.recursionLevel.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.0, 2.0, -2.0, 1.0);
        this.colorRepeatFactor = 2;
        this.fastDrawRecursionLevel = 10;
    }

    protected Complex[] computeNextLevel(Complex[] complexArray, int n) {
        Complex[] complexArray2;
        if (n == 0) {
            complexArray2 = new Complex[]{new Complex(-1.0, 0.0), new Complex(0.0, -1.0), new Complex(1.0, 0.0)};
        } else {
            complexArray2 = new Complex[2 * complexArray.length - 1];
            double d = Math.min(0.5, Math.max(this.fractality.getValue(), 0.0));
            Complex complex = new Complex(0.0, d);
            int n2 = 0;
            for (int i = 0; i < complexArray.length - 1; ++i) {
                Complex complex2 = complexArray[i];
                Complex complex3 = complexArray[i + 1];
                Complex complex4 = complex2.plus(complex3).times(0.5);
                Complex complex5 = complex3.minus(complex2);
                complexArray2[n2++] = complex2;
                complexArray2[n2++] = complex4.plus(complex.times(complex5));
                complex.im = -complex.im;
            }
            complexArray2[n2] = complexArray[complexArray.length - 1];
        }
        return complexArray2;
    }
}

