/*
 * Decompiled with CFR 0.152.
 */
package vmm.fourier;

import vmm.core.Complex;
import vmm.fourier.FastFourier;

public class FourierSeries {
    static final int SAMPLINGARRAYSIZE = 1025;
    private static Complex[] SamplingArray;
    private static Complex[] SamplingArrayTransform;

    public static boolean IsAPowerOf2(int n) {
        return n == 4 || n == 8 || n == 16 || n == 32 || n == 64 || n == 128 || n == 256 || n == 512;
    }

    private static void InitializeSamplingArrays() {
        int n;
        if (SamplingArray == null) {
            SamplingArray = new Complex[1025];
            for (n = 0; n < 1025; ++n) {
                FourierSeries.SamplingArray[n] = new Complex();
            }
        }
        if (SamplingArrayTransform == null) {
            SamplingArrayTransform = new Complex[1025];
            for (n = 0; n < 1025; ++n) {
                FourierSeries.SamplingArrayTransform[n] = new Complex();
            }
        }
    }

    private static Complex eToThe2piIalpha(double d) {
        return Complex.I_C.times(Math.PI * 2 * d).exponential();
    }

    public static void SFT(Complex[] complexArray, Complex[] complexArray2, int n) {
        int n2;
        if (complexArray2 == null) {
            complexArray2 = new Complex[n];
            for (n2 = 0; n2 < n; ++n2) {
                complexArray2[n2] = new Complex();
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            complexArray2[n2] = Complex.ZERO_C;
            for (int i = 0; i < n; ++i) {
                double d = (double)(-i * n2) / (double)n;
                complexArray2[n2] = complexArray2[n2].plus(complexArray[i].times(FourierSeries.eToThe2piIalpha(d)));
                complexArray2[n2] = complexArray2[n2].times(1 / n);
            }
        }
    }

    public static void ISFT(Complex[] complexArray, Complex[] complexArray2, int n) {
        int n2;
        if (complexArray2 == null) {
            complexArray2 = new Complex[n];
            for (n2 = 0; n2 < n; ++n2) {
                complexArray2[n2] = new Complex();
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            complexArray2[n2] = Complex.ZERO_C;
            for (int i = 0; i < n; ++i) {
                double d = (double)(-i * n2) / (double)n;
                complexArray2[n2] = complexArray2[n2].plus(complexArray[i].times(FourierSeries.eToThe2piIalpha(d)));
            }
        }
    }

    public static void DFT(Complex[] complexArray, Complex[] complexArray2, int n) {
        int n2;
        if (complexArray2 == null) {
            complexArray2 = new Complex[n];
            for (n2 = 0; n2 < n; ++n2) {
                complexArray2[n2] = new Complex();
            }
        }
        if (n == 4 || n == 8 || n == 16 || n == 32 || n == 64 || n == 128 || n == 256 || n == 512) {
            for (n2 = 0; n2 < n; ++n2) {
                complexArray2[n2] = complexArray[n2];
            }
            FastFourier.fft(complexArray2, n);
        } else {
            FourierSeries.SFT(complexArray, complexArray2, n);
        }
    }

    public static void IDFT(Complex[] complexArray, Complex[] complexArray2, int n) {
        int n2;
        if (complexArray2 == null) {
            complexArray2 = new Complex[n];
            for (n2 = 0; n2 < n; ++n2) {
                complexArray2[n2] = new Complex();
            }
        }
        if (n == 4 || n == 8 || n == 16 || n == 32 || n == 64 || n == 128 || n == 256 || n == 512) {
            for (n2 = 0; n2 < n; ++n2) {
                complexArray2[n2] = complexArray[n2];
            }
            FastFourier.ifft(complexArray2, n);
        } else {
            FourierSeries.ISFT(complexArray, complexArray2, n);
        }
    }

    public static void DFTinPlace(Complex[] complexArray, int n) {
        FourierSeries.InitializeSamplingArrays();
        if (n == 4 || n == 8 || n == 16 || n == 32 || n == 64 || n == 128 || n == 256 || n == 512) {
            FastFourier.fft(complexArray, n);
        } else {
            FourierSeries.SFT(complexArray, SamplingArrayTransform, n);
            for (int i = 0; i < n; ++i) {
                complexArray[i] = SamplingArrayTransform[i];
            }
        }
    }

    public static void IDFTinPlace(Complex[] complexArray, int n) {
        FourierSeries.InitializeSamplingArrays();
        if (n == 4 || n == 8 || n == 16 || n == 32 || n == 64 || n == 128 || n == 256 || n == 512) {
            FastFourier.ifft(complexArray, n);
        } else {
            FourierSeries.ISFT(complexArray, SamplingArray, n);
            for (int i = 0; i < n; ++i) {
                complexArray[i] = SamplingArray[i];
            }
        }
    }

    public static void DST(double[] dArray, double[] dArray2, int n) {
        int n2;
        FourierSeries.InitializeSamplingArrays();
        for (n2 = 0; n2 < n; ++n2) {
            dArray[2 * n - n2] = -dArray[n2];
        }
        for (n2 = 0; n2 < 2 * n; ++n2) {
            FourierSeries.SamplingArray[n2].re = dArray[n2];
            FourierSeries.SamplingArray[n2].im = 0.0;
        }
        FourierSeries.DFTinPlace(SamplingArray, 2 * n);
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = 0.5 * FourierSeries.SamplingArray[n2].im;
        }
    }

    public static void IDST(double[] dArray, double[] dArray2, int n) {
        double d = 2.0 / (double)n;
        FourierSeries.DST(dArray2, dArray, n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = d * dArray[i];
        }
    }

    public static void DSTinPlace(double[] dArray, int n) {
        int n2;
        FourierSeries.InitializeSamplingArrays();
        for (n2 = 0; n2 < n; ++n2) {
            dArray[2 * n - n2] = -dArray[n2];
        }
        for (n2 = 1; n2 <= 2 * n; ++n2) {
            FourierSeries.SamplingArray[n2].re = dArray[n2];
            FourierSeries.SamplingArray[n2].im = 0.0;
        }
        FourierSeries.DFTinPlace(SamplingArray, 2 * n);
        for (n2 = 1; n2 <= n; ++n2) {
            dArray[n2] = 0.5 * FourierSeries.SamplingArray[n2].im;
        }
    }

    public static void IDSTinPlace(double[] dArray, int n) {
        double d = 2.0 / (double)n;
        FourierSeries.DSTinPlace(dArray, n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = d * dArray[i];
        }
    }
}

