/*
 * Decompiled with CFR 0.152.
 */
package vmm.fourier;

import vmm.core.Complex;

public class FastFourier {
    static final int MAXFFTSIZE = 512;
    static Complex[] twid;

    static Complex Cadd(Complex complex, Complex complex2) {
        return complex.plus(complex2);
    }

    static Complex Csub(Complex complex, Complex complex2) {
        return complex.minus(complex2);
    }

    static Complex Cmul(Complex complex, Complex complex2) {
        return complex.times(complex2);
    }

    static Complex Cdiv(Complex complex, Complex complex2) {
        return complex.dividedBy(complex2);
    }

    static Complex RCmul(double d, Complex complex) {
        return complex.times(d);
    }

    static Complex Cexp(Complex complex) {
        return complex.exponential();
    }

    static Complex Comp(double d, double d2) {
        Complex complex = Complex.ZERO_C;
        complex.assign(d, d2);
        return complex;
    }

    static Complex cexp(double d, double d2) {
        return FastFourier.RCmul(Math.exp(d), FastFourier.Comp(Math.cos(d2), Math.sin(d2)));
    }

    static Complex Cconjg(Complex complex) {
        return complex.conj();
    }

    static double Cabs(Complex complex) {
        return complex.r();
    }

    static Complex Cexpi(double d) {
        return FastFourier.Comp(Math.cos(d), Math.sin(d));
    }

    private static void SetupTwid() {
        if (twid == null) {
            twid = new Complex[512];
            double d = 0.01227184630308513;
            for (int i = 0; i < 512; ++i) {
                FastFourier.twid[i] = new Complex();
                FastFourier.twid[i].re = Math.cos((double)i * d);
                FastFourier.twid[i].im = Math.sin((double)i * d);
            }
        }
    }

    static void fft(Complex[] complexArray, int n) {
        FastFourier.SetupTwid();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3;
            for (n3 = n / 2; n2 >= n3; n2 -= n3, n3 /= 2) {
            }
            if ((n2 += n3) >= i) continue;
            Complex complex = complexArray[n2];
            complexArray[n2] = complexArray[i];
            complexArray[i] = complex;
        }
        int n4 = n;
        int n5 = 1;
        while (n4 > 1) {
            n4 /= 2;
            int n6 = n5;
            n5 *= 2;
            for (int i = 0; i < n6; ++i) {
                Complex complex = twid[i * n4];
                for (int j = 0; j < n4; ++j) {
                    int n7 = j * n5 + i;
                    int n8 = n7 + n6;
                    Complex complex2 = complexArray[n7];
                    Complex complex3 = FastFourier.Cmul(complex, complexArray[n8]);
                    complexArray[n7] = FastFourier.Cadd(complex2, complex3);
                    complexArray[n8] = FastFourier.Csub(complex2, complex3);
                }
            }
        }
    }

    static void ifft(Complex[] complexArray, int n) {
        int n2;
        FastFourier.SetupTwid();
        double d = 1.0 / (double)n;
        for (n2 = 0; n2 < n; ++n2) {
            complexArray[n2] = FastFourier.Cconjg(complexArray[n2]);
        }
        FastFourier.fft(complexArray, n);
        for (n2 = 0; n2 < n; ++n2) {
            complexArray[n2] = FastFourier.RCmul(d, FastFourier.Cconjg(complexArray[n2]));
        }
    }

    public static Complex[] ffTransform(Complex[] complexArray, int n) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray2[i] = new Complex(complexArray[i]);
        }
        FastFourier.fft(complexArray2, n);
        return complexArray2;
    }

    public static Complex[] iffTransform(Complex[] complexArray, int n) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray2[i] = new Complex(complexArray[i]);
        }
        FastFourier.ifft(complexArray2, n);
        return complexArray2;
    }
}

