/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core3D.DirectionalLight;
import vmm.core3D.LightSettings;
import vmm.core3D.LightSettingsDialog;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class View3DWithLightSettings
extends View3D {
    @VMMSave
    private boolean lightingEnabled = true;
    private LightSettings anaglyphLightSettings;
    private LightSettings nonAnaglyphLightSettings;
    protected AbstractActionVMM lightSettingsCommand = new AbstractActionVMM(I18n.tr("vmm.core3D.commands.LightSettings")){

        public void actionPerformed(ActionEvent actionEvent) {
            LightSettingsDialog.showDialog(View3DWithLightSettings.this);
        }
    };
    protected ToggleAction lightingEnabledToggle = new ToggleAction(I18n.tr("vmm.core3D.commands.EnableLighting"), true){

        public void actionPerformed(ActionEvent actionEvent) {
            View3DWithLightSettings.this.setLightingEnabled(this.getState());
        }
    };

    public View3DWithLightSettings() {
        this.anaglyphLightSettings = this.nonAnaglyphLightSettings = new LightSettings();
    }

    public LightSettings getLightSettings() {
        return this.getViewStyle() == 1 ? this.anaglyphLightSettings : this.nonAnaglyphLightSettings;
    }

    public void setLightSettings(LightSettings lightSettings) {
        if (lightSettings != null) {
            if (this.anaglyphLightSettings == this.nonAnaglyphLightSettings) {
                this.anaglyphLightSettings = this.nonAnaglyphLightSettings = lightSettings;
            } else if (this.getViewStyle() == 1) {
                this.anaglyphLightSettings = lightSettings;
            } else {
                this.nonAnaglyphLightSettings = lightSettings;
            }
        }
    }

    protected void setAnaglyphLightSettings(LightSettings lightSettings) {
        if (lightSettings != null) {
            this.anaglyphLightSettings = lightSettings;
        }
    }

    protected void setNonAnaglyphLightSettings(LightSettings lightSettings) {
        if (lightSettings != null) {
            this.nonAnaglyphLightSettings = lightSettings;
        }
    }

    public boolean getLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setLightingEnabled(boolean bl) {
        if (this.lightingEnabled == bl) {
            return;
        }
        this.lightingEnabled = bl;
        this.lightingEnabledToggle.setState(bl);
        this.forceRedraw();
    }

    public void setViewStyle(int n) {
        super.setViewStyle(n);
        this.setLightSettings(n == 1 ? this.anaglyphLightSettings : this.nonAnaglyphLightSettings);
    }

    public ActionList getSettingsCommands() {
        ActionList actionList = super.getSettingsCommands();
        this.lightSettingsCommand.setEnabled(this.getEnableThreeD());
        actionList.add(null);
        actionList.add(this.lightingEnabledToggle);
        actionList.add(this.lightSettingsCommand);
        return actionList;
    }

    public void addExtraXML(Document document, Element element) {
        super.addExtraXML(document, element);
        Element element2 = document.createElement("light-settings");
        this.addLightToXML(document, element2, this.nonAnaglyphLightSettings);
        element.appendChild(element2);
        if (this.anaglyphLightSettings != this.nonAnaglyphLightSettings) {
            element2 = document.createElement("light-settings-anaglyph");
            this.addLightToXML(document, element2, this.anaglyphLightSettings);
            element.appendChild(element2);
        }
    }

    private void addLightToXML(Document document, Element element, LightSettings lightSettings) {
        Element element2;
        SaveAndRestore.addProperty(lightSettings, "specularRatio", document, element);
        SaveAndRestore.addProperty(lightSettings, "specularExponent", document, element);
        SaveAndRestore.addProperty(lightSettings, "light0", document, element);
        SaveAndRestore.addProperty(lightSettings, "ambientLight", document, element);
        if (lightSettings.getDirectionalLight1() != null) {
            element2 = document.createElement("light1");
            element2.setAttribute("color", Util.toExternalString(lightSettings.getDirectionalLight1().getItsColor()));
            element2.setAttribute("direction", Util.toExternalString(lightSettings.getDirectionalLight1().getItsDirection()));
            element.appendChild(element2);
        }
        if (lightSettings.getDirectionalLight2() != null) {
            element2 = document.createElement("light2");
            element2.setAttribute("color", Util.toExternalString(lightSettings.getDirectionalLight2().getItsColor()));
            element2.setAttribute("direction", Util.toExternalString(lightSettings.getDirectionalLight2().getItsDirection()));
            element.appendChild(element2);
        }
        if (lightSettings.getDirectionalLight3() != null) {
            element2 = document.createElement("light3");
            element2.setAttribute("color", Util.toExternalString(lightSettings.getDirectionalLight3().getItsColor()));
            element2.setAttribute("direction", Util.toExternalString(lightSettings.getDirectionalLight3().getItsDirection()));
            element.appendChild(element2);
        }
    }

    public void readExtraXML(Element element) throws IOException {
        LightSettings lightSettings;
        super.readExtraXML(element);
        Element element2 = SaveAndRestore.getChildElement(element, "light-settings");
        if (element2 == null) {
            return;
        }
        this.nonAnaglyphLightSettings = this.anaglyphLightSettings = (lightSettings = this.readLightFromXML(element2));
        element2 = SaveAndRestore.getChildElement(element, "light-settings-anaglyph");
        if (element2 != null) {
            this.anaglyphLightSettings = lightSettings = this.readLightFromXML(element2);
        }
    }

    private LightSettings readLightFromXML(Element element) throws IOException {
        Vector3D vector3D;
        Color color;
        LightSettings lightSettings = new LightSettings();
        SaveAndRestore.readProperties(lightSettings, element);
        Element element2 = SaveAndRestore.getChildElement(element, "light1");
        if (element2 != null) {
            try {
                color = (Color)Util.externalStringToValue(element2.getAttribute("color"), Color.class);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", element2.getAttribute("color"), "color"));
            }
            try {
                vector3D = (Vector3D)Util.externalStringToValue(element2.getAttribute("direction"), Vector3D.class);
                vector3D.normalize();
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", element2.getAttribute("direction"), "direction"));
            }
            lightSettings.setDirectionalLight1(new DirectionalLight(color, vector3D));
        }
        if ((element2 = SaveAndRestore.getChildElement(element, "light2")) != null) {
            try {
                color = (Color)Util.externalStringToValue(element2.getAttribute("color"), Color.class);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", element2.getAttribute("color"), "color"));
            }
            try {
                vector3D = (Vector3D)Util.externalStringToValue(element2.getAttribute("direction"), Vector3D.class);
                vector3D.normalize();
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", element2.getAttribute("direction"), "direction"));
            }
            lightSettings.setDirectionalLight2(new DirectionalLight(color, vector3D));
        }
        if ((element2 = SaveAndRestore.getChildElement(element, "light3")) != null) {
            try {
                color = (Color)Util.externalStringToValue(element2.getAttribute("color"), Color.class);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", element2.getAttribute("color"), "color"));
            }
            try {
                vector3D = (Vector3D)Util.externalStringToValue(element2.getAttribute("direction"), Vector3D.class);
                vector3D.normalize();
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", element2.getAttribute("direction"), "direction"));
            }
            lightSettings.setDirectionalLight3(new DirectionalLight(color, vector3D));
        }
        return lightSettings;
    }
}

