/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.I18n;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Grid3D;
import vmm.core3D.SetTransparencyDialog;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DWithLightSettings;

public class View3DLit
extends View3DWithLightSettings {
    public static final int WIREFRAME_RENDERING = 0;
    public static final int PATCH_RENDERING = 1;
    public static final int NORMAL_ORIENTATION = 0;
    public static final int REVERSE_ORIENTATION = 1;
    public static final int NO_ORIENTATION = 2;
    @VMMSave
    private int renderingStyle = 1;
    @VMMSave
    private int orientation = 0;
    @VMMSave
    private boolean phongShading;
    @VMMSave
    private boolean blackAndWhite;
    @VMMSave
    private double transparency;
    private boolean dragAsSurface;
    protected ActionRadioGroup selectRenderingCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.Wireframe"), I18n.tr("vmm.core3D.commands.PatchRendering")}, 1){

        public void optionSelected(int n) {
            View3DLit.this.setRenderingStyle(n);
        }
    };
    protected ActionRadioGroup selectOrientationCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.NormalOrientation"), I18n.tr("vmm.core3D.commands.ReverseOrientation"), I18n.tr("vmm.core3D.commands.NoOrientation")}, 0){

        public void optionSelected(int n) {
            View3DLit.this.setOrientation(n);
        }
    };
    protected ActionRadioGroup selectShadingCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.PhongShading"), I18n.tr("vmm.core3D.commands.FlatShading")}, 0){

        public void optionSelected(int n) {
            View3DLit.this.setPhongShading(n == 0);
        }
    };
    protected ActionRadioGroup selectColoredCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.Color"), I18n.tr("vmm.core3D.commands.BlackAndWhite")}, 0){

        public void optionSelected(int n) {
            View3DLit.this.setBlackAndWhite(n == 1);
        }
    };
    protected ToggleAction dragAsSurfaceToggle = new ToggleAction(I18n.tr("vmm.core3D.commands.DragAsSurface")){

        public void actionPerformed(ActionEvent actionEvent) {
            View3DLit.this.setDragAsSurface(this.getState());
        }
    };
    protected AbstractActionVMM setTransparencyCommand = new AbstractActionVMM(I18n.tr("vmm.core3D.commands.setTransparency") + "..."){

        public void actionPerformed(ActionEvent actionEvent) {
            SetTransparencyDialog.showDialog(View3DLit.this);
        }
    };

    public View3DLit() {
        this.setOrientation(0);
    }

    public int getRenderingStyle() {
        return this.renderingStyle;
    }

    public void setRenderingStyle(int n) {
        if (n != 0 && n != 1) {
            return;
        }
        this.selectRenderingCommands.setSelectedIndex(n);
        if (this.dragAsSurfaceToggle != null) {
            this.dragAsSurfaceToggle.setEnabled(n == 1);
        }
        if (n == this.renderingStyle) {
            return;
        }
        this.renderingStyle = n;
        this.forceRedraw();
    }

    public boolean getBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean bl) {
        this.selectColoredCommands.setSelectedIndex(bl ? 1 : 0);
        if (bl != this.blackAndWhite) {
            this.blackAndWhite = bl;
            this.offscreenImageType = bl ? 10 : 1;
            this.rightStereographOSI = null;
            this.leftStereographOSI = null;
            this.fullOSI = null;
            this.forceRedraw();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1 && n != 2) {
            return;
        }
        this.selectOrientationCommands.setSelectedIndex(n);
        if (this.orientation != n) {
            this.orientation = n;
            this.forceRedraw();
        }
    }

    public boolean getPhongShading() {
        return this.phongShading;
    }

    public void setPhongShading(boolean bl) {
        this.selectShadingCommands.setSelectedIndex(bl ? 0 : 1);
        if (this.phongShading != bl) {
            this.phongShading = bl;
            this.forceRedraw();
        }
    }

    public boolean getDragAsSurface() {
        return this.dragAsSurface;
    }

    public void setDragAsSurface(boolean bl) {
        this.dragAsSurfaceToggle.setState(bl);
        this.dragAsSurface = bl;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        if (this.transparency == d) {
            return;
        }
        this.transparency = d;
        this.forceRedraw();
    }

    public void setEnableThreeD(boolean bl) {
        if (bl == this.getEnableThreeD()) {
            return;
        }
        super.setEnableThreeD(bl);
        this.selectColoredCommands.setEnabled(bl);
        this.selectOrientationCommands.setEnabled(bl);
        this.selectRenderingCommands.setEnabled(bl);
        this.selectShadingCommands.setEnabled(bl);
        this.dragAsSurfaceToggle.setEnabled(bl);
        this.lightingEnabledToggle.setEnabled(bl);
        if (this.lightSettingsCommand != null) {
            this.lightSettingsCommand.setEnabled(bl);
        }
    }

    public ActionList getSettingsCommands() {
        ActionList actionList = super.getSettingsCommands();
        actionList.add(null);
        actionList.add(this.setTransparencyCommand);
        actionList.add(null);
        actionList.add(this.dragAsSurfaceToggle);
        return actionList;
    }

    public void setViewStyle(int n) {
        super.setViewStyle(n);
        this.selectColoredCommands.setEnabled(this.getViewStyle() != 1);
    }

    public void takeExhibit(View view, boolean bl) {
        super.takeExhibit(view, bl);
        if (view instanceof View3DLit) {
            this.setOrientation(((View3DLit)view).getOrientation());
        }
    }

    public ActionList getViewCommands() {
        ActionList actionList = super.getViewCommands();
        actionList.add(null);
        actionList.add(this.selectRenderingCommands);
        actionList.add(null);
        actionList.add(this.selectColoredCommands);
        this.selectColoredCommands.setEnabled(this.getViewStyle() != 1);
        actionList.add(null);
        actionList.add(this.selectOrientationCommands);
        return actionList;
    }

    public void drawSurface(Grid3D grid3D) {
        this.drawSurface(grid3D, 0.0, 1.0);
    }

    public void drawSurface(Grid3D grid3D, double d, double d2) {
        if (this.renderingStyle == 0 || this.getFastDrawing() && !this.dragAsSurface) {
            if (this.getViewStyle() == 0) {
                grid3D.applyTransform(this.transform3D, this);
                grid3D.drawCurves(this, this.currentGraphics);
            } else {
                this.setUpForLeftEye();
                grid3D.applyTransform(this.transform3D, this);
                grid3D.drawCurves(this, this.currentGraphics);
                this.setUpForRightEye();
                grid3D.applyTransform(this.transform3D, this);
                grid3D.drawCurves(this, this.currentGraphics);
                this.finishStereoView();
            }
        } else if (this.renderingStyle == 1) {
            if (this.getViewStyle() == 0) {
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                grid3D.applyTransform(this.transform3D, this);
                if (this.getFastDrawing()) {
                    grid3D.drawMajorPatches(this, this.currentGraphics);
                } else {
                    grid3D.drawSubPatches(this, this.currentGraphics, d, d2);
                }
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            } else {
                this.setUpForLeftEye();
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                grid3D.applyTransform(this.transform3D, this);
                if (this.getFastDrawing()) {
                    grid3D.drawMajorPatches(this, this.currentGraphics);
                } else {
                    grid3D.drawSubPatches(this, this.currentGraphics, d, d2);
                }
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.setUpForRightEye();
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                grid3D.applyTransform(this.transform3D, this);
                if (this.getFastDrawing()) {
                    grid3D.drawMajorPatches(this, this.currentGraphics);
                } else {
                    grid3D.drawSubPatches(this, this.currentGraphics, d, d2);
                }
                if (this.getAntialiased()) {
                    this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.finishStereoView();
            }
        }
    }

    public void fillPolygon(Vector3D[] vector3DArray, Color color) {
        if (this.getViewStyle() == 0) {
            Color color2 = this.currentGraphics.getColor();
            GeneralPath generalPath = new GeneralPath();
            Point2D point2D = this.transform3D.objectToDrawingCoords(vector3DArray[0]);
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            for (int i = 1; i < vector3DArray.length; ++i) {
                point2D = this.transform3D.objectToDrawingCoords(vector3DArray[i]);
                generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            }
            generalPath.closePath();
            this.currentGraphics.fill(generalPath);
            if (color != null) {
                this.currentGraphics.setColor(color);
            }
            this.currentGraphics.draw(generalPath);
            this.currentGraphics.setColor(color2);
        } else {
            int n;
            this.setUpForLeftEye();
            Color color3 = this.currentGraphics.getColor();
            GeneralPath generalPath = new GeneralPath();
            Point2D point2D = this.transform3D.objectToDrawingCoords(vector3DArray[0]);
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            for (n = 1; n < vector3DArray.length; ++n) {
                point2D = this.transform3D.objectToDrawingCoords(vector3DArray[n]);
                generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            }
            generalPath.closePath();
            this.currentGraphics.fill(generalPath);
            if (color != null) {
                this.currentGraphics.setColor(color);
            }
            this.currentGraphics.draw(generalPath);
            this.currentGraphics.setColor(color3);
            this.setUpForRightEye();
            color3 = this.currentGraphics.getColor();
            generalPath.reset();
            point2D = this.transform3D.objectToDrawingCoords(vector3DArray[0]);
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            for (n = 1; n < vector3DArray.length; ++n) {
                point2D = this.transform3D.objectToDrawingCoords(vector3DArray[n]);
                generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            }
            generalPath.closePath();
            this.currentGraphics.fill(generalPath);
            if (color != null) {
                this.currentGraphics.setColor(color);
            }
            this.currentGraphics.draw(generalPath);
            this.currentGraphics.setColor(color3);
            this.finishStereoView();
        }
    }
}

