/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.Axes2D;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Prefs;
import vmm.core.SaveAndRestore;
import vmm.core.Transform;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Axes3D;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Grid3D;
import vmm.core3D.Set3DViewOptionsDialog;
import vmm.core3D.SetViewpointDialog;
import vmm.core3D.StereoComposite;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;

public class View3D
extends View {
    public static final int MONOCULAR_VIEW = 0;
    public static final int RED_GREEN_STEREO_VIEW = 1;
    public static final int STEREOGRAPH_VIEW = 2;
    public static final int CROSS_EYE_STEREO_VIEW = 3;
    @VMMSave
    private int viewStyle = 0;
    private Color savedBackground;
    @VMMSave
    private boolean enableThreeD = true;
    private Transform saveTransform2DWhileThreeDEnabled = null;
    private Transform saveTransform3DWhileThreeDDisabled = null;
    private int saveViewStyleWhile3DDisabled = -1;
    protected Transform3D transform3D;
    protected StereoComposite stereoComposite;
    private Rectangle leftEyeRect;
    private Rectangle rightEyeRect;
    private Dimension stereographPreferredSize;
    private Rectangle stereographPreferredLeftEyeRect;
    private Rectangle stereographPreferredRightEyeRect;
    private int saveStereographDisplayWidth;
    private int saveStereographDisplayHeight;
    private Dimension savePreferredSizeForStereograph;
    private Graphics2D leftEyeGraphics;
    private Graphics2D rightEyeGraphics;
    private Graphics2D leftEyeUntransformedGraphics;
    private Graphics2D rightEyeUntransformedGraphics;
    private Graphics2D saveGraphicsDuringStereo;
    private Graphics2D saveUntransformedGraphicsDuringStereo;
    private Vector3D viewDirection;
    private double clipZ;
    private double eyeSeparationMultiplier;
    protected BufferedImage leftStereographOSI;
    protected BufferedImage rightStereographOSI;
    protected ActionRadioGroup viewStyleCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.Monocular"), I18n.tr("vmm.core3D.commands.RedGreenStereo"), I18n.tr("vmm.core3D.commands.Stereograph"), I18n.tr("vmm.core3D.commands.CrossEyeStereo")}, 0){

        public void optionSelected(int n) {
            View3D.this.setViewStyle(n);
        }
    };
    protected ActionRadioGroup projectionCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core3D.commands.PerspectiveProjection"), I18n.tr("vmm.core3D.commands.OrthographicProjection")}, 0){

        public void optionSelected(int n) {
            View3D.this.setOrthographicProjection(n == 1);
        }
    };
    protected AbstractActionVMM setViewpointAction;
    protected AbstractActionVMM set3DViewOptionsAction;

    public int getViewStyle() {
        return this.viewStyle;
    }

    public void setViewStyle(int n) {
        if (n < 0 || n > 3) {
            return;
        }
        this.viewStyleCommands.setSelectedIndex(n);
        if (n == this.viewStyle) {
            return;
        }
        this.rightStereographOSI = null;
        this.leftStereographOSI = null;
        this.fullOSI = null;
        if (n == 1) {
            Color color = this.getBackground();
            this.setBackground(Color.BLACK);
            this.savedBackground = color;
            this.backgroundCommands.setEnabled(false);
        } else {
            if (this.viewStyle == 1 && this.savedBackground != null) {
                this.setBackground(this.savedBackground);
            }
            this.backgroundCommands.setEnabled(true);
        }
        if (n == 3 || n == 2) {
            this.enterStereographView(this.viewStyle, n);
        } else if (this.viewStyle == 3 || this.viewStyle == 2) {
            this.leaveStereographView();
        }
        this.viewStyle = n;
        if (this.transform3D != null) {
            if (this.viewStyle != 1 || !"yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"))) {
                this.transform3D.setObjectDisplacementNormalToScreen(0.0);
            } else if (this.getViewStyle() == 1 && this.getTransform3D() != null) {
                double d = Math.max(this.getTransform3D().getXmaxRequested() - this.getTransform3D().getXminRequested(), this.getTransform3D().getYmaxRequested() - this.getTransform3D().getYminRequested());
                this.getTransform3D().setObjectDisplacementNormalToScreen(d / 3.0);
            }
        }
        this.forceRedraw();
    }

    private void enterStereographView(int n, int n2) {
        int n3 = Toolkit.getDefaultToolkit().getScreenResolution();
        if (n3 == 72 && Util.isMacOS()) {
            n3 = 100;
        }
        if (n != 3 && n != 2) {
            this.savePreferredSizeForStereograph = this.getDisplay() == null ? null : new Dimension(this.getDisplay().getWidth(), this.getDisplay().getHeight());
        }
        Dimension dimension = null;
        if (n2 == 3) {
            this.leftEyeRect = new Rectangle(n3 - 20, 5, 7 * n3 / 2, 7 * n3 / 2);
            this.rightEyeRect = new Rectangle(5 * n3 - 20, 5, 7 * n3 / 2, 7 * n3 / 2);
            dimension = new Dimension(19 * n3 / 2 - 40, 12 + 7 * n3 / 2);
        } else {
            this.leftEyeRect = new Rectangle(n3 - 20, 5, 5 * n3 / 2, 5 * n3 / 2);
            this.rightEyeRect = new Rectangle(n3 + 5 + 5 * n3 / 2, 5, 5 * n3 / 2, 5 * n3 / 2);
            dimension = new Dimension(-14 + 7 * n3, 12 + 5 * n3 / 2);
        }
        this.stereographPreferredSize = dimension;
        this.stereographPreferredLeftEyeRect = (Rectangle)this.leftEyeRect.clone();
        this.stereographPreferredRightEyeRect = (Rectangle)this.rightEyeRect.clone();
        this.saveStereographDisplayWidth = dimension.width;
        this.saveStereographDisplayHeight = dimension.height;
        if (this.getDisplay() != null) {
            this.getDisplay().setPreferredSize(dimension);
            if (dimension.width > this.getDisplay().getWidth() || dimension.height > this.getDisplay().getHeight()) {
                double d = Math.min((double)this.getDisplay().getWidth() / (double)dimension.width, (double)this.getDisplay().getHeight() / (double)dimension.height);
                this.leftEyeRect.x = (int)((double)this.leftEyeRect.x * d);
                this.rightEyeRect.x = (int)((double)this.rightEyeRect.x * d);
                this.leftEyeRect.width = this.rightEyeRect.width = (int)((double)this.leftEyeRect.width * d);
                this.leftEyeRect.height = this.rightEyeRect.height = (int)((double)this.leftEyeRect.height * d);
            }
            int n4 = (this.getDisplay().getWidth() - (this.rightEyeRect.x + this.rightEyeRect.width - this.leftEyeRect.x)) / 2;
            int n5 = (this.getDisplay().getHeight() - this.leftEyeRect.height) / 2;
            this.rightEyeRect.x += n4 - this.leftEyeRect.x;
            this.leftEyeRect.x = n4;
            this.rightEyeRect.y = this.leftEyeRect.y = n5;
            this.saveStereographDisplayWidth = this.getDisplay().getWidth();
            this.saveStereographDisplayHeight = this.getDisplay().getHeight();
        }
    }

    private void adjustStereographToNewSize(int n, int n2) {
        this.leftEyeRect = (Rectangle)this.stereographPreferredLeftEyeRect.clone();
        this.rightEyeRect = (Rectangle)this.stereographPreferredRightEyeRect.clone();
        double d = Math.min((double)n / (double)this.stereographPreferredSize.width, (double)n2 / (double)this.stereographPreferredSize.height);
        this.leftEyeRect.x = (int)((double)this.leftEyeRect.x * d);
        this.rightEyeRect.x = (int)((double)this.rightEyeRect.x * d);
        this.leftEyeRect.width = this.rightEyeRect.width = (int)((double)this.leftEyeRect.width * d);
        this.leftEyeRect.height = this.rightEyeRect.height = (int)((double)this.leftEyeRect.height * d);
        int n3 = (n - (this.rightEyeRect.x + this.rightEyeRect.width - this.leftEyeRect.x)) / 2;
        int n4 = (n2 - this.leftEyeRect.height) / 2;
        this.rightEyeRect.x += n3 - this.leftEyeRect.x;
        this.leftEyeRect.x = n3;
        this.rightEyeRect.y = this.leftEyeRect.y = n4;
        this.saveStereographDisplayWidth = n;
        this.saveStereographDisplayHeight = n2;
    }

    private void leaveStereographView() {
        if (this.getDisplay() != null) {
            if (this.savePreferredSizeForStereograph == null) {
                this.getDisplay().setPreferredSize(new Dimension(800, 490));
            } else {
                this.getDisplay().setPreferredSize(this.savePreferredSizeForStereograph);
            }
        }
    }

    public void moveStereographImages(int n) {
        if (this.viewStyle != 3 && this.viewStyle != 2) {
            return;
        }
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        if (n < 0) {
            if (this.leftEyeRect.x + n < 0) {
                n = -this.leftEyeRect.x;
            }
            if (n >= 0) {
                return;
            }
        } else {
            if (this.leftEyeRect.x + this.leftEyeRect.width + n + 1 > this.rightEyeRect.x - n - 1) {
                n = (this.rightEyeRect.x - (this.leftEyeRect.x + this.leftEyeRect.width)) / 2 - 1;
            }
            if (n <= 0) {
                return;
            }
        }
        this.leftEyeRect.x += n;
        this.rightEyeRect.x -= n;
        this.forceRedraw();
    }

    public Rectangle stereographLeftEyeRect() {
        return this.leftEyeRect;
    }

    public Rectangle stereographRightEyeRect() {
        return this.rightEyeRect;
    }

    public boolean getEnableThreeD() {
        return this.enableThreeD;
    }

    public void setEnableThreeD(boolean bl) {
        if (bl == this.enableThreeD) {
            return;
        }
        boolean bl2 = this.getShowAxes();
        if (bl2) {
            this.setShowAxes(false);
        }
        this.enableThreeD = bl;
        if (bl2) {
            this.setShowAxes(true);
        }
        if (this.enableThreeD) {
            this.saveTransform2DWhileThreeDEnabled = this.getTransform();
            if (this.saveTransform3DWhileThreeDDisabled != null) {
                this.setTransform(this.saveTransform3DWhileThreeDDisabled);
                this.saveTransform3DWhileThreeDDisabled = null;
            } else {
                this.setTransform(new Transform3D());
            }
            if (this.saveViewStyleWhile3DDisabled >= 0) {
                this.setViewStyle(this.saveViewStyleWhile3DDisabled);
                this.saveViewStyleWhile3DDisabled = -1;
            }
        } else {
            this.saveTransform3DWhileThreeDDisabled = this.getTransform();
            if (this.saveTransform2DWhileThreeDEnabled != null) {
                this.setTransform(this.saveTransform2DWhileThreeDEnabled);
                this.saveTransform2DWhileThreeDEnabled = null;
            } else {
                Transform3D transform3D = new Transform3D();
                if (this.getTransform() != null) {
                    transform3D.setLimits(this.getTransform().getXmin(), this.getTransform().getXmax(), this.getTransform().getYmin(), this.getTransform().getYmax());
                }
                this.setTransform(transform3D);
            }
            this.saveViewStyleWhile3DDisabled = this.getViewStyle();
            this.setViewStyle(0);
            this.setViewPoint(new Vector3D(1.0, 0.0, 0.0));
            this.setOrthographicProjection(true);
        }
        this.viewStyleCommands.setEnabled(this.enableThreeD);
        if (this.setViewpointAction != null) {
            this.setViewpointAction.setEnabled(this.enableThreeD);
        }
        this.projectionCommands.setEnabled(this.enableThreeD);
        this.forceRedraw();
    }

    public void setWindowForUseWhileThreeDDisabled(double d, double d2, double d3, double d4) {
        if (!this.enableThreeD) {
            this.setWindow(d, d2, d3, d4);
        } else {
            if (this.saveTransform2DWhileThreeDEnabled == null) {
                this.saveTransform2DWhileThreeDEnabled = new Transform3D();
            }
            this.saveTransform2DWhileThreeDEnabled.setLimits(d, d2, d3, d4);
        }
    }

    protected Transform getSavedAuxiliaryTransformForEnableThreeD() {
        if (this.enableThreeD) {
            return this.saveTransform2DWhileThreeDEnabled;
        }
        return this.saveTransform3DWhileThreeDDisabled;
    }

    protected void setSavedAuxiliaryTransformForEnableThreeD(Transform transform) {
        if (this.enableThreeD) {
            this.saveTransform2DWhileThreeDEnabled = transform;
        } else {
            this.saveTransform3DWhileThreeDDisabled = transform;
        }
    }

    public boolean getOrthographicProjection() {
        if (this.transform3D == null) {
            return true;
        }
        return this.transform3D.getOrthographicProjection();
    }

    public void setOrthographicProjection(boolean bl) {
        if (this.transform3D != null) {
            this.transform3D.setOrthographicProjection(bl);
        }
    }

    public Vector3D getViewPoint() {
        if (this.transform3D == null) {
            return null;
        }
        return this.transform3D.getViewPoint();
    }

    public void setViewPoint(Vector3D vector3D) {
        if (this.transform3D != null && !this.transform3D.getViewPoint().equals(vector3D)) {
            this.transform3D.setViewPoint(vector3D);
        }
    }

    public Vector3D getViewUp() {
        if (this.transform3D == null) {
            return null;
        }
        return this.transform3D.getImagePlaneYDirection();
    }

    public void setViewUp(Vector3D vector3D) {
        if (this.transform3D != null) {
            this.transform3D.setImagePlaneYDirection(vector3D);
        }
    }

    public void setExhibit(Exhibit exhibit) {
        if (exhibit == this.getExhibit()) {
            return;
        }
        if (!this.enableThreeD) {
            this.saveTransform2DWhileThreeDEnabled = this.getTransform();
        }
        super.setExhibit(exhibit);
        this.transform3D = this.getTransform() != null && this.getTransform() instanceof Transform3D ? (Transform3D)this.getTransform() : null;
        this.savedBackground = null;
        if (exhibit != null && (this.viewStyle == 2 || this.viewStyle == 3)) {
            this.enterStereographView(0, this.viewStyle);
        }
        if (this.viewStyle == 1 && this.transform3D != null && "yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"))) {
            double d = Math.max(this.transform3D.getXmaxRequested() - this.transform3D.getXminRequested(), this.transform3D.getYmaxRequested() - this.transform3D.getYminRequested());
            this.transform3D.setObjectDisplacementNormalToScreen(d / 3.0);
        }
        if (!this.enableThreeD) {
            this.saveTransform3DWhileThreeDDisabled = this.getTransform();
            this.setTransform(this.saveTransform2DWhileThreeDEnabled);
            this.saveTransform2DWhileThreeDEnabled = null;
        }
    }

    public void setTransform(Transform transform) {
        super.setTransform(transform);
        if (transform != null && transform instanceof Transform3D) {
            this.transform3D = (Transform3D)transform;
            this.projectionCommands.setSelectedIndex(this.transform3D.getOrthographicProjection() ? 1 : 0);
            if (this.viewStyle == 1 && "yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"))) {
                double d = Math.max(this.transform3D.getXmaxRequested() - this.transform3D.getXminRequested(), this.transform3D.getYmaxRequested() - this.transform3D.getYminRequested());
                this.transform3D.setObjectDisplacementNormalToScreen(d / 3.0);
            }
        } else {
            this.transform3D = null;
        }
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        if (this.getExhibit() != null && (this.viewStyle == 2 || this.viewStyle == 3)) {
            this.enterStereographView(0, this.viewStyle);
        } else {
            String string = Prefs.get("view3d.initialAnaglyphMode", "default");
            if (string.equalsIgnoreCase("always")) {
                if (this.enableThreeD) {
                    this.setViewStyle(1);
                } else {
                    this.saveViewStyleWhile3DDisabled = 1;
                }
            } else if (string.equalsIgnoreCase("never")) {
                if (this.enableThreeD) {
                    this.setViewStyle(0);
                } else {
                    this.saveViewStyleWhile3DDisabled = 0;
                }
            }
        }
    }

    public void finish() {
        this.setViewStyle(0);
    }

    public void takeExhibit(View view, boolean bl) {
        this.savedBackground = null;
        if (!bl || view.getTransform() == null || !(view.getTransform() instanceof Transform3D)) {
            super.takeExhibit(view, false);
            return;
        }
        if (view instanceof View3D) {
            this.setEnableThreeD(((View3D)view).getEnableThreeD());
        }
        super.takeExhibit(view, true);
        this.transform3D = (Transform3D)this.getTransform();
        if (view instanceof View3D) {
            View3D view3D = (View3D)view;
            if (this.enableThreeD) {
                this.saveTransform2DWhileThreeDEnabled = view3D.saveTransform2DWhileThreeDEnabled;
                this.setViewStyle(view3D.getViewStyle());
            } else {
                this.saveTransform3DWhileThreeDDisabled = view3D.saveTransform3DWhileThreeDDisabled;
                this.saveViewStyleWhile3DDisabled = view3D.saveViewStyleWhile3DDisabled;
            }
        }
    }

    public Transform3D getTransform3D() {
        if (this.getTransform() instanceof Transform3D) {
            return (Transform3D)this.getTransform();
        }
        return null;
    }

    protected Axes2D createAxes() {
        if (this.enableThreeD) {
            return new Axes3D();
        }
        return new Axes2D();
    }

    public MouseTask getDefaultMouseTask() {
        return new BasicMouseTask3D();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.savedBackground = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        if (changeEvent.getSource() instanceof Transform3D) {
            boolean bl = ((Transform3D)changeEvent.getSource()).getOrthographicProjection();
            this.projectionCommands.setSelectedIndex(bl ? 1 : 0);
        }
    }

    public ActionList getViewCommands() {
        ActionList actionList = super.getViewCommands();
        actionList.add(null);
        actionList.add(this.projectionCommands);
        this.projectionCommands.setEnabled(this.enableThreeD);
        actionList.add(null);
        actionList.add(this.viewStyleCommands);
        return actionList;
    }

    public ActionList getSettingsCommands() {
        ActionList actionList = super.getSettingsCommands();
        this.setViewpointAction = new AbstractActionVMM(I18n.tr("vmm.core3D.commands.SetViewpoint")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (View3D.this.getDisplay() != null) {
                    View3D.this.getDisplay().stopAnimation();
                }
                SetViewpointDialog.showDialog(View3D.this);
            }
        };
        this.set3DViewOptionsAction = new AbstractActionVMM(I18n.tr("vmm.core3D.commands.Set3DViewOptions") + "..."){

            public void actionPerformed(ActionEvent actionEvent) {
                if (View3D.this.getDisplay() != null) {
                    View3D.this.getDisplay().stopAnimation();
                }
                Set3DViewOptionsDialog.showDialog(View3D.this);
            }
        };
        actionList.add(this.set3DViewOptionsAction);
        actionList.add(null);
        this.setViewpointAction.setEnabled(this.enableThreeD);
        actionList.add(this.setViewpointAction);
        return actionList;
    }

    protected boolean needsNewOSI(int n, int n2) {
        if (this.viewStyle == 0 || this.viewStyle == 1) {
            return super.needsNewOSI(n, n2);
        }
        return this.leftStereographOSI == null || n != this.saveStereographDisplayWidth || n2 != this.saveStereographDisplayHeight;
    }

    protected void putOSI(Graphics2D graphics2D, int n, int n2) {
        if (this.viewStyle == 0 || this.viewStyle == 1) {
            graphics2D.drawImage((Image)this.fullOSI, 0, 0, null);
        } else {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawRect(this.leftEyeRect.x - 1, this.leftEyeRect.y - 1, this.leftEyeRect.width + 1, this.leftEyeRect.width + 1);
            graphics2D.drawRect(this.rightEyeRect.x - 1, this.rightEyeRect.y - 1, this.rightEyeRect.width + 1, this.rightEyeRect.width + 1);
            graphics2D.drawImage((Image)this.leftStereographOSI, this.leftEyeRect.x, this.leftEyeRect.y, null);
            graphics2D.drawImage((Image)this.rightStereographOSI, this.rightEyeRect.x, this.rightEyeRect.y, null);
            graphics2D.setColor(color);
        }
    }

    protected void createOSI(int n, int n2) {
        this.rightStereographOSI = null;
        this.leftStereographOSI = null;
        this.fullOSI = null;
        if (this.viewStyle == 0) {
            super.createOSI(n, n2);
        } else if (this.viewStyle == 1) {
            if (this.stereoComposite == null) {
                this.stereoComposite = new StereoComposite();
            }
            this.stereoComposite.setSize(n, n2);
            this.fullOSI = this.stereoComposite.getImage();
        } else if (this.viewStyle == 2 || this.viewStyle == 3) {
            if (n != this.saveStereographDisplayWidth || n2 != this.saveStereographDisplayHeight) {
                this.adjustStereographToNewSize(n, n2);
            }
            this.leftStereographOSI = new BufferedImage(this.leftEyeRect.width, this.leftEyeRect.height, this.offscreenImageType);
            this.rightStereographOSI = new BufferedImage(this.leftEyeRect.width, this.leftEyeRect.height, this.offscreenImageType);
            this.fullOSI = this.leftStereographOSI;
        }
    }

    protected void clearOSI() {
        if (this.viewStyle == 0) {
            super.clearOSI();
        } else if (this.viewStyle == 1) {
            Graphics2D graphics2D = this.stereoComposite.getLeftEyeGraphics();
            if (graphics2D != null) {
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight());
                graphics2D.setColor(Color.white);
            }
            graphics2D.dispose();
            graphics2D = this.stereoComposite.getRightEyeGraphics();
            if (graphics2D != null) {
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight());
                graphics2D.setColor(Color.white);
            }
            graphics2D.dispose();
        } else {
            Graphics graphics = this.leftStereographOSI.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.leftEyeRect.width, this.leftEyeRect.height);
            graphics.dispose();
            graphics = this.rightStereographOSI.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.leftEyeRect.width, this.leftEyeRect.height);
            graphics.dispose();
        }
    }

    protected Graphics2D prepareOSIForDrawing() {
        this.viewDirection = this.transform3D.getViewDirection();
        this.viewDirection.negate();
        this.clipZ = this.transform3D.getFocalLength() - this.transform3D.getClipDistance();
        this.eyeSeparationMultiplier = Prefs.getDouble("eyeSeparationMultiplier", 1.0);
        if (this.viewStyle == 0) {
            return super.prepareOSIForDrawing();
        }
        if (this.viewStyle == 1) {
            Graphics2D graphics2D = (Graphics2D)this.stereoComposite.getLeftEyeGraphics().create();
            if (graphics2D != null) {
                graphics2D.setColor(Color.white);
                graphics2D.setBackground(Color.black);
                if (this.getAntialiased()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.getTransform().setUpDrawInfo(graphics2D, 0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight(), this.getPreserveAspect(), this.getApplyGraphics2DTransform());
                this.leftEyeGraphics = graphics2D;
                this.leftEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
            }
            if ((graphics2D = (Graphics2D)this.stereoComposite.getRightEyeGraphics().create()) != null) {
                graphics2D.setColor(Color.white);
                graphics2D.setBackground(Color.black);
                if (this.getAntialiased()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.getTransform().setUpDrawInfo(graphics2D, 0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight(), this.getPreserveAspect(), this.getApplyGraphics2DTransform());
                this.rightEyeGraphics = graphics2D;
                this.rightEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
            }
            graphics2D = (Graphics2D)this.fullOSI.getGraphics();
            this.getTransform().setUpDrawInfo(graphics2D, 0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight(), this.getPreserveAspect(), this.getApplyGraphics2DTransform());
            this.currentGraphics = graphics2D;
            return graphics2D;
        }
        Graphics2D graphics2D = (Graphics2D)this.rightStereographOSI.getGraphics();
        graphics2D.setColor(this.getForeground());
        graphics2D.setBackground(this.getBackground());
        this.getTransform().setUpDrawInfo(graphics2D, 0, 0, this.leftEyeRect.width, this.leftEyeRect.height, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
        if (this.getAntialiased()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.rightEyeGraphics = graphics2D;
        this.rightEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
        graphics2D = (Graphics2D)this.leftStereographOSI.getGraphics();
        if (this.getAntialiased()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setColor(this.getForeground());
        graphics2D.setBackground(this.getBackground());
        this.getTransform().setUpDrawInfo(graphics2D, 0, 0, this.leftEyeRect.width, this.leftEyeRect.height, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
        this.leftEyeGraphics = graphics2D;
        this.leftEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
        this.currentGraphics = graphics2D;
        return graphics2D;
    }

    protected void finishOSIDraw() {
        if (this.viewStyle == 0) {
            super.finishOSIDraw();
        } else {
            this.leftEyeGraphics.dispose();
            this.rightEyeGraphics.dispose();
            if (this.leftEyeUntransformedGraphics != null) {
                this.leftEyeUntransformedGraphics.dispose();
            }
            if (this.rightEyeUntransformedGraphics != null) {
                this.rightEyeUntransformedGraphics.dispose();
            }
            if (this.viewStyle == 1) {
                this.stereoComposite.compose();
            }
        }
    }

    public void addExtraXML(Document document, Element element) {
        super.addExtraXML(document, element);
        Transform transform = this.getSavedAuxiliaryTransformForEnableThreeD();
        if (transform != null) {
            Element element2 = SaveAndRestore.makeTransformElement("savedtransform", document, transform);
            element.appendChild(element2);
        }
    }

    public void readExtraXML(Element element) throws IOException {
        super.readExtraXML(element);
        Element element2 = SaveAndRestore.getChildElement(element, "savedtransform");
        if (element2 != null) {
            Transform transform = SaveAndRestore.buildTransformFromElement(element2);
            this.setSavedAuxiliaryTransformForEnableThreeD(transform);
        }
    }

    public void drawPixel(Vector3D vector3D) {
        Point2D.Double double_ = new Point2D.Double();
        if (this.clip(vector3D)) {
            return;
        }
        if (this.viewStyle == 0) {
            this.transform3D.objectToXYWindowCoords(vector3D, double_);
            this.transform3D.windowToViewport(double_);
            this.drawPixelDirect(null, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
        } else {
            this.setUpForLeftEye();
            this.transform3D.objectToXYWindowCoords(vector3D, double_);
            this.transform3D.windowToViewport(double_);
            this.drawPixelDirect(null, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
            this.setUpForRightEye();
            this.transform3D.objectToXYWindowCoords(vector3D, double_);
            this.transform3D.windowToViewport(double_);
            this.drawPixelDirect(null, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
            this.finishStereoView();
        }
    }

    public void drawDot(Vector3D vector3D, double d) {
        double d2 = d * this.transform3D.getPixelWidth();
        double d3 = d * this.transform3D.getPixelHeight();
        Point2D.Double double_ = new Point2D.Double();
        if (this.viewStyle == 0) {
            this.transform3D.objectToDrawingCoords(vector3D, double_);
            this.currentGraphics.fill(new Ellipse2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - d3 / 2.0, d2, d3));
        } else {
            this.setUpForLeftEye();
            this.transform3D.objectToDrawingCoords(vector3D, double_);
            this.currentGraphics.fill(new Ellipse2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - d3 / 2.0, d2, d3));
            this.setUpForRightEye();
            this.transform3D.objectToDrawingCoords(vector3D, double_);
            this.currentGraphics.fill(new Ellipse2D.Double(((Point2D)double_).getX() - d2 / 2.0, ((Point2D)double_).getY() - d3 / 2.0, d2, d3));
            this.finishStereoView();
        }
    }

    public void drawPixels(Vector3D[] vector3DArray) {
        Point2D.Double double_ = new Point2D.Double();
        if (this.viewStyle == 0) {
            for (int i = 0; i < vector3DArray.length; ++i) {
                if (vector3DArray[i] == null || this.clip(vector3DArray[i])) continue;
                this.transform3D.objectToXYWindowCoords(vector3DArray[i], double_);
                this.transform3D.windowToViewport(double_);
                this.drawPixelDirect(null, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
            }
        } else {
            int n;
            this.setUpForLeftEye();
            for (n = 0; n < vector3DArray.length; ++n) {
                if (vector3DArray[n] == null || this.clip(vector3DArray[n])) continue;
                this.transform3D.objectToXYWindowCoords(vector3DArray[n], double_);
                this.transform3D.windowToViewport(double_);
                this.drawPixelDirect(null, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
            }
            this.setUpForRightEye();
            for (n = 0; n < vector3DArray.length; ++n) {
                if (vector3DArray[n] == null || this.clip(vector3DArray[n])) continue;
                this.transform3D.objectToXYWindowCoords(vector3DArray[n], double_);
                this.transform3D.windowToViewport(double_);
                this.drawPixelDirect(null, (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
            }
            this.finishStereoView();
        }
    }

    public void drawLine(Vector3D vector3D, Vector3D vector3D2) {
        if (this.clip(vector3D) || this.clip(vector3D2)) {
            return;
        }
        if (this.viewStyle == 0) {
            Point2D point2D = this.transform3D.objectToDrawingCoords(vector3D);
            Point2D point2D2 = this.transform3D.objectToDrawingCoords(vector3D2);
            this.currentGraphics.draw(new Line2D.Float(point2D, point2D2));
        } else {
            this.setUpForLeftEye();
            Point2D point2D = this.transform3D.objectToDrawingCoords(vector3D);
            Point2D point2D3 = this.transform3D.objectToDrawingCoords(vector3D2);
            this.currentGraphics.draw(new Line2D.Float(point2D, point2D3));
            this.setUpForRightEye();
            point2D = this.transform3D.objectToDrawingCoords(vector3D);
            point2D3 = this.transform3D.objectToDrawingCoords(vector3D2);
            this.currentGraphics.draw(new Line2D.Float(point2D, point2D3));
            this.finishStereoView();
        }
    }

    public void drawString(String string, Vector3D vector3D) {
        if (this.clip(vector3D)) {
            return;
        }
        if (this.viewStyle == 0) {
            Point2D point2D = this.transform3D.objectToXYWindowCoords(vector3D);
            super.drawString(string, point2D.getX(), point2D.getY());
        } else {
            this.setUpForLeftEye();
            Point2D point2D = this.transform3D.objectToXYWindowCoords(vector3D);
            super.drawString(string, point2D.getX(), point2D.getY());
            this.setUpForRightEye();
            point2D = this.transform3D.objectToXYWindowCoords(vector3D);
            super.drawString(string, point2D.getX(), point2D.getY());
            this.finishStereoView();
        }
    }

    public void drawCurve(Vector3D[] vector3DArray) {
        if (vector3DArray != null) {
            this.drawCurve(vector3DArray, vector3DArray.length);
        }
    }

    public void drawCurve(Vector3D[] vector3DArray, int n) {
        this.drawCurve(vector3DArray, 0, n - 1);
    }

    public void drawCurve(Vector3D[] vector3DArray, int n, int n2) {
        if (vector3DArray == null) {
            return;
        }
        if (n >= vector3DArray.length) {
            n = vector3DArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= vector3DArray.length) {
            n2 = vector3DArray.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 <= n) {
            return;
        }
        Point2D[] point2DArray = new Point2D[n2 - n + 1];
        if (this.viewStyle == 0) {
            for (int i = 0; i < point2DArray.length; ++i) {
                point2DArray[i] = vector3DArray[i - n] == null || this.clip(vector3DArray[i - n]) ? null : this.transform3D.objectToXYWindowCoords(vector3DArray[i - n]);
            }
            super.drawCurve(point2DArray);
        } else {
            int n3;
            this.setUpForLeftEye();
            for (n3 = 0; n3 < point2DArray.length; ++n3) {
                point2DArray[n3] = vector3DArray[n3 - n] == null || this.clip(vector3DArray[n3 - n]) ? null : this.transform3D.objectToXYWindowCoords(vector3DArray[n3 - n]);
            }
            super.drawCurve(point2DArray);
            this.setUpForRightEye();
            for (n3 = 0; n3 < point2DArray.length; ++n3) {
                point2DArray[n3] = vector3DArray[n3 - n] == null || this.clip(vector3DArray[n3 - n]) ? null : this.transform3D.objectToXYWindowCoords(vector3DArray[n3 - n]);
            }
            super.drawCurve(point2DArray);
            this.finishStereoView();
        }
    }

    public void drawCollaredCurve(Vector3D[] vector3DArray, boolean bl) {
        if (vector3DArray != null) {
            this.drawCollaredCurve(vector3DArray, 0, vector3DArray.length - 1, bl);
        }
    }

    public void drawCollaredCurve(Vector3D[] vector3DArray, int n, boolean bl) {
        if (vector3DArray != null) {
            this.drawCollaredCurve(vector3DArray, 0, n - 1, bl);
        }
    }

    public void drawCollaredCurve(Vector3D[] vector3DArray, int n, int n2, boolean bl) {
        if (vector3DArray == null) {
            return;
        }
        if (!bl && this.viewStyle != 0) {
            this.drawCurve(vector3DArray, n, n2);
            return;
        }
        if (n >= vector3DArray.length) {
            n = vector3DArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= vector3DArray.length) {
            n2 = vector3DArray.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 <= n) {
            return;
        }
        if (this.viewStyle == 0) {
            this.drawCollaredCurveDirect(vector3DArray, n, n2, bl);
        } else {
            this.setUpForLeftEye();
            this.drawCollaredCurveDirect(vector3DArray, n, n2, bl);
            this.setUpForRightEye();
            this.drawCollaredCurveDirect(vector3DArray, n, n2, bl);
            this.finishStereoView();
        }
    }

    public void drawWireframeSurface(Grid3D grid3D) {
        if (this.getViewStyle() == 0) {
            grid3D.applyTransform(this.transform3D, this);
            grid3D.drawCurves(this, this.currentGraphics);
        } else {
            this.setUpForLeftEye();
            grid3D.applyTransform(this.transform3D, this);
            grid3D.drawCurves(this, this.currentGraphics);
            this.setUpForRightEye();
            grid3D.applyTransform(this.transform3D, this);
            grid3D.drawCurves(this, this.currentGraphics);
            this.finishStereoView();
        }
    }

    public void drawPixelDirect(Color color, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        if (color == null) {
            color = this.currentGraphics.getColor();
        }
        int n3 = color.getRGB();
        BufferedImage bufferedImage = this.viewStyle == 1 ? (this.currentGraphics == this.leftEyeGraphics ? this.stereoComposite.getLeftEyeImage() : this.stereoComposite.getRightEyeImage()) : (this.viewStyle == 0 ? this.fullOSI : (this.currentGraphics == this.leftEyeGraphics ? this.leftStereographOSI : this.rightStereographOSI));
        if (n >= bufferedImage.getWidth() || n2 >= bufferedImage.getHeight()) {
            return;
        }
        bufferedImage.setRGB(n, n2, n3);
    }

    private void drawCollaredCurveDirect(Vector3D[] vector3DArray, int n, int n2, boolean bl) {
        Stroke stroke;
        Object object = vector3DArray[n] == null ? null : this.transform3D.objectToViewCoords(vector3DArray[n]);
        ArrayList<CurveSegment> arrayList = new ArrayList<CurveSegment>();
        for (int i = n + 1; i <= n2; ++i) {
            Stroke stroke2 = stroke = vector3DArray[i] == null || this.clip(vector3DArray[i]) ? null : this.transform3D.objectToViewCoords(vector3DArray[i]);
            if (object != null && stroke != null) {
                arrayList.add(new CurveSegment((Vector3D)object, (Vector3D)((Object)stroke)));
            }
            object = stroke;
        }
        Collections.sort(arrayList);
        Color color = this.currentGraphics.getColor();
        stroke = this.currentGraphics.getStroke();
        BasicStroke basicStroke = new BasicStroke(this.getTransform().getDefaultStrokeSize() * 5.0f, 0, 0);
        BasicStroke basicStroke2 = new BasicStroke(this.getTransform().getDefaultStrokeSize(), 0, 0);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.currentGraphics.setStroke(basicStroke);
            this.currentGraphics.setColor(bl ? color : this.currentGraphics.getBackground());
            this.currentGraphics.draw((Shape)arrayList.get(i));
            this.currentGraphics.setStroke(basicStroke2);
            this.currentGraphics.setColor(bl ? this.currentGraphics.getBackground() : color);
            this.currentGraphics.draw((Shape)arrayList.get(i));
        }
        this.currentGraphics.setColor(color);
        this.currentGraphics.setStroke(stroke);
    }

    protected void setUpForLeftEye() {
        double d = this.viewStyle == 3 ? 0.04 : (this.viewStyle == 2 ? -0.03 : 0.03);
        this.transform3D.selectLeftEye(d *= this.eyeSeparationMultiplier);
        this.saveGraphicsDuringStereo = this.currentGraphics;
        this.saveUntransformedGraphicsDuringStereo = this.getTransform().getUntransformedGraphics();
        Color color = this.saveGraphicsDuringStereo.getColor();
        this.leftEyeGraphics.setColor(color);
        this.rightEyeGraphics.setColor(color);
        Stroke stroke = this.saveGraphicsDuringStereo.getStroke();
        this.leftEyeGraphics.setStroke(stroke);
        this.rightEyeGraphics.setStroke(stroke);
        Font font = this.saveGraphicsDuringStereo.getFont();
        this.leftEyeGraphics.setFont(font);
        this.rightEyeGraphics.setFont(font);
        this.transform3D.useGraphics(this.leftEyeGraphics, this.leftEyeUntransformedGraphics);
        this.currentGraphics = this.leftEyeGraphics;
    }

    protected void setUpForRightEye() {
        double d = this.viewStyle == 3 ? 0.04 : (this.viewStyle == 2 ? -0.03 : 0.03);
        this.transform3D.selectRightEye(d *= this.eyeSeparationMultiplier);
        this.transform3D.useGraphics(this.rightEyeGraphics, this.rightEyeUntransformedGraphics);
        this.currentGraphics = this.rightEyeGraphics;
    }

    protected void finishStereoView() {
        this.transform3D.selectNoEye();
        this.transform3D.useGraphics(this.saveGraphicsDuringStereo, this.saveUntransformedGraphicsDuringStereo);
        this.currentGraphics = this.saveGraphicsDuringStereo;
        this.saveGraphicsDuringStereo = null;
        this.saveUntransformedGraphicsDuringStereo = null;
    }

    public final boolean clip(Vector3D vector3D) {
        return vector3D.dot(this.viewDirection) > this.clipZ;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurveSegment
    extends Line2D.Double
    implements Comparable<CurveSegment> {
        Vector3D v1;
        Vector3D v2;
        double midpoint_z;

        CurveSegment(Vector3D vector3D, Vector3D vector3D2) {
            this.v1 = vector3D;
            this.v2 = vector3D2;
            this.midpoint_z = (vector3D.z + vector3D2.z) / 2.0;
            Point2D.Double double_ = new Point2D.Double(vector3D.x, vector3D.y);
            Point2D.Double double_2 = new Point2D.Double(vector3D2.x, vector3D2.y);
            if (!View3D.this.getTransform().appliedTransform2D()) {
                View3D.this.getTransform().windowToViewport(double_);
                View3D.this.getTransform().windowToViewport(double_2);
            }
            this.setLine(double_, double_2);
        }

        @Override
        public int compareTo(CurveSegment curveSegment) {
            if (this.midpoint_z < curveSegment.midpoint_z) {
                return -1;
            }
            if (this.midpoint_z > curveSegment.midpoint_z) {
                return 1;
            }
            return 0;
        }
    }
}

