/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vmm.core.Util;

public class Vector3D {
    public double x;
    public double y;
    public double z;
    public static final Vector3D ORIGIN = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D UNIT_X = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D UNIT_Y = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D UNIT_Z = new Vector3D(0.0, 0.0, 1.0);

    public Vector3D() {
    }

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(Vector3D vector3D) {
        if (vector3D == null) {
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        } else {
            this.x = vector3D.x;
            this.y = vector3D.y;
            this.z = vector3D.z;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(Vector3D.class)) {
            return false;
        }
        Vector3D vector3D = (Vector3D)object;
        return vector3D.x == this.x && vector3D.y == this.y && vector3D.z == this.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        double d = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.z = Double.NaN;
            this.y = Double.NaN;
            this.x = Double.NaN;
        } else {
            this.x *= d;
            this.y *= d;
            this.z *= d;
        }
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Vector3D normalized() {
        Vector3D vector3D = new Vector3D(this.x, this.y, this.z);
        vector3D.normalize();
        return vector3D;
    }

    public Vector3D negated() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D plus(Vector3D vector3D) {
        return new Vector3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public Vector3D linComb(double d, double d2, Vector3D vector3D) {
        return new Vector3D(d * this.x + d2 * vector3D.x, d * this.y + d2 * vector3D.y, d * this.z + d2 * vector3D.z);
    }

    public void assign(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public void assignPlus(Vector3D vector3D) {
        this.x += vector3D.x;
        this.y += vector3D.y;
        this.z += vector3D.z;
    }

    public void assignSum(Vector3D vector3D, Vector3D vector3D2) {
        this.x = vector3D.x + vector3D2.x;
        this.y = vector3D.y + vector3D2.y;
        this.z = vector3D.z + vector3D2.z;
    }

    public void assignLinComb(double d, double d2, Vector3D vector3D) {
        this.x = d * this.x + d2 * vector3D.x;
        this.y = d * this.y + d2 * vector3D.y;
        this.z = d * this.z + d2 * vector3D.z;
    }

    public void assignLinComb(double d, Vector3D vector3D, double d2, Vector3D vector3D2) {
        this.x = d * vector3D.x + d2 * vector3D2.x;
        this.y = d * vector3D.y + d2 * vector3D2.y;
        this.z = d * vector3D.z + d2 * vector3D2.z;
    }

    public void assignPlus_SumTimes(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, double d) {
        this.x += d * (vector3D.x + vector3D2.x + vector3D3.x + vector3D4.x);
        this.y += d * (vector3D.y + vector3D2.y + vector3D3.y + vector3D4.y);
        this.z += d * (vector3D.z + vector3D2.z + vector3D3.z + vector3D4.z);
    }

    public Vector3D minus(Vector3D vector3D) {
        return new Vector3D(this.x - vector3D.x, this.y - vector3D.y, this.z - vector3D.z);
    }

    public void assignMinus(Vector3D vector3D) {
        this.x -= vector3D.x;
        this.y -= vector3D.y;
        this.z -= vector3D.z;
    }

    public void assignMinus(Vector3D vector3D, Vector3D vector3D2) {
        this.x = vector3D.x - vector3D2.x;
        this.y = vector3D.y - vector3D2.y;
        this.z = vector3D.z - vector3D2.z;
    }

    public Vector3D times(double d) {
        return new Vector3D(d * this.x, d * this.y, d * this.z);
    }

    public void assignTimes(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public void assignTimes(double d, Vector3D vector3D) {
        this.x = d * vector3D.x;
        this.y = d * vector3D.y;
        this.z = d * vector3D.z;
    }

    public void assignSumTimes(Vector3D vector3D, Vector3D vector3D2, double d) {
        this.x = d * (vector3D.x + vector3D2.x);
        this.y = d * (vector3D.y + vector3D2.y);
        this.z = d * (vector3D.z + vector3D2.z);
    }

    public void assignSumTimes(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, double d) {
        this.x = d * (vector3D.x + vector3D2.x + vector3D3.x + vector3D4.x);
        this.y = d * (vector3D.y + vector3D2.y + vector3D3.y + vector3D4.y);
        this.z = d * (vector3D.z + vector3D2.z + vector3D3.z + vector3D4.z);
    }

    public double dot(Vector3D vector3D) {
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public Vector3D cross(Vector3D vector3D) {
        double d = this.y * vector3D.z - vector3D.y * this.z;
        double d2 = -(this.x * vector3D.z) + vector3D.x * this.z;
        double d3 = this.x * vector3D.y - vector3D.x * this.y;
        return new Vector3D(d, d2, d3);
    }

    public Vector3D reflectInAxis(Vector3D vector3D) {
        double d = 2.0 * (vector3D.x * this.x + vector3D.y * this.y + vector3D.z * this.z);
        Vector3D vector3D2 = new Vector3D(d * vector3D.x - this.x, d * vector3D.y - this.y, d * vector3D.z - this.z);
        return vector3D2;
    }

    public String toString() {
        String string = Util.toExternalString(this.x);
        String string2 = Util.toExternalString(this.y);
        String string3 = Util.toExternalString(this.z);
        return "(" + string + "," + string2 + "," + string3 + ")";
    }

    public static Vector3D fromString(String string) throws NumberFormatException {
        try {
            Matcher matcher = Pattern.compile("\\((.*),(.*),(.*)\\)").matcher(string);
            if (!matcher.matches() && !(matcher = Pattern.compile("(.*) (.*) (.*)").matcher(string.trim())).matches()) {
                throw new Exception();
            }
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            double d = (Double)Util.externalStringToValue(string2, Double.TYPE);
            double d2 = (Double)Util.externalStringToValue(string3, Double.TYPE);
            double d3 = (Double)Util.externalStringToValue(string4, Double.TYPE);
            return new Vector3D(d, d2, d3);
        }
        catch (Exception exception) {
            throw new NumberFormatException("Can't convert string to Vector3D");
        }
    }
}

