/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core3D.Vector3D;

public class Transform3D
extends Transform {
    @VMMSave
    private Vector3D viewPoint;
    @VMMSave
    private double clipDistance;
    @VMMSave
    private Vector3D imagePlaneYDirection = new Vector3D(0.0, 0.0, 1.0);
    @VMMSave
    private boolean orthographicProjection = false;
    private Vector3D viewDirection;
    private double focalLength;
    private Vector3D imagePlaneXDirection;
    private Vector3D tempVector = new Vector3D();
    private Vector3D saveViewDirection;
    private Vector3D saveImagePlaneXDirection;
    private Vector3D saveImagePlaneYDirection;
    private Vector3D saveViewPoint;
    private double objectDisplacementNormalToScreen;

    public Transform3D() {
        this(null, -5.0, 5.0, -5.0, 5.0);
    }

    public Transform3D(Vector3D vector3D) {
        this(vector3D, -5.0, 5.0, -5.0, 5.0);
    }

    public Transform3D(Vector3D vector3D, double d) {
        super(d);
        this.setViewPoint(vector3D);
    }

    public Transform3D(Vector3D vector3D, double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.setViewPoint(vector3D);
    }

    public Transform3D(Transform transform) {
        super(transform);
        if (transform instanceof Transform3D) {
            Transform3D transform3D = (Transform3D)transform;
            this.viewPoint = new Vector3D(transform3D.viewPoint);
            this.viewDirection = new Vector3D(transform3D.viewDirection);
            this.imagePlaneXDirection = new Vector3D(transform3D.imagePlaneXDirection);
            this.imagePlaneYDirection = new Vector3D(transform3D.imagePlaneYDirection);
            this.orthographicProjection = transform3D.orthographicProjection;
            this.clipDistance = transform3D.clipDistance;
            this.focalLength = transform3D.focalLength;
        }
    }

    public boolean getOrthographicProjection() {
        return this.orthographicProjection;
    }

    public void setOrthographicProjection(boolean bl) {
        if (this.orthographicProjection == bl) {
            return;
        }
        this.orthographicProjection = bl;
        this.fireTransformChangeEvent();
    }

    public void setViewPoint(Vector3D vector3D) {
        this.viewPoint = vector3D == null ? (vector3D = new Vector3D(20.0, 0.0, 0.0)) : new Vector3D(vector3D);
        this.viewDirection = new Vector3D(this.viewPoint);
        this.viewDirection.normalize();
        this.viewDirection.negate();
        this.focalLength = vector3D.norm();
        this.clipDistance = 0.25 * this.focalLength;
        this.saveViewPoint = new Vector3D(vector3D);
        this.saveViewDirection = new Vector3D(this.viewDirection);
        this.setImagePlaneYDirection(this.imagePlaneYDirection);
    }

    public Vector3D getViewPoint() {
        return new Vector3D(this.viewPoint);
    }

    public double getClipDistance() {
        return this.clipDistance;
    }

    public void setClipDistance(double d) {
        if (this.clipDistance == d) {
            return;
        }
        this.clipDistance = d;
        this.fireTransformChangeEvent();
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public double getObjectDisplacementNormalToScreen() {
        return this.objectDisplacementNormalToScreen;
    }

    public void setObjectDisplacementNormalToScreen(double d) {
        if (d < -0.75 * this.focalLength) {
            d = -0.75 * this.focalLength;
        } else if (d > 0.75 * this.focalLength) {
            d = 0.75 * this.focalLength;
        }
        if (this.objectDisplacementNormalToScreen == d) {
            return;
        }
        this.objectDisplacementNormalToScreen = d;
        System.out.println("ObjectDisplacementNormalToScreen = " + d);
        this.fireTransformChangeEvent();
    }

    public Vector3D getImagePlaneXDirection() {
        return new Vector3D(this.imagePlaneXDirection);
    }

    public Vector3D getImagePlaneYDirection() {
        return new Vector3D(this.imagePlaneYDirection);
    }

    public Vector3D getViewDirection() {
        return new Vector3D(this.viewDirection);
    }

    public void setImagePlaneYDirection(Vector3D vector3D) {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
        double d = this.viewDirection.dot(vector3D);
        this.imagePlaneYDirection = new Vector3D(vector3D.x - d * this.viewDirection.x, vector3D.y - d * this.viewDirection.y, vector3D.z - d * this.viewDirection.z);
        if (this.imagePlaneYDirection.norm() < 1.0E-5) {
            this.imagePlaneYDirection = new Vector3D(-this.viewDirection.z * this.viewDirection.x, -this.viewDirection.z * this.viewDirection.y, 1.0 - this.viewDirection.z * this.viewDirection.z);
        }
        if (this.imagePlaneYDirection.norm() < 1.0E-5) {
            this.imagePlaneYDirection = new Vector3D(-this.viewDirection.y * this.viewDirection.x, 1.0 - this.viewDirection.y * this.viewDirection.y, -this.viewDirection.y * this.viewDirection.z);
        }
        this.imagePlaneYDirection.normalize();
        this.imagePlaneXDirection = this.viewDirection.cross(this.imagePlaneYDirection);
        this.saveImagePlaneXDirection = new Vector3D(this.imagePlaneXDirection);
        this.saveImagePlaneYDirection = new Vector3D(this.imagePlaneYDirection);
        this.fireTransformChangeEvent();
    }

    public void applyTransvection(Vector3D vector3D, Vector3D vector3D2) {
        Vector3D vector3D3 = new Vector3D(vector3D.x + vector3D2.x, vector3D.y + vector3D2.y, vector3D.z + vector3D2.z);
        vector3D3.normalize();
        Vector3D vector3D4 = new Vector3D();
        this.reflectInAxis(vector3D3, this.saveViewDirection, vector3D4);
        this.reflectInAxis(vector3D, vector3D4, this.saveViewDirection);
        this.reflectInAxis(vector3D3, this.saveImagePlaneXDirection, vector3D4);
        this.reflectInAxis(vector3D, vector3D4, this.saveImagePlaneXDirection);
        this.reflectInAxis(vector3D3, this.saveImagePlaneYDirection, vector3D4);
        this.reflectInAxis(vector3D, vector3D4, this.saveImagePlaneYDirection);
        double d = this.saveViewPoint.norm();
        this.saveViewPoint.x = -d * this.saveViewDirection.x;
        this.saveViewPoint.y = -d * this.saveViewDirection.y;
        this.saveViewPoint.z = -d * this.saveViewDirection.z;
        this.selectNoEye();
        this.fireTransformChangeEvent();
    }

    private void doTransvection(Vector3D vector3D, Vector3D vector3D2) {
        Vector3D vector3D3 = new Vector3D(vector3D.x + vector3D2.x, vector3D.y + vector3D2.y, vector3D.z + vector3D2.z);
        vector3D3.normalize();
        Vector3D vector3D4 = new Vector3D();
        this.reflectInAxis(vector3D3, this.viewDirection, vector3D4);
        this.reflectInAxis(vector3D, vector3D4, this.viewDirection);
        this.reflectInAxis(vector3D3, this.imagePlaneXDirection, vector3D4);
        this.reflectInAxis(vector3D, vector3D4, this.imagePlaneXDirection);
        this.reflectInAxis(vector3D3, this.imagePlaneYDirection, vector3D4);
        this.reflectInAxis(vector3D, vector3D4, this.imagePlaneYDirection);
        double d = this.viewPoint.norm();
        this.viewPoint.x = -d * this.viewDirection.x;
        this.viewPoint.y = -d * this.viewDirection.y;
        this.viewPoint.z = -d * this.viewDirection.z;
    }

    private void reflectInAxis(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        double d = 2.0 * (vector3D.x * vector3D2.x + vector3D.y * vector3D2.y + vector3D.z * vector3D2.z);
        vector3D3.x = d * vector3D.x - vector3D2.x;
        vector3D3.y = d * vector3D.y - vector3D2.y;
        vector3D3.z = d * vector3D.z - vector3D2.z;
    }

    void selectLeftEye(double d) {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.imagePlaneXDirection = new Vector3D(this.saveImagePlaneXDirection);
        this.imagePlaneYDirection = new Vector3D(this.saveImagePlaneYDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
        Vector3D vector3D = this.imagePlaneXDirection.times(d);
        Vector3D vector3D2 = this.viewDirection.plus(vector3D);
        vector3D2.normalize();
        this.doTransvection(this.viewDirection, vector3D2);
    }

    void selectRightEye(double d) {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.imagePlaneXDirection = new Vector3D(this.saveImagePlaneXDirection);
        this.imagePlaneYDirection = new Vector3D(this.saveImagePlaneYDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
        Vector3D vector3D = this.imagePlaneXDirection.times(d);
        Vector3D vector3D2 = this.viewDirection.minus(vector3D);
        vector3D2.normalize();
        this.doTransvection(this.viewDirection, vector3D2);
    }

    void selectNoEye() {
        this.viewDirection = new Vector3D(this.saveViewDirection);
        this.imagePlaneXDirection = new Vector3D(this.saveImagePlaneXDirection);
        this.imagePlaneYDirection = new Vector3D(this.saveImagePlaneYDirection);
        this.viewPoint = new Vector3D(this.saveViewPoint);
    }

    public boolean equals(Object object) {
        if (object == null || !Transform3D.class.equals(object.getClass())) {
            return false;
        }
        Transform3D transform3D = (Transform3D)object;
        return this.hasSameProjection(transform3D) && this.hasSameViewTransform(transform3D);
    }

    public boolean hasSameProjection(Transform3D transform3D) {
        if (transform3D == null) {
            return false;
        }
        return this.orthographicProjection == transform3D.orthographicProjection && this.clipDistance == transform3D.clipDistance && this.viewPoint.equals(transform3D.viewPoint) && this.imagePlaneYDirection.equals(transform3D.imagePlaneYDirection);
    }

    public Object clone() {
        Transform3D transform3D = (Transform3D)super.clone();
        transform3D.viewPoint = new Vector3D(this.viewPoint);
        transform3D.viewDirection = new Vector3D(this.viewDirection);
        transform3D.imagePlaneXDirection = new Vector3D(this.imagePlaneXDirection);
        transform3D.imagePlaneYDirection = new Vector3D(this.imagePlaneYDirection);
        return transform3D;
    }

    void useGraphics(Graphics2D graphics2D, Graphics2D graphics2D2) {
        this.g = graphics2D;
        this.untransformedGraphics = graphics2D2;
    }

    public void objectToViewCoords(Vector3D vector3D, Vector3D vector3D2) {
        double d = vector3D.x;
        double d2 = vector3D.y;
        double d3 = vector3D.z;
        if (this.objectDisplacementNormalToScreen != 0.0) {
            d -= this.objectDisplacementNormalToScreen * this.saveViewDirection.x;
            d2 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.y;
            d3 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.z;
        }
        if (this.orthographicProjection) {
            vector3D2.x = d * this.imagePlaneXDirection.x + d2 * this.imagePlaneXDirection.y + d3 * this.imagePlaneXDirection.z;
            vector3D2.y = d * this.imagePlaneYDirection.x + d2 * this.imagePlaneYDirection.y + d3 * this.imagePlaneYDirection.z;
        } else {
            double d4 = d - this.viewPoint.x;
            double d5 = d2 - this.viewPoint.y;
            double d6 = d3 - this.viewPoint.z;
            double d7 = d4 * this.viewDirection.x + d5 * this.viewDirection.y + d6 * this.viewDirection.z;
            d4 = this.focalLength / d7 * d4;
            d5 = this.focalLength / d7 * d5;
            d6 = this.focalLength / d7 * d6;
            vector3D2.x = (d4 += this.viewPoint.x) * this.imagePlaneXDirection.x + (d5 += this.viewPoint.y) * this.imagePlaneXDirection.y + (d6 += this.viewPoint.z) * this.imagePlaneXDirection.z;
            vector3D2.y = d4 * this.imagePlaneYDirection.x + d5 * this.imagePlaneYDirection.y + d6 * this.imagePlaneYDirection.z;
        }
        vector3D2.z = -(d * this.viewDirection.x + d2 * this.viewDirection.y + d3 * this.viewDirection.z);
    }

    public Vector3D objectToViewCoords(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D();
        this.objectToViewCoords(vector3D, vector3D2);
        return vector3D2;
    }

    public void objectToXYWindowCoords(Vector3D vector3D, Point2D point2D) {
        this.objectToViewCoords(vector3D, this.tempVector);
        point2D.setLocation(this.tempVector.x, this.tempVector.y);
    }

    public Point2D objectToXYWindowCoords(Vector3D vector3D) {
        Point2D.Double double_ = new Point2D.Double();
        this.objectToXYWindowCoords(vector3D, double_);
        return double_;
    }

    public void objectToDrawingCoords(Vector3D vector3D, Point2D point2D) {
        this.objectToXYWindowCoords(vector3D, point2D);
        this.windowToDrawingCoords(point2D);
    }

    public Point2D objectToDrawingCoords(Vector3D vector3D) {
        Point2D.Double double_ = new Point2D.Double();
        this.objectToXYWindowCoords(vector3D, double_);
        this.windowToDrawingCoords(double_);
        return double_;
    }

    public double objectToViewZ(Vector3D vector3D) {
        double d = vector3D.x;
        double d2 = vector3D.y;
        double d3 = vector3D.z;
        if (this.objectDisplacementNormalToScreen != 0.0) {
            d -= this.objectDisplacementNormalToScreen * this.saveViewDirection.x;
            d2 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.y;
            d3 -= this.objectDisplacementNormalToScreen * this.saveViewDirection.z;
        }
        return -(d * this.viewDirection.x + d2 * this.viewDirection.y + d3 * this.viewDirection.z);
    }
}

