/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class StereoComposite {
    private int width;
    private int height;
    private BufferedImage view;
    private BufferedImage leftEyeView;
    private BufferedImage rightEyeView;
    private int chunkSize;
    private int[] leftSamples;
    private int[] rightSamples;
    private int[] viewInts;

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.chunkSize = 10000 / n;
        if (this.chunkSize < 1) {
            this.chunkSize = 1;
        }
        this.rightEyeView = null;
        this.leftEyeView = null;
        this.view = null;
        this.viewInts = null;
        this.rightSamples = null;
        this.leftSamples = null;
        try {
            this.leftEyeView = new BufferedImage(n, n2, 10);
            this.rightEyeView = new BufferedImage(n, n2, 10);
            this.view = new BufferedImage(n, n2, 1);
            this.leftSamples = new int[this.chunkSize * n];
            this.rightSamples = new int[this.chunkSize * n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.rightEyeView = null;
            this.leftEyeView = null;
            this.view = null;
            this.rightSamples = null;
            this.leftSamples = null;
            throw outOfMemoryError;
        }
        WritableRaster writableRaster = this.view.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        this.viewInts = dataBufferInt.getData();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void releaseMemory() {
        this.rightEyeView = null;
        this.leftEyeView = null;
        this.view = null;
        this.viewInts = null;
        this.rightSamples = null;
        this.leftSamples = null;
        this.height = 0;
        this.width = 0;
    }

    public Graphics2D getLeftEyeGraphics() {
        return this.leftEyeView == null ? null : (Graphics2D)this.leftEyeView.getGraphics();
    }

    public Graphics2D getRightEyeGraphics() {
        return this.rightEyeView == null ? null : (Graphics2D)this.rightEyeView.getGraphics();
    }

    public BufferedImage getLeftEyeImage() {
        return this.leftEyeView;
    }

    public BufferedImage getRightEyeImage() {
        return this.rightEyeView;
    }

    public BufferedImage getImage() {
        return this.view;
    }

    public void compose() {
        Raster raster = this.leftEyeView.getData();
        Raster raster2 = this.rightEyeView.getData();
        for (int i = 0; i < this.height; i += this.chunkSize) {
            int n = this.chunkSize;
            if (i + n > this.height) {
                n = this.height - i;
            }
            int n2 = n * this.width;
            int n3 = i * this.width;
            raster.getSamples(0, i, this.width, n, 0, this.leftSamples);
            raster2.getSamples(0, i, this.width, n, 0, this.rightSamples);
            for (int j = 0; j < n2; ++j) {
                this.viewInts[j + n3] = (this.rightSamples[j] << 16) + (this.leftSamples[j] << 8);
            }
        }
    }
}

