/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.SettingsDialog;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class SetViewpointDialog
extends SettingsDialog {
    private View3D view;
    private RealParam viewX;
    private RealParam viewY;
    private RealParam viewZ;
    private RealParam upX;
    private RealParam upY;
    private RealParam upZ;
    private RealParam clipdist;
    private ParameterInput[] inputs;
    private JRadioButton useDefaultClip;
    private JRadioButton useCustomClip;

    public static void showDialog(View3D view3D) {
        new SetViewpointDialog(view3D).setVisible(true);
    }

    private SetViewpointDialog(View3D view3D) {
        super(view3D.getDisplay(), I18n.tr("vmm.core3D.commands.SetViewpoint"));
        this.view = view3D;
        Vector3D vector3D = view3D.getViewPoint();
        Vector3D vector3D2 = view3D.getViewUp();
        Vector3D vector3D3 = vector3D;
        Vector3D vector3D4 = vector3D2;
        if (view3D.getExhibit() != null && view3D.getExhibit() instanceof Exhibit3D) {
            vector3D3 = ((Exhibit3D)view3D.getExhibit()).getDefaultViewpoint();
            vector3D4 = Vector3D.UNIT_Z;
        }
        this.viewX = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.ViewpointComponent", "x"), vector3D.x);
        this.viewX.setDefaultValue(vector3D3.x);
        this.viewY = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.ViewpointComponent", "y"), vector3D.y);
        this.viewY.setDefaultValue(vector3D3.y);
        this.viewZ = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.ViewpointComponent", "z"), vector3D.z);
        this.viewZ.setDefaultValue(vector3D3.z);
        this.upX = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.UpDirectionComponent", "x"), vector3D2.x);
        this.upX.setDefaultValue(vector3D4.x);
        this.upY = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.UpDirectionComponent", "y"), vector3D2.y);
        this.upY.setDefaultValue(vector3D4.y);
        this.upZ = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.UpDirectionComponent", "z"), vector3D2.z);
        this.upZ.setDefaultValue(vector3D4.z);
        this.clipdist = new RealParam(I18n.tr("vmm.core3D.SetViewpointDialog.ClipDistance"), 0.0);
        this.clipdist.setMinimumValueForInput(Double.MIN_VALUE);
        this.inputs = new ParameterInput[7];
        this.inputs[0] = new ParameterInput(this.viewX);
        this.inputs[1] = new ParameterInput(this.viewY);
        this.inputs[2] = new ParameterInput(this.viewZ);
        this.inputs[3] = new ParameterInput(this.upX);
        this.inputs[4] = new ParameterInput(this.upY);
        this.inputs[5] = new ParameterInput(this.upZ);
        this.inputs[6] = new ParameterInput(this.clipdist);
        this.inputs[6].setEditable(false);
        this.inputs[6].setEnabled(false);
        for (int i = 0; i < 7; ++i) {
            this.inputs[i].setColumns(7);
        }
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(8));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        box.add(jPanel);
        box.add(Box.createVerticalStrut(10));
        box.add(jPanel2);
        jPanel.add(new JLabel(I18n.tr("vmm.core3D.SetViewpointDialog.ViewFrom")));
        jPanel.add(new JLabel(" ( "));
        jPanel.add(this.inputs[0]);
        jPanel.add(new JLabel(" , "));
        jPanel.add(this.inputs[1]);
        jPanel.add(new JLabel(" , "));
        jPanel.add(this.inputs[2]);
        jPanel.add(new JLabel(" ) "));
        jPanel2.add(new JLabel(I18n.tr("vmm.core3D.SetViewpointDialog.UpDirection")));
        jPanel2.add(new JLabel(" ( "));
        jPanel2.add(this.inputs[3]);
        jPanel2.add(new JLabel(" , "));
        jPanel2.add(this.inputs[4]);
        jPanel2.add(new JLabel(" , "));
        jPanel2.add(this.inputs[5]);
        jPanel2.add(new JLabel(" ) "));
        box.add(Box.createVerticalStrut(20));
        JLabel jLabel = new JLabel(I18n.tr("vmm.core3D.SetViewpointDialog.ClipDistance") + ":");
        box.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.useDefaultClip = new JRadioButton(I18n.tr("vmm.core3D.SetViewpointDialog.UseDefaultClip"));
        this.useCustomClip = new JRadioButton(I18n.tr("vmm.core3D.SetViewpointDialog.UseCustomClip") + ":");
        buttonGroup.add(this.useDefaultClip);
        buttonGroup.add(this.useCustomClip);
        this.useDefaultClip.setSelected(true);
        this.useCustomClip.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = SetViewpointDialog.this.useCustomClip.isSelected();
                SetViewpointDialog.this.inputs[6].setEditable(bl);
                SetViewpointDialog.this.inputs[6].setEnabled(bl);
                if (bl) {
                    SetViewpointDialog.this.inputs[6].selectAll();
                    SetViewpointDialog.this.inputs[6].requestFocus();
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(Box.createHorizontalStrut(30));
        jPanel3.add(this.useDefaultClip);
        box.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(Box.createHorizontalStrut(30));
        jPanel4.add(this.useCustomClip);
        jPanel4.add(Box.createHorizontalStrut(15));
        jPanel4.add(this.inputs[6]);
        box.add(jPanel4);
        jPanel.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jLabel.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        this.addInputPanel(box);
    }

    protected boolean doOK() {
        String string;
        int n;
        for (n = 0; n < 6; ++n) {
            String string2 = this.inputs[n].checkContents();
            if (string2 == null) continue;
            JOptionPane.showMessageDialog(this, string2, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        if (this.useCustomClip.isSelected() && (string = this.inputs[6].checkContents()) != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        for (n = 0; n < 6; ++n) {
            this.inputs[n].setValueFromContents();
        }
        Vector3D vector3D = new Vector3D(this.viewX.getValue(), this.viewY.getValue(), this.viewZ.getValue());
        if (vector3D.norm() < 1.0E-10) {
            JOptionPane.showMessageDialog(this, I18n.tr("vmm.core3D.SetViewpointDialog.BadViewpointError"), I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        this.view.setViewPoint(vector3D);
        this.view.setViewUp(new Vector3D(this.upX.getValue(), this.upY.getValue(), this.upZ.getValue()));
        if (this.useCustomClip.isSelected() && this.view.getTransform3D() != null) {
            this.inputs[6].setValueFromContents();
            this.view.getTransform3D().setClipDistance(this.clipdist.getValue());
        }
        return true;
    }

    protected void doDefaults() {
        for (int i = 0; i < 6; ++i) {
            this.inputs[i].defaultVal();
        }
        this.useDefaultClip.setSelected(true);
    }
}

