/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import vmm.core.I18n;
import vmm.core.SettingsDialog;
import vmm.core3D.View3DLit;

public class SetTransparencyDialog
extends SettingsDialog {
    private View3DLit view;
    private JSlider slider;
    private int originalPosition;

    public static void showDialog(View3DLit view3DLit) {
        new SetTransparencyDialog(view3DLit).setVisible(true);
    }

    private SetTransparencyDialog(View3DLit view3DLit) {
        super(view3DLit.getDisplay(), I18n.tr("vmm.core3D.commands.setTransparency"));
        this.view = view3DLit;
        double d = view3DLit.getTransparency();
        this.originalPosition = (int)(255.0 * d);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.slider = new JSlider(0, 255, this.originalPosition);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(0, new JLabel(I18n.tr("vmm.core3D.SetTransparencyDialog.Opaque")));
        hashtable.put(255, new JLabel(I18n.tr("vmm.core3D.SetTransparencyDialog.Transparent")));
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintLabels(true);
        jPanel.add((Component)this.slider, "Center");
        this.addInfoLabel(I18n.tr("vmm.core3D.SetTransparencyDialog.info"));
        this.addInputPanel(jPanel);
    }

    protected boolean doOK() {
        int n = this.slider.getValue();
        if (n != this.originalPosition) {
            double d = n <= 10 ? 0.0 : (double)n / 255.0;
            this.view.setTransparency(d);
            this.originalPosition = n;
        }
        return true;
    }

    protected void doDefaults() {
        this.slider.setValue(0);
    }
}

