/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.Prefs;
import vmm.core.RealParam;
import vmm.core.SettingsDialog;
import vmm.core3D.View3D;

public class Set3DViewOptionsDialog
extends SettingsDialog {
    private View3D view;
    private RealParam multiplier;
    private ParameterInput input;
    private double originalVal;
    private JRadioButton alwaysAnaglyphButton;
    private JRadioButton neverAnaglyphButton;
    private JRadioButton defaultAnaglyphButton;
    private String originalAnaglyph;
    private JCheckBox moveObjectsForwardInAnaglyphToggle;
    private boolean originalMoveObjectsForwardInAnaglyph;

    public static void showDialog(View3D view3D) {
        new Set3DViewOptionsDialog(view3D).setVisible(true);
    }

    private Set3DViewOptionsDialog(View3D view3D) {
        super(view3D.getDisplay(), I18n.tr("vmm.core3D.commands.SetEyeSep"));
        this.view = view3D;
        this.originalVal = Prefs.getDouble("eyeSeparationMultiplier", 1.0);
        this.multiplier = new RealParam(I18n.tr("vmm.core3D.SetEyeSepDialog.EyeSep"), this.originalVal);
        this.multiplier.setDefaultValue(1.0);
        this.multiplier.setMinimumValueForInput(0.1);
        this.multiplier.setMaximumValueForInput(10.0);
        this.input = new ParameterInput(this.multiplier);
        this.input.setColumns(5);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createVerticalBox();
        Box box4 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        box3.setAlignmentX(0.0f);
        box.add(box2);
        box.add(Box.createVerticalStrut(12));
        box.add(box3);
        box.add(Box.createVerticalStrut(12));
        box.add(box4);
        box2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.SetEyeSepMul")), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        box3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.SetViewModePref")), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        box4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.SetAnaglyphObjectPosition")), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JLabel jLabel = new JLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.EyeSep.info"));
        jLabel.setAlignmentX(0.0f);
        box2.add(jLabel);
        box3.add(Box.createVerticalStrut(18));
        JPanel jPanel = new JPanel();
        jLabel = new JLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.EyeSepMul") + " = ");
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        box2.add(jPanel);
        jPanel.add(this.input);
        jPanel.setAlignmentX(0.0f);
        this.originalAnaglyph = Prefs.get("view3d.initialAnaglyphMode", "default");
        this.alwaysAnaglyphButton = new JRadioButton(I18n.tr("vmm.core3D.SetAnaglyphDefaultMode.always"));
        this.neverAnaglyphButton = new JRadioButton(I18n.tr("vmm.core3D.SetAnaglyphDefaultMode.never"));
        this.defaultAnaglyphButton = new JRadioButton(I18n.tr("vmm.core3D.SetAnaglyphDefaultMode.default"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.alwaysAnaglyphButton);
        buttonGroup.add(this.neverAnaglyphButton);
        buttonGroup.add(this.defaultAnaglyphButton);
        if (this.originalAnaglyph.equalsIgnoreCase("always")) {
            this.alwaysAnaglyphButton.setSelected(true);
        } else if (this.originalAnaglyph.equalsIgnoreCase("never")) {
            this.neverAnaglyphButton.setSelected(true);
        } else {
            this.defaultAnaglyphButton.setSelected(true);
        }
        jLabel = new JLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.AnaglyphPref.info"));
        box3.add(jLabel);
        box3.add(Box.createVerticalStrut(12));
        box3.add(this.defaultAnaglyphButton);
        box3.add(this.alwaysAnaglyphButton);
        box3.add(this.neverAnaglyphButton);
        this.moveObjectsForwardInAnaglyphToggle = new JCheckBox(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.AnaglyphPositionOption"));
        this.originalMoveObjectsForwardInAnaglyph = "yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"));
        this.moveObjectsForwardInAnaglyphToggle.setSelected(this.originalMoveObjectsForwardInAnaglyph);
        box4.add(Box.createVerticalStrut(2));
        box4.add(this.moveObjectsForwardInAnaglyphToggle);
        this.addInfoLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.info"));
        this.addInputPanel(box);
    }

    protected boolean doOK() {
        String string = this.input.checkContents();
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        this.input.setValueFromContents();
        double d = this.multiplier.getValue();
        if (d != this.originalVal) {
            Prefs.putDouble("eyeSeparationMultiplier", d);
            if (this.view.getViewStyle() == 1 || this.view.getViewStyle() == 2 || this.view.getViewStyle() == 3) {
                this.view.forceRedraw();
            }
        }
        if (this.defaultAnaglyphButton.isSelected()) {
            Prefs.put("view3d.initialAnaglyphMode", "default");
        } else if (this.alwaysAnaglyphButton.isSelected()) {
            if (this.view.getViewStyle() == 0) {
                this.view.setViewStyle(1);
            }
            Prefs.put("view3d.initialAnaglyphMode", "always");
        } else if (this.neverAnaglyphButton.isSelected()) {
            if (this.view.getViewStyle() == 1) {
                this.view.setViewStyle(0);
            }
            Prefs.put("view3d.initialAnaglyphMode", "never");
        }
        if (this.moveObjectsForwardInAnaglyphToggle.isSelected()) {
            if (this.view.getViewStyle() == 1 && this.view.getTransform3D() != null) {
                double d2 = Math.max(this.view.getTransform3D().getXmaxRequested() - this.view.getTransform3D().getXminRequested(), this.view.getTransform3D().getYmaxRequested() - this.view.getTransform3D().getYminRequested());
                this.view.getTransform3D().setObjectDisplacementNormalToScreen(d2 / 3.0);
            }
            Prefs.put("view3d.moveObjectsForwardInAnaglyph", "yes");
        } else {
            if (this.view.getViewStyle() == 1 && this.view.getTransform3D() != null) {
                this.view.getTransform3D().setObjectDisplacementNormalToScreen(0.0);
            }
            Prefs.put("view3d.moveObjectsForwardInAnaglyph", "no");
        }
        return true;
    }

    protected void doDefaults() {
        this.input.defaultVal();
        this.defaultAnaglyphButton.setSelected(true);
        this.moveObjectsForwardInAnaglyphToggle.setSelected(false);
    }
}

