/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import vmm.core3D.DirectionalLight;
import vmm.core3D.LightSettings;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DLit;
import vmm.core3D.View3DWithLightSettings;

public class PhongLighting {
    static final float removalRatio = 0.6f;
    static float theReflectance;

    private static void getTheReflectance(Vector3D vector3D, Vector3D vector3D2, View3DLit view3DLit) {
        int n = view3DLit.getOrientation();
        float f = (float)vector3D.dot(vector3D2);
        boolean bl = false;
        switch (n) {
            case 2: {
                break;
            }
            case 0: {
                if (f > 0.0f) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 1: {
                bl = f > 0.0f;
            }
        }
        theReflectance = bl ? 0.675f : 1.0f;
    }

    private static float specularIntensityOfSource(Vector3D vector3D, Vector3D vector3D2, View3DWithLightSettings view3DWithLightSettings) {
        LightSettings lightSettings = view3DWithLightSettings.getLightSettings();
        int n = lightSettings.getSpecularExponent();
        float f = (float)(-vector3D.dot(vector3D2));
        f = (float)Math.max((double)f, 0.1);
        f = (float)Math.pow(f, n);
        return f;
    }

    private static Vector3D getDirectionInSpace(Vector3D vector3D, Transform3D transform3D) {
        Vector3D vector3D2 = transform3D.getViewDirection();
        Vector3D vector3D3 = transform3D.getImagePlaneXDirection();
        Vector3D vector3D4 = transform3D.getImagePlaneYDirection();
        Vector3D vector3D5 = vector3D2.times(-vector3D.z);
        Vector3D vector3D6 = vector3D3.times(vector3D.x);
        Vector3D vector3D7 = vector3D4.times(vector3D.y);
        return vector3D5.plus(vector3D6).plus(vector3D7).normalized();
    }

    private static float addValues(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        if (Math.abs(f) + Math.abs(f2) + Math.abs(f3) + Math.abs(f4) == 0.0f) {
            f = 1.0f;
        }
        if ((f10 = f * f5 + f2 * f6 + f3 * f7 + f4 * f8 + f9) < 0.0f) {
            return 0.0f;
        }
        if (f10 > 1.0f) {
            return 1.0f;
        }
        return f10;
    }

    public static Color phongLightingColor(Vector3D vector3D, View3DWithLightSettings view3DWithLightSettings, Transform3D transform3D, Vector3D vector3D2, Color color) {
        float f;
        float f2;
        float f3;
        int n = view3DWithLightSettings.getViewStyle();
        Vector3D vector3D3 = transform3D.getViewPoint();
        Vector3D vector3D4 = transform3D.getViewDirection();
        Vector3D vector3D5 = vector3D2.minus(vector3D3).normalized();
        float[] fArray = color.getColorComponents(null);
        LightSettings lightSettings = view3DWithLightSettings.getLightSettings();
        Color color2 = lightSettings.getLight0();
        DirectionalLight directionalLight = lightSettings.getDirectionalLight1();
        Color color3 = directionalLight.getItsColor();
        DirectionalLight directionalLight2 = lightSettings.getDirectionalLight2();
        Color color4 = directionalLight2.getItsColor();
        DirectionalLight directionalLight3 = lightSettings.getDirectionalLight3();
        Color color5 = directionalLight3.getItsColor();
        Color color6 = lightSettings.getAmbientLight();
        Vector3D vector3D6 = PhongLighting.getDirectionInSpace(directionalLight.getItsDirection(), transform3D);
        Vector3D vector3D7 = PhongLighting.getDirectionInSpace(directionalLight2.getItsDirection(), transform3D);
        Vector3D vector3D8 = PhongLighting.getDirectionInSpace(directionalLight3.getItsDirection(), transform3D);
        Vector3D vector3D9 = vector3D5.plus(vector3D4).normalized();
        Vector3D vector3D10 = vector3D5.plus(vector3D6).normalized().times(-1.0);
        Vector3D vector3D11 = vector3D5.plus(vector3D7).normalized().times(-1.0);
        Vector3D vector3D12 = vector3D5.plus(vector3D8).normalized().times(-1.0);
        Vector3D vector3D13 = view3DWithLightSettings.getOrthographicProjection() ? vector3D4 : vector3D5;
        Vector3D vector3D14 = vector3D.dot(vector3D13) <= 0.0 ? vector3D : vector3D.negated();
        if (view3DWithLightSettings instanceof View3DLit) {
            PhongLighting.getTheReflectance(vector3D, vector3D13, (View3DLit)view3DWithLightSettings);
        } else {
            theReflectance = 1.0f;
        }
        float f4 = theReflectance * (float)(-vector3D14.dot(vector3D5));
        float f5 = theReflectance * (float)(-vector3D14.dot(vector3D6));
        float f6 = theReflectance * (float)(-vector3D14.dot(vector3D7));
        float f7 = theReflectance * (float)(-vector3D14.dot(vector3D8));
        float f8 = theReflectance * PhongLighting.specularIntensityOfSource(vector3D, vector3D9, view3DWithLightSettings);
        float f9 = theReflectance * PhongLighting.specularIntensityOfSource(vector3D, vector3D10, view3DWithLightSettings);
        float f10 = theReflectance * PhongLighting.specularIntensityOfSource(vector3D, vector3D11, view3DWithLightSettings);
        float f11 = theReflectance * PhongLighting.specularIntensityOfSource(vector3D, vector3D12, view3DWithLightSettings);
        float f12 = (1.0f - 0.6f * lightSettings.getSpecularRatio()) * f4 + lightSettings.getSpecularRatio() * f8;
        float f13 = (1.0f - 0.6f * lightSettings.getSpecularRatio()) * f5 + lightSettings.getSpecularRatio() * f9;
        float f14 = (1.0f - 0.6f * lightSettings.getSpecularRatio()) * f6 + lightSettings.getSpecularRatio() * f10;
        float f15 = (1.0f - 0.6f * lightSettings.getSpecularRatio()) * f7 + lightSettings.getSpecularRatio() * f11;
        float[] fArray2 = color2.getColorComponents(null);
        float[] fArray3 = color3.getColorComponents(null);
        float[] fArray4 = color4.getColorComponents(null);
        float[] fArray5 = color5.getColorComponents(null);
        float[] fArray6 = color6.getColorComponents(null);
        if (n == 1) {
            f2 = f3 = Math.min(Math.max(f12, 0.0f), 1.0f);
            f = f3;
        } else {
            f = PhongLighting.addValues(f12, f13, f14, f15, fArray2[0], fArray3[0], fArray4[0], fArray5[0], fArray6[0]);
            f2 = PhongLighting.addValues(f12, f13, f14, f15, fArray2[1], fArray3[1], fArray4[1], fArray5[1], fArray6[1]);
            f3 = PhongLighting.addValues(f12, f13, f14, f15, fArray2[2], fArray3[2], fArray4[2], fArray5[2], fArray6[2]);
        }
        return new Color(f * fArray[0], f2 * fArray[1], f3 * fArray[2]);
    }
}

