/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.SettingsDialog;
import vmm.core3D.DirectionalLight;
import vmm.core3D.LightSettings;
import vmm.core3D.Vector3D;
import vmm.core3D.View3DWithLightSettings;

public class LightSettingsDialog
extends SettingsDialog {
    private RealParam[][] colorParams = new RealParam[5][3];
    private RealParam[][] directionParams = new RealParam[3][3];
    private RealParam specularRatioParam;
    private IntegerParam specularExponentParam;
    private ParameterInput[][] colorInputs = new ParameterInput[5][3];
    private ParameterInput[][] directionInputs = new ParameterInput[3][3];
    private ParameterInput specularRatioInput;
    private ParameterInput specularExponentInput;
    private JButton[] colorSetButton = new JButton[5];
    private JButton[] defaultSettingsButton = new JButton[4];
    private LightSettings currentSettings;
    private View3DWithLightSettings owner;
    private ActionListener colorSetter = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            for (int i = 0; i < 5; ++i) {
                if (object != LightSettingsDialog.this.colorSetButton[i]) continue;
                Color color = Color.white;
                try {
                    color = new Color((float)LightSettingsDialog.this.colorParams[i][0].getValue(), (float)LightSettingsDialog.this.colorParams[i][1].getValue(), (float)LightSettingsDialog.this.colorParams[i][2].getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                color = JColorChooser.showDialog(LightSettingsDialog.this, I18n.tr("vmm.core3D.LightSettingsDialog.ColorDialogTitle"), color);
                if (color == null) {
                    return;
                }
                double d = (double)color.getRed() / 255.0;
                double d2 = (double)color.getGreen() / 255.0;
                double d3 = (double)color.getBlue() / 255.0;
                d = (double)((int)(d * 100000.0 + 0.499)) / 100000.0;
                d2 = (double)((int)(d2 * 100000.0 + 0.499)) / 100000.0;
                d3 = (double)((int)(d3 * 100000.0 + 0.499)) / 100000.0;
                LightSettingsDialog.this.colorInputs[i][0].setText("" + d);
                LightSettingsDialog.this.colorInputs[i][1].setText("" + d2);
                LightSettingsDialog.this.colorInputs[i][2].setText("" + d3);
                return;
            }
        }
    };
    private ActionListener defaultsListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            for (int i = 0; i < 4; ++i) {
                LightSettings lightSettings;
                if (object != LightSettingsDialog.this.defaultSettingsButton[i]) continue;
                switch (i) {
                    case 1: {
                        lightSettings = new LightSettings(2);
                        break;
                    }
                    case 2: {
                        lightSettings = new LightSettings(1);
                        break;
                    }
                    case 3: {
                        lightSettings = new LightSettings(3);
                        break;
                    }
                    default: {
                        lightSettings = new LightSettings();
                    }
                }
                LightSettingsDialog.this.colorInputs[0][0].setText("" + (double)((int)((double)lightSettings.getLight0().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[0][1].setText("" + (double)((int)((double)lightSettings.getLight0().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[0][2].setText("" + (double)((int)((double)lightSettings.getLight0().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[1][0].setText("" + (double)((int)((double)lightSettings.getDirectionalLight1().getItsColor().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[1][1].setText("" + (double)((int)((double)lightSettings.getDirectionalLight1().getItsColor().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[1][2].setText("" + (double)((int)((double)lightSettings.getDirectionalLight1().getItsColor().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[2][0].setText("" + (double)((int)((double)lightSettings.getDirectionalLight2().getItsColor().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[2][1].setText("" + (double)((int)((double)lightSettings.getDirectionalLight2().getItsColor().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[2][2].setText("" + (double)((int)((double)lightSettings.getDirectionalLight2().getItsColor().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[3][0].setText("" + (double)((int)((double)lightSettings.getDirectionalLight3().getItsColor().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[3][1].setText("" + (double)((int)((double)lightSettings.getDirectionalLight3().getItsColor().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[3][2].setText("" + (double)((int)((double)lightSettings.getDirectionalLight3().getItsColor().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[4][0].setText("" + (double)((int)((double)lightSettings.getAmbientLight().getRed() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[4][1].setText("" + (double)((int)((double)lightSettings.getAmbientLight().getGreen() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.colorInputs[4][2].setText("" + (double)((int)((double)lightSettings.getAmbientLight().getBlue() / 255.0 * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[0][0].setText("" + (double)((int)(lightSettings.getDirectionalLight1().getItsDirection().x * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[0][1].setText("" + (double)((int)(lightSettings.getDirectionalLight1().getItsDirection().y * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[0][2].setText("" + (double)((int)(lightSettings.getDirectionalLight1().getItsDirection().z * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[1][0].setText("" + (double)((int)(lightSettings.getDirectionalLight2().getItsDirection().x * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[1][1].setText("" + (double)((int)(lightSettings.getDirectionalLight2().getItsDirection().y * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[1][2].setText("" + (double)((int)(lightSettings.getDirectionalLight2().getItsDirection().z * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[2][0].setText("" + (double)((int)(lightSettings.getDirectionalLight3().getItsDirection().x * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[2][1].setText("" + (double)((int)(lightSettings.getDirectionalLight3().getItsDirection().y * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.directionInputs[2][2].setText("" + (double)((int)(lightSettings.getDirectionalLight3().getItsDirection().z * 10000.0 + 0.5)) / 10000.0);
                LightSettingsDialog.this.specularRatioInput.setText("" + (double)((int)((double)(lightSettings.getSpecularRatio() * 10000.0f) + 0.5)) / 10000.0);
                LightSettingsDialog.this.specularExponentInput.setText("" + lightSettings.getSpecularExponent());
            }
        }
    };

    public static void showDialog(View3DWithLightSettings view3DWithLightSettings) {
        new LightSettingsDialog(view3DWithLightSettings).setVisible(true);
    }

    public LightSettingsDialog(View3DWithLightSettings view3DWithLightSettings) {
        super(view3DWithLightSettings.getDisplay(), I18n.tr("vmm.core3D.LightSettingsDialog.dialogTitle"), false, true);
        int n;
        int n2;
        this.owner = view3DWithLightSettings;
        this.currentSettings = view3DWithLightSettings.getLightSettings();
        LightSettings lightSettings = new LightSettings();
        Box box = Box.createVerticalBox();
        JPanel jPanel = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.LightColors"), 6, 5);
        JPanel jPanel2 = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.LightDirections"), 4, 4);
        JPanel jPanel3 = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.Specular"), 1, 4);
        JPanel jPanel4 = this.borderedPanel(I18n.tr("vmm.core3D.LightSettingsDialog.DefaultsButtons"), 0, 2);
        box.add(jPanel);
        box.add(jPanel2);
        box.add(jPanel3);
        box.add(jPanel4);
        String[] stringArray = new String[]{I18n.tr("vmm.core3D.LightSettingsDialog.Source0"), I18n.tr("vmm.core3D.LightSettingsDialog.Source1"), I18n.tr("vmm.core3D.LightSettingsDialog.Source2"), I18n.tr("vmm.core3D.LightSettingsDialog.Source3"), I18n.tr("vmm.core3D.LightSettingsDialog.Ambient")};
        String[] stringArray2 = new String[]{I18n.tr("common.Red"), I18n.tr("common.Green"), I18n.tr("common.Blue")};
        Vector3D[] vector3DArray = new Vector3D[]{this.currentSettings.getDirectionalLight1().getItsDirection(), this.currentSettings.getDirectionalLight2().getItsDirection(), this.currentSettings.getDirectionalLight3().getItsDirection()};
        Vector3D[] vector3DArray2 = new Vector3D[]{lightSettings.getDirectionalLight1().getItsDirection(), lightSettings.getDirectionalLight2().getItsDirection(), lightSettings.getDirectionalLight3().getItsDirection()};
        jPanel.add(new JLabel());
        jPanel.add(new JLabel(stringArray2[0], 0));
        jPanel.add(new JLabel(stringArray2[1], 0));
        jPanel.add(new JLabel(stringArray2[2], 0));
        jPanel.add(new JLabel());
        for (n2 = 0; n2 < 5; ++n2) {
            jPanel.add(new JLabel(stringArray[n2], 4));
            for (n = 0; n < 3; ++n) {
                this.colorParams[n2][n] = new RealParam(stringArray[n2] + " " + stringArray2[n], this.colorComponent(this.currentSettings, n2, n));
                this.colorParams[n2][n].setDefaultValue((double)((int)(100000.0 * this.colorComponent(lightSettings, n2, n) + 0.4999)) / 100000.0);
                this.colorParams[n2][n].setMinimumValueForInput(0.0);
                this.colorParams[n2][n].setMaximumValueForInput(1.0);
                this.colorInputs[n2][n] = new ParameterInput(this.colorParams[n2][n]);
                this.colorInputs[n2][n].setColumns(7);
                jPanel.add(this.colorInputs[n2][n]);
            }
            this.colorSetButton[n2] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.SetColorButton"));
            this.colorSetButton[n2].addActionListener(this.colorSetter);
            jPanel.add(this.colorSetButton[n2]);
        }
        jPanel2.add(new JLabel());
        jPanel2.add(new JLabel("x", 0));
        jPanel2.add(new JLabel("y", 0));
        jPanel2.add(new JLabel("z", 0));
        for (n2 = 0; n2 < 3; ++n2) {
            jPanel2.add(new JLabel(stringArray[n2 + 1], 4));
            this.directionParams[n2][0] = new RealParam(stringArray[n2 + 1] + " x", vector3DArray[n2].x);
            this.directionParams[n2][0].setDefaultValue((double)((int)(100000.0 * vector3DArray2[n2].x + 0.4999)) / 100000.0);
            this.directionParams[n2][1] = new RealParam(stringArray[n2 + 1] + " y", vector3DArray[n2].y);
            this.directionParams[n2][1].setDefaultValue((double)((int)(100000.0 * vector3DArray2[n2].y + 0.4999)) / 100000.0);
            this.directionParams[n2][2] = new RealParam(stringArray[n2 + 1] + " z", vector3DArray[n2].z);
            this.directionParams[n2][2].setDefaultValue((double)((int)(100000.0 * vector3DArray2[n2].z + 0.4999)) / 100000.0);
            for (n = 0; n < 3; ++n) {
                this.directionInputs[n2][n] = new ParameterInput(this.directionParams[n2][n]);
                this.directionInputs[n2][n].setColumns(7);
                jPanel2.add(this.directionInputs[n2][n]);
            }
        }
        jPanel3.add(new JLabel(I18n.tr("vmm.core3D.LightSettingsDialog.Ratio"), 4));
        this.specularRatioParam = new RealParam("vmm.core3D.LightSettingsDialog.SpecularRatio", this.currentSettings.getSpecularRatio());
        this.specularRatioParam.setDefaultValue((double)((int)((double)(100000.0f * lightSettings.getSpecularRatio()) + 0.4999)) / 100000.0);
        this.specularRatioParam.setMinimumValueForInput(0.0);
        this.specularRatioParam.setMaximumValueForInput(1.0);
        this.specularRatioInput = new ParameterInput(this.specularRatioParam);
        this.specularRatioInput.setColumns(7);
        jPanel3.add(this.specularRatioInput);
        jPanel3.add(new JLabel(I18n.tr("vmm.core3D.LightSettingsDialog.Exponent"), 4));
        this.specularExponentParam = new IntegerParam("vmm.core3D.LightSettingsDialog.SpecularExponent", this.currentSettings.getSpecularExponent());
        this.specularExponentParam.setDefaultValue(lightSettings.getSpecularExponent());
        this.specularExponentParam.setMinimumValueForInput(1);
        this.specularExponentParam.setMaximumValueForInput(250);
        this.specularExponentInput = new ParameterInput(this.specularExponentParam);
        this.specularExponentInput.setColumns(7);
        jPanel3.add(this.specularExponentInput);
        this.defaultSettingsButton[0] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.Defaults"));
        this.defaultSettingsButton[1] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.White"));
        this.defaultSettingsButton[2] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.DistinctlyColoredSidesDefault"));
        this.defaultSettingsButton[3] = new JButton(I18n.tr("vmm.core3D.LightSettingsDialog.preset.HighSpecularityDefault"));
        for (n2 = 0; n2 < this.defaultSettingsButton.length; ++n2) {
            this.defaultSettingsButton[n2].addActionListener(this.defaultsListener);
            jPanel4.add(this.defaultSettingsButton[n2]);
        }
        this.addInputPanel(box);
    }

    private JPanel borderedPanel(String string, int n, int n2) {
        JPanel jPanel = this.borderedPanel(string);
        jPanel.setLayout(new GridLayout(n, n2, 7, 4));
        return jPanel;
    }

    private double colorComponent(LightSettings lightSettings, int n, int n2) {
        Color color;
        switch (n) {
            case 0: {
                color = lightSettings.getLight0();
                break;
            }
            case 1: {
                color = lightSettings.getDirectionalLight1().getItsColor();
                break;
            }
            case 2: {
                color = lightSettings.getDirectionalLight2().getItsColor();
                break;
            }
            case 3: {
                color = lightSettings.getDirectionalLight3().getItsColor();
                break;
            }
            default: {
                color = lightSettings.getAmbientLight();
            }
        }
        switch (n2) {
            case 0: {
                return (double)color.getRed() / 255.0;
            }
            case 1: {
                return (double)color.getGreen() / 255.0;
            }
        }
        return (double)color.getBlue() / 255.0;
    }

    protected boolean doOK() {
        String string;
        int n;
        int n2;
        Vector3D[] vector3DArray = new Vector3D[3];
        Color[] colorArray = new Color[5];
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = 0; n < 3; ++n) {
                string = this.colorInputs[n2][n].checkContents();
                if (string != null) {
                    this.errorMessage(string);
                    return false;
                }
                this.colorInputs[n2][n].setValueFromContents();
            }
            colorArray[n2] = new Color((float)this.colorParams[n2][0].getValue(), (float)this.colorParams[n2][1].getValue(), (float)this.colorParams[n2][2].getValue());
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                string = this.directionInputs[n2][n].checkContents();
                if (string != null) {
                    this.errorMessage(string);
                    return false;
                }
                this.directionInputs[n2][n].setValueFromContents();
            }
            vector3DArray[n2] = new Vector3D(this.directionParams[n2][0].getValue(), this.directionParams[n2][1].getValue(), this.directionParams[n2][2].getValue());
            if (vector3DArray[n2].norm() < 1.0E-10) {
                this.errorMessage(I18n.tr("vmm.core3D.LightSettingsDialog.BadDirectionVector"));
                this.directionInputs[n2][0].requestFocus();
                this.directionInputs[n2][0].selectAll();
                return false;
            }
            vector3DArray[n2].normalize();
        }
        String string2 = this.specularRatioInput.checkContents();
        if (string2 != null) {
            this.errorMessage(string2);
            return false;
        }
        this.specularRatioInput.setValueFromContents();
        string2 = this.specularExponentInput.checkContents();
        if (string2 != null) {
            this.errorMessage(string2);
            return false;
        }
        this.specularExponentInput.setValueFromContents();
        this.currentSettings.setLight0(colorArray[0]);
        this.currentSettings.setDirectionalLight1(new DirectionalLight(colorArray[1], vector3DArray[0]));
        this.currentSettings.setDirectionalLight2(new DirectionalLight(colorArray[2], vector3DArray[1]));
        this.currentSettings.setDirectionalLight3(new DirectionalLight(colorArray[3], vector3DArray[2]));
        this.currentSettings.setAmbientLight(colorArray[4]);
        this.currentSettings.setSpecularExponent(this.specularExponentParam.getValue());
        this.currentSettings.setSpecularRatio((float)this.specularRatioParam.getValue());
        this.owner.setLightingEnabled(true);
        this.owner.forceRedraw();
        return true;
    }

    private void errorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
    }
}

