/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import vmm.core3D.DirectionalLight;
import vmm.core3D.Vector3D;

public class LightSettings {
    public static final int DEFAULTS = 0;
    public static final int DISTICTLY_COLORED_SIDES_DEFAULT = 1;
    public static final int WHITE_LIGHT = 2;
    public static final int HIGH_SPECULARITY_DEFAULT = 3;
    private Color light0;
    private DirectionalLight directionalLight1;
    private DirectionalLight directionalLight2;
    private DirectionalLight directionalLight3;
    private Color ambientLight;
    private float specularRatio;
    private int specularExponent;

    public LightSettings(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, float f16, int n) {
        this.light0 = new Color(f, f2, f3);
        this.directionalLight1 = new DirectionalLight(f4, f5, f6, d, d2, d3);
        this.directionalLight2 = new DirectionalLight(f7, f8, f9, d4, d5, d6);
        this.directionalLight3 = new DirectionalLight(f10, f11, f12, d7, d8, d9);
        this.ambientLight = new Color(f13, f14, f15);
        this.specularRatio = f16;
        this.specularExponent = n;
    }

    public LightSettings() {
        this(0.25f, 0.25f, 0.25f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 0.1f, 0.1f, -0.7071, 0.0, -0.7071, -0.5774, -0.5774, -0.5774, 0.0, -0.7071, -0.7071, 0.3f, 25);
    }

    public LightSettings(int n) {
        this();
        switch (n) {
            case 3: {
                this.specularExponent = 150;
                this.specularRatio = 0.85f;
                this.ambientLight = new Color(0.22f, 0.22f, 0.22f);
                break;
            }
            case 1: {
                this.light0 = new Color(0.3f, 0.3f, 0.3f);
                this.directionalLight1.setItsColor(new Color(1.0f, 1.0f, 0.25f));
                this.directionalLight2.setItsColor(new Color(0.5f, 0.5f, 0.5f));
                this.directionalLight3.setItsColor(new Color(0.25f, 0.25f, 1.0f));
                this.directionalLight3.setItsDirection(new Vector3D(-1.0, 0.0, -1.0).normalized());
                break;
            }
            case 2: {
                this.light0 = Color.WHITE;
                this.directionalLight1.setItsColor(Color.BLACK);
                this.directionalLight2.setItsColor(Color.BLACK);
                this.directionalLight3.setItsColor(Color.BLACK);
                this.ambientLight = new Color(0.3f, 0.3f, 0.3f);
                this.specularRatio = 0.0f;
            }
        }
    }

    public Color getAmbientLight() {
        return this.ambientLight;
    }

    public void setAmbientLight(Color color) {
        this.ambientLight = color;
    }

    public DirectionalLight getDirectionalLight1() {
        return this.directionalLight1;
    }

    public void setDirectionalLight1(DirectionalLight directionalLight) {
        this.directionalLight1 = directionalLight;
    }

    public DirectionalLight getDirectionalLight2() {
        return this.directionalLight2;
    }

    public void setDirectionalLight2(DirectionalLight directionalLight) {
        this.directionalLight2 = directionalLight;
    }

    public DirectionalLight getDirectionalLight3() {
        return this.directionalLight3;
    }

    public void setDirectionalLight3(DirectionalLight directionalLight) {
        this.directionalLight3 = directionalLight;
    }

    public Color getLight0() {
        return this.light0;
    }

    public void setLight0(Color color) {
        this.light0 = color;
    }

    public int getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(int n) {
        this.specularExponent = n;
    }

    public float getSpecularRatio() {
        return this.specularRatio;
    }

    public void setSpecularRatio(float f) {
        this.specularRatio = f;
    }
}

