/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import vmm.core3D.Vector3D;

public class GridTransformMatrix {
    private double[][] matrix;
    private boolean reverseSurfaceOrientation;

    public GridTransformMatrix() {
        this.matrix = new double[3][4];
        this.matrix[2][2] = 1.0;
        this.matrix[1][1] = 1.0;
        this.matrix[0][0] = 1.0;
        this.reverseSurfaceOrientation = false;
    }

    public GridTransformMatrix(GridTransformMatrix gridTransformMatrix) {
        if (gridTransformMatrix == null) {
            this.matrix = new double[3][4];
            this.matrix[2][2] = 1.0;
            this.matrix[1][1] = 1.0;
            this.matrix[0][0] = 1.0;
            this.reverseSurfaceOrientation = false;
        } else {
            this.matrix = new double[3][4];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.matrix[i][j] = gridTransformMatrix.matrix[i][j];
                }
            }
            this.reverseSurfaceOrientation = gridTransformMatrix.reverseSurfaceOrientation;
        }
    }

    public static GridTransformMatrix SetGridTransformMatrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, boolean bl) {
        GridTransformMatrix gridTransformMatrix = new GridTransformMatrix();
        gridTransformMatrix.matrix[0][0] = d;
        gridTransformMatrix.matrix[0][1] = d2;
        gridTransformMatrix.matrix[0][2] = d3;
        gridTransformMatrix.matrix[0][3] = d4;
        gridTransformMatrix.matrix[1][0] = d5;
        gridTransformMatrix.matrix[1][1] = d6;
        gridTransformMatrix.matrix[1][2] = d7;
        gridTransformMatrix.matrix[1][3] = d8;
        gridTransformMatrix.matrix[2][0] = d9;
        gridTransformMatrix.matrix[2][1] = d10;
        gridTransformMatrix.matrix[2][2] = d11;
        gridTransformMatrix.matrix[2][3] = d12;
        gridTransformMatrix.reverseSurfaceOrientation = bl;
        return gridTransformMatrix;
    }

    public boolean equals(Object object) {
        try {
            double[][] dArray = ((GridTransformMatrix)object).matrix;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (dArray[i][j] == this.matrix[i][j]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Vector3D apply(Vector3D vector3D) {
        return new Vector3D(this.matrix[0][0] * vector3D.x + this.matrix[0][1] * vector3D.y + this.matrix[0][2] * vector3D.z + this.matrix[0][3], this.matrix[1][0] * vector3D.x + this.matrix[1][1] * vector3D.y + this.matrix[1][2] * vector3D.z + this.matrix[1][3], this.matrix[2][0] * vector3D.x + this.matrix[2][1] * vector3D.y + this.matrix[2][2] * vector3D.z + this.matrix[2][3]);
    }

    public Vector3D applyToNormal(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D(this.matrix[0][0] * vector3D.x + this.matrix[0][1] * vector3D.y + this.matrix[0][2] * vector3D.z, this.matrix[1][0] * vector3D.x + this.matrix[1][1] * vector3D.y + this.matrix[1][2] * vector3D.z, this.matrix[2][0] * vector3D.x + this.matrix[2][1] * vector3D.y + this.matrix[2][2] * vector3D.z);
        vector3D.assign(vector3D2);
        if (this.reverseSurfaceOrientation) {
            vector3D.negate();
        }
        return vector3D;
    }

    public boolean getReverseSurfaceOrientation() {
        return this.reverseSurfaceOrientation;
    }

    public GridTransformMatrix setReverseSurfaceOrientation(boolean bl) {
        this.reverseSurfaceOrientation = bl;
        return this;
    }

    public GridTransformMatrix reverse() {
        this.reverseSurfaceOrientation = !this.reverseSurfaceOrientation;
        return this;
    }

    public GridTransformMatrix scale(double d) {
        return this.scale(d, d, d);
    }

    public GridTransformMatrix scale(double d, double d2, double d3) {
        double[] dArray = this.matrix[0];
        dArray[0] = dArray[0] * d;
        double[] dArray2 = this.matrix[0];
        dArray2[1] = dArray2[1] * d;
        double[] dArray3 = this.matrix[0];
        dArray3[2] = dArray3[2] * d;
        double[] dArray4 = this.matrix[0];
        dArray4[3] = dArray4[3] * d;
        double[] dArray5 = this.matrix[1];
        dArray5[0] = dArray5[0] * d2;
        double[] dArray6 = this.matrix[1];
        dArray6[1] = dArray6[1] * d2;
        double[] dArray7 = this.matrix[1];
        dArray7[2] = dArray7[2] * d2;
        double[] dArray8 = this.matrix[1];
        dArray8[3] = dArray8[3] * d2;
        double[] dArray9 = this.matrix[2];
        dArray9[0] = dArray9[0] * d3;
        double[] dArray10 = this.matrix[2];
        dArray10[1] = dArray10[1] * d3;
        double[] dArray11 = this.matrix[2];
        dArray11[2] = dArray11[2] * d3;
        double[] dArray12 = this.matrix[2];
        dArray12[3] = dArray12[3] * d3;
        return this;
    }

    public GridTransformMatrix translate(double d, double d2, double d3) {
        double[] dArray = this.matrix[0];
        dArray[3] = dArray[3] + d;
        double[] dArray2 = this.matrix[1];
        dArray2[3] = dArray2[3] + d2;
        double[] dArray3 = this.matrix[2];
        dArray3[3] = dArray3[3] + d3;
        return this;
    }

    public GridTransformMatrix translate(Vector3D vector3D) {
        if (vector3D != null) {
            double[] dArray = this.matrix[0];
            dArray[3] = dArray[3] + vector3D.x;
            double[] dArray2 = this.matrix[1];
            dArray2[3] = dArray2[3] + vector3D.y;
            double[] dArray3 = this.matrix[2];
            dArray3[3] = dArray3[3] + vector3D.z;
        }
        return this;
    }

    public GridTransformMatrix setTranslation(Vector3D vector3D) {
        if (vector3D == null) {
            this.matrix[2][3] = 0.0;
            this.matrix[1][3] = 0.0;
            this.matrix[0][3] = 0.0;
        } else {
            this.matrix[0][3] = vector3D.x;
            this.matrix[1][3] = vector3D.y;
            this.matrix[2][3] = vector3D.z;
        }
        return this;
    }

    public GridTransformMatrix setTranslation(double d, double d2, double d3) {
        this.matrix[0][3] = d;
        this.matrix[1][3] = d2;
        this.matrix[2][3] = d3;
        return this;
    }

    public GridTransformMatrix rotateZ(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = d3 * this.matrix[0][0] + d4 * this.matrix[1][0];
        this.matrix[1][0] = -d4 * this.matrix[0][0] + d3 * this.matrix[1][0];
        this.matrix[0][0] = d5;
        d5 = d3 * this.matrix[0][1] + d4 * this.matrix[1][1];
        this.matrix[1][1] = -d4 * this.matrix[0][1] + d3 * this.matrix[1][1];
        this.matrix[0][1] = d5;
        d5 = d3 * this.matrix[0][2] + d4 * this.matrix[1][2];
        this.matrix[1][2] = -d4 * this.matrix[0][2] + d3 * this.matrix[1][2];
        this.matrix[0][2] = d5;
        d5 = d3 * this.matrix[0][3] + d4 * this.matrix[1][3];
        this.matrix[1][3] = -d4 * this.matrix[0][3] + d3 * this.matrix[1][3];
        this.matrix[0][3] = d5;
        return this;
    }

    public GridTransformMatrix rotateX(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = d3 * this.matrix[1][0] + d4 * this.matrix[2][0];
        this.matrix[2][0] = -d4 * this.matrix[1][0] + d3 * this.matrix[2][0];
        this.matrix[1][0] = d5;
        d5 = d3 * this.matrix[1][1] + d4 * this.matrix[2][1];
        this.matrix[2][1] = -d4 * this.matrix[1][1] + d3 * this.matrix[2][1];
        this.matrix[1][1] = d5;
        d5 = d3 * this.matrix[1][2] + d4 * this.matrix[2][2];
        this.matrix[2][2] = -d4 * this.matrix[1][2] + d3 * this.matrix[2][2];
        this.matrix[1][2] = d5;
        d5 = d3 * this.matrix[1][3] + d4 * this.matrix[2][3];
        this.matrix[2][3] = -d4 * this.matrix[1][3] + d3 * this.matrix[2][3];
        this.matrix[1][3] = d5;
        return this;
    }

    public GridTransformMatrix rotateY(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = d3 * this.matrix[2][0] + d4 * this.matrix[0][0];
        this.matrix[0][0] = -d4 * this.matrix[2][0] + d3 * this.matrix[0][0];
        this.matrix[2][0] = d5;
        d5 = d3 * this.matrix[2][1] + d4 * this.matrix[0][1];
        this.matrix[0][1] = -d4 * this.matrix[2][1] + d3 * this.matrix[0][1];
        this.matrix[2][1] = d5;
        d5 = d3 * this.matrix[2][2] + d4 * this.matrix[0][2];
        this.matrix[0][2] = -d4 * this.matrix[2][2] + d3 * this.matrix[0][2];
        this.matrix[2][2] = d5;
        d5 = d3 * this.matrix[2][3] + d4 * this.matrix[0][3];
        this.matrix[0][3] = -d4 * this.matrix[2][3] + d3 * this.matrix[0][3];
        this.matrix[2][3] = d5;
        return this;
    }

    public GridTransformMatrix leftMultiplyBy(GridTransformMatrix gridTransformMatrix) {
        double[][] dArray = new double[3][4];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                double d = 0.0;
                for (int k = 0; k < 3; ++k) {
                    d += gridTransformMatrix.matrix[i][k] * this.matrix[k][j];
                }
                if (j == 3) {
                    d += gridTransformMatrix.matrix[i][3];
                }
                dArray[i][j] = d;
            }
        }
        this.matrix = dArray;
        this.reverseSurfaceOrientation = this.reverseSurfaceOrientation != gridTransformMatrix.reverseSurfaceOrientation;
        return this;
    }
}

