/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.PhongLighting;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.core3D.View3DLit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid3D {
    private int uPatchCount;
    private int vPatchCount;
    private final int subPatchesPerPatch;
    private int uCurveIncrement;
    private int vCurveIncrement;
    private Color defaultPatchColor = Color.white;
    private Color defaultBackColor;
    private int uCount;
    private int vCount;
    private Vector3D[][] pointsOnSurface;
    private Color[][] patchColor;
    private Vector3D[][] normal;
    private Vector3D[][][] transformedData;
    private Vector3D[][][] transformedVCurves;
    private boolean subPatchesValid;
    private ArrayList<Patch> subpatches;
    private boolean patchesValid;
    private ArrayList<Patch> patches;
    private ArrayList<GridTransformMatrix> transforms;
    private boolean useIdentityTransform = true;

    public Grid3D(int n, int n2) {
        this.subPatchesPerPatch = 6;
        this.setPatchCount(n, n2);
        this.vCurveIncrement = 6;
        this.uCurveIncrement = 6;
    }

    public Grid3D(int n, int n2, int n3) {
        this.subPatchesPerPatch = n3;
        this.setPatchCount(n, n2);
        this.uCurveIncrement = this.vCurveIncrement = n3;
    }

    private void setPatchCount(int n, int n2) {
        this.uPatchCount = n;
        this.vPatchCount = n2;
        this.uCount = 1 + n * this.subPatchesPerPatch;
        this.vCount = 1 + n2 * this.subPatchesPerPatch;
        this.pointsOnSurface = new Vector3D[this.uCount][this.vCount];
    }

    public void addGridTransform(GridTransformMatrix gridTransformMatrix) {
        if (gridTransformMatrix == null) {
            return;
        }
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        this.transforms.add(gridTransformMatrix);
        this.transformedVCurves = null;
        this.transformedData = this.transformedVCurves;
        this.subpatches = null;
        this.patches = null;
        this.subPatchesValid = false;
        this.patchesValid = false;
    }

    public void discardGridTransforms() {
        if (this.transforms != null) {
            this.transforms = null;
            this.transformedVCurves = null;
            this.transformedData = this.transformedVCurves;
            this.subpatches = null;
            this.patches = null;
            this.subPatchesValid = false;
            this.patchesValid = false;
        }
    }

    public boolean getUseIdentityTransform() {
        return this.useIdentityTransform;
    }

    public void setUseIdentityTransform(boolean bl) {
        if (bl != this.useIdentityTransform) {
            this.useIdentityTransform = bl;
            this.subpatches = null;
            this.patches = null;
            this.subPatchesValid = false;
            this.patchesValid = false;
        }
    }

    public final void setVertex(int n, int n2, Vector3D vector3D) {
        this.pointsOnSurface[n][n2] = vector3D;
    }

    public final Vector3D getVertex(int n, int n2) {
        return this.pointsOnSurface[n][n2];
    }

    public int getUCount() {
        return this.uCount;
    }

    public int getUPatchCount() {
        return this.uPatchCount;
    }

    public int getVCount() {
        return this.vCount;
    }

    public int getVPatchCount() {
        return this.vPatchCount;
    }

    public int getSubPatchCountInGrid() {
        return (this.uCount - 1) * (this.vCount - 1);
    }

    public int getPatchCountInGrid() {
        return this.uPatchCount * this.vPatchCount;
    }

    public int getSubPatchCountInSurface() {
        int n = 1;
        if (this.transforms != null) {
            n = this.transforms.size();
            if (this.useIdentityTransform) {
                ++n;
            }
        }
        return n * (this.uCount - 1) * (this.vCount - 1);
    }

    public int getPatchCountInSurface() {
        int n = 1;
        if (this.transforms != null) {
            n = this.transforms.size();
            if (this.useIdentityTransform) {
                ++n;
            }
        }
        return n * this.uPatchCount * this.vPatchCount;
    }

    public int getSubpatchesPerPatch() {
        return this.subPatchesPerPatch;
    }

    public int getUCurveIncrement() {
        return this.uCurveIncrement;
    }

    public void setUCurveIncrement(int n) {
        if (n < 0) {
            n = 0;
        }
        this.uCurveIncrement = n;
    }

    public int getVCurveIncrement() {
        return this.vCurveIncrement;
    }

    public void setVCurveIncrement(int n) {
        if (n < 0) {
            n = 0;
        }
        this.vCurveIncrement = n;
    }

    public void setPatchColor(int n, int n2, Color color) {
        if (this.patchColor == null) {
            if (color == null) {
                return;
            }
            this.patchColor = new Color[this.uCount][this.vCount];
        }
        this.patchColor[n][n2] = color;
    }

    public Color getPatchColor(int n, int n2, boolean bl) {
        if (this.patchColor == null) {
            if (bl || this.defaultBackColor == null) {
                return this.defaultPatchColor;
            }
            return this.defaultBackColor;
        }
        Color color = this.patchColor[n][n2];
        return color == null ? this.defaultPatchColor : color;
    }

    public void clearPatchColors() {
        this.patchColor = null;
    }

    public void setNormal(int n, int n2, Vector3D vector3D) {
        if (this.normal == null) {
            this.normal = new Vector3D[this.uCount + 1][this.vCount + 1];
        }
        this.normal[n][n2] = vector3D;
    }

    public Vector3D getNormal(int n, int n2) {
        Vector3D vector3D;
        Vector3D vector3D2;
        if (this.normal != null && this.normal[n][n2] != null) {
            return new Vector3D(this.normal[n][n2]);
        }
        Vector3D vector3D3 = this.pointsOnSurface[n][n2];
        if (n < this.uCount && n2 < this.vCount) {
            vector3D2 = this.pointsOnSurface[n + 1][n2];
            vector3D = this.pointsOnSurface[n][n2 + 1];
        } else if (n == this.uCount && n2 < this.vCount) {
            vector3D2 = this.pointsOnSurface[n][n2 + 1];
            vector3D = this.pointsOnSurface[n - 1][n2];
        } else if (n < this.uCount && n2 == this.vCount) {
            vector3D2 = this.pointsOnSurface[n][n2 - 1];
            vector3D = this.pointsOnSurface[n + 1][n2];
        } else {
            vector3D2 = this.pointsOnSurface[n - 1][n2];
            vector3D = this.pointsOnSurface[n][n2 - 1];
        }
        Vector3D vector3D4 = vector3D2.minus(vector3D3);
        Vector3D vector3D5 = vector3D.minus(vector3D3);
        Vector3D vector3D6 = vector3D4.cross(vector3D5);
        return vector3D6;
    }

    public Vector3D getUnitNormal(int n, int n2) {
        Vector3D vector3D = this.getNormal(n, n2);
        vector3D.normalize();
        if (Double.isInfinite(vector3D.x) || Double.isNaN(vector3D.x) || Double.isInfinite(vector3D.y) || Double.isNaN(vector3D.y) || Double.isInfinite(vector3D.z) || Double.isNaN(vector3D.z)) {
            vector3D = new Vector3D(1.0, 0.0, 0.0);
        }
        return vector3D;
    }

    public void clearNormals() {
        this.normal = null;
    }

    public void setDefaultPatchColor(Color color) {
        this.defaultPatchColor = color == null ? Color.white : color;
    }

    public Color getDefaultPatchColor() {
        return this.defaultPatchColor;
    }

    public Color getDefaultBackColor() {
        return this.defaultBackColor;
    }

    public void setDefaultBackColor(Color color) {
        this.defaultBackColor = color;
    }

    public void applyTransform(Transform3D transform3D, View3D view3D) {
        int n;
        int n2 = 1;
        if (this.transforms != null) {
            n2 = this.transforms.size();
            if (this.useIdentityTransform) {
                ++n2;
            }
        }
        if (this.transformedData == null || this.transformedData.length != n2) {
            this.transformedData = new Vector3D[n2][this.uCount][this.vCount];
            this.transformedVCurves = new Vector3D[n2][this.vCount][this.uCount];
        }
        int n3 = 0;
        if (this.transforms == null || this.useIdentityTransform) {
            for (n = 0; n < this.uCount; ++n) {
                for (int i = 0; i < this.vCount; ++i) {
                    if (this.pointsOnSurface[n][i] == null || view3D.clip(this.pointsOnSurface[n][i])) {
                        this.transformedData[0][n][i] = null;
                    } else {
                        if (this.transformedData[0][n][i] == null) {
                            this.transformedData[0][n][i] = new Vector3D();
                        }
                        transform3D.objectToViewCoords(this.pointsOnSurface[n][i], this.transformedData[0][n][i]);
                    }
                    this.transformedVCurves[0][i][n] = this.transformedData[0][n][i];
                }
                n3 = 1;
            }
        }
        if (this.transforms != null) {
            for (n = n3; n < n2; ++n) {
                GridTransformMatrix gridTransformMatrix = this.transforms.get(n - n3);
                for (int i = 0; i < this.uCount; ++i) {
                    for (int j = 0; j < this.vCount; ++j) {
                        if (this.pointsOnSurface[i][j] == null) {
                            this.transformedData[n][i][j] = null;
                        } else {
                            Vector3D vector3D = gridTransformMatrix.apply(this.pointsOnSurface[i][j]);
                            if (view3D.clip(vector3D)) {
                                this.transformedData[n][i][j] = null;
                            } else {
                                if (this.transformedData[n][i][j] == null) {
                                    this.transformedData[n][i][j] = new Vector3D();
                                }
                                transform3D.objectToViewCoords(vector3D, this.transformedData[n][i][j]);
                            }
                        }
                        this.transformedVCurves[n][j][i] = this.transformedData[n][i][j];
                    }
                }
            }
        }
        this.subPatchesValid = false;
        this.patchesValid = false;
    }

    public void drawCurves(View3D view3D, Graphics2D graphics2D) {
        int n;
        int n2;
        int n3 = this.uCurveIncrement;
        int n4 = this.vCurveIncrement;
        if (n3 == 0 && n4 == 0) {
            n3 = n4 = this.subPatchesPerPatch;
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < this.transformedData.length; ++n2) {
                for (n = 0; n < this.uCount - 1; n += n3) {
                    this.drawCurve(this.transformedData[n2][n], view3D, graphics2D);
                }
                this.drawCurve(this.transformedData[n2][this.uCount - 1], view3D, graphics2D);
            }
        }
        if (n4 > 0) {
            for (n2 = 0; n2 < this.transformedVCurves.length; ++n2) {
                for (n = 0; n < this.vCount - 1; n += n4) {
                    this.drawCurve(this.transformedVCurves[n2][n], view3D, graphics2D);
                }
                this.drawCurve(this.transformedVCurves[n2][this.vCount - 1], view3D, graphics2D);
            }
        }
    }

    public void drawSubPatches(View3DLit view3DLit, Graphics2D graphics2D, double d, double d2) {
        this.computeSubPatches();
        this.drawPatches(this.subpatches, 1, view3DLit, view3DLit.getPhongShading(), d, d2);
    }

    public void drawMajorPatches(View3DLit view3DLit, Graphics2D graphics2D) {
        this.computeMajorPatches();
        this.drawPatches(this.patches, this.subPatchesPerPatch, view3DLit, false, 0.0, 1.0);
    }

    private void computeSubPatches() {
        if (this.subpatches == null || !this.subPatchesValid) {
            int n;
            if (this.subpatches == null) {
                this.subpatches = new ArrayList((this.uCount - 1) * (this.vCount - 1));
                for (n = 0; n < this.transformedData.length; ++n) {
                    for (int i = 0; i < this.uCount - 1; ++i) {
                        for (int j = 0; j < this.vCount - 1; ++j) {
                            this.subpatches.add(new Patch(n, i, j, 1));
                        }
                    }
                }
            }
            for (n = 0; n < this.subpatches.size(); ++n) {
                this.subpatches.get(n).compute();
            }
            Collections.sort(this.subpatches);
            this.subPatchesValid = true;
            if (this.subPatchesPerPatch == 1) {
                this.patches = this.subpatches;
                this.patchesValid = true;
            }
        }
    }

    private void computeMajorPatches() {
        if (this.patches == null || !this.patchesValid) {
            int n;
            if (this.patches == null) {
                this.patches = new ArrayList(this.transformedData.length * (this.uPatchCount - 1) * (this.vPatchCount - 1));
                for (n = 0; n < this.transformedData.length; ++n) {
                    for (int i = 0; i < this.uCount - 1; i += this.subPatchesPerPatch) {
                        for (int j = 0; j < this.vCount - 1; j += this.subPatchesPerPatch) {
                            this.patches.add(new Patch(n, i, j, this.subPatchesPerPatch));
                        }
                    }
                }
            }
            for (n = 0; n < this.patches.size(); ++n) {
                this.patches.get(n).compute();
            }
            Collections.sort(this.patches);
            this.patchesValid = true;
            if (this.subPatchesPerPatch == 1) {
                this.subpatches = this.patches;
                this.subPatchesValid = true;
            }
        }
    }

    private void drawCurve(Vector3D[] vector3DArray, View3D view3D, Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector3DArray.length - 1; ++i) {
            if (vector3DArray[i] != null) {
                if (!bl) {
                    generalPath.moveTo((float)vector3DArray[i].x, (float)vector3DArray[i].y);
                } else {
                    generalPath.lineTo((float)vector3DArray[i].x, (float)vector3DArray[i].y);
                }
            }
            boolean bl3 = bl = vector3DArray[i] != null;
            if (bl) continue;
            bl2 = true;
        }
        if (!bl2 && vector3DArray[vector3DArray.length - 1] != null && Math.abs(vector3DArray[0].x - vector3DArray[vector3DArray.length - 1].x) < 1.0E-5 && Math.abs(vector3DArray[0].y - vector3DArray[vector3DArray.length - 1].y) < 1.0E-5) {
            generalPath.closePath();
        } else if (bl && vector3DArray[vector3DArray.length - 1] != null) {
            generalPath.lineTo((float)vector3DArray[vector3DArray.length - 1].x, (float)vector3DArray[vector3DArray.length - 1].y);
        }
        graphics2D.draw(generalPath);
    }

    private void drawPatches(ArrayList<Patch> arrayList, int n, View3DLit view3DLit, boolean bl, double d, double d2) {
        int n2;
        Polygon polygon = new Polygon();
        Point2D.Double double_ = new Point2D.Double();
        Transform3D transform3D = view3DLit.getTransform3D();
        Graphics2D graphics2D = transform3D.getUntransformedGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        boolean bl2 = view3DLit.getAntialiased();
        int n3 = (int)(255.0 * (1.0 - view3DLit.getTransparency()));
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        for (n2 = arrayList.size(); n2 > 0 && arrayList.get(n2 - 1).getMidpointZ() == Double.POSITIVE_INFINITY; --n2) {
        }
        if (n2 == 0) {
            return;
        }
        int n4 = d <= 0.0 ? 0 : (int)((double)n2 * d);
        int n5 = d2 >= 1.0 ? n2 : (int)((double)n2 * d2);
        for (int i = n4; i < n5; ++i) {
            Patch patch = arrayList.get(i);
            if (!Double.isInfinite(patch.z)) {
                Vector3D vector3D = patch.getTransformedVertex(1);
                Vector3D vector3D2 = patch.getTransformedVertex(2);
                Vector3D vector3D3 = patch.getTransformedVertex(3);
                Vector3D vector3D4 = patch.getTransformedVertex(4);
                ((Point2D)double_).setLocation(vector3D.x, vector3D.y);
                transform3D.windowToViewport(double_);
                int n6 = (int)(((Point2D)double_).getX() + 0.4999);
                int n7 = (int)(((Point2D)double_).getY() + 0.4999);
                ((Point2D)double_).setLocation(vector3D2.x, vector3D2.y);
                transform3D.windowToViewport(double_);
                int n8 = (int)(((Point2D)double_).getX() + 0.4999);
                int n9 = (int)(((Point2D)double_).getY() + 0.4999);
                ((Point2D)double_).setLocation(vector3D3.x, vector3D3.y);
                transform3D.windowToViewport(double_);
                int n10 = (int)(((Point2D)double_).getX() + 0.4999);
                int n11 = (int)(((Point2D)double_).getY() + 0.4999);
                ((Point2D)double_).setLocation(vector3D4.x, vector3D4.y);
                transform3D.windowToViewport(double_);
                int n12 = (int)(((Point2D)double_).getX() + 0.4999);
                int n13 = (int)(((Point2D)double_).getY() + 0.4999);
                Color color = graphics2D.getColor();
                Color color2 = this.computeColorForPatch(patch, view3DLit);
                if (n3 < 255) {
                    color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n3);
                }
                graphics2D.setColor(color2);
                polygon.reset();
                polygon.addPoint(n6, n7);
                polygon.addPoint(n8, n9);
                polygon.addPoint(n10, n11);
                polygon.addPoint(n12, n13);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.fillPolygon(polygon);
                if (bl2) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                graphics2D.setColor(view3DLit.getViewStyle() == 1 ? Color.white : Color.black);
                if (this.uCurveIncrement > 0) {
                    if (patch.uIndex % this.uCurveIncrement == 0) {
                        graphics2D.drawLine(n6, n7, n12, n13);
                    }
                    if ((patch.uIndex + n) % this.uCurveIncrement == 0 || patch.uIndex + n >= this.uCount - 1) {
                        graphics2D.drawLine(n8, n9, n10, n11);
                    }
                }
                if (this.vCurveIncrement > 0) {
                    if (patch.vIndex % this.vCurveIncrement == 0) {
                        graphics2D.drawLine(n6, n7, n8, n9);
                    }
                    if ((patch.vIndex + n) % this.vCurveIncrement == 0 || patch.vIndex + n >= this.vCount - 1) {
                        graphics2D.drawLine(n12, n13, n10, n11);
                    }
                }
                graphics2D.setColor(color);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private Color computeColorForPatch(Patch patch, View3DLit view3DLit) {
        boolean bl;
        Vector3D vector3D = view3DLit.getTransform3D().getViewDirection();
        Vector3D vector3D2 = patch.getVertex(1);
        Vector3D vector3D3 = patch.getVertex(2);
        Vector3D vector3D4 = patch.getVertex(3);
        Vector3D vector3D5 = patch.getVertex(4);
        Vector3D vector3D6 = vector3D2.plus(vector3D3.plus(vector3D4.plus(vector3D5))).times(0.25);
        Vector3D vector3D7 = patch.getUnitNormal();
        if (view3DLit.getOrientation() == 2) {
            bl = true;
        } else {
            if (view3DLit.getOrthographicProjection()) {
                bl = vector3D7.dot(vector3D) > 0.0;
            } else {
                boolean bl2 = bl = vector3D7.dot(vector3D6.minus(view3DLit.getTransform3D().getViewPoint())) > 0.0;
            }
            if (view3DLit.getOrientation() == 1) {
                bl = !bl;
            }
        }
        Color color = this.getPatchColor(patch.uIndex, patch.vIndex, bl);
        if (view3DLit.getLightingEnabled()) {
            return PhongLighting.phongLightingColor(vector3D7, view3DLit, view3DLit.getTransform3D(), vector3D6, color);
        }
        return color;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Patch
    implements Comparable<Patch> {
        private int copyNum;
        private GridTransformMatrix gridTransform;
        private int uIndex;
        private int vIndex;
        private int size;
        private double z;

        private Patch(int n, int n2, int n3, int n4) {
            this.copyNum = n;
            this.uIndex = n2;
            this.vIndex = n3;
            this.size = n4;
            if (Grid3D.this.transforms != null && (n > 0 || n == 0 && !Grid3D.this.useIdentityTransform)) {
                this.gridTransform = Grid3D.this.useIdentityTransform ? (GridTransformMatrix)Grid3D.this.transforms.get(n - 1) : (GridTransformMatrix)Grid3D.this.transforms.get(n);
            }
        }

        public Vector3D getVertex(int n) {
            Vector3D vector3D;
            switch (n) {
                case 1: {
                    vector3D = Grid3D.this.pointsOnSurface[this.uIndex][this.vIndex];
                    break;
                }
                case 2: {
                    vector3D = Grid3D.this.pointsOnSurface[this.uIndex + this.size][this.vIndex];
                    break;
                }
                case 3: {
                    vector3D = Grid3D.this.pointsOnSurface[this.uIndex + this.size][this.vIndex + this.size];
                    break;
                }
                case 4: {
                    vector3D = Grid3D.this.pointsOnSurface[this.uIndex][this.vIndex + this.size];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal vertex number \"" + n + "\" for patch; must be 1, 2, 3, or 4.");
                }
            }
            if (vector3D == null || this.gridTransform == null) {
                return vector3D;
            }
            return this.gridTransform.apply(vector3D);
        }

        public Vector3D getTransformedVertex(int n) {
            switch (n) {
                case 1: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex][this.vIndex];
                }
                case 2: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex + this.size][this.vIndex];
                }
                case 3: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex + this.size][this.vIndex + this.size];
                }
                case 4: {
                    return Grid3D.this.transformedData[this.copyNum][this.uIndex][this.vIndex + this.size];
                }
            }
            throw new IllegalArgumentException("Illegal vertex number \"" + n + "\" for patch; must be 1, 2, 3, or 4.");
        }

        private void compute() {
            Vector3D vector3D = this.getTransformedVertex(1);
            Vector3D vector3D2 = this.getTransformedVertex(2);
            Vector3D vector3D3 = this.getTransformedVertex(3);
            Vector3D vector3D4 = this.getTransformedVertex(4);
            if (vector3D == null || vector3D2 == null || vector3D3 == null || vector3D4 == null) {
                this.z = Double.POSITIVE_INFINITY;
            } else {
                this.z = (vector3D.z + vector3D2.z + vector3D3.z + vector3D4.z) / 4.0;
                if (Double.isInfinite(this.z)) {
                    this.z = Double.POSITIVE_INFINITY;
                }
            }
        }

        public double getMidpointZ() {
            return this.z;
        }

        public Vector3D getUnitNormal() {
            Vector3D vector3D = Grid3D.this.getUnitNormal(this.uIndex, this.vIndex);
            if (this.gridTransform != null) {
                vector3D = this.gridTransform.applyToNormal(vector3D);
            }
            return vector3D;
        }

        @Override
        public int compareTo(Patch patch) {
            if (this.z > patch.z) {
                return 1;
            }
            if (this.z == patch.z) {
                return 0;
            }
            return -1;
        }
    }
}

