/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Graphics2D;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public abstract class Exhibit3D
extends Exhibit {
    protected Transform3D previousTransform3D;
    @VMMSave
    protected Vector3D defaultViewpoint = new Vector3D(20.0, 0.0, 0.0);
    @VMMSave
    protected Vector3D defaultViewUp = null;

    public Transform getDefaultTransform(View view) {
        double[] dArray = this.getDefaultWindow();
        if (view instanceof View3D) {
            Transform3D transform3D = new Transform3D(this.defaultViewpoint, dArray[0], dArray[1], dArray[2], dArray[3]);
            if (this.defaultViewUp != null) {
                transform3D.setImagePlaneYDirection(this.defaultViewUp);
            }
            return transform3D;
        }
        return new Transform(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public View getDefaultView() {
        return new View3D();
    }

    public Vector3D getDefaultViewpoint() {
        return this.defaultViewpoint;
    }

    public void setDefaultViewpoint(Vector3D vector3D) {
        this.defaultViewpoint = vector3D == null ? new Vector3D(20.0, 0.0, 0.0) : vector3D;
    }

    public Vector3D getDefaultViewUp() {
        return this.defaultViewpoint;
    }

    public void setDefaultViewUp(Vector3D vector3D) {
        this.defaultViewUp = vector3D;
    }

    protected void computeDrawDataHook(View view, Transform transform) {
        if (view instanceof View3D && transform instanceof Transform3D) {
            this.computeDrawData3D((View3D)view, this.exhibitNeedsRedraw, this.previousTransform3D, (Transform3D)transform);
            this.previousTransform3D = (Transform3D)transform.clone();
        } else {
            this.computeDrawData(view, this.exhibitNeedsRedraw, this.previousTransform, transform);
            this.previousTransform = (Transform)transform.clone();
        }
    }

    protected void doDrawHook(Graphics2D graphics2D, View view, Transform transform) {
        if (view instanceof View3D && transform instanceof Transform3D) {
            this.doDraw3D(graphics2D, (View3D)view, (Transform3D)transform);
        } else {
            this.doDraw(graphics2D, view, transform);
        }
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
    }
}

