/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Random;
import vmm.core.Decoration;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public abstract class DotCloudSurface
extends Decoration {
    @VMMSave
    private int dotCount = 10000;
    @VMMSave
    private Color color = Color.GRAY;
    private Vector3D[] points;

    protected abstract Vector3D makeRandomPixel(Random var1);

    public void setDotCount(int n) {
        this.dotCount = n;
        this.forceRedraw();
    }

    public int getDotCount() {
        return this.dotCount;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color == null ? Color.GRAY : color;
    }

    public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
        if (this.points == null || bl || this.decorationNeedsRedraw) {
            this.points = new Vector3D[this.dotCount];
            Random random = new Random(42L);
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i] = this.makeRandomPixel(random);
            }
        }
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        View3D view3D = (View3D)view;
        Color color = graphics2D.getColor();
        if (view3D.getViewStyle() == 1) {
            graphics2D.setColor(Color.WHITE);
        } else {
            graphics2D.setColor(this.color);
        }
        view3D.drawPixels(this.points);
        graphics2D.setColor(color);
    }
}

