/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import vmm.core.Complex;
import vmm.core3D.Vector3D;

public class ComplexVector3D {
    public Complex x;
    public Complex y;
    public Complex z;
    static final Complex ZERO_C = new Complex(0.0, 0.0);
    static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final ComplexVector3D ORIGIN = new ComplexVector3D();
    public static final ComplexVector3D UNIT_X = new ComplexVector3D(ONE_C, ZERO_C, ZERO_C);
    public static final ComplexVector3D UNIT_Y = new ComplexVector3D(ZERO_C, ONE_C, ZERO_C);
    public static final ComplexVector3D UNIT_Z = new ComplexVector3D(ZERO_C, ZERO_C, ONE_C);

    public ComplexVector3D() {
        this.x = new Complex(0.0, 0.0);
        this.y = new Complex(0.0, 0.0);
        this.z = new Complex(0.0, 0.0);
    }

    public ComplexVector3D(Complex complex, Complex complex2, Complex complex3) {
        if (complex == null || complex2 == null || complex3 == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else {
            this.x = new Complex(complex);
            this.y = new Complex(complex2);
            this.z = new Complex(complex3);
        }
    }

    public void assign(Complex complex, Complex complex2, Complex complex3) {
        this.x.assign(complex);
        this.y.assign(complex2);
        this.z.assign(complex3);
    }

    public ComplexVector3D(Vector3D vector3D, Vector3D vector3D2) {
        if (vector3D == null && vector3D2 == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else if (vector3D2 == null) {
            this.x = new Complex(vector3D.x, 0.0);
            this.y = new Complex(vector3D.y, 0.0);
            this.z = new Complex(vector3D.z, 0.0);
        } else if (vector3D == null) {
            this.x = new Complex(0.0, vector3D2.x);
            this.y = new Complex(0.0, vector3D2.y);
            this.z = new Complex(0.0, vector3D2.z);
        } else {
            this.x = new Complex(vector3D.x, vector3D2.x);
            this.y = new Complex(vector3D.y, vector3D2.y);
            this.z = new Complex(vector3D.z, vector3D2.z);
        }
    }

    public ComplexVector3D(ComplexVector3D complexVector3D) {
        if (complexVector3D == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else if (complexVector3D.x == null || complexVector3D.y == null || complexVector3D.z == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else {
            this.x = new Complex(complexVector3D.x);
            this.y = new Complex(complexVector3D.y);
            this.z = new Complex(complexVector3D.z);
        }
    }

    public void assign(ComplexVector3D complexVector3D) {
        this.x.assign(complexVector3D.x);
        this.y.assign(complexVector3D.y);
        this.z.assign(complexVector3D.z);
    }

    public boolean equals(Object object) {
        try {
            ComplexVector3D complexVector3D = (ComplexVector3D)object;
            if (this.x == null && complexVector3D.x != null) {
                return false;
            }
            if (this.y == null && complexVector3D.y != null) {
                return false;
            }
            if (this.z == null && complexVector3D.z != null) {
                return false;
            }
            return this.x.equals(complexVector3D.x) && this.y.equals(complexVector3D.y) && this.z.equals(complexVector3D.z);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Vector3D re() {
        Vector3D vector3D = new Vector3D();
        vector3D.x = this.x.re;
        vector3D.y = this.y.re;
        vector3D.z = this.z.re;
        return vector3D;
    }

    public Vector3D im() {
        Vector3D vector3D = new Vector3D();
        vector3D.x = this.x.im;
        vector3D.y = this.y.im;
        vector3D.z = this.z.im;
        return vector3D;
    }

    public double norm() {
        return Math.sqrt(this.re().norm2() + this.im().norm2());
    }

    public void normalize() {
        double d = 1.0 / Math.sqrt(this.norm());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.z.re = Double.NaN;
            this.y.re = Double.NaN;
            this.x.re = Double.NaN;
            this.z.im = Double.NaN;
            this.y.im = Double.NaN;
            this.x.im = Double.NaN;
        } else {
            this.x = this.x.times(d);
            this.y = this.y.times(d);
            this.z = this.z.times(d);
        }
    }

    public void negate() {
        this.x = this.x.times(-1.0);
        this.y = this.y.times(-1.0);
        this.z = this.z.times(-1.0);
    }

    public ComplexVector3D plus(ComplexVector3D complexVector3D) {
        return new ComplexVector3D(this.x.plus(complexVector3D.x), this.y.plus(complexVector3D.y), this.z.plus(complexVector3D.z));
    }

    public void assignPlus(ComplexVector3D complexVector3D) {
        this.x.assignPlus(complexVector3D.x);
        this.y.assignPlus(complexVector3D.y);
        this.z.assignPlus(complexVector3D.z);
    }

    public ComplexVector3D minus(ComplexVector3D complexVector3D) {
        return new ComplexVector3D(this.x.minus(complexVector3D.x), this.y.minus(complexVector3D.y), this.z.minus(complexVector3D.z));
    }

    public void assignMinus(ComplexVector3D complexVector3D) {
        this.x.assignMinus(complexVector3D.x);
        this.y.assignMinus(complexVector3D.y);
        this.z.assignMinus(complexVector3D.z);
    }

    public ComplexVector3D times(Complex complex) {
        return new ComplexVector3D(this.x.times(complex), this.y.times(complex), this.z.times(complex));
    }

    public ComplexVector3D times(double d) {
        return new ComplexVector3D(this.x.times(d), this.y.times(d), this.z.times(d));
    }

    public void assignTimes(Complex complex) {
        this.x.assignTimes(complex);
        this.y.assignTimes(complex);
        this.z.assignTimes(complex);
    }

    public void assignTimes(double d) {
        this.x.assignTimes(d);
        this.y.assignTimes(d);
        this.z.assignTimes(d);
    }
}

