/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import vmm.core.Display;
import vmm.core.MouseTask;
import vmm.core.TimerAnimation;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class BasicMouseTask3D
extends MouseTask {
    private int operation;
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int ROTATE = 3;
    private static final int MOVE_NORMAL_TO_SCREEN = 4;
    private int startx;
    private int starty;
    private int prevx;
    private int prevy;
    private double[] startWindow;
    private double requestedAspectRatio;
    private Transform3D transform;
    private double virtualSphereRadius;
    private Vector3D previousRay;
    private Vector3D currentRay;
    private long lastDragTime;
    private long mouseDownTime;
    private boolean startedDragging;
    private boolean saveFastDrawing;
    private boolean isStereographView;
    private Rectangle stereographLeftEyeRect;
    private Rectangle stereographRightEyeRect;
    private boolean inLeftEyeRect;
    private Transform3D stereographTransform;
    private double zoom_startx_real;
    private double zoom_starty_real;
    private double zoom_startx_pixel;
    private double zoom_starty_pixel;
    private double originalObjectDisplacementNormalToScreen;

    public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        this.operation = 0;
        if (view.getExhibit() == null) {
            return false;
        }
        try {
            this.startWindow = view.getWindow();
            this.transform = (Transform3D)view.getTransform();
            this.requestedAspectRatio = Math.abs((this.transform.getYmaxRequested() - this.transform.getYminRequested()) / (this.transform.getXmaxRequested() - this.transform.getXminRequested()));
        }
        catch (Exception exception) {
            return false;
        }
        this.operation = view instanceof View3D && ((View3D)view).getViewStyle() == 1 && mouseEvent.isAltDown() && mouseEvent.isShiftDown() ? 4 : (mouseEvent.isAltDown() || mouseEvent.isShiftDown() ? 2 : (mouseEvent.isControlDown() || mouseEvent.isMetaDown() ? 1 : 3));
        this.startx = this.prevx = mouseEvent.getX();
        this.starty = this.prevy = mouseEvent.getY();
        boolean bl = this.isStereographView = view instanceof View3D && (((View3D)view).getViewStyle() == 2 || ((View3D)view).getViewStyle() == 3);
        if (this.isStereographView && !(view.getTransform() instanceof Transform3D)) {
            return false;
        }
        if (this.isStereographView && this.operation != 1) {
            this.stereographLeftEyeRect = ((View3D)view).stereographLeftEyeRect();
            this.stereographRightEyeRect = ((View3D)view).stereographRightEyeRect();
            if (this.stereographLeftEyeRect.contains(this.startx, this.starty)) {
                this.startx = this.prevx = this.startx - this.stereographLeftEyeRect.x;
                this.starty = this.prevy = this.starty - this.stereographLeftEyeRect.y;
                this.inLeftEyeRect = true;
            } else if (this.stereographRightEyeRect.contains(this.startx, this.starty)) {
                this.startx = this.prevx = this.startx - this.stereographRightEyeRect.x;
                this.starty = this.prevy = this.starty - this.stereographRightEyeRect.y;
                this.inLeftEyeRect = false;
            } else {
                return false;
            }
            this.stereographTransform = (Transform3D)view.getTransform().clone();
            this.stereographTransform.setUpDrawInfo(null, 0, 0, this.stereographLeftEyeRect.width, this.stereographLeftEyeRect.height, view.getPreserveAspect(), view.getApplyGraphics2DTransform());
        }
        if (this.operation == 2) {
            this.operation = 2;
            if (this.isStereographView) {
                this.zoom_startx_real = this.stereographTransform.getXmin() + (double)this.startx * ((this.stereographTransform.getXmax() - this.stereographTransform.getXmin()) / (double)this.stereographTransform.getWidth());
                this.zoom_starty_real = this.stereographTransform.getYmin() + (double)(this.stereographTransform.getHeight() - this.starty) * ((this.stereographTransform.getYmax() - this.stereographTransform.getYmin()) / (double)this.stereographTransform.getHeight());
                Point2D.Double double_ = new Point2D.Double(this.startx, this.starty);
                this.stereographTransform.viewportToWindow(double_);
                this.transform.windowToViewport(double_);
                this.zoom_startx_pixel = ((Point2D)double_).getX();
                this.zoom_starty_pixel = ((Point2D)double_).getY();
            } else {
                this.zoom_startx_real = this.startWindow[0] + (double)this.startx * ((this.startWindow[1] - this.startWindow[0]) / (double)n);
                this.zoom_starty_real = this.startWindow[2] + (double)(n2 - this.starty) * ((this.startWindow[3] - this.startWindow[2]) / (double)n2);
                this.zoom_startx_pixel = this.startx;
                this.zoom_starty_pixel = this.starty;
            }
        } else if (this.operation == 3) {
            this.virtualSphereRadius = this.isStereographView ? 0.48 * Math.min(Math.abs(this.stereographTransform.getXmax() - this.stereographTransform.getXmin()), Math.abs(this.stereographTransform.getYmax() - this.stereographTransform.getYmin())) : 0.48 * Math.min(Math.abs(this.transform.getXmax() - this.transform.getXmin()), Math.abs(this.transform.getYmax() - this.transform.getYmin()));
            this.operation = 3;
        } else if (this.operation == 4) {
            this.originalObjectDisplacementNormalToScreen = ((Transform3D)view.getTransform()).getObjectDisplacementNormalToScreen();
        }
        this.saveFastDrawing = view.getFastDrawing();
        this.mouseDownTime = mouseEvent.getWhen();
        this.startedDragging = false;
        return true;
    }

    public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        if (this.operation == 0) {
            return;
        }
        if (!this.startedDragging && mouseEvent.getWhen() - this.mouseDownTime < 300L && Math.abs(mouseEvent.getX() - this.startx) < 3 && Math.abs(mouseEvent.getY() - this.starty) < 3) {
            return;
        }
        if (!this.startedDragging) {
            this.startedDragging = true;
            view.setFastDrawing(true);
        }
        if (this.operation == 4) {
            double d = Math.max(this.transform.getXmax() - this.transform.getXmin(), this.transform.getYmax() - this.transform.getYmin());
            double d2 = (double)(mouseEvent.getY() - this.starty) / (double)(n2 / 2) * d;
            this.transform.setObjectDisplacementNormalToScreen(this.originalObjectDisplacementNormalToScreen + d2);
            return;
        }
        int n3 = mouseEvent.isAltDown() || mouseEvent.isShiftDown() ? 2 : (mouseEvent.isControlDown() || mouseEvent.isMetaDown() ? 1 : 3);
        if (n3 != this.operation) {
            this.operation = n3;
            this.startx = this.prevx = mouseEvent.getX();
            this.starty = this.prevy = mouseEvent.getY();
            if (this.isStereographView && this.operation != 1) {
                if (this.inLeftEyeRect) {
                    this.startx = this.prevx = this.startx - this.stereographLeftEyeRect.x;
                    this.starty = this.prevy = this.starty - this.stereographLeftEyeRect.y;
                } else {
                    this.startx = this.prevx = this.startx - this.stereographRightEyeRect.x;
                    this.starty = this.prevy = this.starty - this.stereographRightEyeRect.y;
                }
                this.stereographTransform = (Transform3D)view.getTransform().clone();
                this.stereographTransform.setUpDrawInfo(null, 0, 0, this.stereographLeftEyeRect.width, this.stereographLeftEyeRect.height, view.getPreserveAspect(), view.getApplyGraphics2DTransform());
            }
            this.startWindow = view.getWindow();
            if (n3 == 2) {
                if (this.isStereographView) {
                    this.zoom_startx_real = this.stereographTransform.getXmin() + (double)this.startx * ((this.stereographTransform.getXmax() - this.stereographTransform.getXmin()) / (double)this.stereographTransform.getWidth());
                    this.zoom_starty_real = this.stereographTransform.getYmin() + (double)(this.stereographTransform.getHeight() - this.starty) * ((this.stereographTransform.getYmax() - this.stereographTransform.getYmin()) / (double)this.stereographTransform.getHeight());
                    Point2D.Double double_ = new Point2D.Double(this.startx, this.starty);
                    this.stereographTransform.viewportToWindow(double_);
                    this.transform.windowToViewport(double_);
                    this.zoom_startx_pixel = ((Point2D)double_).getX();
                    this.zoom_starty_pixel = ((Point2D)double_).getY();
                } else {
                    this.zoom_startx_real = this.startWindow[0] + (double)this.startx * ((this.startWindow[1] - this.startWindow[0]) / (double)n);
                    this.zoom_starty_real = this.startWindow[2] + (double)(n2 - this.starty) * ((this.startWindow[3] - this.startWindow[2]) / (double)n2);
                    this.zoom_startx_pixel = this.startx;
                    this.zoom_starty_pixel = this.starty;
                }
            } else if (n3 == 3) {
                this.virtualSphereRadius = this.isStereographView ? 0.48 * Math.min(Math.abs(this.stereographTransform.getXmax() - this.stereographTransform.getXmin()), Math.abs(this.stereographTransform.getYmax() - this.stereographTransform.getYmin())) : 0.48 * Math.min(Math.abs(this.transform.getXmax() - this.transform.getXmin()), Math.abs(this.transform.getYmax() - this.transform.getYmin()));
            }
            return;
        }
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        if (this.isStereographView && this.operation != 1) {
            if (this.inLeftEyeRect) {
                n4 -= this.stereographLeftEyeRect.x;
                n5 -= this.stereographLeftEyeRect.y;
            } else {
                n4 -= this.stereographRightEyeRect.x;
                n5 -= this.stereographRightEyeRect.y;
            }
        }
        switch (this.operation) {
            case 1: {
                double d;
                double d3;
                if (this.isStereographView) {
                    int n6 = mouseEvent.getX() - this.prevx;
                    if (n6 != 0) {
                        ((View3D)view).moveStereographImages(n6);
                    }
                    this.prevx = mouseEvent.getX();
                    break;
                }
                double d4 = Math.abs(this.startWindow[1] - this.startWindow[0]) / (double)n;
                double d5 = Math.abs(this.startWindow[3] - this.startWindow[2]) / (double)n2;
                if (this.isStereographView) {
                    double d6 = Math.abs(this.stereographTransform.getXmax() - this.stereographTransform.getXmin()) / (double)this.stereographLeftEyeRect.width;
                    double d7 = Math.abs(this.stereographTransform.getYmax() - this.stereographTransform.getYmin()) / (double)this.stereographLeftEyeRect.height;
                    d3 = (double)(this.startx - n4) * d6;
                    d = (double)(-(this.starty - n5)) * d7;
                } else {
                    d3 = (double)(this.startx - n4) * d4;
                    d = (double)(-(this.starty - n5)) * d5;
                }
                this.newWindow(view, this.startWindow[0] + d3, this.startWindow[1] + d3, this.startWindow[2] + d, this.startWindow[3] + d);
                view.forceRedraw();
                break;
            }
            case 2: {
                if (this.isStereographView) {
                    n = this.stereographTransform.getWidth();
                    n2 = this.stereographTransform.getHeight();
                }
                double d = (double)(-(this.starty - n5)) / 200.0;
                double d8 = Math.exp(d);
                double d9 = (this.startWindow[1] - this.startWindow[0]) * d8;
                double d10 = (this.startWindow[3] - this.startWindow[2]) * d8;
                double d11 = d9 / (double)n;
                double d12 = d10 / (double)n2;
                double d13 = this.zoom_startx_real - d11 * this.zoom_startx_pixel;
                double d14 = d13 + d9;
                double d15 = this.zoom_starty_real - d12 * ((double)n2 - this.zoom_starty_pixel);
                double d16 = d15 + d10;
                this.newWindow(view, d13, d14, d15, d16);
                view.forceRedraw();
                break;
            }
            case 3: {
                if (this.prevx == n4 && this.prevy == n5) break;
                this.previousRay = this.mousePointToRay(this.prevx, this.prevy);
                this.currentRay = this.mousePointToRay(n4, n5);
                this.transform.applyTransvection(this.previousRay, this.currentRay);
                this.prevx = n4;
                this.prevy = n5;
                view.forceRedraw();
                this.lastDragTime = mouseEvent.getWhen();
            }
        }
    }

    public void doMouseUp(MouseEvent mouseEvent, Display display, final View view, int n, int n2) {
        if (!this.startedDragging || this.operation == 0) {
            return;
        }
        boolean bl = false;
        if (this.operation == 3) {
            display.repaint();
            final boolean bl2 = this.saveFastDrawing;
            final Transform3D transform3D = this.transform;
            final Vector3D vector3D = this.previousRay;
            final Vector3D vector3D2 = this.currentRay;
            if (mouseEvent.getWhen() - this.lastDragTime < 200L && this.currentRay != null && this.currentRay.minus(this.previousRay).norm() >= 0.002) {
                bl = true;
                display.installAnimation(new TimerAnimation(0, 50){

                    protected void drawFrame() {
                        transform3D.applyTransvection(vector3D, vector3D2);
                        view.forceRedraw();
                    }

                    protected void animationEnding() {
                        view.setFastDrawing(bl2);
                    }
                });
            }
        }
        if (!bl) {
            view.setFastDrawing(this.saveFastDrawing);
        }
        this.transform = null;
        this.currentRay = null;
        this.previousRay = null;
        this.stereographLeftEyeRect = null;
        this.stereographRightEyeRect = null;
        this.stereographTransform = null;
        this.operation = 0;
    }

    public Cursor getCursorForDragging(MouseEvent mouseEvent, Display display, View view) {
        if (this.operation == 1) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.operation == 2) {
            return Cursor.getPredefinedCursor(9);
        }
        return null;
    }

    private Vector3D mousePointToRay(int n, int n2) {
        Vector3D vector3D;
        Transform3D transform3D = this.isStereographView ? this.stereographTransform : this.transform;
        Point2D.Double double_ = new Point2D.Double(n, n2);
        transform3D.viewportToWindow(double_);
        Vector3D vector3D2 = transform3D.getImagePlaneXDirection();
        Vector3D vector3D3 = transform3D.getImagePlaneYDirection();
        double d = ((Point2D)double_).getX() * vector3D2.x + ((Point2D)double_).getY() * vector3D3.x;
        double d2 = ((Point2D)double_).getX() * vector3D2.y + ((Point2D)double_).getY() * vector3D3.y;
        double d3 = ((Point2D)double_).getX() * vector3D2.z + ((Point2D)double_).getY() * vector3D3.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 > this.virtualSphereRadius * this.virtualSphereRadius) {
            double d5 = Math.sqrt(d4);
            vector3D = new Vector3D(d * this.virtualSphereRadius / d5, d2 * this.virtualSphereRadius / d5, d3 * this.virtualSphereRadius / d5);
        } else {
            double d6 = Math.sqrt(this.virtualSphereRadius * this.virtualSphereRadius - d4);
            Vector3D vector3D4 = transform3D.getViewDirection();
            vector3D = new Vector3D(d - d6 * vector3D4.x, d2 - d6 * vector3D4.y, d3 - d6 * vector3D4.z);
        }
        vector3D.normalize();
        return vector3D;
    }

    private void newWindow(View view, double d, double d2, double d3, double d4) {
        double d5 = Math.abs((d4 - d3) / (d2 - d));
        if (d5 > this.requestedAspectRatio) {
            double d6 = this.requestedAspectRatio / d5;
            double d7 = (d4 - d3) * d6;
            double d8 = (d4 + d3) / 2.0;
            d3 = d8 - d7 / 2.0;
            d4 = d8 + d7 / 2.0;
        } else {
            double d9 = d5 / this.requestedAspectRatio;
            double d10 = (d2 - d) * d9;
            double d11 = (d2 + d) / 2.0;
            d = d11 - d10 / 2.0;
            d2 = d11 + d10 / 2.0;
        }
        view.setWindow(d, d2, d3, d4);
    }
}

