/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.Animation;
import vmm.core.Axes2D;
import vmm.core.BasicMouseTask2D;
import vmm.core.Decorateable;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Parameter;
import vmm.core.Parameterizable;
import vmm.core.Transform;
import vmm.core.UserExhibit;
import vmm.core.VMMSave;

public class View
implements Parameterizable,
Decorateable,
ChangeListener {
    private Display display;
    private Exhibit exhibit;
    private String name;
    @VMMSave
    private boolean applyGraphics2DTransform = true;
    @VMMSave
    private boolean preserveAspect = true;
    @VMMSave
    private boolean antialiased;
    @VMMSave
    private boolean showAxes;
    @VMMSave
    private Color background = Color.white;
    @VMMSave
    private Color foreground = Color.black;
    private Point2D tempPoint = new Point2D.Double();
    private int previousWidth;
    private int previousHeight;
    private Transform transform;
    protected Animation buildAnimation;
    protected boolean needsRedraw;
    protected BufferedImage fullOSI;
    protected Graphics2D currentGraphics;
    protected ArrayList<Parameter> parameters;
    protected ArrayList<Decoration> decorations;
    protected volatile boolean buildingImageForFilmstrip;
    protected AbstractActionVMM showAxesAction = new AbstractActionVMM(I18n.tr("vmm.core.commands.ShowAxes")){

        public void actionPerformed(ActionEvent actionEvent) {
            View.this.setShowAxes(!View.this.getShowAxes());
        }
    };
    protected ActionRadioGroup backgroundCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm.core.commands.BlackBackground"), I18n.tr("vmm.core.commands.WhiteBackground"), I18n.tr("vmm.core.commands.CustomBackground")}, 1){

        public void optionSelected(int n) {
            if (n == 0) {
                View.this.setBackground(Color.black);
                this.setSelectedIndex(0);
            } else if (n == 1) {
                View.this.setBackground(Color.white);
                this.setSelectedIndex(1);
            } else if (View.this.getDisplay() != null) {
                Color color = JColorChooser.showDialog(View.this.getDisplay(), I18n.tr("vmm.core.dialogtitle.ChooseBackground"), View.this.getBackground());
                if (color != null) {
                    View.this.setBackground(color);
                    this.setSelectedIndex(2);
                } else {
                    if (View.this.getBackground().equals(Color.black)) {
                        this.setSelectedIndex(0);
                    } else if (View.this.getBackground().equals(Color.white)) {
                        this.setSelectedIndex(1);
                    } else {
                        this.setSelectedIndex(2);
                    }
                    return;
                }
            }
            View.this.forceRedraw();
        }
    };
    protected boolean directOffscreenDrawing;
    protected int offscreenImageType = 1;

    public String getName() {
        if (this.name == null) {
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return I18n.tr(this.getName());
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Exhibit getExhibit() {
        return this.exhibit;
    }

    public void setExhibit(Exhibit exhibit) {
        if (exhibit == this.exhibit) {
            return;
        }
        if (this.exhibit != null) {
            this.exhibit.removeChangeListener(this);
            this.exhibit.removeView(this);
        }
        this.exhibit = exhibit;
        if (exhibit == null) {
            this.setTransform(null);
            this.setBackground(null);
            this.setForeground(null);
        } else {
            exhibit.addChangeListener(this);
            exhibit.addView(this);
            this.setTransform(exhibit.getDefaultTransform(this));
            this.setBackground(exhibit.getDefaultBackground());
            this.setForeground(exhibit.getDefaultForeground());
        }
        this.forceRedraw();
    }

    public void finish() {
    }

    public void takeExhibit(View view, boolean bl) {
        Exhibit exhibit;
        Exhibit exhibit2 = exhibit = view == null ? null : view.getExhibit();
        if (exhibit == null) {
            this.setExhibit(null);
        } else {
            this.setExhibit(exhibit);
            this.setBackground(exhibit.getDefaultBackground());
            this.setForeground(exhibit.getDefaultForeground());
            if (bl) {
                this.setTransform(view.getTransform());
            } else {
                this.setTransform((Transform)view.getTransform().clone());
            }
        }
    }

    public String getStatusText() {
        return null;
    }

    public boolean getShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean bl) {
        if (bl != this.showAxes) {
            if (bl) {
                Axes2D axes2D = this.createAxes();
                this.addDecoration(axes2D);
            } else {
                for (int i = this.decorations.size() - 1; i >= 0; --i) {
                    if (!(this.decorations.get(i) instanceof Axes2D)) continue;
                    this.decorations.remove(i);
                }
                this.forceRedraw();
            }
            if (bl) {
                this.showAxesAction.putValue("Name", I18n.tr("vmm.core.commands.HideAxes"));
            } else {
                this.showAxesAction.putValue("Name", I18n.tr("vmm.core.commands.ShowAxes"));
            }
            this.showAxes = bl;
        }
    }

    protected Axes2D createAxes() {
        return new Axes2D();
    }

    public MouseTask getDefaultMouseTask() {
        return new BasicMouseTask2D();
    }

    public boolean getApplyGraphics2DTransform() {
        return this.applyGraphics2DTransform;
    }

    public void setApplyGraphics2DTransform(boolean bl) {
        if (bl != this.applyGraphics2DTransform) {
            this.forceRedraw();
            this.applyGraphics2DTransform = bl;
        }
    }

    public boolean getPreserveAspect() {
        return this.preserveAspect;
    }

    public void setPreserveAspect(boolean bl) {
        if (bl != this.preserveAspect) {
            this.forceRedraw();
            this.preserveAspect = bl;
        }
    }

    public boolean getAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean bl) {
        if (bl != this.antialiased) {
            this.forceRedraw();
            this.antialiased = bl;
        }
    }

    public void setWindow(double d, double d2, double d3, double d4) {
        if (this.transform != null) {
            this.transform.setLimits(d, d2, d3, d4);
        }
    }

    public void setWindow(double[] dArray) {
        if (dArray != null) {
            this.setWindow(dArray[0], dArray[1], dArray[2], dArray[3]);
        }
    }

    public double[] getWindow() {
        if (this.transform == null) {
            return null;
        }
        return new double[]{this.transform.getXmin(), this.transform.getXmax(), this.transform.getYmin(), this.transform.getYmax()};
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        if (transform != null) {
            transform.removeChangeListener(this);
        }
        this.transform = transform;
        if (transform != null) {
            transform.addChangeListener(this);
        }
    }

    public double[] getRequestedWindow() {
        if (this.transform == null) {
            return null;
        }
        return new double[]{this.transform.getXminRequested(), this.transform.getXmaxRequested(), this.transform.getYminRequested(), this.transform.getYmaxRequested()};
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = this.exhibit != null ? this.exhibit.getDefaultBackground() : Color.white;
        }
        if (color.equals(this.background)) {
            return;
        }
        this.background = color;
        if (color.getRed() < 150 && color.getGreen() < 120 && color.getBlue() < 150) {
            this.setForeground(Color.white);
        } else {
            this.setForeground(Color.black);
        }
        this.forceRedraw();
        if (Color.black.equals(this.getBackground())) {
            this.backgroundCommands.setSelectedIndex(0);
        } else if (Color.white.equals(this.getBackground())) {
            this.backgroundCommands.setSelectedIndex(1);
        } else {
            this.backgroundCommands.setSelectedIndex(2);
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = this.exhibit != null ? this.exhibit.getDefaultBackground() : Color.white;
        }
        if (color.equals(this.foreground)) {
            return;
        }
        this.foreground = color;
        this.forceRedraw();
    }

    public void setFastDrawing(boolean bl, boolean bl2) {
        if (this.transform != null) {
            this.transform.setFastDrawing(bl, bl2);
            if (!bl2) {
                this.forceRedraw();
            }
        }
    }

    public void setFastDrawing(boolean bl) {
        this.setFastDrawing(bl, true);
    }

    public boolean getFastDrawing() {
        return this.transform == null ? false : this.transform.getFastDrawing();
    }

    public void addExtraXML(Document document, Element element) {
    }

    public void readExtraXML(Element element) throws IOException {
    }

    public Parameter[] getParameters() {
        if (this.parameters == null) {
            return new Parameter[0];
        }
        Parameter[] parameterArray = new Parameter[this.parameters.size()];
        for (int i = parameterArray.length - 1; i >= 0; --i) {
            parameterArray[parameterArray.length - i - 1] = this.parameters.get(i);
        }
        return parameterArray;
    }

    public Parameter[] getViewAndExhibitParameters() {
        int n;
        Parameter[] parameterArray = null;
        Parameter[] parameterArray2 = null;
        if (this.exhibit != null) {
            parameterArray = this.exhibit.getParameters();
            if (this.exhibit instanceof UserExhibit) {
                parameterArray2 = ((UserExhibit)((Object)this.exhibit)).getUserExhibitSupport().getFunctionParameters();
            }
        }
        int n2 = this.parameters == null ? 0 : this.parameters.size();
        n2 += parameterArray == null ? 0 : parameterArray.length;
        Parameter[] parameterArray3 = new Parameter[n2 += parameterArray2 == null ? 0 : parameterArray2.length];
        int n3 = 0;
        if (parameterArray2 != null) {
            for (n = 0; n < parameterArray2.length; ++n) {
                parameterArray3[n3++] = parameterArray2[n];
            }
        }
        if (parameterArray != null) {
            for (n = 0; n < parameterArray.length; ++n) {
                parameterArray3[n3++] = parameterArray[n];
            }
        }
        if (this.parameters != null) {
            for (n = 0; n < this.parameters.size(); ++n) {
                parameterArray3[n3++] = this.parameters.get(n);
            }
        }
        return parameterArray3;
    }

    public Parameter getParameterByName(String string) {
        if (this.parameters != null && string != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!string.equals(this.parameters.get(i).getName())) continue;
                return this.parameters.get(i);
            }
        }
        return null;
    }

    protected void addParameter(Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        if (this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.add(parameter);
        parameter.setOwner(this);
    }

    protected void removeParameter(Parameter parameter) {
        if (parameter == null || this.parameters == null || !this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.remove(parameter);
        parameter.setOwner(null);
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        this.forceRedraw();
    }

    public void addDecoration(Decoration decoration) {
        if (decoration == null) {
            return;
        }
        if (this.decorations == null) {
            this.decorations = new ArrayList();
        }
        if (this.decorations.contains(decoration)) {
            return;
        }
        this.decorations.add(decoration);
        decoration.addChangeListener(this);
        this.forceRedraw();
    }

    public void removeDecoration(Decoration decoration) {
        if (this.decorations != null && decoration != null && this.decorations.contains(decoration)) {
            this.decorations.remove(decoration);
            if (this.decorations.size() == 0) {
                this.decorations = null;
            }
            decoration.removeChangeListener(this);
            this.forceRedraw();
        }
    }

    public void clearDecorations() {
        if (this.decorations != null) {
            for (int i = 0; i < this.decorations.size(); ++i) {
                this.decorations.get(i).removeChangeListener(this);
            }
            this.decorations = null;
            this.forceRedraw();
        }
    }

    public Decoration[] getDecorations() {
        if (this.decorations == null) {
            return new Decoration[0];
        }
        Decoration[] decorationArray = new Decoration[this.decorations.size()];
        this.decorations.toArray(decorationArray);
        return decorationArray;
    }

    public ActionList getViewCommands() {
        ActionList actionList = new ActionList();
        actionList.add(this.showAxesAction);
        actionList.add(null);
        actionList.add(this.backgroundCommands);
        return actionList;
    }

    public ActionList getSettingsCommands() {
        return new ActionList();
    }

    public ActionList getSettingsCommandsForViewAndExhibit() {
        Object object;
        ActionList actionList = null;
        AbstractActionVMM abstractActionVMM = null;
        if (this.exhibit != null) {
            actionList = this.exhibit.getSettingsCommandsForView(this);
            if (this.exhibit instanceof UserExhibit && ((UserExhibit.Support)(object = ((UserExhibit)((Object)this.exhibit)).getUserExhibitSupport())).getAllowChangeUserDataCommand()) {
                abstractActionVMM = ((UserExhibit.Support)object).makeChangeUserDataAction(this);
            }
        }
        object = this.getSettingsCommands();
        if (actionList == null && abstractActionVMM == null && object == null) {
            return null;
        }
        ActionList actionList2 = new ActionList();
        if (actionList != null) {
            actionList2.addAll(actionList);
        }
        if (abstractActionVMM != null) {
            if (actionList2.getItemCount() > 0) {
                actionList2.add(null);
            }
            actionList2.add(abstractActionVMM);
        }
        if (object != null && ((ActionList)object).getItemCount() > 0) {
            if (actionList2.getItemCount() > 0) {
                actionList2.add(null);
            }
            actionList2.addAll((ActionList)object);
        }
        return actionList2;
    }

    public ActionList getActions() {
        return new ActionList();
    }

    public ActionList getActionsForViewAndExhibit() {
        ActionList actionList = null;
        if (this.exhibit != null) {
            actionList = this.exhibit.getActionsForView(this);
        }
        ActionList actionList2 = this.getActions();
        if (actionList == null && actionList2 == null) {
            return null;
        }
        ActionList actionList3 = new ActionList();
        if (actionList != null) {
            actionList3.addAll(actionList);
        }
        if (actionList2 != null && actionList2.getItemCount() > 0) {
            if (actionList3.getItemCount() > 0) {
                actionList3.add(null);
            }
            actionList3.addAll(actionList2);
        }
        return actionList3;
    }

    public ActionList getAdditionalAnimations() {
        return new ActionList();
    }

    public ActionList getAdditionalAnimationsForViewAndExhibit() {
        ActionList actionList = null;
        if (this.exhibit != null) {
            actionList = this.exhibit.getAdditionalAnimationsForView(this);
        }
        ActionList actionList2 = this.getAdditionalAnimations();
        if (actionList == null && actionList2 == null) {
            return null;
        }
        ActionList actionList3 = new ActionList();
        if (actionList != null) {
            actionList3.addAll(actionList);
        }
        if (actionList2 != null && actionList2.getItemCount() > 0) {
            if (actionList3.getItemCount() > 0) {
                actionList3.add(null);
            }
            actionList3.addAll(actionList2);
        }
        return actionList3;
    }

    protected void doDraw(Graphics2D graphics2D) {
        if (this.exhibit != null) {
            this.exhibit.render(graphics2D, this, this.transform, this.decorations);
        }
    }

    public void forceRedraw() {
        this.needsRedraw = true;
        if (this.buildAnimation != null) {
            this.buildAnimation.cancel();
        }
        if (this.display != null) {
            this.display.repaint();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.forceRedraw();
    }

    void installBuildAnimation(Animation animation) {
        if (this.buildAnimation != null) {
            this.buildAnimation.cancel();
        }
        this.buildAnimation = animation;
        if (animation != null) {
            this.display.installAnimation(animation);
        }
    }

    Animation getBuildAnimation() {
        return this.buildAnimation;
    }

    public void render(Graphics2D graphics2D, int n, int n2) {
        if (this.directOffscreenDrawing) {
            this.endDrawToOffscreenImage();
        }
        if (n == 0 || n2 == 0) {
            return;
        }
        if (this.exhibit == null) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.background);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(color);
            return;
        }
        if (this.previousWidth != n || this.previousHeight != n2) {
            this.needsRedraw = true;
            this.previousWidth = n;
            this.previousHeight = n2;
        }
        if (this.needsNewOSI(n, n2)) {
            this.needsRedraw = true;
            try {
                this.createOSI(n, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.previousWidth = 0;
                Color color = graphics2D.getColor();
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(Color.RED);
                graphics2D.drawString(I18n.tr("vmm.core.OutOfMemoryError"), 20, 35);
                graphics2D.setColor(color);
                return;
            }
        }
        if (this.needsRedraw) {
            this.clearOSI();
            Graphics2D graphics2D2 = this.prepareOSIForDrawing();
            this.doDraw(graphics2D2);
            this.finishOSIDraw();
            this.currentGraphics = null;
            this.transform.finishDrawing();
            graphics2D2.dispose();
            this.needsRedraw = false;
        }
        this.putOSI(graphics2D, n, n2);
    }

    protected boolean needsNewOSI(int n, int n2) {
        return this.fullOSI == null || this.fullOSI.getWidth() != n || this.fullOSI.getHeight() != n2;
    }

    protected void putOSI(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawImage((Image)this.fullOSI, 0, 0, null);
    }

    protected void createOSI(int n, int n2) {
        this.fullOSI = null;
        this.fullOSI = new BufferedImage(n, n2, this.offscreenImageType);
    }

    protected void clearOSI() {
        Graphics2D graphics2D = (Graphics2D)this.fullOSI.getGraphics();
        graphics2D.setColor(this.background);
        graphics2D.fillRect(0, 0, this.fullOSI.getWidth(), this.fullOSI.getHeight());
        graphics2D.dispose();
    }

    protected Graphics2D prepareOSIForDrawing() {
        Graphics2D graphics2D = (Graphics2D)this.fullOSI.getGraphics();
        graphics2D.setColor(this.foreground);
        graphics2D.setBackground(this.background);
        if (this.antialiased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.transform.setUpDrawInfo(graphics2D, 0, 0, this.fullOSI.getWidth(), this.fullOSI.getHeight(), this.preserveAspect, this.applyGraphics2DTransform);
        this.currentGraphics = graphics2D;
        return this.currentGraphics;
    }

    protected void finishOSIDraw() {
    }

    public void setColor(Color color) {
        if (this.currentGraphics != null) {
            this.currentGraphics.setColor(color == null ? this.getForeground() : color);
        }
    }

    public Color getColor() {
        return this.currentGraphics == null ? null : this.currentGraphics.getColor();
    }

    public void setStrokeSizeMultiplier(int n) {
        if (this.currentGraphics != null) {
            this.currentGraphics.setStroke(new BasicStroke((float)n * this.transform.getDefaultStrokeSize()));
        }
    }

    public void drawPixel(double d, double d2) {
        this.tempPoint.setLocation(d, d2);
        this.transform.windowToViewport(this.tempPoint);
        int n = (int)(this.tempPoint.getX() + 0.4999);
        int n2 = (int)(this.tempPoint.getY() + 0.4999);
        this.drawPixelDirect(null, n, n2);
    }

    public void drawPixel(Point2D point2D) {
        this.drawPixel(point2D.getX(), point2D.getY());
    }

    public void drawDot(Point2D point2D, double d) {
        this.tempPoint.setLocation(point2D);
        this.transform.windowToDrawingCoords(this.tempPoint);
        double d2 = d * this.transform.getPixelWidth();
        double d3 = d * this.transform.getPixelHeight();
        this.currentGraphics.fill(new Ellipse2D.Double(point2D.getX() - d2 / 2.0, point2D.getY() - d3 / 2.0, d2, d3));
    }

    public void drawPixels(Point2D[] point2DArray, int n, int n2) {
        if (point2DArray == null) {
            return;
        }
        if (n >= point2DArray.length) {
            n = point2DArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= point2DArray.length) {
            n2 = point2DArray.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 <= n) {
            return;
        }
        Color color = this.currentGraphics.getColor();
        for (int i = n; i <= n2; ++i) {
            if (point2DArray[i] == null) continue;
            this.tempPoint.setLocation(point2DArray[i]);
            this.transform.windowToViewport(this.tempPoint);
            this.drawPixelDirect(color, (int)(this.tempPoint.getX() + 0.499), (int)(this.tempPoint.getY() + 0.499));
        }
    }

    public void drawString(String string, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.transform.windowToViewport(double_);
        this.transform.getUntransformedGraphics().drawString(string, (float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
    }

    public void drawString(String string, Point2D point2D) {
        this.drawString(string, point2D.getX(), point2D.getY());
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.tempPoint.setLocation(d, d2);
        this.transform.windowToDrawingCoords(this.tempPoint);
        double d5 = this.tempPoint.getX();
        double d6 = this.tempPoint.getY();
        this.tempPoint.setLocation(d3, d4);
        this.transform.windowToDrawingCoords(this.tempPoint);
        this.currentGraphics.draw(new Line2D.Double(d5, d6, this.tempPoint.getX(), this.tempPoint.getY()));
    }

    public void drawLine(Point2D point2D, Point2D point2D2) {
        this.drawLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void drawCurve(Point2D[] point2DArray, int n, int n2) {
        if (point2DArray == null) {
            return;
        }
        if (n >= point2DArray.length) {
            n = point2DArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= point2DArray.length) {
            n2 = point2DArray.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 <= n) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        double d = Math.abs(this.transform.getXmax() - this.transform.getXmin()) / 4.0;
        double d2 = Math.abs(this.transform.getYmax() - this.transform.getYmin()) / 4.0;
        if (this.applyGraphics2DTransform) {
            d = d2 = Math.max(d, d2);
        }
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            if (point2DArray[i] == null) continue;
            this.tempPoint.setLocation(point2DArray[i]);
            this.transform.windowToDrawingCoords(this.tempPoint);
            if (i == n) {
                generalPath.moveTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                continue;
            }
            if (i > n && point2DArray[i - 1] != null && Math.abs(point2DArray[i].getX() - point2DArray[i - 1].getX()) <= d && Math.abs(point2DArray[i].getY() - point2DArray[i - 1].getY()) <= d2) {
                generalPath.lineTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                continue;
            }
            generalPath.moveTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
            bl = true;
        }
        if (point2DArray[n2] != null) {
            if (n == 0 && n2 == point2DArray.length - 1 && point2DArray[0] != null && Math.abs(point2DArray[0].getX() - point2DArray[n2].getX()) <= this.transform.getPixelWidth() / 100.0 && Math.abs(point2DArray[0].getY() - point2DArray[n2].getY()) <= this.transform.getPixelHeight() / 100.0 && !bl) {
                generalPath.closePath();
            } else {
                this.tempPoint.setLocation(point2DArray[n2]);
                this.transform.windowToDrawingCoords(this.tempPoint);
                if (point2DArray[n2 - 1] != null && Math.abs(point2DArray[n2].getX() - point2DArray[n2 - 1].getX()) <= d && Math.abs(point2DArray[n2].getY() - point2DArray[n2 - 1].getY()) <= d2) {
                    generalPath.lineTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                } else {
                    generalPath.moveTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                }
            }
        }
        this.currentGraphics.draw(generalPath);
    }

    public void drawCurve(Point2D[] point2DArray) {
        if (point2DArray != null) {
            this.drawCurve(point2DArray, point2DArray.length);
        }
    }

    public void drawCurve(Point2D[] point2DArray, int n) {
        this.drawCurve(point2DArray, 0, n - 1);
    }

    public void drawPixelDirect(Color color, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.fullOSI.getWidth() || n2 >= this.fullOSI.getHeight()) {
            return;
        }
        if (color == null) {
            color = this.currentGraphics.getColor();
        }
        int n3 = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        this.fullOSI.setRGB(n, n2, n3);
    }

    public void drawLineDirect(int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = this.getTransform().getUntransformedGraphics();
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public void fillRectDirect(int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = this.getTransform().getUntransformedGraphics();
        graphics2D.fillRect(n, n2, n3, n4);
    }

    public boolean beginDrawToOffscreenImage() {
        if (this.transform == null || this.transform.getWidth() == 0 || this.currentGraphics != null || this.fullOSI == null) {
            return false;
        }
        this.prepareOSIForDrawing();
        this.directOffscreenDrawing = true;
        return true;
    }

    public void endDrawToOffscreenImage() {
        if (!this.directOffscreenDrawing) {
            return;
        }
        this.transform.finishDrawing();
        this.finishOSIDraw();
        this.directOffscreenDrawing = false;
        this.currentGraphics = null;
    }

    public BufferedImage getImage(boolean bl) {
        if (this.display == null || this.exhibit == null || this.previousWidth == 0) {
            return null;
        }
        if (this.fullOSI != null && !bl) {
            return this.fullOSI;
        }
        BufferedImage bufferedImage = new BufferedImage(this.previousWidth, this.previousHeight, this.offscreenImageType);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if (this.fullOSI == null) {
            this.render(graphics2D, this.previousWidth, this.previousHeight);
        } else {
            graphics2D.drawImage((Image)this.fullOSI, 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

