/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.functions.ComplexExpression;
import vmm.functions.Expression;
import vmm.functions.ParseError;
import vmm.functions.Parser;
import vmm.functions.Variable;

public class Util {
    private static Parser constantParser;
    private static Parser constantParserWithNanAndInf;
    private static char isMac;
    private static String commandKey;

    public static Expression parseConstantExpression(String string) throws ParseError {
        if (constantParser == null) {
            constantParser = new Parser();
        }
        return constantParser.parseExpression(string);
    }

    public static ComplexExpression parseComplexConstantExpression(String string) throws ParseError {
        if (constantParser == null) {
            constantParser = new Parser();
        }
        return constantParser.parseComplexExpression(string);
    }

    public static Cursor createCursorFromResource(String string, int n, int n2) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ClassLoader classLoader = MouseTask.class.getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (uRL == null) {
                return null;
            }
            Image image = toolkit.createImage(uRL);
            return toolkit.createCustomCursor(image, new Point(n, n2), string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isMacOS() {
        if (isMac == '?') {
            try {
                String string = System.getProperty("mrj.version");
                isMac = string != null ? (char)89 : (char)78;
            }
            catch (Exception exception) {
                isMac = (char)78;
            }
        }
        return isMac == 'Y';
    }

    public static KeyStroke getAccelerator(String string) {
        if (commandKey == null) {
            commandKey = Util.isMacOS() ? "meta " : "control ";
        }
        return KeyStroke.getKeyStroke(commandKey + string);
    }

    public static long availableMemory() {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        long l2 = runtime.maxMemory();
        long l3 = l2 == Long.MAX_VALUE ? runtime.freeMemory() : l2 - l;
        return l3;
    }

    public static Point2D getPoint2DFromUser(Component component, String string) {
        return Util.getPoint2DFromUser(component, string, Double.NaN, Double.NaN);
    }

    public static Point2D getPoint2DFromUser(Component component, String string, double d, double d2) {
        return Util.getPoint2DFromUser(component, string, d, d2, "x", "y");
    }

    public static Point2D getPoint2DFromUser(Component component, String string, double d, double d2, String string2, String string3) {
        double d3;
        double d4;
        RealParam realParam = new RealParam(string2, d);
        RealParam realParam2 = new RealParam(string3, d2);
        ParameterInput parameterInput = new ParameterInput(realParam);
        ParameterInput parameterInput2 = new ParameterInput(realParam2);
        parameterInput.setColumns(15);
        parameterInput2.setColumns(15);
        if (Double.isNaN(d)) {
            parameterInput.setText("");
        }
        if (Double.isNaN(d2)) {
            parameterInput2.setText("");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.add((Component)new JLabel(realParam.getTitle() + " = "), "West");
        jPanel.add((Component)parameterInput, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(3, 3));
        jPanel2.add((Component)new JLabel(realParam2.getTitle() + " = "), "West");
        jPanel2.add((Component)parameterInput2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(10, 10));
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)new JLabel(string, 2), "North");
        int n = JOptionPane.showConfirmDialog(component, jPanel4, "", 2, -1);
        if (n == 2) {
            return null;
        }
        String string4 = parameterInput.getText();
        String string5 = parameterInput2.getText();
        try {
            d4 = Double.parseDouble(string4);
            d3 = Double.parseDouble(string5);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(component, I18n.tr("vmm.core.Util.getPoint2D.error.illegalnumbers"));
            return null;
        }
        return new Point2D.Double(d4, d3);
    }

    public static String[] explode(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return new String[]{string};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String toExternalString(Object object) {
        try {
            if (object == null) {
                return "##NULL##";
            }
            if (object instanceof Double) {
                double d = (Double)object;
                if (Double.isNaN(d)) {
                    return "NaN";
                }
                if (d == Double.POSITIVE_INFINITY) {
                    return "+INF";
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    return "-INF";
                }
                if (d == Double.MIN_VALUE) {
                    return "EPSILON";
                }
                return "" + d;
            }
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                if (Float.isNaN(f)) {
                    return "NaN";
                }
                if (f == Float.POSITIVE_INFINITY) {
                    return "+INF";
                }
                if (f == Float.NEGATIVE_INFINITY) {
                    return "-INF";
                }
                if (f == Float.MIN_VALUE) {
                    return "EPSILON";
                }
                return "" + f;
            }
            if (object instanceof Color) {
                Color color = (Color)object;
                return color.getRed() + " " + color.getGreen() + " " + color.getBlue();
            }
            if (object instanceof Point2D) {
                Point2D point2D = (Point2D)object;
                return Util.toExternalString(point2D.getX()) + " " + Util.toExternalString(point2D.getY());
            }
            if (object instanceof double[]) {
                String string = "";
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    string = string + Util.toExternalString(dArray[i]);
                    if (i >= dArray.length - 1) continue;
                    string = string + " ";
                }
                return string;
            }
            if (object instanceof int[]) {
                String string = "";
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + nArray[i];
                    if (i >= nArray.length - 1) continue;
                    string = string + " ";
                }
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object.toString();
    }

    public static Object externalStringToValue(String string, Class clazz) throws IllegalArgumentException {
        try {
            if (clazz.isPrimitive()) {
                if (clazz.equals(Boolean.TYPE)) {
                    return new Boolean(string);
                }
                if (clazz.equals(Integer.TYPE)) {
                    return new Integer(string);
                }
                if (clazz.equals(Double.TYPE)) {
                    if ("NaN".equalsIgnoreCase(string)) {
                        return Double.NaN;
                    }
                    if ("+INF".equalsIgnoreCase(string)) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if ("-INF".equalsIgnoreCase(string)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    if ("EPSILON".equalsIgnoreCase(string)) {
                        return Double.MIN_VALUE;
                    }
                    return new Double(string);
                }
                if (clazz.equals(Float.TYPE)) {
                    if ("NaN".equalsIgnoreCase(string)) {
                        return Float.valueOf(Float.NaN);
                    }
                    if ("+INF".equalsIgnoreCase(string)) {
                        return Float.valueOf(Float.POSITIVE_INFINITY);
                    }
                    if ("-INF".equalsIgnoreCase(string)) {
                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                    }
                    if ("EPSILON".equalsIgnoreCase(string)) {
                        return Float.valueOf(Float.MIN_VALUE);
                    }
                    return new Float(string);
                }
                if (clazz.equals(Long.TYPE)) {
                    return new Long(string);
                }
                if (clazz.equals(Short.TYPE)) {
                    return new Short(string);
                }
                if (clazz.equals(Byte.TYPE)) {
                    return new Byte(string);
                }
                return new Character(string.charAt(0));
            }
            if (string.equalsIgnoreCase("##NULL##")) {
                return null;
            }
            if (clazz.equals(Double.class)) {
                return Util.externalStringToValue(string, Double.TYPE);
            }
            if (clazz.equals(Float.class)) {
                return Util.externalStringToValue(string, Float.TYPE);
            }
            if (clazz.equals(String.class)) {
                return string;
            }
            if (clazz.equals(Complex.class)) {
                if (constantParserWithNanAndInf == null) {
                    constantParserWithNanAndInf = new Parser();
                    constantParserWithNanAndInf.add(new Variable("NaN", Double.NaN));
                    constantParserWithNanAndInf.add(new Variable("INF", Double.POSITIVE_INFINITY));
                }
                return constantParserWithNanAndInf.parseComplexExpression(string).value();
            }
            if (clazz.equals(Color.class)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\t");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                return new Color(Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
            }
            if (clazz.equals(double[].class)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
                int n = stringTokenizer.countTokens();
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    String string5 = stringTokenizer.nextToken();
                    dArray[i] = (Double)Util.externalStringToValue(string5, Double.TYPE);
                }
                return dArray;
            }
            if (clazz.equals(int[].class)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\t");
                int[] nArray = new int[stringTokenizer.countTokens()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                }
                return nArray;
            }
            if (clazz.equals(Point2D.class)) {
                double[] dArray = (double[])Util.externalStringToValue(string, double[].class);
                if (dArray.length != 2) {
                    throw new Exception();
                }
                return new Point2D.Double(dArray[0], dArray[1]);
            }
            Method method = null;
            try {
                method = clazz.getDeclaredMethod("fromString", String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method != null) {
                Object object = method.invoke(null, string);
                if (clazz.isInstance(object)) {
                    return object;
                }
                throw new Exception();
            }
            Constructor constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(I18n.tr("vmm.core.Util.error.BadString", string));
        }
    }

    static {
        isMac = (char)63;
        commandKey = null;
    }
}

