/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vmm.actions.AbstractActionVMM;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexVariableParam;
import vmm.core.ComplexVariableParamAnimateable;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.ParameterInput;
import vmm.core.Parameterizable;
import vmm.core.SaveAndRestore;
import vmm.core.VariableParam;
import vmm.core.VariableParamAnimateable;
import vmm.core.View;
import vmm.functions.ComplexFunction;
import vmm.functions.Function;
import vmm.functions.ParseError;
import vmm.functions.Parser;

public interface UserExhibit
extends Parameterizable {
    public Support getUserExhibitSupport();

    public Parameter[] getParameters();

    public double[] getDefaultWindow();

    public void setDefaultWindow(double[] var1);

    public View getDefaultView();

    public static class Support {
        private final UserExhibit exhibit;
        private ArrayList<FunctionInfo> functions = new ArrayList();
        private ArrayList<Parameter> functionParameters = new ArrayList();
        private boolean showWindow = true;
        private boolean allowNewParameters = true;
        private boolean allowChangeUserDataCommand = true;

        public Support(UserExhibit userExhibit) {
            this.exhibit = userExhibit;
        }

        public void addFunctionParameter(VariableParam variableParam) {
            this.functionParameters.add(variableParam);
            variableParam.setOwner(this.exhibit);
        }

        public void addFunctionParameter(ComplexVariableParam complexVariableParam) {
            this.functionParameters.add(complexVariableParam);
            complexVariableParam.setOwner(this.exhibit);
        }

        public FunctionInfo addRealFunction(String string, String string2, String ... stringArray) {
            FunctionInfo functionInfo = new FunctionInfo(string, string2, stringArray, false);
            this.functions.add(functionInfo);
            return functionInfo;
        }

        public FunctionInfo addComplexFunction(String string, String string2, String ... stringArray) {
            FunctionInfo functionInfo = new FunctionInfo(string, string2, stringArray, true);
            this.functions.add(functionInfo);
            return functionInfo;
        }

        public int getFunctionCount() {
            return this.functions.size();
        }

        public FunctionInfo getFunctionInfo(int n) {
            return this.functions.get(n);
        }

        public Parameter[] getFunctionParameters() {
            Parameter[] parameterArray = new Parameter[this.functionParameters.size()];
            this.functionParameters.toArray(parameterArray);
            return parameterArray;
        }

        public boolean getAllowChangeUserDataCommand() {
            return this.allowChangeUserDataCommand;
        }

        public void setAllowChangeUserDataCommand(boolean bl) {
            this.allowChangeUserDataCommand = bl;
        }

        public boolean getAllowNewParameters() {
            return this.allowNewParameters;
        }

        public void setAllowNewParameters(boolean bl) {
            this.allowNewParameters = bl;
        }

        public boolean getShowWindow() {
            return this.showWindow;
        }

        public void setShowWindow(boolean bl) {
            this.showWindow = bl;
        }

        public View defaults() {
            View view = this.exhibit.getDefaultView();
            Dialog dialog = this.createDialog(null, view, true);
            boolean bl = dialog.getData();
            if (!bl) {
                return null;
            }
            this.finish(dialog, view, true);
            return view;
        }

        public View showCreateDialog(Display display) {
            View view = this.exhibit.getDefaultView();
            Dialog dialog = this.createDialog(display, view, true);
            boolean bl = dialog.showDialog();
            if (!bl) {
                return null;
            }
            this.finish(dialog, view, true);
            return view;
        }

        public boolean showChangeDialog(Display display, View view) {
            Dialog dialog = this.createDialog(display, view, false);
            boolean bl = dialog.showDialog();
            if (!bl) {
                return false;
            }
            this.finish(dialog, view, false);
            return true;
        }

        public AbstractActionVMM makeChangeUserDataAction(final View view) {
            return new AbstractActionVMM(I18n.tr("vmm.core.UserExhibitDialog.SetUserData")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Support.this.showChangeDialog(view.getDisplay(), view) && view.getExhibit() != null) {
                        view.getExhibit().forceRedraw();
                    }
                }
            };
        }

        public void addToXML(Document document, Element element) {
            Element element2;
            for (Parameter object : this.functionParameters) {
                element2 = document.createElement("functionParam");
                SaveAndRestore.buildParameterElement(document, element2, object);
                element2.setAttribute("isComplex", object instanceof ComplexVariableParam ? "yes" : "no");
                element2.setAttribute("isAnimateable", object instanceof Animateable ? "yes" : "no");
                element.appendChild(element2);
            }
            for (FunctionInfo functionInfo : this.functions) {
                element2 = document.createElement("function");
                element2.setAttribute("name", functionInfo.name);
                element2.setAttribute("definition", functionInfo.definition);
                element.appendChild(element2);
            }
            SaveAndRestore.addProperties(this, new String[]{"allowChangeUserDataCommand", "showWindow", "allowNewParameters"}, document, element);
        }

        public void readFromXML(Element element) throws IOException {
            Object object;
            String string;
            Element element2;
            Object object22;
            int n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Parser parser = new Parser();
            NodeList nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object22 = nodeList.item(n);
                if (!(object22 instanceof Element) || !((Element)object22).getTagName().equals("functionParam")) continue;
                element2 = (Element)object22;
                string = element2.getAttribute("name").trim();
                boolean bl = "yes".equalsIgnoreCase(element2.getAttribute("isComplex"));
                boolean bl2 = "yes".equalsIgnoreCase(element2.getAttribute("isAnimateable"));
                object = bl ? (bl2 ? new ComplexVariableParamAnimateable(string, new Complex()) : new ComplexVariableParam(string, new Complex())) : (bl2 ? new VariableParamAnimateable(string, 0.0) : new VariableParam(string, 0.0));
                SaveAndRestore.setParamInfoFromElement((Parameter)object, element2);
                arrayList.add(object);
                if (object instanceof ComplexVariableParam) {
                    parser.add(((ComplexVariableParam)object).getVariable());
                    continue;
                }
                parser.add(((VariableParam)object).getVariable());
            }
            for (n = 0; n < nodeList.getLength(); ++n) {
                object22 = nodeList.item(n);
                if (!(object22 instanceof Element) || !((Element)object22).getTagName().equals("function")) continue;
                element2 = (Element)object22;
                object = element2.getAttribute("name").trim();
                string = element2.getAttribute("definition").trim();
                FunctionInfo functionInfo = null;
                for (FunctionInfo functionInfo2 : this.functions) {
                    if (!functionInfo2.getName().equalsIgnoreCase((String)object)) continue;
                    functionInfo = functionInfo2;
                    break;
                }
                if (functionInfo == null) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.UnknownFunctionInUserExhibitData", object));
                }
                functionInfo.definition = string;
                try {
                    if (functionInfo.isComplex) {
                        functionInfo.function = parser.parseComplexFunction(functionInfo.name, string, functionInfo.argumentNames);
                        continue;
                    }
                    functionInfo.function = parser.parseFunction(functionInfo.name, string, functionInfo.argumentNames);
                    continue;
                }
                catch (ParseError parseError) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadExpressionDefinition"));
                }
            }
            for (Object object22 : arrayList) {
                ((Parameter)object22).setOwner(null);
            }
            this.functionParameters = arrayList;
            for (Object object22 : arrayList) {
                ((Parameter)object22).setOwner(this.exhibit);
            }
            SaveAndRestore.readProperties(this, element);
        }

        protected Dialog createDialog(Display display, View view, boolean bl) {
            Container container;
            for (container = display; container != null && !(container instanceof JFrame); container = container.getParent()) {
            }
            Dialog dialog = new Dialog((JFrame)container, "");
            if (this.showWindow) {
                double[] dArray = bl ? this.exhibit.getDefaultWindow() : view.getRequestedWindow();
                dialog.showViewWindowLimits(dArray[0], dArray[1], dArray[2], dArray[3]);
            }
            if (this.allowNewParameters) {
                dialog.allowNewParameters();
            }
            return dialog;
        }

        protected void finish(Dialog dialog, View view, boolean bl) {
            view.setWindow(dialog.getWindow());
            this.exhibit.setDefaultWindow(dialog.getWindow());
        }

        protected class Dialog
        extends JDialog {
            private JFrame parent;
            private ArrayList<ParameterInput> parameterInputs;
            private ArrayList<JTextField> functionInputs;
            private ArrayList<ExtraPanel> extraPanels;
            private JPanel expressionPromptPanel;
            private JPanel expressionInputPanel;
            private JPanel parameterPanel;
            private boolean parameterPanelAdded;
            private JPanel windowPanel;
            private Box inputPane;
            private JPanel buttons;
            private JButton okButton;
            private JButton cancelButton;
            private JButton addParameterButton;
            private JButton removeParameterButton;
            private double[] window;
            private JTextField[] windowInputs;
            private boolean showParameters;
            private boolean canceled;

            protected Dialog(JFrame jFrame, String string) {
                Iterator<ExtraPanel> iterator;
                Object object2;
                super(jFrame, string, true);
                this.parameterInputs = new ArrayList();
                this.functionInputs = new ArrayList();
                this.parent = jFrame;
                Parameter[] parameterArray = Support.this.exhibit.getParameters();
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout(8, 8));
                this.setContentPane(jPanel);
                this.inputPane = Box.createVerticalBox();
                JScrollPane jScrollPane = new JScrollPane(this.inputPane, 20, 30);
                jPanel.add((Component)jScrollPane, "Center");
                this.okButton = new JButton(I18n.tr("buttonNames.OK"));
                this.cancelButton = new JButton(I18n.tr("buttonNames.Cancel"));
                this.addParameterButton = new JButton(I18n.tr("buttonNames.AddParameter"));
                this.removeParameterButton = new JButton(I18n.tr("buttonNames.RemoveParameter"));
                ButtonHandler buttonHandler = new ButtonHandler();
                this.okButton.addActionListener(buttonHandler);
                this.cancelButton.addActionListener(buttonHandler);
                this.addParameterButton.addActionListener(buttonHandler);
                this.removeParameterButton.addActionListener(buttonHandler);
                this.removeParameterButton.setEnabled(Support.this.functionParameters.size() > 0);
                this.buttons = new JPanel();
                this.buttons.setLayout(new FlowLayout(2, 8, 8));
                this.buttons.add(this.cancelButton);
                this.buttons.add(this.okButton);
                jPanel.add((Component)this.buttons, "South");
                JPanel jPanel2 = new JPanel();
                jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.EnterExpressions")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                jPanel2.setLayout(new BorderLayout(5, 5));
                this.expressionPromptPanel = new JPanel();
                this.expressionPromptPanel.setLayout(new GridLayout(0, 1, 5, 5));
                jPanel2.add((Component)this.expressionPromptPanel, "West");
                this.expressionInputPanel = new JPanel();
                this.expressionInputPanel.setLayout(new GridLayout(0, 1, 5, 5));
                jPanel2.add((Component)this.expressionInputPanel, "Center");
                for (Object object2 : Support.this.functions) {
                    this.expressionPromptPanel.add(new JLabel(((FunctionInfo)object2).prompt, 4));
                    iterator = new JTextField(((FunctionInfo)object2).definition, 40);
                    this.functionInputs.add((JTextField)((Object)iterator));
                    this.expressionInputPanel.add((Component)((Object)iterator), "Center");
                }
                this.inputPane.add(jPanel2);
                this.parameterPanel = new JPanel();
                this.parameterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.Parameters")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                this.parameterPanel.setLayout(new GridLayout(0, 4, 5, 5));
                Color color = new Color(180, 0, 0);
                object2 = new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterName"), 0);
                ((JComponent)object2).setForeground(color);
                this.parameterPanel.add((Component)object2);
                object2 = new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterValue"), 0);
                ((JComponent)object2).setForeground(color);
                this.parameterPanel.add((Component)object2);
                object2 = new JLabel(I18n.tr("vmm.core.ParameterDialog.AnimationStartValue"), 0);
                ((JComponent)object2).setForeground(color);
                this.parameterPanel.add((Component)object2);
                object2 = new JLabel(I18n.tr("vmm.core.ParameterDialog.AnimationEndValue"), 0);
                ((JComponent)object2).setForeground(color);
                this.parameterPanel.add((Component)object2);
                if (Support.this.functionParameters.size() > 0) {
                    for (Parameter parameter : Support.this.functionParameters) {
                        this.addParamInputs(parameter);
                    }
                }
                if (parameterArray != null && parameterArray.length > 0) {
                    iterator = new JPanel();
                    ((JComponent)((Object)iterator)).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.ExhibitParameters")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                    ((Container)((Object)iterator)).setLayout(new GridLayout(0, 4, 5, 5));
                    for (int i = 0; i < parameterArray.length; ++i) {
                        Parameter parameter = parameterArray[i];
                        ((Container)((Object)iterator)).add(new JLabel(parameter.getTitle() + " = ", 4));
                        ParameterInput parameterInput = parameter.createParameterInput(0);
                        this.parameterInputs.add(parameterInput);
                        ((Container)((Object)iterator)).add(parameterInput);
                        if (parameter instanceof Animateable) {
                            ParameterInput parameterInput2 = parameter.createParameterInput(1);
                            this.parameterInputs.add(parameterInput2);
                            ((Container)((Object)iterator)).add(parameterInput2);
                            ParameterInput parameterInput3 = parameter.createParameterInput(2);
                            this.parameterInputs.add(parameterInput3);
                            ((Container)((Object)iterator)).add(parameterInput3);
                            continue;
                        }
                        ((Container)((Object)iterator)).add(new JLabel());
                        ((Container)((Object)iterator)).add(new JLabel());
                    }
                    this.inputPane.add((Component)((Object)iterator));
                }
                if (this.extraPanels != null) {
                    for (ExtraPanel extraPanel : this.extraPanels) {
                        this.inputPane.add(extraPanel);
                    }
                }
                this.buttons.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
                this.buttons.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "ok");
                this.buttons.getActionMap().put("cancel", new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Dialog.this.cancelButton.doClick();
                    }
                });
                this.buttons.getActionMap().put("ok", new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Dialog.this.okButton.doClick();
                    }
                });
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        Dialog.this.canceled = true;
                        Dialog.this.dispose();
                    }
                });
            }

            public void addExtraPanel(ExtraPanel extraPanel) {
                if (this.extraPanels == null) {
                    this.extraPanels = new ArrayList();
                }
                this.extraPanels.add(extraPanel);
                this.inputPane.add(extraPanel);
            }

            private boolean showDialog() {
                if (this.parent != null) {
                    this.setLocation(this.parent.getX() + 20, this.parent.getY() + 40);
                }
                this.checkBounds();
                this.canceled = false;
                this.setVisible(true);
                return !this.canceled;
            }

            private void checkBounds() {
                this.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (this.getHeight() > dimension.height - 30) {
                    this.setSize(this.getWidth() + 30, dimension.height - 30);
                }
                if (this.getLocation().y + this.getHeight() > dimension.height - 3) {
                    this.setLocation(this.getLocation().x, dimension.height - this.getHeight() - 3);
                }
                if (this.getLocation().x + this.getWidth() > dimension.width - 3) {
                    this.setLocation(dimension.width - 3 - this.getWidth(), this.getLocation().y);
                }
            }

            private void makeWindowInputPanel(double[] dArray) {
                this.windowPanel = new JPanel();
                this.windowPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.ViewLimits")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                this.windowPanel.setLayout(new GridLayout(0, 4, 5, 5));
                this.windowInputs = new JTextField[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    this.windowInputs[i] = new JTextField("" + dArray[i]);
                }
                this.windowPanel.add(new JLabel(I18n.tr("common.xmin") + " = ", 4));
                this.windowPanel.add(this.windowInputs[0]);
                this.windowPanel.add(new JLabel(I18n.tr("common.xmax") + " = ", 4));
                this.windowPanel.add(this.windowInputs[1]);
                this.windowPanel.add(new JLabel(I18n.tr("common.ymin") + " = ", 4));
                this.windowPanel.add(this.windowInputs[2]);
                this.windowPanel.add(new JLabel(I18n.tr("common.ymax") + " = ", 4));
                this.windowPanel.add(this.windowInputs[3]);
            }

            private void errorMessage(String string) {
                JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.UserExhibitDialog.errorTitle"), 0);
            }

            private void allowNewParameters() {
                if (!this.showParameters) {
                    this.showParameters = true;
                    this.buttons.add((Component)this.addParameterButton, 0);
                    this.buttons.add((Component)this.removeParameterButton, 0);
                    this.buttons.validate();
                }
            }

            private void doAddParameter() {
                JCheckBox jCheckBox = new JCheckBox(I18n.tr("vmm.core.UserExhibitDialog.ParameterIsComplex"));
                JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("vmm.core.UserExhibitDialog.ParameterIsAnimateable"), true);
                JPanel jPanel = new JPanel();
                jPanel.add(new JLabel(I18n.tr("vmm.core.UserExhibitDialog.ParameterName")));
                JTextField jTextField = new JTextField(4);
                jPanel.add(jTextField);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(3, 1, 10, 10));
                jPanel2.add(jPanel);
                jPanel2.add(jCheckBox);
                jPanel2.add(jCheckBox2);
                int n = JOptionPane.showConfirmDialog(this, jPanel2, I18n.tr("vmm.core.UserExhibitDialog.AddParameterTitle"), 2, -1);
                if (n == 2) {
                    return;
                }
                String string = jTextField.getText();
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                if (!Character.isLetter((string = string.trim()).charAt(0))) {
                    this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.BadParamName"));
                    return;
                }
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isLetterOrDigit(string.charAt(i))) continue;
                    this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.BadParamName"));
                    return;
                }
                for (Parameter parameter : Support.this.functionParameters) {
                    if (!parameter.getName().equalsIgnoreCase(string)) continue;
                    this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.DuplicateParam", string));
                    return;
                }
                Parameter parameter = jCheckBox.isSelected() ? (jCheckBox2.isSelected() ? new ComplexVariableParamAnimateable(string, new Complex(1.0), new Complex(-5.0), new Complex(5.0)) : new ComplexVariableParam(string, new Complex(1.0))) : (jCheckBox2.isSelected() ? new VariableParamAnimateable(string, 1.0, -5.0, 5.0) : new VariableParam(string, 1.0));
                Support.this.functionParameters.add(parameter);
                parameter.setOwner(Support.this.exhibit);
                this.addParamInputs(parameter);
                this.removeParameterButton.setEnabled(true);
                this.validate();
                this.checkBounds();
            }

            private void doRemoveParameter() {
                JComponent jComponent;
                final JDialog jDialog = new JDialog(this, I18n.tr("vmm.core.UserExhibitDialog.RemoveParameterDialogTitle"), true);
                jDialog.setDefaultCloseOperation(2);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(0, 1, 7, 7));
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
                int n = 0;
                while (n < Support.this.functionParameters.size()) {
                    jComponent = new JButton(((Parameter)Support.this.functionParameters.get(n)).getTitle());
                    jPanel.add(jComponent);
                    final int n2 = n++;
                    ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jDialog.dispose();
                            Parameter parameter = (Parameter)Support.this.functionParameters.get(n2);
                            Support.this.functionParameters.remove(n2);
                            parameter.setOwner(null);
                            Dialog.this.parameterPanel.remove(4 * (n2 + 1) + 3);
                            Dialog.this.parameterPanel.remove(4 * (n2 + 1) + 2);
                            Dialog.this.parameterPanel.remove(4 * (n2 + 1) + 1);
                            Dialog.this.parameterPanel.remove(4 * (n2 + 1));
                            for (int i = Dialog.this.parameterInputs.size() - 1; i >= 0; --i) {
                                if (((ParameterInput)Dialog.this.parameterInputs.get(i)).getParameter() != parameter) continue;
                                Dialog.this.parameterInputs.remove(i);
                            }
                            Dialog.this.validate();
                            if (Support.this.functionParameters.size() == 0) {
                                Dialog.this.removeParameterButton.setEnabled(false);
                            }
                            Dialog.this.checkBounds();
                        }
                    });
                }
                JPanel jPanel2 = new JPanel();
                jDialog.setContentPane(jPanel2);
                jPanel2.setLayout(new BorderLayout(7, 7));
                jPanel2.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
                jPanel2.add((Component)new JLabel(I18n.tr("vmm.core.UserExhibitDialog.RemoveParameterDialogPrompt")), "North");
                jComponent = new JPanel();
                jComponent.add(jPanel);
                jPanel2.add((Component)jComponent, "Center");
                JPanel jPanel3 = new JPanel();
                JButton jButton = new JButton(I18n.tr("buttonNames.Cancel"));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.dispose();
                    }
                });
                jPanel3.add(jButton);
                jPanel2.add((Component)jPanel3, "South");
                jDialog.pack();
                jDialog.setLocation(this.getLocation().x + 15, this.getLocation().y + 25);
                jDialog.setVisible(true);
            }

            private boolean getData() {
                int n;
                int n2;
                Object[] objectArray = new Object[this.functionInputs.size()];
                Parser parser = new Parser();
                for (Parameter object2 : Support.this.functionParameters) {
                    if (object2 instanceof ComplexVariableParam) {
                        parser.add(((ComplexVariableParam)object2).getVariable());
                        continue;
                    }
                    parser.add(((VariableParam)object2).getVariable());
                }
                for (n2 = 0; n2 < this.functionInputs.size(); ++n2) {
                    try {
                        FunctionInfo numberFormatException = (FunctionInfo)Support.this.functions.get(n2);
                        if (numberFormatException.isComplex) {
                            objectArray[n2] = parser.parseComplexFunction(numberFormatException.name, this.functionInputs.get(n2).getText(), numberFormatException.argumentNames);
                            continue;
                        }
                        objectArray[n2] = parser.parseFunction(numberFormatException.name, this.functionInputs.get(n2).getText(), numberFormatException.argumentNames);
                        continue;
                    }
                    catch (ParseError parseError) {
                        this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.parseError", this.functionInputs.get(n2).getText(), parseError.getMessage()));
                        this.functionInputs.get(n2).requestFocus();
                        this.functionInputs.get(n2).selectAll();
                        return false;
                    }
                }
                if (this.windowInputs != null) {
                    this.window = new double[4];
                    for (n2 = 0; n2 < 4; ++n2) {
                        try {
                            this.window[n2] = Double.parseDouble(this.windowInputs[n2].getText());
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string = "common.";
                            if (n2 == 0) {
                                string = string + "xmin";
                            } else if (n2 == 1) {
                                string = string + "xmax";
                            } else if (n2 == 2) {
                                string = string + "ymin";
                            } else if (n2 == 3) {
                                string = string + "ymax";
                            }
                            this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.badReal", I18n.tr(string)));
                            this.windowInputs[n2].requestFocus();
                            this.windowInputs[n2].selectAll();
                            return false;
                        }
                    }
                    if (this.window[1] <= this.window[0]) {
                        this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.badRange", I18n.tr("common.xmax"), I18n.tr("common.xmin")));
                        this.windowInputs[1].requestFocus();
                        this.windowInputs[1].selectAll();
                        return false;
                    }
                    if (this.window[3] <= this.window[2]) {
                        this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.badRange", I18n.tr("common.ymax"), I18n.tr("common.ymin")));
                        this.windowInputs[1].requestFocus();
                        this.windowInputs[1].selectAll();
                        return false;
                    }
                }
                for (n2 = 0; n2 < this.parameterInputs.size(); ++n2) {
                    String string = this.parameterInputs.get(n2).checkContents();
                    if (string == null) continue;
                    this.errorMessage(string);
                    return false;
                }
                if (this.extraPanels != null) {
                    for (ExtraPanel extraPanel : this.extraPanels) {
                        try {
                            extraPanel.checkData();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.errorMessage(illegalArgumentException.getMessage());
                        }
                    }
                }
                for (n = 0; n < this.functionInputs.size(); ++n) {
                    ((FunctionInfo)Support.this.functions.get(n)).function = objectArray[n];
                    ((FunctionInfo)Support.this.functions.get(n)).definition = this.functionInputs.get(n).getText();
                }
                for (n = 0; n < this.parameterInputs.size(); ++n) {
                    this.parameterInputs.get(n).setValueAndDefaultFromContents();
                }
                if (this.extraPanels != null) {
                    for (ExtraPanel extraPanel : this.extraPanels) {
                        extraPanel.commitData();
                    }
                }
                return true;
            }

            private void addParamInputs(Parameter parameter) {
                ParameterInput parameterInput = parameter.createParameterInput(0);
                this.parameterInputs.add(parameterInput);
                this.parameterPanel.add(new JLabel(parameter.getTitle() + " = ", 4));
                this.parameterPanel.add(parameterInput);
                if (parameter instanceof Animateable) {
                    ParameterInput parameterInput2 = parameter.createParameterInput(1);
                    ParameterInput parameterInput3 = parameter.createParameterInput(2);
                    this.parameterInputs.add(parameterInput2);
                    this.parameterInputs.add(parameterInput3);
                    this.parameterPanel.add(parameterInput2);
                    this.parameterPanel.add(parameterInput3);
                } else {
                    this.parameterPanel.add(new JLabel());
                    this.parameterPanel.add(new JLabel());
                }
                if (!this.parameterPanelAdded) {
                    this.inputPane.add((Component)this.parameterPanel, 1);
                    this.parameterPanelAdded = true;
                }
            }

            private void showViewWindowLimits(double d, double d2, double d3, double d4) {
                this.makeWindowInputPanel(new double[]{d, d2, d3, d4});
                this.inputPane.add(this.windowPanel);
            }

            public double[] getWindow() {
                if (this.window == null) {
                    return null;
                }
                return (double[])this.window.clone();
            }

            private class ButtonHandler
            implements ActionListener {
                private ButtonHandler() {
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object == Dialog.this.cancelButton) {
                        Dialog.this.canceled = true;
                        Dialog.this.dispose();
                    } else if (object == Dialog.this.addParameterButton) {
                        Dialog.this.doAddParameter();
                    } else if (object == Dialog.this.removeParameterButton) {
                        Dialog.this.doRemoveParameter();
                    } else if (object == Dialog.this.okButton && Dialog.this.getData()) {
                        Dialog.this.canceled = false;
                        Dialog.this.dispose();
                    }
                }
            }
        }

        protected static abstract class ExtraPanel
        extends JPanel {
            public ExtraPanel(String string) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), string), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            }

            public void commitData() {
            }

            public abstract void checkData() throws IllegalArgumentException;
        }
    }

    public static class FunctionInfo {
        private Object function;
        private final boolean isComplex;
        private final String name;
        private final String[] argumentNames;
        private String prompt;
        private String definition;

        private FunctionInfo(String string, String string2, String[] stringArray, boolean bl) {
            this.name = string;
            this.definition = string2;
            this.argumentNames = stringArray;
            this.isComplex = bl;
            this.setPrompt(null);
        }

        public double realFunctionValue(double ... dArray) {
            return ((Function)this.function).value(dArray);
        }

        public Complex complexFunctionValue(Complex ... complexArray) {
            return ((ComplexFunction)this.function).value(complexArray);
        }

        public Complex complexFunctionValue(double ... dArray) {
            return ((ComplexFunction)this.function).value(dArray);
        }

        public Function getRealFunction() {
            return (Function)this.function;
        }

        public ComplexFunction getComplexFunction() {
            return (ComplexFunction)this.function;
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }

        public String getDefinition() {
            return this.definition;
        }

        public boolean getIsComplex() {
            return this.isComplex;
        }

        public String getName() {
            return this.name;
        }

        public void setPrompt(String string) {
            if (string != null) {
                this.prompt = string;
            } else {
                this.prompt = this.name;
                this.prompt = this.prompt + "(";
                if (this.argumentNames != null && this.argumentNames.length > 0) {
                    for (int i = 0; i < this.argumentNames.length; ++i) {
                        this.prompt = this.prompt + this.argumentNames[i];
                        this.prompt = this.prompt + (i == this.argumentNames.length - 1 ? ") = " : ",");
                    }
                }
            }
        }
    }
}

