/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.MouseTask;
import vmm.core.View;

public abstract class TwoPointInput
extends MouseTask {
    public static final int DRAW_NOTHING = 0;
    public static final int DRAW_LINE = 1;
    public static final int DRAW_CIRCLE_FROM_RADIUS = 2;
    public static final int DRAW_CIRCLE_FROM_DIAMETER = 3;
    public static final int DRAW_RECT = 4;
    private int minimumDrag = 2;
    private double maximumDrag = 2.147483647E9;
    private boolean allowOutOfBoundsDrag = true;
    private int figureToDraw = 1;
    private Color drawColor = null;
    private int startX;
    private int endX;
    private int startY;
    private int endY;

    protected abstract void gotPoints(Display var1, View var2, int var3, int var4, int var5, int var6);

    public boolean getAllowOutOfBoundsDrag() {
        return this.allowOutOfBoundsDrag;
    }

    public void setAllowOutOfBoundsDrag(boolean bl) {
        this.allowOutOfBoundsDrag = bl;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color color) {
        this.drawColor = color;
    }

    public int getFigureToDraw() {
        return this.figureToDraw;
    }

    public void setFigureToDraw(int n) {
        if (n == 0 || n == 1 || n == 3 || n == 2 || n == 4) {
            this.figureToDraw = n;
        }
    }

    public int getMaximumDrag() {
        return (int)this.maximumDrag;
    }

    public void setMaximumDrag(int n) {
        this.maximumDrag = n;
    }

    public int getMinimumDrag() {
        return this.minimumDrag;
    }

    public void setMinimumDrag(int n) {
        this.minimumDrag = n;
    }

    public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        this.startX = this.endX = mouseEvent.getX();
        this.startY = this.endY = mouseEvent.getY();
        return true;
    }

    public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        this.endX = mouseEvent.getX();
        this.endY = mouseEvent.getY();
        display.repaint();
    }

    public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        int n3 = (this.startX - this.endX) * (this.startX - this.endX) + (this.startY - this.endY) * (this.startY - this.endY);
        if (n3 < this.minimumDrag * this.minimumDrag || (double)n3 > this.maximumDrag * this.maximumDrag) {
            return;
        }
        if (!(this.allowOutOfBoundsDrag || this.endX >= 0 && this.endY >= 0 && this.endX < n && this.endY < n2)) {
            return;
        }
        this.gotPoints(display, view, this.startX, this.startY, this.endX, this.endY);
    }

    public void drawWhileDragging(Graphics2D graphics2D, Display display, View view, int n, int n2) {
        if (this.figureToDraw == 0) {
            return;
        }
        int n3 = (this.startX - this.endX) * (this.startX - this.endX) + (this.startY - this.endY) * (this.startY - this.endY);
        if (n3 < this.minimumDrag * this.minimumDrag || (double)n3 > this.maximumDrag * this.maximumDrag) {
            return;
        }
        if (!(this.allowOutOfBoundsDrag || this.endX >= 0 && this.endY >= 0 && this.endX < n && this.endY < n2)) {
            return;
        }
        if (this.drawColor != null) {
            graphics2D.setColor(this.drawColor);
        }
        switch (this.figureToDraw) {
            case 1: {
                graphics2D.drawLine(this.startX, this.startY, this.endX, this.endY);
                break;
            }
            case 3: {
                int n4 = (int)(0.5 * Math.sqrt(n3));
                int n5 = (this.endX + this.startX) / 2;
                int n6 = (this.endY + this.startY) / 2;
                graphics2D.drawOval(n5 - n4 / 2, n6 - n4 / 2, n4, n4);
                break;
            }
            case 2: {
                int n7 = (int)(0.5 + Math.sqrt(n3));
                graphics2D.drawOval(this.startX - n7, this.startY - n7, 2 * n7, 2 * n7);
                break;
            }
            case 4: {
                int n8 = Math.min(this.startX, this.endX);
                int n9 = Math.max(this.startX, this.endX);
                int n10 = Math.min(this.startY, this.endY);
                int n11 = Math.max(this.startY, this.endY);
                graphics2D.drawRect(n8, n10, n9 - n8, n11 - n10);
            }
        }
        super.drawWhileDragging(graphics2D, display, view, n, n2);
    }

    public Cursor getCursor(Display display, View view) {
        return Cursor.getPredefinedCursor(1);
    }
}

